@echo off

setlocal EnableDelayedExpansion

cd /d %~dp0

REM For notes on unzipping at the command-line, see:
REM   https://superuser.com/questions/1314420/how-to-unzip-a-file-using-the-cmd

if not exist subversion-windows-64bit.zip (
  curl https://svn.greenstone.org/main/trunk/greenstone3/ext-cli/subversion-windows-64bit.zip ^
    > subversion-windows-64bit.zip
) else (
  echo.
  echo The file subversion-windows-64bit.zip already exists
  echo No need to download
  echo.
)
  

if not exist subversion-windows-64bit (
  REM The following allows for a situation where the developer has started
  REM with cygwin (likely to have 'svn'), and then started 'cmd' from with
  REM the cygwin terminal window.  The cygwin version of tar does not support
  REM the.zip file format, so we need to steer things to using 'unzip'

  where unzip >nul 2>&1
  if !ERRORLEVEL!==0 (
    echo Detected unzip on PATH
    unzip subversion-windows-64bit.zip
  ) else (
    echo Modern Windows now provides 'tar' with support for 'zip' files
    tar -xvf subversion-windows-64bit.zip
  )
) else (
  echo.
  echo The directory subversion-windows-64bit already exists
  echo No need to unzip
  echo.
)

endlocal

:: keep calling window open
exit /b 0
