###########################################################################
#
# solrutil.pm -- support module for Solr extension
# A component of the Greenstone digital library software
# from the New Zealand Digital Library Project at the
# University of Waikato, New Zealand.
#
# Copyright (C) 1999 New Zealand Digital Library Project
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
###########################################################################

package solrutil;

use strict; 


# I'll leave this here for now to remind us of how to do it in case its needed later
sub get_solr_admin_url_from_ant_UNUSED {

    my $solr_url = &get_solr_admin_url(); # fallback value

    my $perl_command = "ant -buildfile \"$ENV{'GEXT_SOLR9'}/build.xml\" get-solr-admin-url";
    
    if (open(PIN, "$perl_command |")) {
	while (defined (my $perl_output_line = <PIN>)) {
	    if($perl_output_line =~ m@(http):\/\/(\S*)@) { # grab all the non-whitespace chars
		$solr_url="$1://".$2; # preserve the http protocol
	    }
	}
	close(PIN);
	
	print STDERR "XXXXXXXXXX SOLR URL: $solr_url\n";

    } else {
	print STDERR "*** ERROR IN solrutil::get_solr_admin_url:\n";
	print STDERR "    Failed to run $perl_command to work out GS3's solr URL\n";
	print STDERR "    falling back to using original solr_URL: $solr_url\n";
    }

    return $solr_url;
}


# bin/solr post --mode stdin --url <collection endpoint> --type application/xml -out
# -out prints info back to console
sub get_post_pipe_cmd
{
    my ($core, $solr_base_url) = @_;

    my $solr_post_cmd = &util::filename_cat($ENV{'GEXT_SOLR9'}, "solr", "bin", "solr");
    # Now run solr-post command
    # See https://wiki.apache.org/solr/UpdateXmlMessages
    # also https://lucene.apache.org/solr/4_2_1/tutorial.html
        # suffixing commit=true/commitWithin=10000 to solr's /update servlet didn't work, because
        # when using SimplePostTool, the commit only happens after the pipe to the tool is closed
    #my $post_props = "-Durl=$solr_base_url/$core/update"; # robustness of protocol is taken care of too

    #$post_props .= " -Ddata=stdin";
    #$post_props .= " -Dcommit=yes";

    $solr_post_cmd .= " post --name $core --mode stdin --type application/xml --solr-url $solr_base_url";
    # increased VM mem from 512 to 1024, but increasing to 2048M didn't help either when too much
    # data streamed to SimplePostTool before commit. Nothing works short of committing before the
    # data streamed gets too large. The solution is to close and reopen the pipe to force commits.
    #my $post_java_cmd = "java -Xmx1024M $post_props -jar \"$full_post_jar\"";
    
       ##print STDERR "**** post cmd = $post_java_cmd\n";
    
    return $solr_post_cmd;
}

sub open_post_pipe
{
    my ($core, $solr_base_url) = @_;
    my $post_java_cmd = &get_post_pipe_cmd($core, $solr_base_url);

    open (PIPEOUT, "| $post_java_cmd") 
	|| die "Error in solr_passes.pl: Failed to run $post_java_cmd\n!$\n";

    return $post_java_cmd; # return the post_java_cmd so caller can store it and reopen_post_pipe()
}

sub reopen_post_pipe
{
    my $post_java_cmd = shift(@_);
    
    open (PIPEOUT, "| $post_java_cmd") 
	|| die "Error in solrutil::reopen_post_pipe: Failed to run $post_java_cmd\n!$\n";
    
}

sub print_to_post_pipe
{
    my ($line) = @_;

    print PIPEOUT $line;
}

sub close_post_pipe
{
    # closing the pipe has the effect of shutting down solr-post.jar
    close(PIPEOUT);
}

1;
