/*
 *    GroupsUtil.java
 *
 *    Utility class to handle working out collection access based on group
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.greenstone.gsdl3.util;

import org.apache.log4j.Logger;

/**
 * A class to contain static methods that are used to work out
 * collection access based on groups
 */
public class GroupsUtil
{

  public static final String ADMIN_GROUP = "administrator";
  public static final String ALL_COLL_EDITOR_GROUP = "all-collections-editor";
  public static final String SHARED_COLL_EDITOR_GROUP = "shared-collections-editor";
  public static final String PERSONAL_COLL_EDITOR_GROUP = "personal-collections-editor";
  public static final String ONE_COLL_EDITOR_GROUP_SUFFIX = "-collection-editor";
  
  static Logger logger = Logger.getLogger(org.greenstone.gsdl3.util.GroupsUtil.class.getName());

  public static boolean isAdministrator(String groups) {
    return groups.contains(ADMIN_GROUP);
  }

  public static boolean canCreateCollection(String groups) {
    if (groups.contains(ADMIN_GROUP)) return true;
    if (groups.contains(ALL_COLL_EDITOR_GROUP)) return true;
    if (groups.contains(SHARED_COLL_EDITOR_GROUP)) return true;
    if (groups.contains(PERSONAL_COLL_EDITOR_GROUP)) return true;
    return false;
  }
  
  public static boolean canEditCollection(String user, String groups, String collection) {
    // administrator can do anything
    if (groups.contains(ADMIN_GROUP)) {
      return true;
    }
    // all-colllections-editor can edit any collection
    if (groups.contains(ALL_COLL_EDITOR_GROUP)) {
      return true;
      
    }

    // personal collection. only the owner can edit (apart from all-collections-editor which has already been handled)
    if(collection.contains("@")) {
      String collectionOwner = collection.substring(0, collection.indexOf("@"));
    
      if (groups.contains(PERSONAL_COLL_EDITOR_GROUP)&& user.equals(collectionOwner)) {
        return true;
      }
      return false;
    }

    // shared-collection-editor can edit any non-personal collection
    if (groups.contains(SHARED_COLL_EDITOR_GROUP)) {
      return true;
    }
    // xxx-collection editor can edit the xxx collection
    if (groups.contains(collection+ONE_COLL_EDITOR_GROUP_SUFFIX)) {
      return true;
    }
    // sorry, this user can't edit this collection
    return false;
  }

}
