#!/bin/bash

if [ $# = 0 ] ; then
    echo "" >&2
    echo "Usage: $0 <installation-name>" >&2
    echo "" >&2
    exit 1
fi

installation=$1

. ./_gs-wget-check.bash


echo ""
echo "Checking for interface ..."

wget --no-check-certificate -q -O - https://svn.greenstone.org/gs3-installations/$installation/trunk/interfaces/$installation > /dev/null
interface_status=$?

if [ $interface_status == 0 ] ; then
    echo "... found $intstallation"
    ./get-installation-interface.sh $installation
else
    echo "... not found => nothing to download"
fi


echo ""
echo "Checking for site ..."

wget --no-check-certificate -q -O - https://svn.greenstone.org/gs3-installations/$installation/trunk/sites/$installation > /dev/null
site_status=$?

if [ $site_status == 0 ] ; then
    echo "... found $intstallation"
    ./get-installation-site.sh $installation
else
    echo "... not found => nothing to download"
fi

echo ""

echo "Checking for installation specific README instructions ..."
wget --no-check-certificate -q -O - https://svn.greenstone.org/gs3-installations/$installation/trunk/README.txt > /dev/null
install_readme_status=$?

if [ $install_readme_status == 0 ] ; then
    echo "... found"
    echo "----"
    wget --no-check-certificate -q -O - https://svn.greenstone.org/gs3-installations/$installation/trunk/README.txt
    echo "----"
else
    echo "... none found"
fi

echo ""

if [ $interface_status == 0 ] || [ $site_status == 0 ] ; then
    echo "----"
    echo "To use the checked out installation, update:"
    echo "    \$GSDL3SRCHOME/resources/web/servlet.xml.in"
    echo "And restart the server"
    echo "----"
    echo ""
fi
