package org.greenstone.gatherer.gui;


import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSet;
import org.greenstone.gatherer.metadata.MetadataSetManager;
import org.greenstone.gatherer.metadata.MetadataTools;


public class MetadataImportMappingPrompt
    implements ActionListener
{
    final static public int ADD_BUTTON_PRESSED = 0;
    final static public int MERGE_BUTTON_PRESSED = 1;
    final static public int IGNORE_BUTTON_PRESSED = 2;
    final static private Dimension DIALOG_SIZE = new Dimension(640, 180);

    private int result;
    private String metadata_element_name_full = null;
    private GComboBox metadata_sets_combobox = null;
    private GComboBox metadata_elements_combobox = null;
    private JButton add_button = null;
    private JButton merge_button = null;
    private JButton ignore_button = null;
    private JDialog on_screen = null;


    public MetadataImportMappingPrompt(String metadata_element_name_full)
    {
	this.metadata_element_name_full = metadata_element_name_full;

	// Construction and configuration
	JDialog dialog = new ModalDialog(Gatherer.g_man);
        dialog.setComponentOrientation(Dictionary.getOrientation());
	dialog.setModal(true);
	dialog.setSize(DIALOG_SIZE);
	dialog.setJMenuBar(new SimpleMenuBar("importingpreviouslyassignedmetadata"));
	dialog.setTitle(Dictionary.get("MIMP.Title"));
	
	// All the loaded metadata sets except the extracted metadata set are applicable
	ArrayList metadata_sets = MetadataSetManager.getMetadataSets();
	for (int i = metadata_sets.size() - 1; i >= 0; i--) {
	    if (((MetadataSet) metadata_sets.get(i)).getNamespace().equals(MetadataSetManager.EXTRACTED_METADATA_NAMESPACE)) {
		metadata_sets.remove(i);
	    }
	}

  	add_button = new GLIButton(Dictionary.get("MIMP.Add"), Dictionary.get("MIMP.Add_Tooltip"));
 	add_button.addActionListener(this);
  	
  	merge_button = new GLIButton(Dictionary.get("MIMP.Merge"), Dictionary.get("MIMP.Merge_Tooltip"));
  	merge_button.addActionListener(this);
  	merge_button.setEnabled(true);
  	
  	ignore_button = new GLIButton(Dictionary.get("MIMP.Ignore"), Dictionary.get("MIMP.Ignore_Tooltip"));
  	ignore_button.addActionListener(this);
  	ignore_button.setEnabled(true);
  	
	// !! Need to add instructions: "MIMP.Instructions", args: source elem
	metadata_elements_combobox = new GComboBox();

	metadata_sets_combobox = new GComboBox(metadata_sets);
	metadata_sets_combobox.addActionListener(new MetadataSetListSelectionListener());
	metadata_sets_combobox.setSelectedIndex(0);

	// Layout
	JPanel left_pane = new JPanel();
        left_pane.setComponentOrientation(Dictionary.getOrientation());
	left_pane.setLayout(new GridLayout(3,1));
        
        JLabel tmp_lable;
        
        tmp_lable = new JLabel(Dictionary.get("MIMP.Source_Element"));
        tmp_lable.setComponentOrientation(Dictionary.getOrientation());
	left_pane.add(tmp_lable);
        
        tmp_lable = new JLabel(Dictionary.get("MIMP.Target_Set"));
        tmp_lable.setComponentOrientation(Dictionary.getOrientation());
	left_pane.add(tmp_lable);
        
        tmp_lable = new JLabel(Dictionary.get("MIMP.Target_Element"));
        tmp_lable.setComponentOrientation(Dictionary.getOrientation());
	left_pane.add(tmp_lable);

	JPanel right_pane = new JPanel();
        right_pane.setComponentOrientation(Dictionary.getOrientation());
        
	right_pane.setLayout(new GridLayout(3,1));
	tmp_lable = new JLabel(metadata_element_name_full);
        tmp_lable.setComponentOrientation(Dictionary.getOrientation());
        right_pane.add(tmp_lable);
	right_pane.add(metadata_sets_combobox);
	right_pane.add(metadata_elements_combobox);

	JPanel button_pane = new JPanel();
        button_pane.setComponentOrientation(Dictionary.getOrientation());
	button_pane.setBorder(BorderFactory.createEmptyBorder(0,5,5,5));
	button_pane.setLayout(new GridLayout(1,3));
	button_pane.add(add_button);
	button_pane.add(merge_button);
	button_pane.add(ignore_button);

	JPanel content_pane = (JPanel) dialog.getContentPane();
        content_pane.setComponentOrientation(Dictionary.getOrientation());
	content_pane.setLayout(new BorderLayout());
	content_pane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
	content_pane.add(left_pane, BorderLayout.LINE_START);
	content_pane.add(right_pane, BorderLayout.CENTER);
	content_pane.add(button_pane, BorderLayout.SOUTH);

	TestingPreparation.setNamesRecursively(dialog, "MetadataImportMappingPrompt");
	
	// Display
	Dimension screen_size = Configuration.screen_size;
	dialog.setLocation((screen_size.width - DIALOG_SIZE.width) / 2, (screen_size.height - DIALOG_SIZE.height) / 2);
	on_screen = dialog;
	on_screen.setVisible(true); // Blocks until hidden.
	on_screen.dispose();
	on_screen = null;
    }


    /** Any implementation of <i>ActionListener</i> must include this method so that we can be informed when an action has occured.
     * @param event An <strong>ActionEvent</strong> containing information gatherer when this event occured.
     */
    public void actionPerformed(ActionEvent event)
    {
	Object esrc = event.getSource();

	if (esrc == add_button) {
	    result = ADD_BUTTON_PRESSED;
	}
	if (esrc == merge_button) {
	    result = MERGE_BUTTON_PRESSED;
	}
	if (esrc == ignore_button) {
	    result = IGNORE_BUTTON_PRESSED;
	}

	on_screen.setVisible(false);
    }


    public MetadataElement getSelectedMetadataElement()
    {
	return (MetadataElement) metadata_elements_combobox.getSelectedItem();
    }


    public MetadataSet getSelectedMetadataSet()
    {
	return (MetadataSet) metadata_sets_combobox.getSelectedItem();
    }


    public int getResult()
    {
	return result;
    }


    private class MetadataSetListSelectionListener
	implements ActionListener
    {
	public void actionPerformed(ActionEvent event)
	{
	    boolean enable_add_button = true;
	    String metadata_element_name = MetadataTools.getMetadataElementName(metadata_element_name_full);

	    MetadataSet metadata_set = (MetadataSet) metadata_sets_combobox.getSelectedItem();
	    ArrayList metadata_elements = metadata_set.getMetadataSetElements();

	    metadata_elements_combobox.removeAllItems();
	    for (int i = 0; i < metadata_elements.size(); i++) {
		MetadataElement metadata_element = (MetadataElement) metadata_elements.get(i);
		metadata_elements_combobox.addItem(metadata_element);
		if (metadata_element.getName().equals(metadata_element_name)) {
		    metadata_elements_combobox.setSelectedIndex(i);
		    enable_add_button = false;
		}
	    }

	    add_button.setEnabled(enable_add_button);

	    // are there any elements in the set? if not (e.g. with exp set),
	    // disable merge
	    if (metadata_elements.size()==0) {
		merge_button.setEnabled(false);
	    }
	}
    }
}
