/**************************************************************************
 *
 * mg.special.cpp -- Special pass for mg_passes
 * Copyright (C) 1994  Neil Sharman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

// need this to avoid bizarre compiler problems under VC++ 6.0
#if defined (__WIN32__) && !defined (GSDL_USE_IOS_H)
# include <iostream>
#endif

#include "sysfuncs.h"
#include "mg.h"
#include "build.h"

int init_special (const TagInfo &/*tagInfo*/, char * /*FileName*/) {
  return COMPALLOK;
}

int process_special (const TagInfo &/*tagInfo*/, const TextElArray &doc) {
  // print out the document
  TextElArray::const_iterator here = doc.begin();
  TextElArray::const_iterator end = doc.end();
  while (here != end) {
    if ((*here).elType == OpenTagE) {
      cout << "** OpenTag  \"" << (*here).tagName << "\"\tText \""
	   << (*here).text << "\"\n"; 
    } else if ((*here).elType == CloseTagE) {
      cout << "** CloseTag \"" << (*here).tagName << "\"\tText \""
	   << (*here).text << "\"\n";
    } else {
      cout << "** Text     \"" << (*here).text << "\"\n";
    }
    
    ++here;
  }
  
  return COMPALLOK;
}

int done_special (const TagInfo &/*tagInfo*/, char * /*FileName*/) {
  return COMPALLOK;
}
