/*
 *    AbstractAudioSearch.java
 *    Copyright (C) 2011 New Zealand Digital Library, http://www.nzdl.org
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.greenstone.gsdl3.service;

// Greenstone classes
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.GSPath;

// XML classes
import org.w3c.dom.Document;
import org.w3c.dom.Element; 
import org.w3c.dom.NodeList;

// java classes
import java.util.ArrayList;
import java.util.HashMap;

import org.apache.log4j.*;

/** Partially implements a generic audio search service
 */

public abstract class AbstractAudioSearch
    extends AbstractSearch 
{

   static Logger logger = Logger.getLogger(org.greenstone.gsdl3.service.AbstractAudioSearch.class.getName());

   
    public AbstractAudioSearch()
    {
	// the search service
	QUERY_SERVICE = "AudioQuery";
    }

    /** do the actual query 
     * must be implemented by subclass */
    abstract protected Element processAudioQuery(Element request); 
	
}

