/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import opennlp.maxent.DataIndexer;
import opennlp.maxent.EventStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.MutableContext;
import opennlp.maxent.OnePassDataIndexer;

class GISTrainer {
    private boolean _simpleSmoothing = false;
    private boolean _useSlackParameter = false;
    private double sigma = 2.0;
    private double _smoothingObservation = 0.1;
    private boolean printMessages = false;
    private int numTokens;
    private int numPreds;
    private int numOutcomes;
    private int TID;
    private int PID;
    private int OID;
    private int[][] contexts;
    private int[] outcomes;
    private int[] outcomeList;
    private int[] numTimesEventsSeen;
    private String[] outcomeLabels;
    private String[] predLabels;
    private MutableContext[] observedExpects;
    private MutableContext[] params;
    private MutableContext[] modelExpects;
    private int constant;
    private double constantInverse;
    private double correctionParam;
    private double cfObservedExpect;
    private double CFMOD;
    private final double NEAR_ZERO = 0.01;
    private final double LLThreshold = 1.0E-4;
    double[] modelDistribution;
    int[] numfeats;
    double iprob;

    GISTrainer() {
    }

    GISTrainer(boolean printMessages) {
        this();
        this.printMessages = printMessages;
    }

    public void setSmoothing(boolean smooth) {
        this._simpleSmoothing = smooth;
    }

    public void setSmoothingObservation(double timesSeen) {
        this._smoothingObservation = timesSeen;
    }

    public GISModel trainModel(EventStream eventStream, int iterations, int cutoff) {
        return this.trainModel(iterations, new OnePassDataIndexer(eventStream, cutoff));
    }

    public GISModel trainModel(int iterations, DataIndexer di) {
        this.display("Incorporating indexed data for training...  \n");
        this.contexts = di.getContexts();
        this.outcomes = di.getOutcomeList();
        this.numTimesEventsSeen = di.getNumTimesEventsSeen();
        this.numTokens = this.contexts.length;
        this.constant = this.contexts[0].length;
        this.TID = 1;
        while (this.TID < this.contexts.length) {
            if (this.contexts[this.TID].length > this.constant) {
                this.constant = this.contexts[this.TID].length;
            }
            ++this.TID;
        }
        this.constantInverse = 1.0 / (double)this.constant;
        this.display("done.\n");
        this.outcomeLabels = di.getOutcomeLabels();
        this.outcomeList = di.getOutcomeList();
        this.numOutcomes = this.outcomeLabels.length;
        this.iprob = Math.log(1.0 / (double)this.numOutcomes);
        this.predLabels = di.getPredLabels();
        this.numPreds = this.predLabels.length;
        this.display("\tNumber of Event Tokens: " + this.numTokens + "\n");
        this.display("\t    Number of Outcomes: " + this.numOutcomes + "\n");
        this.display("\t  Number of Predicates: " + this.numPreds + "\n");
        int[][] predCount = new int[this.numPreds][this.numOutcomes];
        this.TID = 0;
        while (this.TID < this.numTokens) {
            int j = 0;
            while (j < this.contexts[this.TID].length) {
                int[] nArray = predCount[this.contexts[this.TID][j]];
                int n = this.outcomeList[this.TID];
                nArray[n] = nArray[n] + this.numTimesEventsSeen[this.TID];
                ++j;
            }
            ++this.TID;
        }
        di = null;
        double smoothingObservation = this._smoothingObservation;
        this.params = new MutableContext[this.numPreds];
        this.modelExpects = new MutableContext[this.numPreds];
        this.observedExpects = new MutableContext[this.numPreds];
        int[] activeOutcomes = new int[this.numOutcomes];
        int[] allOutcomesPattern = new int[this.numOutcomes];
        this.OID = 0;
        while (this.OID < this.numOutcomes) {
            allOutcomesPattern[this.OID] = this.OID;
            ++this.OID;
        }
        int numActiveOutcomes = 0;
        this.PID = 0;
        while (this.PID < this.numPreds) {
            int aoi;
            int[] outcomePattern;
            numActiveOutcomes = 0;
            if (this._simpleSmoothing) {
                numActiveOutcomes = this.numOutcomes;
                outcomePattern = allOutcomesPattern;
            } else {
                this.OID = 0;
                while (this.OID < this.numOutcomes) {
                    if (predCount[this.PID][this.OID] > 0) {
                        activeOutcomes[numActiveOutcomes] = this.OID;
                        ++numActiveOutcomes;
                    }
                    ++this.OID;
                }
                if (numActiveOutcomes == this.numOutcomes) {
                    outcomePattern = allOutcomesPattern;
                } else {
                    outcomePattern = new int[numActiveOutcomes];
                    aoi = 0;
                    while (aoi < numActiveOutcomes) {
                        outcomePattern[aoi] = activeOutcomes[aoi];
                        ++aoi;
                    }
                }
            }
            this.params[this.PID] = new MutableContext(outcomePattern, new double[numActiveOutcomes]);
            this.modelExpects[this.PID] = new MutableContext(outcomePattern, new double[numActiveOutcomes]);
            this.observedExpects[this.PID] = new MutableContext(outcomePattern, new double[numActiveOutcomes]);
            aoi = 0;
            while (aoi < numActiveOutcomes) {
                this.OID = outcomePattern[aoi];
                this.params[this.PID].setParameter(aoi, 0.0);
                this.modelExpects[this.PID].setParameter(aoi, 0.0);
                if (predCount[this.PID][this.OID] > 0) {
                    this.observedExpects[this.PID].setParameter(aoi, predCount[this.PID][this.OID]);
                } else if (this._simpleSmoothing) {
                    this.observedExpects[this.PID].setParameter(aoi, smoothingObservation);
                }
                ++aoi;
            }
            ++this.PID;
        }
        if (this._useSlackParameter) {
            int cfvalSum = 0;
            this.TID = 0;
            while (this.TID < this.numTokens) {
                int j = 0;
                while (j < this.contexts[this.TID].length) {
                    this.PID = this.contexts[this.TID][j];
                    if (!this.modelExpects[this.PID].contains(this.outcomes[this.TID])) {
                        cfvalSum += this.numTimesEventsSeen[this.TID];
                    }
                    ++j;
                }
                cfvalSum += (this.constant - this.contexts[this.TID].length) * this.numTimesEventsSeen[this.TID];
                ++this.TID;
            }
            this.cfObservedExpect = cfvalSum == 0 ? Math.log(0.01) : Math.log(cfvalSum);
            this.correctionParam = 0.0;
        }
        predCount = null;
        this.display("...done.\n");
        this.modelDistribution = new double[this.numOutcomes];
        this.numfeats = new int[this.numOutcomes];
        this.display("Computing model parameters...\n");
        this.findParameters(iterations);
        return new GISModel(this.params, this.predLabels, this.outcomeLabels, this.constant, this.correctionParam);
    }

    private void findParameters(int iterations) {
        double prevLL = 0.0;
        double currLL = 0.0;
        this.display("Performing " + iterations + " iterations.\n");
        int i = 1;
        while (i <= iterations) {
            if (i < 10) {
                this.display("  " + i + ":  ");
            } else if (i < 100) {
                this.display(" " + i + ":  ");
            } else {
                this.display(String.valueOf(i) + ":  ");
            }
            currLL = this.nextIteration();
            if (i > 1) {
                if (prevLL > currLL) {
                    System.err.println("Model Diverging: loglikelihood decreased");
                    break;
                }
                if (currLL - prevLL < 1.0E-4) break;
            }
            prevLL = currLL;
            ++i;
        }
        this.observedExpects = null;
        this.modelExpects = null;
        this.numTimesEventsSeen = null;
        this.contexts = null;
    }

    public void eval(int[] context, double[] outsums) {
        int oid = 0;
        while (oid < this.numOutcomes) {
            outsums[oid] = this.iprob;
            this.numfeats[oid] = 0;
            ++oid;
        }
        int i = 0;
        while (i < context.length) {
            MutableContext predParams = this.params[context[i]];
            int[] activeOutcomes = predParams.getOutcomes();
            double[] activeParameters = predParams.getParameters();
            int j = 0;
            while (j < activeOutcomes.length) {
                int oid2;
                int n = oid2 = activeOutcomes[j];
                this.numfeats[n] = this.numfeats[n] + 1;
                int n2 = oid2;
                outsums[n2] = outsums[n2] + this.constantInverse * activeParameters[j];
                ++j;
            }
            ++i;
        }
        double SUM = 0.0;
        int oid3 = 0;
        while (oid3 < this.numOutcomes) {
            outsums[oid3] = this._useSlackParameter ? Math.exp(outsums[oid3] + (1.0 - (double)this.numfeats[oid3] / (double)this.constant) * this.correctionParam) : Math.exp(outsums[oid3]);
            SUM += outsums[oid3];
            ++oid3;
        }
        oid3 = 0;
        while (oid3 < this.numOutcomes) {
            int n = oid3++;
            outsums[n] = outsums[n] / SUM;
        }
    }

    private double nextIteration() {
        double loglikelihood = 0.0;
        this.CFMOD = 0.0;
        int numEvents = 0;
        int numCorrect = 0;
        this.TID = 0;
        while (this.TID < this.numTokens) {
            this.eval(this.contexts[this.TID], this.modelDistribution);
            int j = 0;
            while (j < this.contexts[this.TID].length) {
                this.PID = this.contexts[this.TID][j];
                int[] activeOutcomes = this.modelExpects[this.PID].getOutcomes();
                int aoi = 0;
                while (aoi < activeOutcomes.length) {
                    this.OID = activeOutcomes[aoi];
                    this.modelExpects[this.PID].updateParameter(aoi, this.modelDistribution[this.OID] * (double)this.numTimesEventsSeen[this.TID]);
                    ++aoi;
                }
                if (this._useSlackParameter) {
                    this.OID = 0;
                    while (this.OID < this.numOutcomes) {
                        if (!this.modelExpects[this.PID].contains(this.OID)) {
                            this.CFMOD += this.modelDistribution[this.OID] * (double)this.numTimesEventsSeen[this.TID];
                        }
                        ++this.OID;
                    }
                }
                ++j;
            }
            if (this._useSlackParameter) {
                this.CFMOD += (double)((this.constant - this.contexts[this.TID].length) * this.numTimesEventsSeen[this.TID]);
            }
            loglikelihood += Math.log(this.modelDistribution[this.outcomes[this.TID]]) * (double)this.numTimesEventsSeen[this.TID];
            numEvents += this.numTimesEventsSeen[this.TID];
            if (this.printMessages) {
                int max = 0;
                this.OID = 1;
                while (this.OID < this.numOutcomes) {
                    if (this.modelDistribution[this.OID] > this.modelDistribution[max]) {
                        max = this.OID;
                    }
                    ++this.OID;
                }
                if (max == this.outcomes[this.TID]) {
                    numCorrect += this.numTimesEventsSeen[this.TID];
                }
            }
            ++this.TID;
        }
        this.display(".");
        this.PID = 0;
        while (this.PID < this.numPreds) {
            double[] observed = this.observedExpects[this.PID].getParameters();
            double[] model = this.modelExpects[this.PID].getParameters();
            int[] activeOutcomes = this.params[this.PID].getOutcomes();
            int aoi = 0;
            while (aoi < activeOutcomes.length) {
                this.params[this.PID].updateParameter(aoi, Math.log(observed[aoi]) - Math.log(model[aoi]));
                this.modelExpects[this.PID].setParameter(aoi, 0.0);
                ++aoi;
            }
            ++this.PID;
        }
        if (this.CFMOD > 0.0 && this._useSlackParameter) {
            this.correctionParam += this.cfObservedExpect - Math.log(this.CFMOD);
        }
        this.display(". loglikelihood=" + loglikelihood + "\t" + (double)numCorrect / (double)numEvents + "\n");
        return loglikelihood;
    }

    private void display(String s) {
        if (this.printMessages) {
            System.out.print(s);
        }
    }
}

