/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CyclicCoreLabel;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.parser.ViterbiParserWithOptions;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.trees.CoordinationTransformer;
import edu.stanford.nlp.trees.DependencyPrinter;
import edu.stanford.nlp.trees.DependencyReader;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TreeNormalizer;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.Triple;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnglishGrammaticalStructure
extends GrammaticalStructure {
    private static final long serialVersionUID = -1866362375001969402L;
    public static final String DEFAULT_PARSER_FILE = "/u/nlp/data/lexparser/englishPCFG.ser.gz";
    private static final boolean DEBUG = false;
    private static final String[][] MULTIWORD_PREPS = new String[][]{{"according", "to"}, {"across", "from"}, {"ahead", "of"}, {"along", "with"}, {"alongside", "of"}, {"apart", "from"}, {"as", "for"}, {"as", "from"}, {"as", "of"}, {"as", "per"}, {"as", "to"}, {"aside", "from"}, {"away", "from"}, {"based", "on"}, {"because", "of"}, {"close", "by"}, {"close", "to"}, {"contrary", "to"}, {"compared", "to"}, {"compared", "with"}, {"due", "to"}, {"depending", "on"}, {"except", "for"}, {"exclusive", "of"}, {"far", "from"}, {"followed", "by"}, {"inside", "of"}, {"instead", "of"}, {"irrespective", "of"}, {"next", "to"}, {"near", "to"}, {"off", "of"}, {"out", "of"}, {"outside", "of"}, {"owing", "to"}, {"preliminary", "to"}, {"preparatory", "to"}, {"previous", "to"}, {"prior", "to"}, {"pursuant", "to"}, {"regardless", "of"}, {"subsequent", "to"}, {"such", "as"}, {"thanks", "to"}, {"together", "with"}};
    private static final String[][] THREEWORD_PREPS = new String[][]{{"by", "means", "of"}, {"in", "accordance", "with"}, {"in", "addition", "to"}, {"in", "case", "of"}, {"in", "front", "of"}, {"in", "lieu", "of"}, {"in", "place", "of"}, {"in", "spite", "of"}, {"on", "account", "of"}, {"on", "behalf", "of"}, {"on", "top", "of"}, {"with", "regard", "to"}, {"with", "respect", "to"}};
    public static final int CoNLLX_WordField = 1;
    public static final int CoNLLX_POSField = 3;
    public static final int CoNLLX_GovField = 6;
    public static final int CoNLLX_RelnField = 7;
    public static final int CoNLLX_FieldCount = 10;
    public static final Map<String, GrammaticalRelation> shortNameToGRel = new ConcurrentHashMap<String, GrammaticalRelation>();

    public EnglishGrammaticalStructure(Tree t) {
        this(t, new PennTreebankLanguagePack().punctuationWordRejectFilter());
    }

    public EnglishGrammaticalStructure(Tree t, Filter<String> puncFilter) {
        this(t, puncFilter, (HeadFinder)new SemanticHeadFinder(true), false);
    }

    public EnglishGrammaticalStructure(Tree t, Filter<String> puncFilter, HeadFinder hf) {
        this(t, puncFilter, hf, false);
    }

    public EnglishGrammaticalStructure(Tree t, Filter<String> puncFilter, HeadFinder hf, boolean threadSafe) {
        super(new CoordinationTransformer().transformTree(t), EnglishGrammaticalRelations.values(threadSafe), threadSafe ? EnglishGrammaticalRelations.valuesLock() : null, hf, puncFilter);
    }

    public EnglishGrammaticalStructure(List<TypedDependency> projectiveDependencies, TreeGraphNode root) {
        super(projectiveDependencies, root);
    }

    public static TreeGraphNode getSubject(TreeGraphNode t) {
        TreeGraphNode subj = EnglishGrammaticalStructure.getNodeInRelation(t, EnglishGrammaticalRelations.NOMINAL_SUBJECT);
        if (subj != null) {
            return subj;
        }
        subj = EnglishGrammaticalStructure.getNodeInRelation(t, EnglishGrammaticalRelations.CLAUSAL_SUBJECT);
        if (subj != null) {
            return subj;
        }
        return EnglishGrammaticalStructure.getNodeInRelation(t, EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT);
    }

    @Override
    protected void correctDependencies(Collection<TypedDependency> list) {
        EnglishGrammaticalStructure.correctSubjPassAndPoss(list);
    }

    private static void printListSorted(String title, Collection<TypedDependency> list) {
        ArrayList<TypedDependency> lis = new ArrayList<TypedDependency>(list);
        Collections.sort(lis);
        if (title != null) {
            System.err.println(title);
        }
        System.err.println(lis);
    }

    @Override
    protected void collapseDependencies(List<TypedDependency> list, boolean CCprocess) {
        this.correctDependencies(list);
        EnglishGrammaticalStructure.eraseMultiConj(list);
        EnglishGrammaticalStructure.collapse2WP(list);
        EnglishGrammaticalStructure.collapseFlatMWP(list);
        EnglishGrammaticalStructure.collapse2WPbis(list);
        EnglishGrammaticalStructure.collapse3WP(list);
        EnglishGrammaticalStructure.collapsePrepAndPoss(list);
        EnglishGrammaticalStructure.collapseConj(list);
        EnglishGrammaticalStructure.collapseReferent(list);
        if (CCprocess) {
            EnglishGrammaticalStructure.treatCC(list);
        }
        EnglishGrammaticalStructure.removeDep(list);
        Collections.sort(list);
    }

    @Override
    protected void collapseDependenciesTree(List<TypedDependency> list) {
        this.correctDependencies(list);
        EnglishGrammaticalStructure.eraseMultiConj(list);
        EnglishGrammaticalStructure.collapse2WP(list);
        EnglishGrammaticalStructure.collapseFlatMWP(list);
        EnglishGrammaticalStructure.collapse2WPbis(list);
        EnglishGrammaticalStructure.collapse3WP(list);
        EnglishGrammaticalStructure.collapsePrepAndPoss(list);
        EnglishGrammaticalStructure.collapseConj(list);
        Collections.sort(list);
    }

    protected static GrammaticalRelation conjValue(String conj) {
        String newConj = conj.toLowerCase();
        if (newConj.equals("not") || newConj.equals("instead") || newConj.equals("rather")) {
            newConj = "negcc";
        } else if (newConj.equals("mention") || newConj.equals("to") || newConj.equals("also") || newConj.contains("well") || newConj.equals("&")) {
            newConj = "and";
        }
        return EnglishGrammaticalRelations.getConj(newConj);
    }

    private static void treatCC(Collection<TypedDependency> list) {
        HashMap map = new HashMap();
        HashMap<TreeGraphNode, TypedDependency> subjectMap = new HashMap<TreeGraphNode, TypedDependency>();
        HashSet<TreeGraphNode> withPassiveAuxiliary = new HashSet<TreeGraphNode>();
        ArrayList<TreeGraphNode> rcmodHeads = new ArrayList<TreeGraphNode>();
        ArrayList<TreeGraphNode> prepcDep = new ArrayList<TreeGraphNode>();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.dep())) {
                map.put(typedDep.dep(), new TreeSet());
            }
            ((Set)map.get(typedDep.dep())).add(typedDep);
            if (typedDep.reln().equals(EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER)) {
                withPassiveAuxiliary.add(typedDep.gov());
            }
            if (!(typedDep.reln().getParent() != EnglishGrammaticalRelations.NOMINAL_SUBJECT && typedDep.reln().getParent() != EnglishGrammaticalRelations.SUBJECT && typedDep.reln().getParent() != EnglishGrammaticalRelations.CLAUSAL_SUBJECT || subjectMap.containsKey(typedDep.gov()))) {
                subjectMap.put(typedDep.gov(), typedDep);
            }
            if (typedDep.reln() == EnglishGrammaticalRelations.RELATIVE_CLAUSE_MODIFIER) {
                rcmodHeads.add(typedDep.gov());
            }
            if (!typedDep.reln().toString().startsWith("prepc")) continue;
            prepcDep.add(typedDep.dep());
        }
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>(list);
        for (TypedDependency td : list) {
            if (!EnglishGrammaticalRelations.getConjs().contains(td.reln())) continue;
            TreeGraphNode gov = td.gov();
            TreeGraphNode dep = td.dep();
            Set gov_relations = (Set)map.get(gov);
            if (gov_relations != null) {
                for (TypedDependency td1 : gov_relations) {
                    TreeGraphNode newGov = td1.gov();
                    GrammaticalRelation newRel = td1.reln();
                    if (rcmodHeads.contains(gov) && rcmodHeads.contains(dep)) {
                        if (newRel == EnglishGrammaticalRelations.DIRECT_OBJECT || newRel == EnglishGrammaticalRelations.NOMINAL_SUBJECT) continue;
                        newTypedDeps.add(new TypedDependency(newRel, newGov, dep));
                        continue;
                    }
                    newTypedDeps.add(new TypedDependency(newRel, newGov, dep));
                }
            }
            String tag = dep.parent().value();
            if (!subjectMap.containsKey(gov) || !tag.startsWith("VB") && !tag.startsWith("JJ") || subjectMap.containsKey(dep)) continue;
            TypedDependency tdsubj = (TypedDependency)subjectMap.get(gov);
            GrammaticalRelation relation = tdsubj.reln();
            if (relation == EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT) {
                if (EnglishGrammaticalStructure.isDefinitelyActive(tag)) {
                    relation = EnglishGrammaticalRelations.NOMINAL_SUBJECT;
                }
            } else if (relation == EnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT) {
                if (EnglishGrammaticalStructure.isDefinitelyActive(tag)) {
                    relation = EnglishGrammaticalRelations.CLAUSAL_SUBJECT;
                }
            } else if (relation == EnglishGrammaticalRelations.NOMINAL_SUBJECT) {
                if (withPassiveAuxiliary.contains(dep)) {
                    relation = EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT;
                }
            } else if (relation == EnglishGrammaticalRelations.CLAUSAL_SUBJECT && withPassiveAuxiliary.contains(dep)) {
                relation = EnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT;
            }
            newTypedDeps.add(new TypedDependency(relation, dep, tdsubj.dep()));
        }
        list.clear();
        list.addAll(newTypedDeps);
    }

    private static boolean isDefinitelyActive(String tag) {
        return tag.equals("VB") || tag.equals("VBZ") || tag.equals("VBP") || tag.startsWith("JJ");
    }

    private static void collapseConj(Collection<TypedDependency> list) {
        ArrayList<TreeGraphNode> govs = new ArrayList<TreeGraphNode>();
        for (TypedDependency td : list) {
            if (td.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
            TreeGraphNode gov = td.gov();
            GrammaticalRelation conj = EnglishGrammaticalStructure.conjValue(td.dep().value());
            boolean foundOne = false;
            for (TypedDependency td1 : list) {
                if (td1.gov() != gov) continue;
                if (td1.reln() == EnglishGrammaticalRelations.CONJUNCT) {
                    td1.setReln(conj);
                    foundOne = true;
                    continue;
                }
                if (td1.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
                conj = EnglishGrammaticalStructure.conjValue(td1.dep().value());
            }
            if (!foundOne) continue;
            govs.add(gov);
        }
        Iterator<TypedDependency> iter = list.iterator();
        while (iter.hasNext()) {
            TypedDependency td2 = iter.next();
            if (td2.reln() != EnglishGrammaticalRelations.COORDINATION || !govs.contains(td2.gov())) continue;
            iter.remove();
        }
    }

    private static void collapseReferent(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> refs = new ArrayList<TypedDependency>();
        Iterator<TypedDependency> iter = list.iterator();
        while (iter.hasNext()) {
            TypedDependency td = iter.next();
            if (td.reln() != EnglishGrammaticalRelations.REFERENT) continue;
            refs.add(td);
            iter.remove();
        }
        for (TypedDependency ref : refs) {
            TreeGraphNode dep = ref.dep();
            TreeGraphNode ant = ref.gov();
            for (TypedDependency td : list) {
                if (td.dep() != dep || td.reln() == EnglishGrammaticalRelations.RELATIVE || td.reln() == EnglishGrammaticalRelations.REFERENT || td.gov() == ant) continue;
                td.setDep(ant);
            }
        }
    }

    private static void correctSubjPassAndPoss(Collection<TypedDependency> list) {
        ArrayList<TreeGraphNode> list_auxpass = new ArrayList<TreeGraphNode>();
        for (TypedDependency td : list) {
            if (td.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
            list_auxpass.add(td.gov());
        }
        for (TypedDependency td : list) {
            if (td.reln() == EnglishGrammaticalRelations.NOMINAL_SUBJECT && list_auxpass.contains(td.gov())) {
                td.setReln(EnglishGrammaticalRelations.NOMINAL_PASSIVE_SUBJECT);
            }
            if (td.reln() != EnglishGrammaticalRelations.CLAUSAL_SUBJECT || !list_auxpass.contains(td.gov())) continue;
            td.setReln(EnglishGrammaticalRelations.CLAUSAL_PASSIVE_SUBJECT);
        }
    }

    private static boolean inConjDeps(TypedDependency td, List<Triple<TypedDependency, TypedDependency, Boolean>> conjs) {
        for (Triple<TypedDependency, TypedDependency, Boolean> trip : conjs) {
            if (!td.equals(trip.first())) continue;
            return true;
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    private static void collapsePrepAndPoss(Collection<TypedDependency> list) {
        TreeGraphNode td1Dep;
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        HashMap map = new HashMap();
        ArrayList<TreeGraphNode> partmod = new ArrayList<TreeGraphNode>();
        for (TypedDependency typedDep : list) {
            if (!map.containsKey(typedDep.gov())) {
                map.put(typedDep.gov(), new TreeSet());
            }
            ((SortedSet)map.get(typedDep.gov())).add(typedDep);
            if (typedDep.reln() != EnglishGrammaticalRelations.PARTICIPIAL_MODIFIER) continue;
            partmod.add(typedDep.dep());
        }
        for (TypedDependency td1 : list) {
            TypedDependency tdNew;
            GrammaticalRelation reln;
            TypedDependency prepOtherDep;
            SortedSet possibles;
            if (td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER && td1.reln() != EnglishGrammaticalRelations.RELATIVE || td1.reln() == GrammaticalRelation.KILL || (possibles = (SortedSet)map.get(td1Dep = td1.dep())) == null) continue;
            Pair<TypedDependency, Boolean> prepDep = null;
            TypedDependency ccDep = null;
            ArrayList<Triple<TypedDependency, TypedDependency, Boolean>> conjs = new ArrayList<Triple<TypedDependency, TypedDependency, Boolean>>();
            TreeSet<TypedDependency> otherDtrs = new TreeSet<TypedDependency>();
            boolean samePrepositionInEachConjunct = true;
            int conjIndex = -1;
            for (TypedDependency td2 : possibles) {
                TreeGraphNode td2Dep;
                String td2DepPOS;
                if (td2.reln() != EnglishGrammaticalRelations.CONJUNCT || !(td2DepPOS = (td2Dep = td2.dep()).parent().value()).equals("IN") && !td2DepPOS.equals("TO")) continue;
                samePrepositionInEachConjunct = samePrepositionInEachConjunct && td2Dep.value().equals(td1Dep.value());
                Set possibles2 = (Set)map.get(td2Dep);
                boolean pobj = true;
                prepOtherDep = null;
                if (possibles2 != null) {
                    for (TypedDependency td3 : possibles2) {
                        TreeGraphNode td3Dep = td3.dep();
                        String td3DepPOS = td3Dep.parent().value();
                        if (!(td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || td3DepPOS.equals("IN") || td3DepPOS.equals("TO") || prepOtherDep != null)) {
                            prepOtherDep = td3;
                            if (td3.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                            pobj = false;
                            continue;
                        }
                        otherDtrs.add(td3);
                    }
                }
                if (conjIndex < td2Dep.index()) {
                    conjIndex = td2Dep.index();
                }
                conjs.add(new Triple<TypedDependency, Object, Boolean>(td2, prepOtherDep, pobj));
            }
            if (conjs.isEmpty()) continue;
            String td1DepPOS = td1Dep.parent().value();
            for (TypedDependency td2 : possibles) {
                if (td2.reln() == EnglishGrammaticalRelations.COORDINATION && td2.dep().index() < conjIndex) {
                    ccDep = td2;
                    continue;
                }
                TreeGraphNode td2Dep = td2.dep();
                String td2DepPOS = td2Dep.parent().value();
                if (!(td2.reln() != GrammaticalRelation.DEPENDENT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || !td1DepPOS.equals("IN") && !td1DepPOS.equals("TO") && !td1DepPOS.equals("VBG") || prepDep != null || td2DepPOS.equals("RB") || td2DepPOS.equals("IN") || td2DepPOS.equals("TO"))) {
                    prepDep = new Pair<TypedDependency, Boolean>(td2, td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT);
                    continue;
                }
                if (EnglishGrammaticalStructure.inConjDeps(td2, conjs)) continue;
                otherDtrs.add(td2);
            }
            if (prepDep == null || ccDep == null) continue;
            if (samePrepositionInEachConjunct) {
                reln = EnglishGrammaticalStructure.determinePrepRelation(map, partmod, td1, td1, (Boolean)prepDep.second());
                tdNew = new TypedDependency(reln, td1.gov(), ((TypedDependency)prepDep.first()).dep());
                newTypedDeps.add(tdNew);
                td1.setReln(GrammaticalRelation.KILL);
                ((TypedDependency)prepDep.first()).setReln(GrammaticalRelation.KILL);
                ccDep.setReln(GrammaticalRelation.KILL);
                for (Triple trip : conjs) {
                    TypedDependency conjDep = (TypedDependency)trip.first();
                    prepOtherDep = (TypedDependency)trip.second();
                    if (prepOtherDep == null) {
                        ccDep.setReln(GrammaticalRelation.KILL);
                    } else {
                        TypedDependency tdNew2 = new TypedDependency(EnglishGrammaticalStructure.conjValue(ccDep.dep().value()), prepDep.first().dep(), prepOtherDep.dep());
                        newTypedDeps.add(tdNew2);
                        prepOtherDep.setReln(GrammaticalRelation.KILL);
                    }
                    conjDep.setReln(GrammaticalRelation.KILL);
                }
                for (TypedDependency otd : otherDtrs) {
                    otd.setGov(td1.gov());
                }
                for (TypedDependency td2 : possibles) {
                    if (td2.reln() == GrammaticalRelation.KILL || td2.gov() != td1.dep()) continue;
                    td2.setGov(td1.gov());
                }
                continue;
            }
            for (Triple trip : conjs) {
                if (trip.first() == null || trip.second() != null) continue;
                trip.setSecond(new TypedDependency(((TypedDependency)prepDep.first()).reln(), ((TypedDependency)trip.first()).dep(), ((TypedDependency)prepDep.first()).dep()));
                trip.setThird(prepDep.second());
            }
            reln = EnglishGrammaticalStructure.determinePrepRelation(map, partmod, td1, td1, (Boolean)prepDep.second());
            tdNew = new TypedDependency(reln, td1.gov(), ((TypedDependency)prepDep.first()).dep());
            newTypedDeps.add(tdNew);
            td1.setReln(GrammaticalRelation.KILL);
            ((TypedDependency)prepDep.first()).setReln(GrammaticalRelation.KILL);
            ccDep.setReln(GrammaticalRelation.KILL);
            int copyNumber = 1;
            for (Triple trip : conjs) {
                TypedDependency conjDep = (TypedDependency)trip.first();
                TypedDependency prepOtherDep2 = (TypedDependency)trip.second();
                boolean pobj = (Boolean)trip.third();
                TreeGraphNode copy = new TreeGraphNode(td1.gov());
                CyclicCoreLabel label = new CyclicCoreLabel(td1.gov().label());
                label.set(CoreAnnotations.CopyAnnotation.class, copyNumber);
                ++copyNumber;
                copy.setLabel(label);
                TypedDependency tdNew2 = new TypedDependency(EnglishGrammaticalStructure.conjValue(ccDep.dep().value()), td1.gov(), copy);
                newTypedDeps.add(tdNew2);
                GrammaticalRelation reln2 = EnglishGrammaticalStructure.determinePrepRelation(map, partmod, conjDep, td1, pobj);
                TypedDependency tdNew3 = new TypedDependency(reln2, copy, prepOtherDep2.dep());
                newTypedDeps.add(tdNew3);
                conjDep.setReln(GrammaticalRelation.KILL);
                prepOtherDep2.setReln(GrammaticalRelation.KILL);
                for (TypedDependency otd : otherDtrs) {
                    if (otd.dep().parent().value().equals("IN")) {
                        otd.setReln(EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER);
                    }
                    otd.setGov(td1.gov());
                }
            }
            for (TypedDependency td2 : possibles) {
                if (td2.reln() == GrammaticalRelation.KILL) continue;
                td2.setGov(td1.gov());
            }
        }
        for (TypedDependency td1 : list) {
            if (td1.reln() == GrammaticalRelation.KILL) continue;
            td1Dep = td1.dep();
            String td1DepPOS = td1Dep.parent().value();
            Set possibles = (Set)map.get(td1Dep);
            if (possibles != null && (td1.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER || td1.reln() == EnglishGrammaticalRelations.RELATIVE || td1.reln() == EnglishGrammaticalRelations.POSSESSION_MODIFIER || td1.reln() == EnglishGrammaticalRelations.CONJUNCT)) {
                boolean pobj = true;
                for (TypedDependency td2 : possibles) {
                    if (td2.reln() == EnglishGrammaticalRelations.COORDINATION || td2.reln() == EnglishGrammaticalRelations.CONJUNCT) continue;
                    TreeGraphNode td2Dep = td2.dep();
                    String td2DepPOS = td2Dep.parent().value();
                    if (td1.reln() == EnglishGrammaticalRelations.POSSESSION_MODIFIER || td1.reln() == EnglishGrammaticalRelations.CONJUNCT) {
                        if (td2.reln() != EnglishGrammaticalRelations.POSSESSIVE_MODIFIER || map.containsKey(td2Dep)) continue;
                        td2.setReln(GrammaticalRelation.KILL);
                        continue;
                    }
                    if (td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || !td1DepPOS.equals("IN") && !td1DepPOS.equals("TO") && !td1DepPOS.equals("VBG") || td2DepPOS.equals("RB") || td2DepPOS.equals("IN") || td2DepPOS.equals("TO") || EnglishGrammaticalStructure.isConjWithNoPrep(td2.gov(), possibles)) continue;
                    if (td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) {
                        pobj = false;
                    }
                    GrammaticalRelation reln = EnglishGrammaticalStructure.determinePrepRelation(map, partmod, td1, td1, pobj);
                    TypedDependency td3 = new TypedDependency(reln, td1.gov(), td2.dep());
                    ((SortedSet)map.get(td3.gov())).add(td3);
                    newTypedDeps.add(td3);
                    td1.setReln(GrammaticalRelation.KILL);
                    td2.setReln(GrammaticalRelation.KILL);
                }
            }
            if (possibles == null || td1.reln() != GrammaticalRelation.KILL) continue;
            for (TypedDependency td2 : possibles) {
                if (td2.reln() == GrammaticalRelation.KILL) continue;
                td2.setGov(td1.gov());
            }
        }
        Iterator<TypedDependency> iter = list.iterator();
        while (iter.hasNext()) {
            TypedDependency td = iter.next();
            if (td.reln() != GrammaticalRelation.KILL) continue;
            iter.remove();
        }
        list.addAll(newTypedDeps);
    }

    private static GrammaticalRelation determinePrepRelation(Map<TreeGraphNode, ? extends Set<TypedDependency>> map, List<TreeGraphNode> partmod, TypedDependency pc, TypedDependency topPrep, boolean pobj) {
        boolean agent = false;
        String preposition = pc.dep().value().toLowerCase();
        if (preposition.equals("by")) {
            Set<TypedDependency> aux_pass_poss = map.get(topPrep.gov());
            if (aux_pass_poss != null) {
                for (TypedDependency td_pass : aux_pass_poss) {
                    if (td_pass.reln() != EnglishGrammaticalRelations.AUX_PASSIVE_MODIFIER) continue;
                    agent = true;
                }
            }
            if (!partmod.isEmpty() && partmod.contains(topPrep.gov())) {
                agent = true;
            }
        }
        GrammaticalRelation reln = agent ? EnglishGrammaticalRelations.AGENT : (pc.reln() == EnglishGrammaticalRelations.RELATIVE ? EnglishGrammaticalRelations.RELATIVE : (pobj ? EnglishGrammaticalRelations.getPrep(preposition) : EnglishGrammaticalRelations.getPrepC(preposition)));
        return reln;
    }

    private static boolean isConjWithNoPrep(TreeGraphNode node, Collection<TypedDependency> list) {
        for (TypedDependency td : list) {
            String tdDepPOS;
            if (td.gov() != node || td.reln() != EnglishGrammaticalRelations.CONJUNCT || (tdDepPOS = td.dep().parent().value()).equals("IN") || tdDepPOS.equals("TO")) continue;
            return true;
        }
        return false;
    }

    private static void collapse2WP(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : MULTIWORD_PREPS) {
            EnglishGrammaticalStructure.collapseMultiWordPrep(list, newTypedDeps, mwp[0], mwp[1], mwp[0], mwp[1]);
            EnglishGrammaticalStructure.collapseMultiWordPrep(list, newTypedDeps, mwp[0], mwp[1], mwp[1], mwp[0]);
        }
    }

    private static void collapseMultiWordPrep(Collection<TypedDependency> list, Collection<TypedDependency> newTypedDeps, String str_mwp0, String str_mwp1, String w_mwp0, String w_mwp1) {
        TreeGraphNode mwp0 = null;
        TreeGraphNode mwp1 = null;
        TypedDependency dep = null;
        for (TypedDependency td : list) {
            if (!td.gov().value().equalsIgnoreCase(w_mwp0) || !td.dep().value().equalsIgnoreCase(w_mwp1) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
            mwp0 = td.gov();
            mwp1 = td.dep();
            dep = td;
        }
        TreeGraphNode governor = null;
        TypedDependency prep = null;
        for (TypedDependency td1 : list) {
            if (td1.dep() != mwp0 || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER && td1.reln() != EnglishGrammaticalRelations.ADVERBIAL_MODIFIER && td1.reln() != EnglishGrammaticalRelations.ADJECTIVAL_MODIFIER && td1.reln() != GrammaticalRelation.DEPENDENT && td1.reln() != EnglishGrammaticalRelations.MULTI_WORD_EXPRESSION) continue;
            prep = td1;
            governor = prep.gov();
        }
        TypedDependency pobj = null;
        TypedDependency newtd = null;
        for (TypedDependency td2 : list) {
            if (td2.gov() != mwp1 && td2.gov() != mwp0 || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT && td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT || pobj != null && pobj.dep().index() <= td2.dep().index()) continue;
            pobj = td2;
            GrammaticalRelation gr = td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT ? EnglishGrammaticalRelations.getPrepC(str_mwp0 + '_' + str_mwp1) : EnglishGrammaticalRelations.getPrep(str_mwp0 + '_' + str_mwp1);
            if (governor == null) continue;
            newtd = new TypedDependency(gr, governor, pobj.dep());
        }
        if (prep != null && dep != null && pobj != null && newtd != null) {
            prep.setReln(GrammaticalRelation.KILL);
            dep.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            newTypedDeps.add(newtd);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov() == mwp0 || td1.gov() == mwp1) {
                    if (td1.reln() == EnglishGrammaticalRelations.TEMPORAL_MODIFIER) {
                        td1.setGov(pobj.dep());
                    } else {
                        td1.setGov(governor);
                    }
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
    }

    private static void collapse2WPbis(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : MULTIWORD_PREPS) {
            TreeGraphNode mwp0 = null;
            TreeGraphNode mwp1 = null;
            TreeGraphNode governor = null;
            TypedDependency prep = null;
            TypedDependency dep = null;
            TypedDependency pobj = null;
            TypedDependency newtd = null;
            for (TypedDependency td : list) {
                if (!td.dep().value().equalsIgnoreCase(mwp[0]) || td.reln() != EnglishGrammaticalRelations.PHRASAL_VERB_PARTICLE && td.reln() != EnglishGrammaticalRelations.ADVERBIAL_MODIFIER && td.reln() != GrammaticalRelation.DEPENDENT && td.reln() != EnglishGrammaticalRelations.MULTI_WORD_EXPRESSION) continue;
                governor = td.gov();
                mwp0 = td.dep();
                dep = td;
            }
            for (TypedDependency td1 : list) {
                if (mwp0 == null || !td1.dep().value().equalsIgnoreCase(mwp[1]) || td1.gov() != governor || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER || Math.abs(td1.dep().index() - mwp0.index()) != 1) continue;
                mwp1 = td1.dep();
                prep = td1;
            }
            for (TypedDependency td2 : list) {
                GrammaticalRelation gr;
                if (td2.gov() == mwp1 && td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + '_' + mwp[1]);
                    if (governor != null) {
                        newtd = new TypedDependency(gr, governor, pobj.dep());
                    }
                }
                if (td2.gov() != mwp1 || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + '_' + mwp[1]);
                if (governor == null) continue;
                newtd = new TypedDependency(gr, governor, pobj.dep());
            }
            if (prep == null || pobj == null || newtd == null) continue;
            prep.setReln(GrammaticalRelation.KILL);
            dep.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            newTypedDeps.add(newtd);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov() == mwp0 || td1.gov() == mwp1) {
                    td1.setGov(governor);
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
    }

    private static void collapse3WP(Collection<TypedDependency> list) {
        GrammaticalRelation gr;
        TypedDependency newtd;
        TypedDependency pobj;
        TypedDependency prep;
        TreeGraphNode governor;
        TypedDependency dep2;
        TypedDependency dep1;
        TreeGraphNode mwp2;
        TreeGraphNode mwp1;
        TreeGraphNode mwp0;
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : THREEWORD_PREPS) {
            mwp0 = null;
            mwp1 = null;
            mwp2 = null;
            dep1 = null;
            dep2 = null;
            for (TypedDependency td : list) {
                if (!td.gov().value().equalsIgnoreCase(mwp[0]) || !td.dep().value().equalsIgnoreCase(mwp[1]) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
                mwp0 = td.gov();
                mwp1 = td.dep();
                dep1 = td;
            }
            for (TypedDependency td : list) {
                if (td.gov() != mwp1 || !td.dep().value().equalsIgnoreCase(mwp[2]) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
                mwp2 = td.dep();
                dep2 = td;
            }
            if (dep1 == null || dep2 == null) continue;
            governor = null;
            prep = null;
            for (TypedDependency td1 : list) {
                if (td1.dep() != mwp0 || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER) continue;
                prep = td1;
                governor = prep.gov();
            }
            pobj = null;
            newtd = null;
            for (TypedDependency td2 : list) {
                if (td2.gov() == mwp2 && td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + '_' + mwp[1] + '_' + mwp[2]);
                    if (governor != null) {
                        newtd = new TypedDependency(gr, governor, pobj.dep());
                    }
                }
                if (td2.gov() != mwp2 || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + '_' + mwp[1] + '_' + mwp[2]);
                if (governor == null) continue;
                newtd = new TypedDependency(gr, governor, pobj.dep());
            }
            if (prep == null || pobj == null || newtd == null) continue;
            prep.setReln(GrammaticalRelation.KILL);
            dep1.setReln(GrammaticalRelation.KILL);
            dep2.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            newTypedDeps.add(newtd);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov() == mwp0 || td1.gov() == mwp1 || td1.gov() == mwp2) {
                    td1.setGov(governor);
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
        for (String[] mwp : THREEWORD_PREPS) {
            mwp0 = null;
            mwp1 = null;
            mwp2 = null;
            dep1 = null;
            dep2 = null;
            for (TypedDependency td : list) {
                if (!td.gov().value().equalsIgnoreCase(mwp[0]) || !td.dep().value().equalsIgnoreCase(mwp[1]) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
                mwp0 = td.gov();
                mwp1 = td.dep();
                dep1 = td;
            }
            for (TypedDependency td : list) {
                if (td.gov() != mwp0 || !td.dep().value().equalsIgnoreCase(mwp[2]) || Math.abs(td.gov().index() - td.dep().index()) != 2) continue;
                mwp2 = td.dep();
                dep2 = td;
            }
            if (dep1 == null || dep2 == null) continue;
            governor = null;
            prep = null;
            for (TypedDependency td1 : list) {
                if (td1.dep() != mwp0 || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER) continue;
                prep = td1;
                governor = prep.gov();
            }
            pobj = null;
            newtd = null;
            for (TypedDependency td2 : list) {
                if (td2.gov() == mwp0 && td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + '_' + mwp[1] + '_' + mwp[2]);
                    if (governor != null) {
                        newtd = new TypedDependency(gr, governor, pobj.dep());
                    }
                }
                if (td2.gov() != mwp0 || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + '_' + mwp[1] + '_' + mwp[2]);
                if (governor == null) continue;
                newtd = new TypedDependency(gr, governor, pobj.dep());
            }
            if (prep == null || pobj == null || newtd == null) continue;
            prep.setReln(GrammaticalRelation.KILL);
            dep1.setReln(GrammaticalRelation.KILL);
            dep2.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            newTypedDeps.add(newtd);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov() == mwp0 || td1.gov() == mwp1 || td1.gov() == mwp2) {
                    td1.setGov(governor);
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
    }

    private static void collapseFlatMWP(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> newTypedDeps = new ArrayList<TypedDependency>();
        for (String[] mwp : MULTIWORD_PREPS) {
            TreeGraphNode mwp1 = null;
            TreeGraphNode governor = null;
            TypedDependency prep = null;
            TypedDependency dep = null;
            TypedDependency pobj = null;
            for (TypedDependency td : list) {
                if (!td.gov().value().equalsIgnoreCase(mwp[1]) || !td.dep().value().equalsIgnoreCase(mwp[0]) || Math.abs(td.gov().index() - td.dep().index()) != 1) continue;
                mwp1 = td.gov();
                dep = td;
            }
            for (TypedDependency td1 : list) {
                if (td1.dep() != mwp1 || td1.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_MODIFIER) continue;
                prep = td1;
                governor = prep.gov();
            }
            for (TypedDependency td2 : list) {
                GrammaticalRelation gr;
                if (td2.gov() == mwp1 && td2.reln() == EnglishGrammaticalRelations.PREPOSITIONAL_OBJECT) {
                    pobj = td2;
                    gr = EnglishGrammaticalRelations.getPrep(mwp[0] + '_' + mwp[1]);
                    newTypedDeps.add(new TypedDependency(gr, governor, pobj.dep()));
                }
                if (td2.gov() != mwp1 || td2.reln() != EnglishGrammaticalRelations.PREPOSITIONAL_COMPLEMENT) continue;
                pobj = td2;
                gr = EnglishGrammaticalRelations.getPrepC(mwp[0] + '_' + mwp[1]);
                newTypedDeps.add(new TypedDependency(gr, governor, pobj.dep()));
            }
            if (prep == null || dep == null || pobj == null) continue;
            prep.setReln(GrammaticalRelation.KILL);
            dep.setReln(GrammaticalRelation.KILL);
            pobj.setReln(GrammaticalRelation.KILL);
            for (TypedDependency td1 : list) {
                if (td1.reln() == GrammaticalRelation.KILL) continue;
                if (td1.gov() == mwp1) {
                    td1.setGov(governor);
                }
                if (newTypedDeps.contains(td1)) continue;
                newTypedDeps.add(td1);
            }
            list.clear();
            list.addAll(newTypedDeps);
        }
    }

    private static void eraseMultiConj(Collection<TypedDependency> list) {
        for (TypedDependency td1 : list) {
            if (td1.reln() != EnglishGrammaticalRelations.COORDINATION) continue;
            TreeGraphNode x = td1.dep();
            for (TypedDependency td2 : list) {
                if (!td2.gov().equals(x) || td2.reln() != GrammaticalRelation.DEPENDENT && td2.reln() != EnglishGrammaticalRelations.MULTI_WORD_EXPRESSION && td2.reln() != EnglishGrammaticalRelations.COORDINATION && td2.reln() != EnglishGrammaticalRelations.ADVERBIAL_MODIFIER && td2.reln() != EnglishGrammaticalRelations.NEGATION_MODIFIER && td2.reln() != EnglishGrammaticalRelations.AUX_MODIFIER) continue;
                td2.setReln(GrammaticalRelation.KILL);
            }
        }
        Iterator<TypedDependency> iter = list.iterator();
        while (iter.hasNext()) {
            TypedDependency td = iter.next();
            if (td.reln() != GrammaticalRelation.KILL) continue;
            iter.remove();
        }
    }

    private static void removeDep(Collection<TypedDependency> list) {
        HashSet<GrammaticalRelation> prepRels = new HashSet<GrammaticalRelation>(EnglishGrammaticalRelations.getPreps());
        prepRels.addAll(EnglishGrammaticalRelations.getPrepsC());
        for (TypedDependency td1 : list) {
            if (!prepRels.contains(td1.reln())) continue;
            TreeGraphNode gov = td1.gov();
            TreeGraphNode dep = td1.dep();
            for (TypedDependency td2 : list) {
                if (td2.reln() != GrammaticalRelation.DEPENDENT || td2.gov() != gov || td2.dep() != dep) continue;
                td2.setReln(GrammaticalRelation.KILL);
            }
        }
        Iterator<TypedDependency> iter = list.iterator();
        while (iter.hasNext()) {
            TypedDependency td = iter.next();
            if (td.reln() != GrammaticalRelation.KILL) continue;
            iter.remove();
        }
    }

    public static void printDependencies(GrammaticalStructure gs, Collection<TypedDependency> deps, Tree tree, boolean conllx, boolean extraSep) {
        System.out.println(EnglishGrammaticalStructure.dependenciesToString(gs, deps, tree, conllx, extraSep));
    }

    public static String dependenciesToString(GrammaticalStructure gs, Collection<TypedDependency> deps, Tree tree, boolean conllx, boolean extraSep) {
        StringBuilder bf;
        block9: {
            HashMap<Integer, Integer> indexToPos;
            block10: {
                block8: {
                    bf = new StringBuilder();
                    indexToPos = new HashMap<Integer, Integer>();
                    List<Tree> gsLeaves = gs.root.getLeaves();
                    for (int i = 0; i < gsLeaves.size(); ++i) {
                        TreeGraphNode leaf = (TreeGraphNode)gsLeaves.get(i);
                        indexToPos.put(leaf.label.index(), i + 1);
                    }
                    if (!conllx) break block8;
                    List<Tree> leaves = tree.getLeaves();
                    ArrayList<String> words = new ArrayList<String>(leaves.size());
                    ArrayList<String> pos = new ArrayList<String>(leaves.size());
                    String[] relns = new String[leaves.size()];
                    int[] govs = new int[leaves.size()];
                    for (Tree leaf : leaves) {
                        words.add(leaf.value());
                        pos.add(leaf.parent(tree).value());
                    }
                    for (TypedDependency dep : deps) {
                        int depPos = (Integer)indexToPos.get(dep.dep().index()) - 1;
                        govs[depPos] = (Integer)indexToPos.get(dep.gov().index());
                        relns[depPos] = dep.reln().toString();
                    }
                    for (int i = 0; i < relns.length; ++i) {
                        String out2 = String.format("%d\t%s\t_\t%s\t%s\t_\t%d\t%s\t_\t_\n", i + 1, words.get(i), pos.get(i), pos.get(i), govs[i], relns[i] != null ? relns[i] : "root");
                        bf.append(out2);
                    }
                    break block9;
                }
                if (!extraSep) break block10;
                ArrayList<TypedDependency> extraDeps = new ArrayList<TypedDependency>();
                for (TypedDependency dep : deps) {
                    if (dep.extra()) {
                        extraDeps.add(dep);
                        continue;
                    }
                    bf.append(EnglishGrammaticalStructure.toStringIndex(dep, indexToPos));
                    bf.append("\n");
                }
                if (extraDeps.isEmpty()) break block9;
                bf.append("======\n");
                for (TypedDependency dep : extraDeps) {
                    bf.append(EnglishGrammaticalStructure.toStringIndex(dep, indexToPos));
                    bf.append("\n");
                }
                break block9;
            }
            for (TypedDependency dep : deps) {
                bf.append(EnglishGrammaticalStructure.toStringIndex(dep, indexToPos));
                bf.append("\n");
            }
        }
        return bf.toString();
    }

    private static String toStringIndex(TypedDependency td, Map<Integer, Integer> indexToPos) {
        TreeGraphNode gov = td.gov();
        TreeGraphNode dep = td.dep();
        return td.reln() + "(" + gov.value() + "-" + indexToPos.get(gov.index()) + gov.toPrimes() + ", " + dep.value() + "-" + indexToPos.get(dep.index()) + dep.toPrimes() + ")";
    }

    public static List<GrammaticalStructure> readCoNLLXGrammaticStructureCollection(String fileName) throws IOException {
        LineNumberReader reader = new LineNumberReader(new FileReader(fileName));
        LinkedList<GrammaticalStructure> gsList = new LinkedList<GrammaticalStructure>();
        ArrayList<List<String>> tokenFields = new ArrayList<List<String>>();
        String inline = reader.readLine();
        while (inline != null) {
            if (!"".equals(inline)) {
                List<String> fields = Arrays.asList(inline.split("\t"));
                if (fields.size() != 10) {
                    throw new RuntimeException(String.format("Error (line %d): 10 fields expected but %d are present", reader.getLineNumber(), fields.size()));
                }
                tokenFields.add(fields);
            } else if (!tokenFields.isEmpty()) {
                ArrayList<TreeGraphNode> tgWordNodes = new ArrayList<TreeGraphNode>(tokenFields.size());
                ArrayList<TreeGraphNode> tgPOSNodes = new ArrayList<TreeGraphNode>(tokenFields.size());
                for (List list : tokenFields) {
                    TreeGraphNode word = new TreeGraphNode(new Word((String)list.get(1)));
                    TreeGraphNode pos = new TreeGraphNode(new Word((String)list.get(3)));
                    tgWordNodes.add(word);
                    tgPOSNodes.add(pos);
                    Tree[] childArr = new TreeGraphNode[]{word};
                    pos.setChildren(childArr);
                    word.setParent(pos);
                }
                TreeGraphNode root = new TreeGraphNode(new Word("-" + (tgWordNodes.size() + 1)));
                root.setChildren(tgPOSNodes.toArray(new TreeGraphNode[tgPOSNodes.size()]));
                ArrayList<TypedDependency> arrayList = new ArrayList<TypedDependency>(tgWordNodes.size());
                for (int i = 0; i < tgWordNodes.size(); ++i) {
                    String parentIdStr = (String)((List)tokenFields.get(i)).get(6);
                    int parentId = Integer.parseInt(parentIdStr) - 1;
                    String grelString = (String)((List)tokenFields.get(i)).get(7);
                    if (parentId == -1 || grelString.equals("null")) continue;
                    GrammaticalRelation grel = shortNameToGRel.get(grelString);
                    if (grel == null) {
                        throw new RuntimeException("Unknown grammatical relation " + grelString + " fields: " + tokenFields.get(i) + "\nNode: " + tgWordNodes.get(i));
                    }
                    TypedDependency tdep = new TypedDependency(grel, (TreeGraphNode)tgWordNodes.get(parentId), (TreeGraphNode)tgWordNodes.get(i));
                    arrayList.add(tdep);
                }
                gsList.add(new EnglishGrammaticalStructure(arrayList, root));
                tokenFields = new ArrayList();
            }
            inline = reader.readLine();
        }
        return gsList;
    }

    private static String[] parseClassConstructArgs(String namePlusArgs) {
        String[] args = StringUtils.EMPTY_STRING_ARRAY;
        String name = namePlusArgs;
        if (namePlusArgs.matches(".*\\([^)]*\\)$")) {
            String argStr = namePlusArgs.replaceFirst("^.*\\(([^)]*)\\)$", "$1");
            args = argStr.split(",");
            name = namePlusArgs.replaceFirst("\\([^)]*\\)$", "");
        }
        String[] tokens = new String[1 + args.length];
        tokens[0] = name;
        System.arraycopy(args, 0, tokens, 1, args.length);
        return tokens;
    }

    private static DependencyReader loadAlternateDependencyReader(String altDepReaderName) {
        DependencyReader altDepReader;
        Class<?> cl;
        Class<DependencyReader> altDepReaderClass = null;
        String[] toks = EnglishGrammaticalStructure.parseClassConstructArgs(altDepReaderName);
        altDepReaderName = toks[0];
        String[] depReaderArgs = new String[toks.length - 1];
        System.arraycopy(toks, 1, depReaderArgs, 0, toks.length - 1);
        try {
            cl = Class.forName(altDepReaderName);
            altDepReaderClass = cl.asSubclass(DependencyReader.class);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (altDepReaderClass == null) {
            try {
                cl = Class.forName("edu.stanford.nlp.trees." + altDepReaderName);
                altDepReaderClass = cl.asSubclass(DependencyReader.class);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (altDepReaderClass == null) {
            System.err.println("Can't load dependency reader " + altDepReaderName + " or edu.stanford.nlp.trees." + altDepReaderName);
            return null;
        }
        if (depReaderArgs.length == 0) {
            try {
                altDepReader = altDepReaderClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                System.err.println("No argument constructor to " + altDepReaderName + " is not public");
                return null;
            }
        }
        try {
            altDepReader = altDepReaderClass.getConstructor(String[].class).newInstance(new Object[]{depReaderArgs});
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            System.err.println(depReaderArgs.length + " argument constructor to " + altDepReaderName + " is not public.");
            return null;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            System.err.println("String arguments constructor to " + altDepReaderName + " does not exist.");
            return null;
        }
        return altDepReader;
    }

    private static DependencyPrinter loadAlternateDependencyPrinter(String altDepPrinterName) {
        Class<?> cl;
        Class<DependencyPrinter> altDepPrinterClass = null;
        String[] toks = EnglishGrammaticalStructure.parseClassConstructArgs(altDepPrinterName);
        altDepPrinterName = toks[0];
        Object[] depPrintArgs = new String[toks.length - 1];
        System.arraycopy(toks, 1, depPrintArgs, 0, toks.length - 1);
        try {
            cl = Class.forName(altDepPrinterName);
            altDepPrinterClass = cl.asSubclass(DependencyPrinter.class);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (altDepPrinterClass == null) {
            try {
                cl = Class.forName("edu.stanford.nlp.trees." + altDepPrinterName);
                altDepPrinterClass = cl.asSubclass(DependencyPrinter.class);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (altDepPrinterClass == null) {
            System.err.printf("Unable to load alternative printer %s or %s. Is your classpath set correctly?\n", altDepPrinterName, "edu.stanford.nlp.trees." + altDepPrinterName);
            return null;
        }
        try {
            DependencyPrinter depPrinter = depPrintArgs.length == 0 ? altDepPrinterClass.newInstance() : altDepPrinterClass.getConstructor(String[].class).newInstance(new Object[]{depPrintArgs});
            return depPrinter;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
        catch (SecurityException e) {
            e.printStackTrace();
            return null;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
        catch (NoSuchMethodException e) {
            if (depPrintArgs == null) {
                System.err.printf("Can't find no-argument constructor %s().\n", altDepPrinterName);
            } else {
                System.err.printf("Can't find constructor %s(%s).\n", altDepPrinterName, Arrays.toString(depPrintArgs));
            }
            return null;
        }
    }

    public static void main(String[] args) {
        MemoryTreebank tb = new MemoryTreebank(new TreeNormalizer());
        Collection<GrammaticalStructure> gsBank = null;
        Properties props = StringUtils.argsToProperties(args);
        String treeFileName = props.getProperty("treeFile");
        String sentFileName = props.getProperty("sentFile");
        String conllXFileName = props.getProperty("conllxFile");
        String altDepPrinterName = props.getProperty("altprinter");
        String altDepReaderName = props.getProperty("altreader");
        String altDepReaderFilename = props.getProperty("altreaderfile");
        String filter = props.getProperty("filter");
        if (sentFileName == null && (altDepReaderName == null || altDepReaderFilename == null) && treeFileName == null && conllXFileName == null && filter == null) {
            try {
                System.err.println("Usage: java EnglishGrammaticalStructure [options]* [-sentFile|-treeFile|-conllxFile file] [-testGraph]");
                System.err.println("  options: -basic, -collapsed, -CCprocessed [the default], -collapsedTree, -parseTree, -test, -parserFile file, -conllx, -keepPunct, -altprinter -altreader -altreaderfile");
                PennTreeReader tr = new PennTreeReader(new StringReader("((S (NP (NNP Sam)) (VP (VBD died) (NP-TMP (NN today)))))"), new LabeledScoredTreeFactory());
                tb.add(tr.readTree());
            }
            catch (Exception e) {
                System.err.println("Horrible error: " + e);
                e.printStackTrace();
            }
        } else if (altDepReaderName != null && altDepReaderFilename != null) {
            DependencyReader altDepReader = EnglishGrammaticalStructure.loadAlternateDependencyReader(altDepReaderName);
            try {
                gsBank = altDepReader.readDependencies(altDepReaderFilename);
            }
            catch (IOException e) {
                System.err.println("Error reading " + altDepReaderFilename);
                return;
            }
        } else if (treeFileName != null) {
            tb.loadPath(treeFileName);
        } else if (filter != null) {
            tb.load(new BufferedReader(new InputStreamReader(System.in)));
        } else if (conllXFileName != null) {
            try {
                gsBank = EnglishGrammaticalStructure.readCoNLLXGrammaticStructureCollection(conllXFileName);
            }
            catch (IOException e) {
                System.err.println("Error reading " + conllXFileName);
                return;
            }
        } else {
            String parserFile = props.getProperty("parserFile");
            if (!EnglishGrammaticalStructure.loadTreebankByParsing(tb, sentFileName, parserFile)) {
                return;
            }
        }
        boolean basic = props.getProperty("basic") != null;
        boolean collapsed = props.getProperty("collapsed") != null;
        boolean CCprocessed = props.getProperty("CCprocessed") != null;
        boolean tree = props.getProperty("collapsedTree") != null;
        boolean nonCollapsed = props.getProperty("nonCollapsed") != null;
        boolean extraSep = props.getProperty("extraSep") != null;
        boolean parseTree = props.getProperty("parseTree") != null;
        boolean test = props.getProperty("test") != null;
        boolean conllx = props.getProperty("conllx") != null;
        boolean keepPunct = props.getProperty("keepPunct") != null;
        boolean checkConnected = props.getProperty("checkConnected") != null;
        boolean portray = props.getProperty("portray") != null;
        boolean makeCopulaHead = props.getProperty("makeCopulaHead") != null;
        DependencyPrinter altDepPrinter = null;
        if (altDepPrinterName != null) {
            altDepPrinter = EnglishGrammaticalStructure.loadAlternateDependencyPrinter(altDepPrinterName);
        }
        Method m = null;
        if (test) {
            try {
                Class<?> sgf = Class.forName("edu.stanford.nlp.trees.semgraph.SemanticGraphFactory");
                m = sgf.getDeclaredMethod("makeFromTree", GrammaticalStructure.class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Filter.class, String.class, Integer.TYPE);
            }
            catch (Exception e) {
                System.err.println("Test cannot check for cycles in tree format (classes not available)");
            }
        }
        if (gsBank == null) {
            gsBank = new TreeBankGrammaticalStructureWrapper(tb, keepPunct, makeCopulaHead);
        }
        for (GrammaticalStructure gs : gsBank) {
            Tree t = gsBank instanceof TreeBankGrammaticalStructureWrapper ? ((TreeBankGrammaticalStructureWrapper)gsBank).getOriginalTree(gs) : gs.root();
            if (test) {
                System.out.println("============= parse tree =======================");
                t.pennPrint();
                System.out.println();
                System.out.println("------------- GrammaticalStructure -------------");
                System.out.println(gs);
                System.out.println("------------- basic dependencies ---------------");
                System.out.println(StringUtils.join(gs.typedDependencies(false), "\n"));
                System.out.println("------------- non-collapsed dependencies (basic + extra) ---------------");
                System.out.println(StringUtils.join(gs.typedDependencies(true), "\n"));
                System.out.println("------------- collapsed dependencies -----------");
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsed(true), "\n"));
                System.out.println("------------- collapsed dependencies tree -----------");
                System.out.println(StringUtils.join(gs.typedDependenciesCollapsedTree(), "\n"));
                System.out.println("------------- CCprocessed dependencies --------");
                System.out.println(StringUtils.join(gs.typedDependenciesCCprocessed(true), "\n"));
                System.out.println("-----------------------------------------------");
                boolean connected = GrammaticalStructure.isConnected(gs.typedDependenciesCollapsed(true));
                System.out.println("collapsed dependencies form a connected graph: " + connected);
                if (!connected) {
                    System.out.println("possible offending nodes: " + GrammaticalStructure.getRoots(gs.typedDependenciesCollapsed(true)));
                }
                if (m != null) {
                    try {
                        Object semGraph = m.invoke(null, gs, false, true, false, false, false, false, null, null, 0);
                        Class<?> sg = Class.forName("edu.stanford.nlp.trees.semgraph.SemanticGraph");
                        Method mDag = sg.getDeclaredMethod("isDag", new Class[0]);
                        boolean isDag = (Boolean)mDag.invoke(semGraph, new Object[0]);
                        System.out.println("tree dependencies form a DAG: " + isDag);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                if (parseTree) {
                    System.out.println("============= parse tree =======================");
                    t.pennPrint();
                    System.out.println();
                }
                if (basic) {
                    if (collapsed || CCprocessed || tree || nonCollapsed) {
                        System.out.println("------------- basic dependencies ---------------");
                    }
                    if (altDepPrinter == null) {
                        EnglishGrammaticalStructure.printDependencies(gs, gs.typedDependencies(false), t, conllx, false);
                    } else {
                        System.out.println(altDepPrinter.dependenciesToString(gs, gs.typedDependencies(false), t));
                    }
                }
                if (nonCollapsed) {
                    if (basic || CCprocessed || collapsed || tree) {
                        System.out.println("----------- non-collapsed dependencies (basic + extra) -----------");
                    }
                    EnglishGrammaticalStructure.printDependencies(gs, gs.allTypedDependencies(), t, conllx, extraSep);
                }
                if (collapsed) {
                    if (basic || CCprocessed || tree || nonCollapsed) {
                        System.out.println("----------- collapsed dependencies -----------");
                    }
                    EnglishGrammaticalStructure.printDependencies(gs, gs.typedDependenciesCollapsed(true), t, conllx, false);
                }
                if (CCprocessed) {
                    if (basic || collapsed || tree || nonCollapsed) {
                        System.out.println("---------- CCprocessed dependencies ----------");
                    }
                    List<TypedDependency> deps = gs.typedDependenciesCCprocessed(true);
                    if (checkConnected && !GrammaticalStructure.isConnected(deps)) {
                        System.err.println("Graph is not connected for:");
                        System.err.println(t);
                        System.err.println("possible offending nodes: " + GrammaticalStructure.getRoots(deps));
                    }
                    EnglishGrammaticalStructure.printDependencies(gs, deps, t, conllx, false);
                }
                if (tree) {
                    if (basic || CCprocessed || collapsed || nonCollapsed) {
                        System.out.println("----------- collapsed dependencies tree -----------");
                    }
                    EnglishGrammaticalStructure.printDependencies(gs, gs.typedDependenciesCollapsedTree(), t, conllx, false);
                }
                if (!(basic || collapsed || CCprocessed || tree || nonCollapsed)) {
                    EnglishGrammaticalStructure.printDependencies(gs, gs.typedDependenciesCCprocessed(true), t, conllx, false);
                }
            }
            if (!portray) continue;
            try {
                Class<?> sgu = Class.forName("edu.stanford.nlp.trees.semgraph.SemanticGraphUtils");
                Method mRender = sgu.getDeclaredMethod("render", GrammaticalStructure.class, String.class);
                mRender.invoke(null, gs, "Collapsed, CC processed deps");
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't use swing to portray semantic graph", e);
            }
        }
    }

    private static boolean loadTreebankByParsing(Treebank tb, String sentFileName, String parserFile) {
        BufferedReader reader;
        ViterbiParserWithOptions lp;
        if (parserFile == null || "".equals(parserFile)) {
            parserFile = DEFAULT_PARSER_FILE;
        }
        try {
            Class[] classes = new Class[]{String.class};
            Constructor<?> constr = Class.forName("edu.stanford.nlp.parser.lexparser.LexicalizedParser").getConstructor(classes);
            String[] opts = new String[]{"-retainTmpSubcategories"};
            lp = (ViterbiParserWithOptions)constr.newInstance(parserFile);
            lp.setOptionFlags(opts);
        }
        catch (Exception cnfe) {
            cnfe.printStackTrace();
            return true;
        }
        try {
            reader = new BufferedReader(new FileReader(sentFileName));
        }
        catch (IOException e) {
            System.err.println("Cannot open file " + sentFileName);
            return true;
        }
        try {
            String line;
            System.err.println("Processing sentence file " + sentFileName);
            while ((line = reader.readLine()) != null) {
                PTBTokenizer<Word> ptb = PTBTokenizer.newPTBTokenizer(new StringReader(line));
                List words = ptb.tokenize();
                if (words.isEmpty()) continue;
                lp.parse(words);
                Tree parseTree = lp.getBestParse();
                tb.add(parseTree);
            }
            reader.close();
        }
        catch (IOException e) {
            System.err.println("IOException reading key file " + sentFileName);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    static {
        for (GrammaticalRelation gr : EnglishGrammaticalRelations.values()) {
            shortNameToGRel.put(gr.getShortName(), gr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeBankGrammaticalStructureWrapper
    extends AbstractCollection<GrammaticalStructure> {
        private final Treebank treebank;
        private final boolean keepPunct;
        private final boolean makeCopulaHead;
        private Map<GrammaticalStructure, Tree> origTrees = new WeakHashMap<GrammaticalStructure, Tree>();

        public TreeBankGrammaticalStructureWrapper(Treebank wrappedTreeBank, boolean keepPunct, boolean makeCopulaHead) {
            this.treebank = wrappedTreeBank;
            this.keepPunct = keepPunct;
            this.makeCopulaHead = makeCopulaHead;
        }

        @Override
        public Iterator<GrammaticalStructure> iterator() {
            return new gsIterator();
        }

        public Tree getOriginalTree(GrammaticalStructure gs) {
            return this.origTrees.get(gs);
        }

        @Override
        public int size() {
            return this.treebank.size();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class gsIterator
        implements Iterator<GrammaticalStructure> {
            Iterator<Tree> tbIterator;

            private gsIterator() {
                this.tbIterator = TreeBankGrammaticalStructureWrapper.this.treebank.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.tbIterator.hasNext();
            }

            @Override
            public GrammaticalStructure next() {
                Tree t = this.tbIterator.next();
                Filter<Object> puncFilter = TreeBankGrammaticalStructureWrapper.this.keepPunct ? Filters.acceptFilter() : new PennTreebankLanguagePack().punctuationWordRejectFilter();
                SemanticHeadFinder hf = new SemanticHeadFinder(!TreeBankGrammaticalStructureWrapper.this.makeCopulaHead);
                EnglishGrammaticalStructure gs = new EnglishGrammaticalStructure(t, puncFilter, hf);
                TreeBankGrammaticalStructureWrapper.this.origTrees.put(gs, t);
                return gs;
            }

            @Override
            public void remove() {
                this.tbIterator.remove();
            }
        }
    }
}

