# It is important that the syntax this file is written in is compliant
# with /bin/sh syntax.  By using this 'older' syntax, then this means
# it will operate with a range of newer default shell terminal windows,
# such as ash, bash, ksh, and zsh

testSource() {

  if test "$0" != "`echo $0 | sed s/SETUP-CLI\.sh//`" ; then
  # if $0 contains "SETUP-CLI.sh" we've been run... $0 is shellname if sourced.
  # One exception is zsh has an option to set it temporarily to the script name
    if test -z "$ZSH_NAME" ; then
     # we aren't using zsh
     gsdl_not_sourced=true
   fi 
  fi

  if test -n "$gsdl_not_sourced" ; then
     echo "  Error: Make sure you source this script, not execute it. Eg:"
     echo "    $ . ./SETUP-CLI.sh"
     echo "  or"
     echo "    $ source ./SETUP-CLI.sh"
     echo "  not"
     echo "    $ ./SETUP-CLI.sh"
     unset gsdl_not_sourced
     exit 1
  fi

  if test ! -f SETUP-CLI.sh ; then
    echo "You must source the script from within the ext-cli directory"
    return 1
  fi
  
  return 0
}


# Note: use return not exit from a sourced script otherwise it kills the shell
testSource
if [ "$?" = "1" ] ; then
    return
fi

export GSDL3_EXTCLI_HOME="$PWD"
echo "Setting environment variable GSDL3_EXTCLI_HOME:"
echo "  $GSDL3_EXTCLI_HOME"

#if test -e ext-cli ; then
    for gsdl_ext in * ; do
	if test -d $gsdl_ext ; then
	    if [[ "$gsdl_ext" == *.inactive ]]; then
		echo "Skipping inactive cli extension $gsdl_ext"
		continue
	    fi
	    echo $gsdl_ext
	    cd $gsdl_ext > /dev/null
	    if test -e SETUP.sh ; then 
		. ./SETUP.sh 
	    fi 
	    cd ..  
	fi
    done
#fi



