/**
 *#########################################################################
 *
 * A component of the Gatherer application, part of the Greenstone digital
 * library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * <BR><BR>
 *
 * Author: John Thompson, Greenstone Digital Library, University of Waikato
 *
 * <BR><BR>
 *
 * Copyright (C) 1999 New Zealand Digital Library Project
 *
 * <BR><BR>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * <BR><BR>
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * <BR><BR>
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *########################################################################
 */
package org.greenstone.gatherer.gui;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.FileManager;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.gui.TestingPreparation;

public class NewFolderOrFilePrompt
    extends JDialog 
    implements ActionListener {
    private FileNode node;
    private JButton cancel_button;
    private JButton ok_button;
    private JTextField name_field;
    private String name;

    private int type;
    private String extension="";
    static final private Dimension SIZE = new Dimension(350,115);

    public NewFolderOrFilePrompt(FileNode node, int type, String extension) {
	super(Gatherer.g_man, true);
        this.setComponentOrientation(Dictionary.getOrientation());
	if (type == FileManager.FILE_TYPE) { 
	    setTitle(Dictionary.get("NewFolderOrFilePrompt.Title_Empty_File"));
        } else if (type== FileManager.DUMMY_TYPE) {
          setTitle(Dictionary.get("NewFolderOrFilePrompt.Title_File"));
	} else {
	    setTitle(Dictionary.get("NewFolderOrFilePrompt.Title_Folder"));
	}
	this.type = type;
	if (extension != null) {
	    this.extension = extension;
	}
	this.node = node;
    }

    public void actionPerformed(ActionEvent event) {
	if (event.getSource() == ok_button) {
          if (type == FileManager.DUMMY_TYPE) {
            // we have hidden the extension
	    name = name_field.getText()+extension;
          } else {
            name = name_field.getText();
          }
	}
	else if(event.getSource() == cancel_button) {
	    name = null;
	}
	dispose();
    }

    // Do not accidentally override JComponent.getName() here, as that returns the name of
    // this widget (this JDialog Java component) and is used for GLI automated testing    
    public String getNameOfNewFolderOrFile() { return this.name; }
    
    public String display() {
	setSize(SIZE);
	JPanel content_pane = (JPanel) getContentPane();
        content_pane.setComponentOrientation(Dictionary.getOrientation());
        
	JPanel labels_pane = new JPanel();
        labels_pane.setComponentOrientation(Dictionary.getOrientation());
	JPanel fields_pane = new JPanel();
        fields_pane.setComponentOrientation(Dictionary.getOrientation());
	JPanel info_pane = new JPanel();
        info_pane.setComponentOrientation(Dictionary.getOrientation());

	JLabel destination_label = new JLabel(Dictionary.get("NewFolderOrFilePrompt.Destination_Name"));
        destination_label.setComponentOrientation(Dictionary.getOrientation());

        
	JTextField destination_textfield = new JTextField(node.getFile().getName());
        destination_textfield.setComponentOrientation(Dictionary.getOrientation());
	destination_textfield.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
	destination_textfield.setEditable(false);
	
	JLabel name_label = new JLabel();
        name_label.setComponentOrientation(Dictionary.getOrientation());
	name_field = new JTextField(getAutomaticName());
        name_field.setComponentOrientation(Dictionary.getOrientation());
		name_field.selectAll(); // select all the text in the textfield
		
	if (type == FileManager.FILE_TYPE || type == FileManager.DUMMY_TYPE) {
	    name_label.setText(Dictionary.get("NewFolderOrFilePrompt.File_Name"));
	    name_field.setToolTipText(Dictionary.get("NewFolderOrFilePrompt.File_Name_Tooltip"));
	} else {
	    name_label.setText(Dictionary.get("NewFolderOrFilePrompt.Folder_Name"));
	    name_field.setToolTipText(Dictionary.get("NewFolderOrFilePrompt.Folder_Name_Tooltip"));
	}

	JPanel button_pane = new JPanel();
        button_pane.setComponentOrientation(Dictionary.getOrientation());
	ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
	
	cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Pure_Cancel_Tooltip"));
	
	// Connection
	cancel_button.addActionListener(this);
	ok_button.addActionListener(this);
	getRootPane().setDefaultButton(ok_button);

	// Layout
	labels_pane.setLayout(new GridLayout(2,1, 5,0));
	labels_pane.add(destination_label);
	labels_pane.add(name_label);

	fields_pane.setLayout(new GridLayout(2,1,0,5));
	fields_pane.add(destination_textfield);
	fields_pane.add(name_field);
	
	info_pane.setLayout(new BorderLayout(5,0));
	info_pane.add(labels_pane, BorderLayout.LINE_START);
	info_pane.add(fields_pane, BorderLayout.CENTER);

	button_pane.setBorder(BorderFactory.createEmptyBorder(5,0,0,0));
	button_pane.setLayout(new GridLayout(1,2,0,5));
	button_pane.add(ok_button);
	button_pane.add(cancel_button);

	content_pane.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
	content_pane.setLayout(new BorderLayout());
	content_pane.add(info_pane, BorderLayout.CENTER);
	content_pane.add(button_pane, BorderLayout.SOUTH);

	// Display
	Rectangle frame_bounds = Gatherer.g_man.getBounds();
	setLocation(frame_bounds.x + (frame_bounds.width - SIZE.width) / 2, frame_bounds.y + (frame_bounds.height - SIZE.height) / 2);

	// have to set component names before making the dialog visible
	// else GUI tester assertj swing can't locate the dialog that's showing by name
	TestingPreparation.setNamesRecursively(this);
	setVisible(true);
	
	return name;
    }

    private String getAutomaticName()
    {
	File file = node.getFile();
	String default_name;
	if (type == FileManager.FILE_TYPE || type ==  FileManager.DUMMY_TYPE) {
          default_name = Dictionary.get("NewFolderOrFilePrompt.Default_File_Name");
	} else {
          default_name = Dictionary.get("NewFolderOrFilePrompt.Default_Folder_Name");
	}
	
	File temp_file = new File(file, default_name+extension);
	int count = 1;
	while (temp_file.exists()) {
	    temp_file = new File(file, default_name + " " + count+extension);
	    count++;
	}
	if (extension.equals("") || type == FileManager.FILE_TYPE) {
	    return temp_file.getName();
	} 
	String name = temp_file.getName();
	// remove the extension - only for dummy files
	return name.substring(0, name.length()-extension.length());
	
    }
}
