/*
 *    MGPassesWrapper.java
 *    Copyright (C) 2002 New Zealand Digital Library, http://www.nzdl.org
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
package org.greenstone.mgpp;


/** java wrapper class for access to gs3_mgpp_passes in C
 *
 * the native side implemented in MGPPPassesWrapperImpl.c
 */

public class MGPPPassesWrapper
{
    static {
	System.loadLibrary("mgpppassjni");
	initIDs();
    }
    
    //static final public char INVF_LEVEL_1 = '1';
    //static final public char INVF_LEVEL_2 = '2';
    //static final public char INVF_LEVEL_3 = '3';
    
    static final public int TEXT_PASS_1 = 0;
    static final public int TEXT_PASS_2 = 1;
    static final public int INDEX_PASS_1 = 2;
    static final public int INDEX_PASS_2 = 3;
    static final public int SPECIAL_PASS = 4;

    //static final public int NO_STEM_OR_CASE = 0;
    //static final public int CASE_ONLY = 1;
    //static final public int STEM_ONLY = 2;
    //static final public int STEM_AND_CASE = 3;

    //static final public String STEMMER_ENGLISH = "english";
    //static final public String STEMMER_FRENCH = "french";
    //static final public String STEMMER_LOVIN = "lovin";
    //static final public String STEMMER_SIMPLE_FRENCH = "simple-french";

    //static final private char END_OF_DOCUMENT = (char) 2;

    public MGPPPassesWrapper() {
	initCSide();
    }

    /** initialise the pass through the documents */
    public native boolean init();
    
    /** add a pass declaration */
    public void addPass(int pass) {
	switch (pass) {
	case TEXT_PASS_1:
	    addPass('T','1');
	    break;
	case TEXT_PASS_2:
	    addPass('T','2');	    
	    break;
	case INDEX_PASS_1:
	    addPass('I','1');
	    break;
	case INDEX_PASS_2:
	    addPass('I','2');
	    break;
	case SPECIAL_PASS:
	    addPass('S','1');
	    break;
	}
    }
    /** set the base path */
    public native void setBasePath(String basepath);
    /** set the file name */
    public native void setFileName(String filename);

    /** set the Document tag */
    public native void setDocumentTag(String tag);

    /** add a level tag */
    public native void addLevelTag(String tag);

    /** set the index level (default word level) */
    public native void setIndexLevel(String tag);
    
    /** Maximum amount of memory to use for  the index  pass-2  file
	inversion  in  megabytes.
    */
    public native void setInversionMemLimit(int limit);

    /** process one or more MGPP documents */
    public boolean processDocument(String doc_text) {
	try {
	    processMGPPDocument(doc_text.getBytes("UTF-8"));
	} catch (Exception e) {
	    e.printStackTrace();
	    return false;
	}
	return true;
    }
   
    /** finalise the pass through the documents */
    public native boolean finish();

    /** get the exit value once finished */
    public native int exitValue();

    /** initialises field and method IDs for java side to enable access on C side */
    private static native void initIDs();

    /** initialises any C side stuff */
    private native boolean initCSide();

    private native void addPass(char pass_type, char pass_num);

    /** process a MGPP document */
    private native boolean processMGPPDocument(byte[] text);

    public static void main(String []args) {

	String doc = "<Document>hello there kath<Title>this is a title</Title></Document><Document>my name is helen</Document>";

	MGPPPassesWrapper wrapper = new MGPPPassesWrapper();
	wrapper.addPass(TEXT_PASS_1);
	wrapper.addPass(TEXT_PASS_2);
	wrapper.setDocumentTag("Document");
	wrapper.setBasePath("/tmp/kjdon/index");
	wrapper.setFileName("idx");

	wrapper.init();
	wrapper.processDocument(doc);
	wrapper.finish();

    }
}
