#!/bin/bash

package=libgsf
version=-1.14.18

progname=$0

source ../cascade-make/lib/cascade-lib.bash GEXTGNOME ../.. $*

prefix=$GEXTGNOME_INSTALLED

export CFLAGS="$CFLAGS -DLIBXML_STATIC"

export CFLAGS="-Dg_memmove=memmove $CFLAGS -I$GEXTGNOME_INSTALLED/include"
export CPPFLAGS="$CPPFLAGS -I$GEXTGNOME_INSTALLED/include"
export CXXFLAGS="$CXXFLAGS -I$GEXTGNOME_INSTALLED/include"
export LDFLAGS="$LDFLAGS -L$GEXTGNOME_INSTALLED/lib"

osversion=`uname -r | sed 's/\..*$//'`;
if [ "x$GSDLOS" = "xdarwin" -a $osversion -ge 11 ] ; then
    export CFLAGS="$CFLAGS -framework Carbon -framework CoreFoundation -framework Security"
    if [ -d /usr/local/lib/pkgconfig ] ; then
	export PKG_CONFIG_PATH=/usr/local/lib/pkgconfig
    fi
fi


opt_run_untar $force_untar $auto_untar $package $version

PARSERPATH=`find $prefix -name "Parser.pm"`
PARSERDIR=`dirname $PARSERPATH`
export PERL5LIB=`dirname $PARSERDIR`

opt_run_configure $force_config $auto_config $package $version $prefix \
  --without-python --without-gdk-pixbuf --disable-shared --enable-static

opt_run_make $compile $package $version
opt_run_make $install $package $version "install"
opt_run_make $clean $package $version "clean"
opt_run_make $distclean $package $version "distclean"

opt_run_tarclean $tarclean $package $version