<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:java="http://xml.apache.org/xslt/java"
	xmlns:util="xalan://org.greenstone.gsdl3.util.XSLTUtil"
	xmlns:gslib="http://www.greenstone.org/skinning"
	xmlns:gsf="http://www.greenstone.org/greenstone3/schema/ConfigFormat"	
	extension-element-prefixes="java util"
	exclude-result-prefixes="java util">

  <!-- This page, structurally speaking, is a hybrid of home.xsl and about.xsl -->
  <!-- Produces a general embedded Phind browser, given the library and collection -->
  
	<!-- use the 'main' layout -->
	<xsl:import href="layouts/main.xsl"/>

	<!-- what is this used for??? Can it be deleted? -->
	<xsl:variable name="groupPath"><xsl:value-of select="/page/pageRequest/paramList/param[@name='group']/@value"/></xsl:variable>

	<!-- set page title -->

	<xsl:template name="pageTitle">WebSwing Phind<!--<gslib:collectionName/><xsl:value-of select="/page/pageResponse/service/applet"/>--></xsl:template>

	<!-- set page breadcrumbs -->
	<xsl:template name="breadcrumbs">
	  <xsl:choose>
	    <xsl:when test="/page/pageRequest/paramList/param[@name='c']/@value != ''">
              <gslib:siteLink/>
              <gslib:rightArrow/>
	      <xsl:if test="$groupPath != ''">
		<gslib:groupLinks/>
		<gslib:rightArrow/>
	      </xsl:if>
	      <a href="{$library_name}/collection/{$collName}/page/about">
		<gslib:collectionName/>
	      </a>
	    </xsl:when>
	    <xsl:otherwise>
	      <xsl:choose>
		<xsl:when test="$groupPath != ''">
		  <a>
		    <xsl:attribute name="href"><gslib:groupHref path="{$groupPath}"/></xsl:attribute>
		    <xsl:attribute name="title"><gslib:groupName path="{$groupPath}"/></xsl:attribute>
		    <gslib:groupName path="{$groupPath}"/>
		  </a>
		</xsl:when>
		<xsl:otherwise>
		  <gslib:siteLink/>
		</xsl:otherwise>
	      </xsl:choose>
	      
	    </xsl:otherwise>
	  </xsl:choose>
	</xsl:template>


	<!-- the page content -->
	<xsl:template match="/page">
  
		<xsl:choose>
			<xsl:when test="$this-element/displayItemList/displayItem[@name='icon']">
			  <img border="0">
				<xsl:attribute name="src"><xsl:value-of select="$this-element/metadataList/metadata[@name='httpPath']"/>/images/<xsl:value-of select="$this-element/displayItemList/displayItem[@name='icon']"/></xsl:attribute>
				<xsl:attribute name="alt">
				  <xsl:value-of select="$this-element/displayItemList/displayItem[@name='name']"/>
				</xsl:attribute>
				<xsl:attribute name="title">
				  <xsl:value-of select="util:getInterfaceText($interface_name, /page/@lang, 'webswing_phindpage')"/>
				</xsl:attribute>
			  </img>		
			</xsl:when>      
		</xsl:choose>	

		<!-- Inactive applet element that is used as a shim by our webswing JavaScript
		     code to read alll param values from and configure the webswing JPhind with.
		     The applet needs to appear on the page before the JavaScript code that
		     tries to locate it, for its parameters to be used to configure the webswing
		     instance. If there applet appears later or there is no applet, the
		     JavaScript will fallback to obtaining the webswing config settings from
		     XSLT/pageResponse.
		-->
		<div id="phind-displaying-info" style="display:none">The Phind Java App</div>
		<!-- the webswing instance and JavaScript code -->
		<xsl:call-template name="webswing-embed-phind"/>
	</xsl:template>
	
	<xsl:template name="webswing-embed-phind">
	  <link rel="stylesheet" href="/{$webswing_context}/css/style.css" />

	  <div id="webswing-phind" class="webswing-element" data-webswing-instance="webswingInstance0" style="width: 500px; height: 500px;">
	    <div id="loading" class="ws-modal-container">
              <div class="ws-login">
		<div  class="ws-login-content">
                  <div class="ws-spinner">
		    <div class="ws-spinner-dot-1"><xsl:comment>filler</xsl:comment></div>
		    <div class="ws-spinner-dot-2"><xsl:comment>filler</xsl:comment></div>
		  </div>
		</div>
              </div>
	    </div>
	  </div>

	  <gsf:script>
	    // https://www.webswing.org/docs/23.2/configure/applet.html
	    // https://www.webswing.org/docs/23.2/configure/swing.html
	    // https://www.webswing.org/docs/23.2/integrate/javascript-api?_h=customArgs%2Cargs#usage-with-customization-and-options	    
	    // https://www.webswing.org/docs/23.2/integrate/embed.html
	    // https://www.webswing.org/docs/20.1/integrate/urlparams.html
	    // https://www.webswing.org/docs/23.2/integrate/urlparams.html
	    // https://www.webswing.org/docs/20.1/integrate/customize.html
	    // https://www.webswing.org/docs/2.7/integrate/embed.html
	    
    var webswingInstance0 = {
        options: {
        autoStart: true,
	//appletParams: getParam('appletParams'),
	//appletParams: {"collection":"tudor", "library":"library"},
            connectionUrl:'/' + gs.xsltParams.webswing_context + '/phind',

	    customization: function(injector) {
	    injector.services.base.handleActionEvent = function(actionName, data, binaryData) {
       	        //console.log("WebSwing actionEvent callback handler: called with actionName = " + actionName);

	        if (actionName === "openURL") {
	          var url = data;
		  // check if a target tab/window name has been specified
		  // TODO: Any better way of passing > 1 string between Java and JavaScript?
		  var index = url.indexOf(" - ");
		  if (index !== -1) {
		     var target = url.substring(index+3); // skip past " - " to get target name
		     url = url.substring(0, index);
		     window.open(url, target);	             
		  } else {
		     window.open(url, '_blank');
		  }
		} else if (actionName == "javaToWebswingJSConsoleLog") {
		    console.log("Got message from java:\n" + data);
		}
	    
	      }
            }

	    
       }
       };

       
       // The applet jar files can just remain in web/applet where they are compiled up
       if(!webswingInstance0.options.args) {
       webswingInstance0.options.args="";       
       }

       var verbosity = 3;
       
       // Set this to false if running the webswing instance as a webswing application. This has
       // nothing to do with if the applet element exists on the page: it can be on the page
       // and you can still decide to run JPhind as a webswing application. If switching
       // between running as application and applet, remember to adjust webswing.config.in
       // If we do push the deprecated applet element onto the page, we can use it as a shim:
       // use JavaScript to read its params and pass them to webswing as configuration args.
       //
       var isWebswingRunAsApplet = true;
       
       // Fill up webswingParams JSON record with non-dynamic values and other vals
       // that may perhaps not be set on the applet element, to use as fallback
       var webswingParams = {
       //"webswing":1, // set in webswing.config.in to discourage editing
       "verbosity": verbosity,
       "phindcgi": "?a=a&amp;rt=r&amp;s=PhindApplet&amp;o=xml&amp;ro=1",
       "classifier": 1, // true or false
       "backdrop": "interfaces/default/images/phindbg1.jpg",
       "orientation": "vertical",
       "depth": 2,
       "resultorder": "L,l,E,e,D,d",
       "fontsize": 10,
       "blocksize": 10
       };

       // When passed into webswing if run as an application, the mostly static args will look like
       //--verbosity 3 --phindcgi \"?a=a&amp;rt=r&amp;s=PhindApplet&amp;o=xml&amp;ro=1\" --classifier 1 --backdrop interfaces/default/images/phindbg1.jpg --orientation vertical --depth 2 --resultorder \"L,l,E,e,D,d\" --fontsize 10 --blocksize 10
       // More will get prefixed and suffixed
       
       
       // The entirely javascript way of setting our webswing app parameters
       // (does not read the parameters set on the applet element)
       // dynamic phind arguments
       webswingParams["collection"] = gs.cgiParams.c;
       webswingParams["library"] = gs.xsltParams.library_name;    

       // If run as webswing application, we need an extra cmdline arg at the *start*: the baseURL
       // It is not of key-value form, just the baseURL by itself.
       if(!isWebswingRunAsApplet) {
          //https://stackoverflow.com/questions/25203124/how-to-get-base-url-with-jquery-or-javascript      
	  var baseURL = window.location.origin+window.location.pathname;
          // webswingInstance0.options.args += "\"" + baseURL+ "?a=a&amp;rt=d&amp;s=PhindApplet&amp;c="+gs.cgiParams.c + "\"";       
	  webswingInstance0.options.args += "\"" + baseURL + "\" ";
       }

       // Special case: width and height are attributes of the applet tag not subelements
       // and may need parsing.
       // Control the width and height of the Java application launched with webswing by
       // passing the width and height params set on the webswing element, unless an applet
       // element is available. In that case try to get the dimensions from the applet tag.

       // Webswing only uses the width and height set on the webswing-phind element when
       // running as applet. If running as application, need to pass in the width and height
       // as parameters, but strip off any px measurement suffix.
       // https://stackoverflow.com/questions/21851633/get-height-from-style-attribute
       var w = document.getElementById("webswing-phind").style.width;
       var h = document.getElementById("webswing-phind").style.height;
       webswingParams["width"] = stripUnitOffAttribute("px", w);
       webswingParams["height"] = stripUnitOffAttribute("px", h);
      

       if(verbosity >= 4) {
          console.log("@@@ Final verbosity: " + webswingParams["verbosity"]
            + ", width: " + webswingParams["width"] + ", height: " + webswingParams["height"]);
       }
       
       // Having collected all the webswingParams, we can finally build up the single webswing customArgs string
       var _args = "";
       for (var webswingParam of Object.keys(webswingParams)) {
          _args += "--" + webswingParam + " \"" + webswingParams[webswingParam] + "\" "; // space at end to precede next arg
       }
       webswingInstance0.options.args += _args.substring(0, _args.length-1); // remove extra space at end

       // When run as webswing applet (instead of as webswing application), the webswing var
       // customargs becomes assigned as the value of key "xtraParams" in webswing.config.in
       // and is a string of key-value pairs. And our Java code is able to successfully
       // receive these key-valye pairs in the form k1::v1;;k2::v2;; (URL form of key-value
       // pairs is not easy to pass in from JavaScript through webswing into Java).

       if(isWebswingRunAsApplet) {
          var xtraParams = webswingInstance0.options.args;
          var hyphens_index = xtraParams.indexOf("--");
          var spaceAfterKey = -1;
          while(hyphens_index >= 0) {
             // Locate start of value in each key-value pair
             spaceAfterKey = xtraParams.indexOf(" ", hyphens_index);
	     if(spaceAfterKey >= 0) {
	        // insert (splice in) the key-value internal separator,creating "key::value"
                xtraParams = [xtraParams.slice(0, spaceAfterKey), "::", xtraParams.slice(spaceAfterKey+1)].join('');
	     }
	     hyphens_index = xtraParams.indexOf("--", hyphens_index+2);
          }
          // now add separator *between* each key-value pairs with ;;
          xtraParams = xtraParams.replaceAll(" --", ";;");
          webswingInstance0.options.args = xtraParams.substring(2);
       }
       
       if(verbosity >= 4) {
          console.log("custom args: " +  webswingInstance0.options.args);
       }
       
       
    function getParam(name) {
        name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
        var results = new RegExp("[\\?&amp;]" + name + "=([^&amp;#]*)").exec(location.href);
        return results == null ? null : decodeURIComponent(results[1]);
    }
	
    function stripUnitOffAttribute(unit, attr) {
       // common code, regardless of whether we use the applet element as a shim or not
       var suffixIndex = 0;
       if(attr) {       
          suffixIndex = attr.indexOf(unit);
          if(suffixIndex>0) {
             attr = attr.substring(0, suffixIndex);
          }
       }       
       return attr;
    }	
  </gsf:script>

	  
  <script data-webswing-global-var="webswing">
    <xsl:text disable-output-escaping="yes">
      var unloaded = false;
    (function (window, document) {
        var loader = function () {
            var baseUrl = '/' + gs.xsltParams.webswing_context + '/phind';
            baseUrl = baseUrl.indexOf("/", baseUrl.length - 1) !== -1 ? baseUrl : (baseUrl + "/");
            var xmlhttp = new XMLHttpRequest();
            xmlhttp.onreadystatechange = function () {
                if (xmlhttp.readyState == XMLHttpRequest.DONE) {
                    var version = xmlhttp.status == 200 ? xmlhttp.responseText : "undefined";
                    var script = document.createElement("script"),
                        tag = document.getElementsByTagName("script")[0];
                    script.src = baseUrl + "javascript/webswing-embed.js?version=" + version;
                    tag.parentNode.insertBefore(script, tag);

		    if (xmlhttp.status != 200) { // possibly no webswing-server
		      document.getElementById("webswing-phind").style.setProperty("display", "none", "important");

		      document.getElementById("phind-displaying-info").style.setProperty("display", "block", "important");
		      document.getElementById("phind-displaying-info").textContent += " cannot be displayed as the webswing extension it requires has possibly been deactivated.";		      
		    }
                }
            };
            xmlhttp.open("GET", baseUrl + "rest/version", true);
            xmlhttp.send();
        };

	var navigatingAway = function () {
	   if(verbosity >= 4) {
	      console.log("*** navigatingAway called");
	   }

	   if(!unloaded) {

	      if(typeof webswingInstance0.kill === 'function') { // it should exist
	         if(verbosity >= 3) {
	            console.log("@@@ Telling webswing to stop the phind application/applet");
		 }
		 webswingInstance0.kill();
		 unloaded = true; // do not unload again, if multiple listeners call navigatingAway() callback function
		 if(verbosity >= 4) {
		    console.log("@@@@ unloaded");
		 }
	      } // else cannot call method that does not exist
	   } else {
	      if(verbosity >= 4) {   
	         console.log("@@@@ already unloaded.");
	      }
	   }
	  
	};

        window.addEventListener ? window.addEventListener("load", loader, false) : window.attachEvent("onload", loader);


	// When the user navigates away from this page or reloads it, we want to shutdown
	// the webswing Java application/applet. For more info, see layouts/webswing-collage.xsl

	window.addEventListener ? window.addEventListener("beforeunload", navigatingAway, false) : window.attachEvent("onbeforeunload", navigatingAway);
	window.addEventListener ? window.addEventListener("pagehide", navigatingAway, false) : window.attachEvent("onpagehide", navigatingAway);
	// Not visibilitychange: it's triggered even if the user minimises the browser window
	// don't want to kill Phind if the user only changed focus to another application.
	//window.addEventListener ? window.addEventListener("visibilitychange", navigatingAway, false) : window.attachEvent("onvisibilitychange", navigatingAway);

	})(window, document);
    </xsl:text>
  </script>



	</xsl:template>

</xsl:stylesheet>  

