/**********************************************************************
 *
 * sqlitedbclass.h -- 
 * Copyright (C) 2008  DL Consulting Ltd
 * Copyright (C) 2010  New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *********************************************************************/

#ifndef SQLITEDBCLASS_H
#define SQLITEDBCLASS_H


#include "sqldbclass.h"
#include "sqlite3.h"


class sqlitedbclass : public sqldbclass
{
public:
  sqlitedbclass(const text_t& gsdlhome);
  virtual ~sqlitedbclass();

  // returns true if opened
  bool opendatabase (const text_t &filename, int mode, int num_retrys, 
		     bool need_filelock);

  void closedatabase ();

  void deletekey (const text_t &key);

  // returns file extension string
  text_t getfileextension ();

  // returns true on success
  bool getkeydata (const text_t& key, text_t &data);

  // returns array of keys
  text_tarray getkeys ();


  // returns array of document OIDs
  virtual text_tarray get_documents_with_metadata_value (const text_tarray &metadata_element_names,
							 const text_t &metadata_value,
							 const text_t &sort_by_metadata_element_name);

  // returns array of values
  virtual text_tarray get_metadata_values (const text_tarray &metadata_element_names,
					   const text_t &metadata_value_filter,
					   const text_t &metadata_value_grouping_expression);

  // returns true on success
  bool setkeydata (const text_t &key, const text_t &data);

protected:
  text_t openfile;
  sqlite3* sqlitefile;

  virtual text_t sql_safe (const text_t &value_arg);

  virtual bool sqlexec (const text_t &sql_cmd);
  virtual bool sqlgetarray (const text_t &sql_cmd, vector<text_tmap> &sql_results);
  virtual bool sqltableexists (const text_t &table_name);

};


#endif
