/**
 *############################################################################
 * A component of the Greenstone Librarian Interface, part of the Greenstone
 * digital library suite from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * Author: Michael Dewsnip, NZDL Project, University of Waikato, NZ
 *
 * Copyright (C) 2004 New Zealand Digital Library Project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *############################################################################
 */

package org.greenstone.gatherer;


import java.io.*;
import java.util.*;


public class DebugStream
{
    static private boolean debugging_enabled = false;
    static private PrintStream debug_stream = null;


    static public void closeDebugStream()
    {
	if (debug_stream != null) {
	    try {
		debug_stream.flush();
		debug_stream.close();
	    }
	    catch (Exception exception) {
		exception.printStackTrace();
	    }
	}
    }


    static public void enableDebugging()
    {
	debugging_enabled = true;
    }


    static public void setDebugging(boolean isEnabled, String caller) {
	if(isEnabled) {
	    System.err.println("**** START DEBUGGING (enabled by: " + caller + ")");
	} else {
	    System.err.println("**** END DEBUGGING (called by: " + caller + ")");
	}
	debugging_enabled = isEnabled;
    }

    static synchronized public boolean isDebuggingEnabled()
    {
	return debugging_enabled;
    }


    static synchronized public void print(Properties properties)
    {
	if (debugging_enabled) {
	    if (debug_stream != null) {
		properties.list(debug_stream);
	    }
	    properties.list(System.err);
	}
    }


    /** Print a message to the debug stream. */
    static synchronized public void print(String message)
    {
	if (debugging_enabled) {
	    if (debug_stream != null) {
		debug_stream.print(message);
	    }
	    System.err.print(message);
	}
    }


    /** Print a message to the debug stream. */
    static synchronized public void println(String message)
    {
	if (debugging_enabled) {
	    if (debug_stream != null) {
		debug_stream.println(message);
	    }
	    System.err.println(message);
	}
    }


    /** Print a stack trace to the debug stream, and always to STDERR. */
    static synchronized public void printStackTrace(Exception exception)
    {
	if (debugging_enabled && debug_stream != null) {
	    exception.printStackTrace(debug_stream);
	}
	exception.printStackTrace();
    }


    static public void setDebugFile(String debug_file_path)
    {
	try {
	    debug_stream = new PrintStream(new FileOutputStream(debug_file_path));
	}
	catch (Exception exception) {
	    exception.printStackTrace();
	}
    }
}
