/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.NativeGlobal;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableEngine;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.tools.debugger.ContextHelper;
import org.mozilla.javascript.tools.debugger.ContextWindow;
import org.mozilla.javascript.tools.debugger.CreateFileWindow;
import org.mozilla.javascript.tools.debugger.EnterInterrupt;
import org.mozilla.javascript.tools.debugger.EvalWindow;
import org.mozilla.javascript.tools.debugger.ExitInterrupt;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.FindFunction;
import org.mozilla.javascript.tools.debugger.JSInternalConsole;
import org.mozilla.javascript.tools.debugger.LoadFile;
import org.mozilla.javascript.tools.debugger.Menubar;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org.mozilla.javascript.tools.debugger.MoreWindows;
import org.mozilla.javascript.tools.debugger.OpenFile;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.debugger.SetFilePosition;
import org.mozilla.javascript.tools.debugger.SetFileText;
import org.mozilla.javascript.tools.debugger.UpdateContext;

public class Main
extends JFrame
implements Debugger,
ContextListener {
    HashSet contexts = new HashSet();
    static Thread mainThread;
    boolean breakFlag = false;
    static final int STEP_OVER = 0;
    static final int STEP_INTO = 1;
    static final int STEP_OUT = 2;
    static final int GO = 3;
    static final int BREAK = 4;
    static final int RUN_TO_CURSOR = 5;
    static final int EXIT = 6;
    private Hashtable threadState = new Hashtable();
    private Thread runToCursorThread;
    private int runToCursorLine;
    private String runToCursorFile;
    private Hashtable sourceNames = new Hashtable();
    Hashtable functionMap = new Hashtable();
    Hashtable breakpointsMap = new Hashtable();
    JDesktopPane desk;
    ContextWindow context;
    Menubar menubar;
    JToolBar toolBar;
    JSInternalConsole console;
    EvalWindow evalWindow;
    JSplitPane split1;
    JLabel statusBar;
    ScopeProvider scopeProvider;
    Runnable exitAction;
    int frameIndex = -1;
    boolean isInterrupted = false;
    boolean nonDispatcherWaiting = false;
    int dispatcherIsWaiting = 0;
    Context currentContext = null;
    JFileChooser dlg;
    Hashtable fileWindows = new Hashtable();
    FileWindow currentWindow;
    Object monitor = new Object();
    Object swingMonitor = new Object();
    int returnValue = -1;
    boolean breakOnExceptions;
    Hashtable toplevels = new Hashtable();
    static /* synthetic */ Class class$javax$swing$JSplitPane;

    public void contextCreated(Context context) {
        HashSet hashSet = this.contexts;
        synchronized (hashSet) {
            DebuggableEngine debuggableEngine = context.getDebuggableEngine();
            debuggableEngine.setDebugger(this);
            context.setGeneratingDebug(true);
            context.setOptimizationLevel(-1);
            if (this.breakFlag || Thread.currentThread() == mainThread) {
                debuggableEngine.setBreakNextLine(true);
            }
        }
    }

    public void contextEntered(Context context) {
        HashSet hashSet = this.contexts;
        synchronized (hashSet) {
            if (!this.contexts.contains(context) && context.getDebuggableEngine().getDebugger() == this) {
                this.contexts.add(context);
            }
        }
    }

    public void contextExited(Context context) {
    }

    public void contextReleased(Context context) {
        HashSet hashSet = this.contexts;
        synchronized (hashSet) {
            this.contexts.remove(context);
        }
    }

    public void doBreak() {
        this.breakFlag = true;
        HashSet hashSet = this.contexts;
        synchronized (hashSet) {
            Iterator iterator = this.contexts.iterator();
            while (iterator.hasNext()) {
                Context context = (Context)iterator.next();
                context.getDebuggableEngine().setBreakNextLine(true);
            }
        }
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.console.consoleTextArea.requestFocus();
            this.context.split.setDividerLocation(0.5);
            try {
                this.console.setMaximum(true);
                this.console.setSelected(true);
                this.console.show();
                this.console.consoleTextArea.requestFocus();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void doClearBreakpoints() {
        Enumeration enumeration = this.breakpointsMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Hashtable hashtable = (Hashtable)this.breakpointsMap.get(string);
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                Integer n = (Integer)hashtable.get(enumeration2.nextElement());
                this.clearBreakPoint(string, n);
            }
        }
    }

    public void handleCompilationDone(Context context, DebuggableScript debuggableScript, StringBuffer stringBuffer) {
        NativeFunction nativeFunction;
        String string;
        Vector<SourceEntry> vector;
        String string2 = debuggableScript.getSourceName();
        if (string2 == null) {
            string2 = "<stdin>";
        }
        if ((vector = (Vector<SourceEntry>)this.sourceNames.get(string2)) == null) {
            vector = new Vector<SourceEntry>();
            this.sourceNames.put(string2, vector);
        }
        SourceEntry sourceEntry = new SourceEntry(stringBuffer, debuggableScript);
        vector.addElement(sourceEntry);
        if (debuggableScript.getScriptable() instanceof NativeFunction && (string = (nativeFunction = (NativeFunction)debuggableScript.getScriptable()).getFunctionName()).length() > 0 && !string.equals("anonymous")) {
            this.functionMap.put(string, sourceEntry);
        }
        this.loadedFile(string2, stringBuffer.toString());
    }

    public void handleBreakpointHit(Context context) {
        this.breakFlag = false;
        this.interrupted(context);
    }

    public void handleExceptionThrown(Context context, Object object) {
        if (this.breakOnExceptions) {
            String string;
            DebuggableEngine debuggableEngine = context.getDebuggableEngine();
            DebugFrame debugFrame = debuggableEngine.getFrame(0);
            String string2 = debugFrame.getSourceName();
            int n = debugFrame.getLineNumber();
            FileWindow fileWindow = null;
            if (string2 == null) {
                string2 = n == -1 ? "<eval>" : "<stdin>";
            } else {
                fileWindow = this.getFileWindow(string2);
            }
            if (object instanceof NativeJavaObject) {
                object = ((NativeJavaObject)object).unwrap();
            }
            if ((string = object.toString()) == null || string.length() == 0) {
                string = object.getClass().toString();
            }
            string = string + " (" + string2 + ", line " + n + ")";
            if (fileWindow != null) {
                Main.swingInvoke(new SetFilePosition(this, fileWindow, n));
            }
            MessageDialogWrapper.showMessageDialog(this, string, "Exception in Script", 0);
            this.interrupted(context);
        }
    }

    void init() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        this.menubar = new Menubar(this);
        this.setJMenuBar(this.menubar);
        this.toolBar = new JToolBar();
        String[] stringArray = new String[]{"Break (Pause)", "Go (F5)", "Step Into (F11)", "Step Over (F7)", "Step Out (F8)"};
        int n = 0;
        JButton jButton7 = jButton6 = (jButton5 = new JButton("Break"));
        jButton6.setToolTipText("Break");
        jButton6.setActionCommand("Break");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(true);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton4 = new JButton("Go");
        jButton6.setToolTipText("Go");
        jButton6.setActionCommand("Go");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(false);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton3 = new JButton("Step Into");
        jButton6.setToolTipText("Step Into");
        jButton6.setActionCommand("Step Into");
        jButton6.addActionListener(this.menubar);
        jButton6.setEnabled(false);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton2 = new JButton("Step Over");
        jButton6.setToolTipText("Step Over");
        jButton6.setActionCommand("Step Over");
        jButton6.setEnabled(false);
        jButton6.addActionListener(this.menubar);
        jButton6.setToolTipText(stringArray[n++]);
        jButton6 = jButton = new JButton("Step Out");
        jButton6.setToolTipText("Step Out");
        jButton6.setActionCommand("Step Out");
        jButton6.setEnabled(false);
        jButton6.addActionListener(this.menubar);
        jButton6.setToolTipText(stringArray[n++]);
        Dimension dimension = jButton2.getPreferredSize();
        jButton5.setPreferredSize(dimension);
        jButton5.setMinimumSize(dimension);
        jButton5.setMaximumSize(dimension);
        jButton5.setSize(dimension);
        jButton4.setPreferredSize(dimension);
        jButton4.setMinimumSize(dimension);
        jButton4.setMaximumSize(dimension);
        jButton3.setPreferredSize(dimension);
        jButton3.setMinimumSize(dimension);
        jButton3.setMaximumSize(dimension);
        jButton2.setPreferredSize(dimension);
        jButton2.setMinimumSize(dimension);
        jButton2.setMaximumSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton.setMaximumSize(dimension);
        this.toolBar.add(jButton5);
        this.toolBar.add(jButton4);
        this.toolBar.add(jButton3);
        this.toolBar.add(jButton2);
        this.toolBar.add(jButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)jPanel, "Center");
        this.desk = new JDesktopPane();
        this.desk.setPreferredSize(new Dimension(600, 300));
        this.desk.setMinimumSize(new Dimension(150, 50));
        this.console = new JSInternalConsole("JavaScript Console");
        this.desk.add(this.console);
        this.context = new ContextWindow(this);
        this.context.setPreferredSize(new Dimension(600, 120));
        this.context.setMinimumSize(new Dimension(50, 50));
        this.split1 = new JSplitPane(0, this.desk, this.context);
        this.split1.setOneTouchExpandable(true);
        Main.setResizeWeight(this.split1, 0.66);
        jPanel.add((Component)this.split1, "Center");
        this.statusBar = new JLabel();
        this.statusBar.setText("Thread: ");
        jPanel.add((Component)this.statusBar, "South");
        this.dlg = new JFileChooser();
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                String string;
                if (file.isDirectory()) {
                    return true;
                }
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                return n > 0 && n < string2.length() - 1 && (string = string2.substring(n + 1).toLowerCase()).equals("js");
            }

            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.dlg.addChoosableFileFilter(fileFilter);
        final Main main = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                main.Exit();
            }
        });
    }

    Scriptable getScope() {
        return this.scopeProvider != null ? this.scopeProvider.getScope() : null;
    }

    FileWindow getFileWindow(String string) {
        if (string == null || string.equals("<stdin>") || string.equals("<eval>")) {
            return null;
        }
        String string2 = string;
        Enumeration enumeration = this.fileWindows.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string2.equals(string3)) continue;
            FileWindow fileWindow = (FileWindow)this.fileWindows.get(string3);
            fileWindow.setUrl(string);
            return fileWindow;
        }
        return (FileWindow)this.fileWindows.get(string);
    }

    void loadedFile(String string, String string2) {
        FileWindow fileWindow = this.getFileWindow(string);
        if (fileWindow != null) {
            Main.swingInvoke(new SetFileText(fileWindow, string2));
            fileWindow.show();
        } else if (!string.equals("<stdin>")) {
            Main.swingInvoke(new CreateFileWindow(this, string, string2, -1));
        }
    }

    static void swingInvoke(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void swingInvokeLater(Runnable runnable) {
        try {
            SwingUtilities.invokeLater(runnable);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    void contextSwitch(int n) {
        Context context = this.getCurrentContext();
        DebuggableEngine debuggableEngine = context.getDebuggableEngine();
        ContextHelper contextHelper = new ContextHelper();
        contextHelper.attach(context);
        if (context != null) {
            int n2 = debuggableEngine.getFrameCount();
            if (n < 0 || n >= n2) {
                contextHelper.reset();
                return;
            }
            this.frameIndex = n;
            DebugFrame debugFrame = debuggableEngine.getFrame(n);
            String string = debugFrame.getSourceName();
            if (string == null || string.equals("<stdin>")) {
                this.console.show();
                contextHelper.reset();
                return;
            }
            if (string == "<eval>") {
                contextHelper.reset();
                return;
            }
            int n3 = debugFrame.getLineNumber();
            this.frameIndex = n;
            FileWindow fileWindow = this.getFileWindow(string);
            if (fileWindow != null) {
                SetFilePosition setFilePosition = new SetFilePosition(this, fileWindow, n3);
                setFilePosition.run();
            } else {
                Vector vector = (Vector)this.sourceNames.get(string);
                String string2 = ((SourceEntry)vector.elementAt((int)0)).source.toString();
                CreateFileWindow createFileWindow = new CreateFileWindow(this, string, string2, n3);
                createFileWindow.run();
            }
            contextHelper.reset();
        }
    }

    Context getCurrentContext() {
        return this.currentContext;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void interrupted(Context var1_1) {
        block58: {
            var2_2 = this.swingMonitor;
            synchronized (var2_2) {
                block59: {
                    if (!EventQueue.isDispatchThread()) ** GOTO lbl-1000
                    ++this.dispatcherIsWaiting;
                    if (!this.nonDispatcherWaiting) break block59;
                    var3_3 = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    while (this.nonDispatcherWaiting) {
                        try {
                            var4_5 = var3_3.getNextEvent();
                            if (var4_5 instanceof ActiveEvent) {
                                ((ActiveEvent)var4_5).dispatch();
                            } else {
                                var5_7 = var4_5.getSource();
                                if (var5_7 instanceof Component) {
                                    var6_8 = (Component)var5_7;
                                    var6_8.dispatchEvent((AWTEvent)var4_5);
                                } else if (var5_7 instanceof MenuComponent) {
                                    ((MenuComponent)var5_7).dispatchEvent((AWTEvent)var4_5);
                                }
                            }
                            if (this.returnValue == 6) {
                                return;
                            }
                            this.swingMonitor.wait(1L);
                        }
                        catch (InterruptedException var4_6) {
                            return;
                        }
                    }
                    break block59;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.swingMonitor.wait();
                            continue;
                        }
                        catch (InterruptedException var3_4) {
                            return;
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        ** while (this.isInterrupted || this.dispatcherIsWaiting > 0)
                    }
lbl35:
                    // 1 sources

                    this.nonDispatcherWaiting = true;
                }
                this.isInterrupted = true;
            }
            this.currentContext = var1_1;
            var3_3 = var1_1.getDebuggableEngine();
            var4_5 = Thread.currentThread();
            this.statusBar.setText("Thread: " + var4_5.toString());
            var5_7 = (ThreadState)this.threadState.get(var4_5);
            var6_9 = -1;
            if (var5_7 != null) {
                var6_9 = ThreadState.access$000((ThreadState)var5_7);
            }
            if (this.runToCursorFile != null && var4_5 == this.runToCursorThread && (var7_11 = var3_3.getFrameCount()) > 0 && (var9_14 = (var8_12 = var3_3.getFrame(0)).getSourceName()) != null && var9_14.equals(this.runToCursorFile)) {
                var10_15 = var8_12.getLineNumber();
                if (var10_15 == this.runToCursorLine) {
                    var6_9 = -1;
                    this.runToCursorFile = null;
                } else {
                    var11_17 = this.getFileWindow((String)var9_14);
                    if (var11_17 == null || !var11_17.isBreakPoint(var10_15)) {
                        return;
                    }
                    this.runToCursorFile = null;
                }
            }
            if (var6_9 <= 0 || var3_3.getFrameCount() <= var6_9) {
                if (var5_7 != null) {
                    ThreadState.access$002((ThreadState)var5_7, -1);
                }
                this.threadState.remove(var4_5);
                var7_11 = var3_3.getFrameCount();
                this.frameIndex = var7_11 - 1;
                var8_13 = 0;
                if (var7_11 != 0) {
                    var9_14 = var3_3.getFrame(0);
                    var10_16 = var9_14.getSourceName();
                    var3_3.setBreakNextLine(false);
                    var8_13 = var9_14.getLineNumber();
                    var11_18 = 0;
                    var12_19 = EventQueue.isDispatchThread();
                    if (!var12_19) {
                        Context.exit();
                        while (Context.getCurrentContext() != null) {
                            Context.exit();
                            ++var11_18;
                        }
                    }
                    if (var10_16 != null && !var10_16.equals("<stdin>")) {
                        var13_20 /* !! */  = this.getFileWindow(var10_16);
                        if (var13_20 /* !! */  != null) {
                            var14_22 = new SetFilePosition(this, (FileWindow)var13_20 /* !! */ , var8_13);
                            Main.swingInvoke((Runnable)var14_22);
                        } else {
                            var14_22 = (Vector)this.sourceNames.get(var10_16);
                            var15_23 = ((SourceEntry)var14_22.elementAt((int)0)).source.toString();
                            var16_26 = new CreateFileWindow(this, var10_16, (String)var15_23, var8_13);
                            Main.swingInvoke((Runnable)var16_26);
                        }
                    } else if (this.console.isVisible()) {
                        var13_20 /* !! */  = this.console;
                        Main.swingInvoke(new Runnable(){

                            public void run() {
                                var13_20.show();
                            }
                        });
                    }
                    Main.swingInvoke(new EnterInterrupt(this, var1_1));
                    Main.swingInvoke(new UpdateContext(this, var1_1));
                    if (!var12_19) {
                        var14_22 = this.monitor;
                        synchronized (var14_22) {
                            this.returnValue = -1;
                            try {
                                while (this.returnValue == -1) {
                                    this.monitor.wait();
                                }
                                var13_21 = this.returnValue;
                            }
                            catch (InterruptedException var15_24) {
                                break block58;
                            }
                        }
                    }
                    var14_22 = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    this.returnValue = -1;
                    while (this.returnValue == -1) {
                        try {
                            var15_23 = var14_22.getNextEvent();
                            if (var15_23 instanceof ActiveEvent) {
                                ((ActiveEvent)var15_23).dispatch();
                                continue;
                            }
                            var16_26 = var15_23.getSource();
                            if (var16_26 instanceof Component) {
                                var17_28 = (Component)var16_26;
                                var17_28.dispatchEvent((AWTEvent)var15_23);
                                continue;
                            }
                            if (!(var16_26 instanceof MenuComponent)) continue;
                            ((MenuComponent)var16_26).dispatchEvent((AWTEvent)var15_23);
                        }
                        catch (InterruptedException var15_25) {
                            // empty catch block
                        }
                    }
                    var13_21 = this.returnValue;
                    Main.swingInvoke(new ExitInterrupt(this));
                    if (!var12_19) {
                        var14_22 = Context.enter(var1_1);
                        if (var14_22 != var1_1) {
                            System.out.println("debugger error: cx = " + var1_1 + " current = " + var14_22);
                        }
                        while (var11_18 > 0) {
                            Context.enter();
                            --var11_18;
                        }
                    }
                    switch (var13_21) {
                        case 0: {
                            var3_3.setBreakNextLine(true);
                            var6_9 = var3_3.getFrameCount();
                            if (var5_7 == null) {
                                var5_7 = new ThreadState();
                            }
                            ThreadState.access$002((ThreadState)var5_7, var6_9);
                            this.threadState.put(var4_5, var5_7);
                            break;
                        }
                        case 1: {
                            var3_3.setBreakNextLine(true);
                            if (var5_7 == null) break;
                            ThreadState.access$002((ThreadState)var5_7, -1);
                            break;
                        }
                        case 2: {
                            var6_9 = var3_3.getFrameCount() - 1;
                            if (var6_9 <= 0) break;
                            var3_3.setBreakNextLine(true);
                            if (var5_7 == null) {
                                var5_7 = new ThreadState();
                            }
                            ThreadState.access$002((ThreadState)var5_7, var6_9);
                            this.threadState.put(var4_5, var5_7);
                            break;
                        }
                        case 5: {
                            var3_3.setBreakNextLine(true);
                            if (var5_7 == null) break;
                            ThreadState.access$002((ThreadState)var5_7, -1);
                        }
                    }
                }
            }
        }
        var3_3 = this.swingMonitor;
        synchronized (var3_3) {
            this.isInterrupted = false;
            if (EventQueue.isDispatchThread()) {
                --this.dispatcherIsWaiting;
            } else {
                this.nonDispatcherWaiting = false;
            }
            this.swingMonitor.notifyAll();
        }
    }

    String chooseFile(String string) {
        int n;
        this.dlg.setDialogTitle(string);
        File file = null;
        String string2 = System.getProperty("user.dir");
        if (string2 != null) {
            file = new File(string2);
        }
        if (file != null) {
            this.dlg.setCurrentDirectory(file);
        }
        if ((n = this.dlg.showOpenDialog(this)) == 0) {
            try {
                String string3 = this.dlg.getSelectedFile().getCanonicalPath();
                file = this.dlg.getSelectedFile().getParentFile();
                System.setProperty("user.dir", file.getPath());
                return string3;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    JInternalFrame getSelectedFrame() {
        JInternalFrame[] jInternalFrameArray = this.desk.getAllFrames();
        int n = 0;
        while (n < jInternalFrameArray.length) {
            if (jInternalFrameArray[n].isShowing()) {
                return jInternalFrameArray[n];
            }
            ++n;
        }
        return jInternalFrameArray[jInternalFrameArray.length - 1];
    }

    void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        int n = -1;
        if (string.equals("Cut") || string.equals("Copy") || string.equals("Paste")) {
            object = this.getSelectedFrame();
            if (object != null && object instanceof ActionListener) {
                ((ActionListener)object).actionPerformed(actionEvent);
            }
        } else if (string.equals("Step Over")) {
            n = 0;
        } else if (string.equals("Step Into")) {
            n = 1;
        } else if (string.equals("Step Out")) {
            n = 2;
        } else if (string.equals("Go")) {
            n = 3;
        } else if (string.equals("Break")) {
            this.doBreak();
        } else if (string.equals("Run to Cursor")) {
            n = 5;
        } else if (string.equals("Exit")) {
            this.Exit();
        } else if (string.equals("Open")) {
            object = this.getScope();
            if (object == null) {
                MessageDialogWrapper.showMessageDialog(this, "Can't compile scripts: no scope available", "Open", 0);
            } else {
                String string2 = this.chooseFile("Select a file to compile");
                if (string2 != null) {
                    new Thread(new OpenFile(this, (Scriptable)object, string2)).start();
                }
            }
        } else if (string.equals("Load")) {
            object = this.getScope();
            if (object == null) {
                MessageDialogWrapper.showMessageDialog(this, "Can't run scripts: no scope available", "Run", 0);
            } else {
                String string3 = this.chooseFile("Select a file to execute");
                if (string3 != null) {
                    new Thread(new LoadFile(this, (Scriptable)object, string3)).start();
                }
            }
        } else if (string.equals("More Windows...")) {
            object = new MoreWindows(this, this.fileWindows, "Window", "Files");
            ((MoreWindows)object).showDialog(this);
        } else if (string.equals("Console")) {
            if (this.console.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(this.console);
            }
            this.console.show();
            this.desk.getDesktopManager().activateFrame(this.console);
            this.console.consoleTextArea.requestFocus();
        } else if (!(string.equals("Cut") || string.equals("Copy") || string.equals("Paste"))) {
            if (string.equals("Go to function...")) {
                object = new FindFunction(this, this.functionMap, "Go to function", "Function");
                ((FindFunction)object).showDialog(this);
            } else if (string.equals("Tile")) {
                object = this.desk.getAllFrames();
                int n2 = ((JInternalFrame[])object).length;
                int n3 = (int)Math.sqrt(n2);
                int n4 = n3;
                if (n4 * n3 < n2 && n4 * ++n3 < n2) {
                    ++n4;
                }
                Dimension dimension = this.desk.getSize();
                int n5 = dimension.width / n3;
                int n6 = dimension.height / n4;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                while (n9 < n4) {
                    int n10 = 0;
                    while (n10 < n3) {
                        int n11 = n9 * n3 + n10;
                        if (n11 >= ((Object)object).length) break;
                        Object object2 = object[n11];
                        try {
                            ((JInternalFrame)object2).setIcon(false);
                            ((JInternalFrame)object2).setMaximum(false);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.desk.getDesktopManager().setBoundsForFrame((JComponent)object2, n7, n8, n5, n6);
                        n7 += n5;
                        ++n10;
                    }
                    n8 += n6;
                    n7 = 0;
                    ++n9;
                }
            } else if (string.equals("Cascade")) {
                object = this.desk.getAllFrames();
                int n12 = ((Object)object).length;
                int n13 = 0;
                int n14 = 0;
                int n15 = this.desk.getHeight();
                int n16 = n15 / n12;
                if (n16 > 30) {
                    n16 = 30;
                }
                int n17 = n12 - 1;
                while (n17 >= 0) {
                    Object object3 = object[n17];
                    try {
                        ((JInternalFrame)object3).setIcon(false);
                        ((JInternalFrame)object3).setMaximum(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Dimension dimension = ((JComponent)object3).getPreferredSize();
                    int n18 = dimension.width;
                    n15 = dimension.height;
                    this.desk.getDesktopManager().setBoundsForFrame((JComponent)object3, n14, n13, n18, n15);
                    --n17;
                    n14 += n16;
                    n13 += n16;
                }
            } else {
                object = this.getFileWindow(string);
                if (object != null) {
                    FileWindow fileWindow = (FileWindow)object;
                    try {
                        if (fileWindow.isIcon()) {
                            fileWindow.setIcon(false);
                        }
                        fileWindow.setVisible(true);
                        fileWindow.moveToFront();
                        fileWindow.setSelected(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (n != -1) {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            object = this.monitor;
            synchronized (object) {
                this.returnValue = n;
                this.monitor.notify();
            }
        }
    }

    void runToCursor(String string, int n, ActionEvent actionEvent) {
        Vector vector = (Vector)this.sourceNames.get(string);
        if (vector == null) {
            System.out.println("debugger error: Couldn't find source: " + string);
        }
        SourceEntry sourceEntry = null;
        int n2 = vector.size() - 1;
        while (n2 >= 0) {
            sourceEntry = (SourceEntry)vector.elementAt(n2);
            if (sourceEntry.fnOrScript.removeBreakpoint(n)) {
                sourceEntry.fnOrScript.placeBreakpoint(n);
                break;
            }
            if (sourceEntry.fnOrScript.placeBreakpoint(n)) {
                sourceEntry.fnOrScript.removeBreakpoint(n);
                break;
            }
            --n2;
        }
        if (n2 >= 0) {
            this.runToCursorFile = string;
            this.runToCursorLine = n;
            this.actionPerformed(actionEvent);
        }
    }

    int setBreakPoint(String string, int n) {
        Vector vector = (Vector)this.sourceNames.get(string);
        if (vector == null) {
            return -1;
        }
        int n2 = 0;
        int n3 = -1;
        n2 = vector.size() - 1;
        while (n2 >= 0) {
            SourceEntry sourceEntry = (SourceEntry)vector.elementAt(n2);
            if (sourceEntry.fnOrScript.placeBreakpoint(n)) {
                n3 = n;
            }
            --n2;
        }
        return n3;
    }

    void clearBreakPoint(String string, int n) {
        Vector vector = (Vector)this.sourceNames.get(string);
        if (vector == null) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            SourceEntry sourceEntry = (SourceEntry)vector.elementAt(n2);
            sourceEntry.fnOrScript.removeBreakpoint(n);
            ++n2;
        }
    }

    JMenu getWindowMenu() {
        return this.menubar.getMenu(3);
    }

    void removeWindow(FileWindow fileWindow) {
        this.fileWindows.remove(fileWindow.getUrl());
        JMenu jMenu = this.getWindowMenu();
        int n = jMenu.getItemCount();
        JMenuItem jMenuItem = jMenu.getItem(n - 1);
        String string = new File(fileWindow.getUrl()).getName();
        int n2 = 5;
        while (n2 < n) {
            int n3;
            String string2;
            JMenuItem jMenuItem2 = jMenu.getItem(n2);
            if (jMenuItem2 != null && (string2 = jMenuItem2.getText()).substring((n3 = string2.indexOf(32)) + 1).equals(string)) {
                jMenu.remove(jMenuItem2);
                if (n == 6) {
                    jMenu.remove(4);
                    break;
                }
                int n4 = n2 - 4;
                while (n2 < n - 1) {
                    JMenuItem jMenuItem3 = jMenu.getItem(n2);
                    if (jMenuItem3 != null) {
                        string2 = jMenuItem3.getText();
                        if (string2.equals("More Windows...")) break;
                        n3 = string2.indexOf(32);
                        jMenuItem3.setText((char)(48 + n4) + " " + string2.substring(n3 + 1));
                        jMenuItem3.setMnemonic(48 + n4);
                        ++n4;
                    }
                    ++n2;
                }
                if (n - 6 != 0 || jMenuItem == jMenuItem2 || !jMenuItem.getText().equals("More Windows...")) break;
                jMenu.remove(jMenuItem);
                break;
            }
            ++n2;
        }
        jMenu.revalidate();
    }

    boolean stringIsCompilableUnit(String string) {
        Context context = Context.enter();
        boolean bl = context.stringIsCompilableUnit(string);
        Context.exit();
        return bl;
    }

    String eval(String string) {
        String string2;
        Context context = this.getCurrentContext();
        DebuggableEngine debuggableEngine = context.getDebuggableEngine();
        if (context == null) {
            return "undefined";
        }
        ContextHelper contextHelper = new ContextHelper();
        contextHelper.attach(context);
        if (this.frameIndex >= debuggableEngine.getFrameCount()) {
            contextHelper.reset();
            return "undefined";
        }
        debuggableEngine.setDebugger(null);
        context.setGeneratingDebug(false);
        context.setOptimizationLevel(-1);
        boolean bl = debuggableEngine.getBreakNextLine();
        debuggableEngine.setBreakNextLine(false);
        try {
            Object object;
            Scriptable scriptable = debuggableEngine.getFrame(this.frameIndex).getVariableObject();
            if (scriptable instanceof NativeCall) {
                NativeCall nativeCall = (NativeCall)scriptable;
                object = NativeGlobal.evalSpecial(context, nativeCall, nativeCall.getThisObj(), new Object[]{string}, "", 1);
            } else {
                object = context.evaluateString(scriptable, string, "", 0, null);
            }
            if (object == Undefined.instance) {
                object = "";
            }
            try {
                string2 = ScriptRuntime.toString(object);
            }
            catch (RuntimeException runtimeException) {
                string2 = object.toString();
            }
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        if (string2 == null) {
            string2 = "null";
        }
        debuggableEngine.setDebugger(this);
        context.setGeneratingDebug(true);
        context.setOptimizationLevel(-1);
        debuggableEngine.setBreakNextLine(bl);
        contextHelper.reset();
        return string2;
    }

    void Exit() {
        this.returnValue = 6;
        if (this.exitAction != null) {
            Main.swingInvokeLater(this.exitAction);
        }
    }

    static void setResizeWeight(JSplitPane jSplitPane, double d) {
        try {
            Method method = (class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = Main.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane).getMethod("setResizeWeight", Double.TYPE);
            method.invoke((Object)jSplitPane, new Double(d));
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    boolean shouldDispatchTo(Component component) {
        Component component2 = SwingUtilities.getRoot(component);
        if (component2 == this) {
            return true;
        }
        Enumeration enumeration = this.toplevels.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            JFrame jFrame = (JFrame)this.toplevels.get(k);
            if (component2 != jFrame) continue;
            return true;
        }
        return false;
    }

    void addTopLevel(String string, JFrame jFrame) {
        if (jFrame != this) {
            this.toplevels.put(string, jFrame);
        }
    }

    void setBreakOnExceptions(boolean bl) {
        this.breakOnExceptions = bl;
    }

    public Main(String string) {
        super(string);
        this.init();
    }

    public void clearAllBreakpoints() {
        this.doClearBreakpoints();
    }

    public void setScopeProvider(ScopeProvider scopeProvider) {
        this.scopeProvider = scopeProvider;
    }

    public void setExitAction(Runnable runnable) {
        this.exitAction = runnable;
    }

    public InputStream getIn() {
        return this.console.getIn();
    }

    public PrintStream getOut() {
        return this.console.getOut();
    }

    public PrintStream getErr() {
        return this.console.getErr();
    }

    public static void main(String[] stringArray) {
        try {
            mainThread = Thread.currentThread();
            final Main main = new Main("Rhino JavaScript Debugger");
            Main.swingInvoke(new Runnable(){

                public void run() {
                    main.pack();
                    ((Component)main).setSize(600, 460);
                    main.setVisible(true);
                }
            });
            main.setExitAction(new Runnable(){

                public void run() {
                    System.exit(0);
                }
            });
            System.setIn(main.getIn());
            System.setOut(main.getOut());
            System.setErr(main.getErr());
            Context.addContextListener(main);
            main.setScopeProvider(new ScopeProvider(){

                public Scriptable getScope() {
                    return org.mozilla.javascript.tools.shell.Main.getScope();
                }
            });
            org.mozilla.javascript.tools.shell.Main.exec(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SourceEntry {
        StringBuffer source;
        DebuggableScript fnOrScript;

        SourceEntry(StringBuffer stringBuffer, DebuggableScript debuggableScript) {
            this.source = stringBuffer;
            this.fnOrScript = debuggableScript;
        }
    }

    class ThreadState {
        private int stopAtFrameDepth = -1;

        ThreadState() {
        }

        static /* synthetic */ int access$000(ThreadState threadState) {
            return threadState.stopAtFrameDepth;
        }

        static /* synthetic */ int access$002(ThreadState threadState, int n) {
            threadState.stopAtFrameDepth = n;
            return threadState.stopAtFrameDepth;
        }
    }
}

