@echo off

setlocal EnableDelayedExpansion

set OS_ALLCAPS=WINDOWS

set selfcon_ext=selfcontained-jdk
set installed_dir=%selfcon_ext%\zulu-jdk11-windows-64bit

echo.

where svn >nul 2>&1
if %ERRORLEVEL%==0 (
    echo Detected svn on PATH
) else (
    cmd /c .\get-subversion-windows-64bit.bat
    call .\setup-subversion-windows-64bit.bat
)


echo.
if not exist %selfcon_ext% (
    echo Checking out from svn: Greenstone3\'s %selfcon_ext% extension
    svn co https://svn.greenstone.org/gs3-extensions/%selfcon_ext%/trunk %selfcon_ext%

    if !ERRORLEVEL! NEQ 0 (	
	echo Error encountered checking out:  1>&2
	echo     svn co https://svn.greenstone.org/gs3-extensions/%selfcon_ext%/trunk %selfcon_ext% 1>&2
	exit /b 1
    )
) else (
    echo Detected directory '%selfcon_ext%'
    echo =^> Taken to mean that the svn check-out command has already been run
)

echo.
if not exist %installed_dir% (
    echo Runing the %selfcon_ext%\PREPARE-%OS_ALLCAPS%.bat

    cd %selfcon_ext% && call .\PREPARE-%OS_ALLCAPS%.bat

    if !ERRORLEVEL! NEQ 0 (    
	echo Error encountered running: 1>&2
	echo     cd %selfcon_ext% && .\PREPARE-%OS_ALLCAPS%.bat 1>&2
	exit /b 1
    )
	
) else (
    echo Detected directory '%installed_dir%'
    echo =^> Taken to mean that the %selfcon_ext%/PREPARE-%OS_ALLCAPS%.bat command has already been run
)


if "x%JAVA_HOME%" NEQ "x%CD%\%installed_dir%" (
    echo.
    echo To use this installed version of JDK, run 
    echo     SETUP-CLI.bat 
    echo in the ext-cli folder.
    echo.
) else (
    echo.
    echo Detected JAVA_HOME set to \%CD\%/%installed_dir%
    echo =^> Taken to mean that the %selfcon_ext% SETUP.bat file has been sourced
)

echo.


endlocal

:: The following keeps the calling window open
::exit /b 0
