/**********************************************************************
 *
 * phrases.cpp -- routines to do with phrases - want to share between colservr
 * and recpt
 * Copyright (C) 1999  The New Zealand Digital Library Project
 *
 * A component of the Greenstone digital library software
 * from the New Zealand Digital Library Project at the
 * University of Waikato, New Zealand.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *********************************************************************/

#include "phrases.h"
#include "unitool.h" // for is_unicode_letdig


void get_phrases (const text_t &querystring, text_tarray &phrases) {

  phrases.erase (phrases.begin(), phrases.end());
  if (!querystring.empty()) {
    
    text_t::const_iterator end = querystring.end();
    text_t::const_iterator here = findchar (querystring.begin(), end, '"');
    if (here != end) {
      text_t tmptext;
      bool foundquote = false;
      bool foundbreak = false;
     while (here != end) {
	if (*here == '"') {
	  if (foundquote) {
	    if (!tmptext.empty() && foundbreak) {
	      phrases.push_back(tmptext);
	    }
	    tmptext.clear();
	      
	    foundquote = false;
	    foundbreak = false;
	  } else foundquote = true;
	} else {
	  if (foundquote) {
	    if (!is_unicode_letdig(*here)) {
	      foundbreak = true;
	    }
	    tmptext.push_back (*here);
	  }
	}
	++here;
     }
    }
  }
}
