/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jdbm.helper.CacheEntry;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.MRUEnumeration;

public class MRU
implements CachePolicy {
    Hashtable _hash = new Hashtable();
    int _max;
    CacheEntry _first;
    CacheEntry _last;
    Vector listeners = new Vector();

    public MRU(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("MRU cache must contain at least one entry");
        }
        this._max = n;
    }

    @Override
    public void put(Object object, Object object2) throws CacheEvictionException {
        CacheEntry cacheEntry = (CacheEntry)this._hash.get(object);
        if (cacheEntry != null) {
            cacheEntry.setValue(object2);
            this.touchEntry(cacheEntry);
        } else {
            if (this._hash.size() == this._max) {
                cacheEntry = this.purgeEntry();
                cacheEntry.setKey(object);
                cacheEntry.setValue(object2);
            } else {
                cacheEntry = new CacheEntry(object, object2);
            }
            this.addEntry(cacheEntry);
            this._hash.put(cacheEntry.getKey(), cacheEntry);
        }
    }

    @Override
    public Object get(Object object) {
        CacheEntry cacheEntry = (CacheEntry)this._hash.get(object);
        if (cacheEntry != null) {
            this.touchEntry(cacheEntry);
            return cacheEntry.getValue();
        }
        return null;
    }

    @Override
    public void remove(Object object) {
        CacheEntry cacheEntry = (CacheEntry)this._hash.get(object);
        if (cacheEntry != null) {
            this.removeEntry(cacheEntry);
            this._hash.remove(cacheEntry.getKey());
        }
    }

    @Override
    public void removeAll() {
        this._hash = new Hashtable();
        this._first = null;
        this._last = null;
    }

    @Override
    public Enumeration elements() {
        return new MRUEnumeration(this._hash.elements());
    }

    @Override
    public void addListener(CachePolicyListener cachePolicyListener) {
        if (cachePolicyListener == null) {
            throw new IllegalArgumentException("Cannot add null listener.");
        }
        if (!this.listeners.contains(cachePolicyListener)) {
            this.listeners.addElement(cachePolicyListener);
        }
    }

    @Override
    public void removeListener(CachePolicyListener cachePolicyListener) {
        this.listeners.removeElement(cachePolicyListener);
    }

    protected void addEntry(CacheEntry cacheEntry) {
        if (this._first == null) {
            this._first = cacheEntry;
            this._last = cacheEntry;
        } else {
            this._last.setNext(cacheEntry);
            cacheEntry.setPrevious(this._last);
            this._last = cacheEntry;
        }
    }

    protected void removeEntry(CacheEntry cacheEntry) {
        if (cacheEntry == this._first) {
            this._first = cacheEntry.getNext();
        }
        if (this._last == cacheEntry) {
            this._last = cacheEntry.getPrevious();
        }
        CacheEntry cacheEntry2 = cacheEntry.getPrevious();
        CacheEntry cacheEntry3 = cacheEntry.getNext();
        if (cacheEntry2 != null) {
            cacheEntry2.setNext(cacheEntry3);
        }
        if (cacheEntry3 != null) {
            cacheEntry3.setPrevious(cacheEntry2);
        }
        cacheEntry.setPrevious(null);
        cacheEntry.setNext(null);
    }

    protected void touchEntry(CacheEntry cacheEntry) {
        if (this._last == cacheEntry) {
            return;
        }
        this.removeEntry(cacheEntry);
        this.addEntry(cacheEntry);
    }

    protected CacheEntry purgeEntry() throws CacheEvictionException {
        CacheEntry cacheEntry = this._first;
        for (int i = 0; i < this.listeners.size(); ++i) {
            CachePolicyListener cachePolicyListener = (CachePolicyListener)this.listeners.elementAt(i);
            cachePolicyListener.cacheObjectEvicted(cacheEntry.getValue());
        }
        this.removeEntry(cacheEntry);
        this._hash.remove(cacheEntry.getKey());
        cacheEntry.setValue(null);
        return cacheEntry;
    }
}

