/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.action;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.action.Action;
import org.greenstone.gsdl3.util.GSPath;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.gsdl3.util.XMLConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NoCollQueryAction
extends Action {
    static Logger logger = Logger.getLogger((String)NoCollQueryAction.class.getName());

    public Node process(Node message_node) {
        Element message = XMLConverter.nodeToElement(message_node);
        Element request = (Element)GSXML.getChildByTagName(message, "request");
        Element result = this.doc.createElement("message");
        Element response = this.basicQuery(request);
        result.appendChild(this.doc.importNode(response, true));
        return result;
    }

    protected Element basicQuery(Element request) {
        String query_coll_list;
        Element page_response = this.doc.createElement("response");
        Element cgi_param_list = (Element)GSXML.getChildByTagName(request, "paramList");
        HashMap params = GSXML.extractParams(cgi_param_list, false);
        String request_type = (String)params.get("rt");
        String lang = request.getAttribute("lang");
        String uid = request.getAttribute("uid");
        if (request_type.equals("d")) {
            Element coll_list = this.getCollectionList(lang, uid);
            page_response.appendChild(this.doc.importNode(coll_list, true));
            return page_response;
        }
        String service_name = (String)params.get("s");
        if (service_name == null || service_name.equals("")) {
            service_name = "TextQuery";
        }
        if ((query_coll_list = (String)params.get("c")) == null || query_coll_list.equals("")) {
            logger.error((Object)"no collections were specified!");
            Element coll_list = this.getCollectionList(lang, uid);
            page_response.appendChild(this.doc.importNode(coll_list, true));
            return page_response;
        }
        HashMap service_params = (HashMap)params.get("s1");
        if (service_params == null) {
            return page_response;
        }
        Element query_param_list = this.doc.createElement("paramList");
        GSXML.addParametersToList(this.doc, query_param_list, service_params);
        String[] colls = query_coll_list.split(",");
        Element mr_query_message = this.doc.createElement("message");
        for (int i = 0; i < colls.length; ++i) {
            String to = GSPath.appendLink(colls[i], service_name);
            Element mr_query_request = GSXML.createBasicRequest(this.doc, "process", to, lang, uid);
            mr_query_message.appendChild(mr_query_request);
            mr_query_request.appendChild(query_param_list.cloneNode(true));
        }
        Element mr_query_response = (Element)this.mr.process(mr_query_message);
        Element mr_meta_message = this.doc.createElement("message");
        NodeList responses = mr_query_response.getElementsByTagName("response");
        for (int j = 0; j < responses.getLength(); ++j) {
            Element document_list = (Element)GSXML.getChildByTagName((Element)responses.item(j), "documentNodeList");
            if (document_list == null) continue;
            String coll_name = this.extractCollName(((Element)responses.item(j)).getAttribute("from"));
            String path = GSPath.appendLink(coll_name, "DocumentMetadataRetrieve");
            Element mr_meta_request = GSXML.createBasicRequest(this.doc, "process", path, lang, uid);
            mr_meta_message.appendChild(mr_meta_request);
            mr_meta_request.appendChild(this.doc.importNode(document_list, true));
            Element param_list = this.doc.createElement("paramList");
            Element param = GSXML.createParameter(this.doc, "metadata", "Title");
            param_list.appendChild(param);
            param = GSXML.createParameter(this.doc, "metadata", "root_Title");
            param_list.appendChild(param);
            mr_meta_request.appendChild(param_list);
        }
        Element mr_meta_response = (Element)this.mr.process(mr_meta_message);
        Element result_doc_list = this.doc.createElement("documentNodeList");
        page_response.appendChild(result_doc_list);
        responses = mr_meta_response.getElementsByTagName("response");
        for (int j = 0; j < responses.getLength(); ++j) {
            Element document_list = (Element)GSXML.getChildByTagName((Element)responses.item(j), "documentNodeList");
            String coll_name = this.extractCollName(((Element)responses.item(j)).getAttribute("from"));
            this.mergeDocLists(result_doc_list, document_list, coll_name);
        }
        return page_response;
    }

    protected String extractCollName(String path) {
        return GSPath.removeLastLink(path);
    }

    protected void mergeDocLists(Element result_list, Element from_list, String collection) {
        Document owner = result_list.getOwnerDocument();
        for (Node child = from_list.getFirstChild(); child != null && child.getNodeType() == 1; child = child.getNextSibling()) {
            ((Element)child).setAttribute("collection", collection);
            result_list.appendChild(owner.importNode(child, true));
        }
    }

    protected Element getCollectionList(String lang, String uid) {
        Element coll_list_message = this.doc.createElement("message");
        Element coll_list_request = GSXML.createBasicRequest(this.doc, "describe", "", lang, uid);
        coll_list_message.appendChild(coll_list_request);
        Element coll_list_response = (Element)this.mr.process(coll_list_message);
        if (coll_list_response == null) {
            logger.error((Object)"couldn't query the message router!");
            return null;
        }
        NodeList colls = coll_list_response.getElementsByTagName("collection");
        Element coll_param_list = this.doc.createElement("paramList");
        Element param = GSXML.createParameter(this.doc, "subset", "displayItemList");
        coll_param_list.appendChild(param);
        Element metadata_message = this.doc.createElement("message");
        for (int i = 0; i < colls.getLength(); ++i) {
            Element c = (Element)colls.item(i);
            String name = c.getAttribute("name");
            Element metadata_request = GSXML.createBasicRequest(this.doc, "describe", name, lang, uid);
            metadata_request.appendChild(coll_param_list.cloneNode(true));
            metadata_message.appendChild(metadata_request);
        }
        Element metadata_response = (Element)this.mr.process(metadata_message);
        NodeList coll_responses = metadata_response.getElementsByTagName("response");
        if (colls.getLength() != coll_responses.getLength()) {
            logger.error((Object)"didn't get a response for each collection - somethings gone wrong!");
        } else {
            for (int i = 0; i < colls.getLength(); ++i) {
                Element c1 = (Element)colls.item(i);
                Element c2 = (Element)coll_responses.item(i);
                if (c1.getAttribute("name").equals(c2.getAttribute("from"))) {
                    GSXML.mergeElements(c1, (Element)GSXML.getChildByTagName(c2, "collection"));
                    continue;
                }
                logger.error((Object)"response does not correspond to request!");
            }
        }
        String path = GSPath.appendLink("response", "collectionList");
        Element response = (Element)GSXML.getNodeByPath(coll_list_response, path);
        return response;
    }
}

