/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.security.SecureRandom;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.DOMParser;
import org.greenstone.gsdl3.core.ModuleInterface;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ModuleWrapper
implements ModuleInterface {
    static Logger logger = Logger.getLogger((String)ModuleWrapper.class.getName());
    protected ModuleInterface inner = null;
    protected String fromSchema = null;
    protected String toSchema = null;
    protected boolean logging = true;
    protected String logDirectory = "/tmp/";
    protected static long logCounter = 0L;

    public ModuleInterface getInner() {
        return this.inner;
    }

    public void setInner(ModuleInterface i) {
        this.inner = i;
    }

    public String getFromSchema() {
        return this.fromSchema;
    }

    public void setFromSchema(String s) {
        this.fromSchema = s;
    }

    public String getToSchema() {
        return this.toSchema;
    }

    public void setToSchema(String s) {
        this.toSchema = s;
    }

    public boolean getLogging() {
        return this.logging;
    }

    public void setLogging(boolean b) {
        this.logging = b;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public void setLogDirectory(String s) {
        this.logDirectory = s;
    }

    public ModuleWrapper() {
    }

    public void cleanUp() {
    }

    public ModuleWrapper(String in, String out, ModuleInterface inner) {
        this.setFromSchema(in);
        this.setToSchema(out);
        this.setInner(inner);
    }

    public String process(String xmlIn) {
        FileWriter writer;
        File file;
        String filename;
        long logNumber = 0L;
        String xmlOut = "";
        if (this.getLogging()) {
            if (logCounter == 0L) {
                logCounter = new SecureRandom().nextLong();
            }
            try {
                logNumber = logCounter++;
                filename = this.getLogDirectory() + File.separator + logNumber + ".in";
                file = new File(filename);
                while (file.exists()) {
                    logCounter = new SecureRandom().nextLong();
                    ++logCounter;
                    filename = this.getLogDirectory() + File.separator + logNumber + ".in";
                    file = new File(filename);
                }
                writer = new FileWriter(file);
                writer.write(xmlIn);
            }
            catch (IOException e) {
                logger.error((Object)("caught exception: " + e));
            }
        }
        xmlOut = this.processInner(xmlIn);
        try {
            filename = this.getLogDirectory() + File.separator + logNumber + ".out";
            file = new File(filename);
            writer = new FileWriter(file);
            writer.write(xmlOut);
        }
        catch (IOException e) {
            logger.error((Object)("caught exception: " + e));
        }
        return xmlOut;
    }

    protected String processInner(String xmlIn) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMParser parser = new DOMParser();
            try {
                parser.setFeature("http://xml.org/sax/features/validation", true);
                parser.setFeature("http://apache.org/xml/features/validation/schema", true);
                parser.setFeature("http://apache.org/xml/features/validation/dynamic", true);
                parser.setFeature("http://apache.org/xml/features/validation/schema", true);
                parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                parser.setFeature("http://apache.org/xml/features/validation/schema/normalized-value", true);
                parser.setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", true);
                parser.setFeature("http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", true);
                parser.setFeature("http://apache.org/xml/features/warn-on-duplicate-entitydef", true);
            }
            catch (Exception a) {
                logger.error((Object)("unable to set feature:" + a));
                a.printStackTrace();
            }
            InputSource xml_source = new InputSource(new StringReader(xmlIn));
            try {
                parser.parse(xml_source);
            }
            catch (Exception e) {
                logger.error((Object)("parsing error:" + e));
                e.printStackTrace();
                return "<response> <error class=\"ModuleWrapper\" code=1> Error: supplied string contained the parse error: " + e + " </error> </response>";
            }
            String xmlOut = this.inner.process(xmlIn);
            InputSource xmlResult = new InputSource(new StringReader(xmlIn));
            try {
                parser.parse(xmlResult);
            }
            catch (Exception e) {
                logger.error((Object)("parsing error:" + e));
                e.printStackTrace();
                return "<response> <error class=\"ModuleWrapper\" code=2> Error: returned string contained the parse error: " + e + "</error></response>";
            }
            return xmlOut;
        }
        catch (Exception e) {
            logger.error((Object)("other error:" + e));
            e.printStackTrace();
            return "<response> <error class=\"ModuleWrapper\" code=3>Error: Unknown error or warning: " + e + " </error></response>";
        }
    }

    public Node process(Node xmlIn) {
        throw new Error("Not implmented yet. Should be faked by stringizing the node.");
    }
}

