/*
 * Decompiled with CFR 0.152.
 */
package org.nzdl.gsdl.Phind;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Scrollbar;
import java.util.Date;
import java.util.Vector;
import org.nzdl.gsdl.Phind.Phind;
import org.nzdl.gsdl.Phind.ResultBox;
import org.nzdl.gsdl.Phind.ResultItem;

public class ResultCanvas
extends Canvas {
    Phind phind;
    ResultBox parent;
    Scrollbar scrollbar;
    Font areaPlain;
    Font areaBold;
    int lineSpacing;
    int numberOfItems;
    int firstItemDisplayed;
    int itemSelected;
    Vector items;
    public static Image backgroundImage;

    ResultCanvas(ResultBox resultBox) {
        this.parent = resultBox;
        this.phind = resultBox.phind;
        this.scrollbar = resultBox.s;
        this.parent.disableScrollbar();
        this.areaPlain = this.phind.plainFont;
        this.areaBold = this.phind.boldFont;
        this.lineSpacing = this.phind.fontSize + 2;
        this.items = new Vector();
        this.numberOfItems = 0;
        this.firstItemDisplayed = 0;
        this.itemSelected = -1;
        if (backgroundImage == null) {
            backgroundImage = resultBox.phind.backgroundImage;
        }
    }

    void resetCanvas() {
        this.items.removeAllElements();
        this.numberOfItems = 0;
        this.repaint();
    }

    boolean addResultItem(ResultItem resultItem) {
        int n;
        for (n = 0; n < this.numberOfItems && (resultItem.sort < ((ResultItem)this.items.elementAt((int)n)).sort || resultItem.sort == ((ResultItem)this.items.elementAt((int)n)).sort && resultItem.frequency <= ((ResultItem)this.items.elementAt((int)n)).frequency); ++n) {
        }
        this.items.insertElementAt(resultItem, n);
        ++this.numberOfItems;
        return true;
    }

    void updateMarkers() {
        this.updateMorePhrasesMarker();
        this.updateMoreDocumentsMarker();
        this.updateMoreLinksMarker();
    }

    void updateMorePhrasesMarker() {
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.numberOfItems) {
            if (((ResultItem)this.items.elementAt(n)).isMorePhrases()) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (this.parent.expansionsRetrieved == this.parent.numberOfExpansions) {
            if (bl) {
                this.items.removeElementAt(n);
                --this.numberOfItems;
            }
        } else if (this.parent.expansionsRetrieved < this.parent.numberOfExpansions && !bl) {
            ResultItem resultItem = new ResultItem(4);
            this.addResultItem(resultItem);
        }
    }

    void updateMoreDocumentsMarker() {
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.numberOfItems) {
            if (((ResultItem)this.items.elementAt(n)).isMoreDocuments()) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (this.parent.documentsRetrieved == this.parent.numberOfDocuments) {
            if (bl) {
                this.items.removeElementAt(n);
                --this.numberOfItems;
            }
        } else if (this.parent.documentsRetrieved < this.parent.numberOfDocuments && !bl) {
            ResultItem resultItem = new ResultItem(2);
            this.addResultItem(resultItem);
        }
    }

    void updateMoreLinksMarker() {
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.numberOfItems) {
            if (((ResultItem)this.items.elementAt(n)).isMoreLinks()) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (this.parent.thesaurusLinksRetrieved == this.parent.numberOfThesaurusLinks) {
            if (bl) {
                this.items.removeElementAt(n);
                --this.numberOfItems;
            }
        } else if (this.parent.thesaurusLinksRetrieved < this.parent.numberOfThesaurusLinks && !bl) {
            ResultItem resultItem = new ResultItem(6);
            this.addResultItem(resultItem);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        int n;
        ResultItem resultItem;
        int n2;
        Dimension dimension = this.size();
        graphics.setFont(this.areaPlain);
        int n3 = graphics.getFontMetrics().stringWidth(" ");
        int n4 = graphics.getFontMetrics().stringWidth("0");
        int n5 = this.phind.column_1_width * n4;
        int n6 = this.phind.column_2_width * n4;
        int n7 = n5 + n6;
        int n8 = dimension.width - n7;
        int n9 = n8 + n5;
        int n10 = 0;
        int n11 = n8;
        int n12 = dimension.height / this.lineSpacing;
        int n13 = this.scrollbar.getValue();
        if (this.numberOfItems <= n12) {
            n13 = 0;
        } else if (n13 > this.numberOfItems - n12) {
            n13 = this.numberOfItems - n12;
        }
        this.firstItemDisplayed = n13;
        Color color = this.phind.panel_fg;
        Color color2 = this.phind.panel_bg;
        if (this.phind.showImage) {
            try {
                graphics.drawImage(backgroundImage, n10, 0, n11, dimension.height, color2, null);
            }
            catch (Exception exception) {
                this.phind.showImage = false;
                System.err.println("ResultCanvas paint error: " + exception);
                graphics.setColor(color2);
                graphics.fillRect(0, 0, dimension.width, dimension.height);
            }
        } else {
            graphics.setColor(color2);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (this.numberOfItems == 0) {
            graphics.drawString("No phrases match this query.", n10 + 10, this.lineSpacing);
        }
        int n14 = 0;
        int n15 = n10 + (n11 - n10 - graphics.getFontMetrics().stringWidth(this.parent.searchPhrase)) / 2;
        int n16 = n10 + n5 + graphics.getFontMetrics().stringWidth("Narrower term");
        for (n2 = n13; n2 < this.numberOfItems && n14 + this.lineSpacing < dimension.height; ++n2) {
            String string;
            String string2;
            resultItem = (ResultItem)this.items.elementAt(n2);
            n14 += this.lineSpacing;
            graphics.setFont(this.areaPlain);
            if (n2 == this.itemSelected) {
                graphics.setColor(this.phind.highlight_bg);
                graphics.fillRect(n10, n14 - this.lineSpacing + 2, n11, this.lineSpacing);
            }
            if (resultItem.isPhrase()) {
                string2 = resultItem.prefixText();
                string = resultItem.mainText();
                String string3 = resultItem.suffixText();
                graphics.setColor(this.phind.expansion_fg);
                graphics.setFont(this.areaPlain);
                n = n15 - graphics.getFontMetrics().stringWidth(string2) - n3;
                graphics.drawString(string2, n, n14);
                graphics.setFont(this.areaBold);
                graphics.drawString(string, n15, n14);
                n = n15 + n3 + graphics.getFontMetrics().stringWidth(string);
                graphics.setFont(this.areaPlain);
                graphics.drawString(string3, n, n14);
                continue;
            }
            if (resultItem.isDocument()) {
                string = resultItem.mainText();
                graphics.setColor(this.phind.document_fg);
                graphics.setFont(this.areaPlain);
                n = (n11 - graphics.getFontMetrics().stringWidth(string)) / 2;
                graphics.drawString(string, n, n14);
                continue;
            }
            if (resultItem.isLink()) {
                string2 = resultItem.prefixText() + ":";
                string = resultItem.mainText();
                n = n16 - graphics.getFontMetrics().stringWidth(string2) - n3;
                graphics.setColor(this.phind.thesaurus_fg);
                graphics.setFont(this.areaPlain);
                graphics.drawString(string2, n, n14);
                graphics.setFont(this.areaBold);
                graphics.drawString(string, n16, n14);
                continue;
            }
            if (!resultItem.isMorePhrases() && !resultItem.isMoreDocuments() && !resultItem.isMoreLinks()) continue;
            string = resultItem.mainText();
            if (resultItem.isMorePhrases()) {
                graphics.setColor(this.phind.expansion_bar_bg);
            } else if (resultItem.isMoreDocuments()) {
                graphics.setColor(this.phind.document_bar_bg);
            } else {
                graphics.setColor(this.phind.thesaurus_bar_bg);
            }
            graphics.fillRect(n10, n14 - this.lineSpacing + 2, n11, this.lineSpacing);
            if (resultItem.isMorePhrases()) {
                graphics.setColor(this.phind.expansion_bar_fg);
            } else if (resultItem.isMoreDocuments()) {
                graphics.setColor(this.phind.document_bar_fg);
            } else {
                graphics.setColor(this.phind.thesaurus_bar_fg);
            }
            graphics.setFont(this.areaPlain);
            n = (n11 - graphics.getFontMetrics().stringWidth(string)) / 2;
            graphics.drawString(string, n, n14);
        }
        graphics.setColor(this.phind.column_1_bg);
        graphics.fillRect(n8, 0, n5, dimension.height);
        graphics.setColor(this.phind.column_2_bg);
        graphics.fillRect(n9, 0, n6, dimension.height);
        graphics.setColor(this.phind.column_1_fg);
        graphics.setFont(this.areaPlain);
        n14 = 0;
        for (n2 = n13; n2 < this.numberOfItems && n14 + this.lineSpacing < dimension.height; ++n2) {
            resultItem = (ResultItem)this.items.elementAt(n2);
            String string = resultItem.docsText();
            String string4 = resultItem.freqText();
            n14 += this.lineSpacing;
            if (string.length() > 0) {
                n = n9 - n3 - graphics.getFontMetrics().stringWidth(string);
                graphics.drawString(string, n, n14);
            }
            if (string4.length() <= 0) continue;
            n = n9 + n6 - n3 - graphics.getFontMetrics().stringWidth(string4);
            graphics.drawString(string4, n, n14);
        }
        if (n12 >= this.numberOfItems) {
            this.parent.disableScrollbar();
        } else {
            this.scrollbar.setValues(n13, n12, 0, this.numberOfItems);
            this.scrollbar.setPageIncrement(n12 - 1);
            this.scrollbar.enable();
        }
        if (this.phind.showBorder) {
            graphics.setColor(this.phind.panel_fg);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 502) {
            Date date = new Date();
            if (date.getTime() < this.phind.lastQueryEndTime.getTime() + 1000L) {
                System.out.println("Ignoring click - too close to last query.");
                return true;
            }
            int n = event.y / this.lineSpacing;
            this.itemSelected = n + this.firstItemDisplayed;
            ResultItem resultItem = (ResultItem)this.items.elementAt(this.itemSelected);
            if (this.itemSelected <= this.numberOfItems) {
                if (resultItem.isPhrase()) {
                    this.itemSelected = this.itemSelected;
                    this.update(this.getGraphics());
                    this.parent.lookupPhrase(resultItem.hiddenText(), resultItem.toString(), 2);
                    if (event.metaDown() && !this.phind.library_address.equals("")) {
                        String string = this.phind.library_address + "a=q&c=" + this.phind.collection + "&q=%22" + resultItem.toString().replace(' ', '+') + "%22";
                        this.phind.displayWebPage(string, this.phind.searchWindowName);
                    }
                } else if (resultItem.isLink()) {
                    this.itemSelected = this.itemSelected;
                    this.update(this.getGraphics());
                    this.parent.lookupPhrase(resultItem.hiddenText(), resultItem.toString(), 2);
                    if (event.metaDown() && !this.phind.library_address.equals("")) {
                        String string = this.phind.library_address + "a=q&c=" + this.phind.collection + "&q=%22" + resultItem.toString().replace(' ', '+') + "%22";
                        this.phind.displayWebPage(string, this.phind.searchWindowName);
                    }
                } else if (resultItem.isDocument()) {
                    this.itemSelected = this.itemSelected;
                    this.update(this.getGraphics());
                    String string = this.phind.library_address + "a=d&c=" + this.phind.collection + "&d=" + resultItem.hiddenText() + "&q=" + this.parent.searchPhrase.replace(' ', '+');
                    this.phind.displayWebPage(string, this.phind.documentWindowName);
                } else if (resultItem.isMorePhrases()) {
                    this.parent.lookupPhrase(this.parent.searchKey, this.parent.searchPhrase, 3);
                } else if (resultItem.isMoreDocuments()) {
                    this.parent.lookupPhrase(this.parent.searchKey, this.parent.searchPhrase, 4);
                } else if (resultItem.isMoreLinks()) {
                    this.parent.lookupPhrase(this.parent.searchKey, this.parent.searchPhrase, 5);
                }
                this.repaint();
            }
        }
        return true;
    }
}

