/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataTools;
import org.greenstone.gatherer.util.Codec;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CollectionConfigXMLReadWrite {
    private static final String[] known_element_names_array = new String[]{"security", "metadataList", "displayItemList", "format", "search", "infodb", "browse", "import", "display", "replaceListRef", "replaceList", "serviceRackList"};
    private static final Set known_element_names = new HashSet<String>(Arrays.asList(known_element_names_array));

    public static String generateStringVersion(Document document) {
        return XMLTools.xmlNodeToString(document);
    }

    public static void parse(File file, Document document) {
        Document document2 = XMLTools.parseXMLFile(file);
        Element element = document2.getDocumentElement();
        Element element2 = document.getDocumentElement();
        CollectionConfigXMLReadWrite.doSecurity(document, element);
        CollectionConfigXMLReadWrite.doMetadataList(document, element);
        CollectionConfigXMLReadWrite.doDisplayItemList(document, element);
        CollectionConfigXMLReadWrite.doGlobalFormat(document, element);
        CollectionConfigXMLReadWrite.doDatabaseType(document, element);
        Node node = XMLTools.getChildByTagNameIndexed(element, "search", 0);
        String string = CollectionConfigXMLReadWrite.doBuildType(document, (Element)node);
        if (string.equalsIgnoreCase("mg")) {
            CollectionConfigXMLReadWrite.doIndexes(document, node, true);
        } else {
            CollectionConfigXMLReadWrite.doIndexes(document, node, false);
        }
        if (string.equalsIgnoreCase("solr") || string.equalsIgnoreCase("lucene")) {
            CollectionConfigXMLReadWrite.doSorts(document, node);
            CollectionConfigXMLReadWrite.doDefaultSort(document, node);
            if (string.equalsIgnoreCase("solr")) {
                CollectionConfigXMLReadWrite.doFacets(document, node);
            }
        }
        CollectionConfigXMLReadWrite.doDefaultIndex(document, node);
        CollectionConfigXMLReadWrite.doDefaultLevel(document, node);
        CollectionConfigXMLReadWrite.doLevel(document, node);
        CollectionConfigXMLReadWrite.doIndexOption(document, node);
        CollectionConfigXMLReadWrite.doSubcollection(document, node);
        CollectionConfigXMLReadWrite.doIndexSubcollection(document, node);
        CollectionConfigXMLReadWrite.doIndexLanguage(document, node);
        CollectionConfigXMLReadWrite.doDefaultIndexLanguage(document, node);
        CollectionConfigXMLReadWrite.doLanguageMetadata(document, node);
        CollectionConfigXMLReadWrite.doSearchType(document, node);
        CollectionConfigXMLReadWrite.doSearchFormat(document, node);
        Node node2 = XMLTools.getChildByTagNameIndexed(element, "import", 0);
        if (node2 == null) {
            System.out.println("There is no 'import' element.");
        } else {
            CollectionConfigXMLReadWrite.doPluginsAndPlugout(document, node2);
        }
        Node node3 = XMLTools.getChildByTagNameIndexed(element, "browse", 0);
        if (node3 == null) {
            System.out.println("There is no browse element.");
        } else {
            CollectionConfigXMLReadWrite.doClassifiers(document, node3);
        }
        CollectionConfigXMLReadWrite.doDisplayFormat(document, element);
        CollectionConfigXMLReadWrite.doReplaceListRef(document, element);
        CollectionConfigXMLReadWrite.doReplaceList(document, element);
        CollectionConfigXMLReadWrite.doServiceRackList(document, element);
        CollectionConfigXMLReadWrite.doUnknownElements(document, element);
    }

    public static void save(File file, Document document) {
        Document document2 = CollectionConfigXMLReadWrite.convertInternalToCollectionConfig(document);
        String[] stringArray = new String[]{"format", "displayItem"};
        XMLTools.writeXMLFile(file, document2, stringArray);
    }

    private static Document convertInternalToCollectionConfig(Document document) {
        Document document2 = XMLTools.parseXMLFile("xml/CollectionConfig.xml", true);
        CollectionConfigXMLReadWrite.convertSecurity(document, document2);
        CollectionConfigXMLReadWrite.convertMetadataList(document, document2);
        CollectionConfigXMLReadWrite.convertDisplayItemList(document, document2);
        CollectionConfigXMLReadWrite.convertGlobalFormat(document, document2);
        CollectionConfigXMLReadWrite.convertBuildType(document, document2);
        Element element = (Element)XMLTools.getChildByTagName(document2.getDocumentElement(), "search");
        String string = element.getAttribute("type");
        if (string.equals("mg")) {
            CollectionConfigXMLReadWrite.convertIndexes(document, document2, element, true);
            CollectionConfigXMLReadWrite.convertDefaultIndex(document, document2, element, true);
        } else {
            CollectionConfigXMLReadWrite.convertIndexes(document, document2, element, false);
            CollectionConfigXMLReadWrite.convertDefaultIndex(document, document2, element, false);
            CollectionConfigXMLReadWrite.convertLevels(document, document2, element);
            CollectionConfigXMLReadWrite.convertDefaultLevel(document, document2, element);
        }
        if (string.equals("lucene") || string.equals("solr")) {
            CollectionConfigXMLReadWrite.convertSorts(document, document2, element);
            CollectionConfigXMLReadWrite.convertDefaultSort(document, document2, element);
        }
        if (string.equals("solr")) {
            CollectionConfigXMLReadWrite.convertFacets(document, document2, element);
        }
        CollectionConfigXMLReadWrite.convertIndexOptions(document, document2, element);
        CollectionConfigXMLReadWrite.convertSubcollectionIndexes(document, document2, element);
        CollectionConfigXMLReadWrite.convertLanguages(document, document2, element);
        CollectionConfigXMLReadWrite.convertSubcollection(document, document2, element);
        CollectionConfigXMLReadWrite.convertSearchType(document, document2, element);
        CollectionConfigXMLReadWrite.convertSearchFormat(document, document2, element);
        CollectionConfigXMLReadWrite.convertDatabaseType(document, document2);
        CollectionConfigXMLReadWrite.convertPluginsAndPlugout(document, document2);
        CollectionConfigXMLReadWrite.convertClassifier(document, document2);
        CollectionConfigXMLReadWrite.convertDisplayFormat(document, document2);
        CollectionConfigXMLReadWrite.convertReplaceListRef(document, document2);
        CollectionConfigXMLReadWrite.convertReplaceList(document, document2);
        CollectionConfigXMLReadWrite.convertServiceRackList(document, document2);
        CollectionConfigXMLReadWrite.convertUnknownElements(document, document2);
        return document2;
    }

    private static void doSecurity(Document document, Element element) {
        Node node = XMLTools.getChildByTagNameIndexed(element, "security", 0);
        if (node != null) {
            Element element2 = XMLTools.duplicateElement(document, (Element)node, true);
            document.getDocumentElement().appendChild(element2);
        }
    }

    private static void convertSecurity(Document document, Document document2) {
        Node node = XMLTools.getChildByTagNameIndexed(document.getDocumentElement(), "security", 0);
        if (node != null) {
            Element element = XMLTools.duplicateElement(document2, (Element)node, true);
            document2.getDocumentElement().appendChild(element);
        }
    }

    private static void doMetadataList(Document document, Element element) {
        int n;
        Element element2 = document.getDocumentElement();
        Element element3 = document.createElement("metadataList");
        Node node = XMLTools.getChildByTagNameIndexed(element, "metadataList", 0);
        if (node == null) {
            return;
        }
        NodeList nodeList = ((Element)node).getElementsByTagName("metadata");
        int n2 = n = nodeList == null ? 0 : nodeList.getLength();
        if (n == 0) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Element element4 = (Element)nodeList.item(i);
            String string = element4.getAttribute("name");
            if (string.equals("creator")) {
                CollectionConfigXMLReadWrite.doSpecialMetadata(document, element4, "Creator");
                continue;
            }
            if (string.equals("maintainer")) {
                CollectionConfigXMLReadWrite.doSpecialMetadata(document, element4, "Maintainer");
                continue;
            }
            if (string.equals("public")) {
                CollectionConfigXMLReadWrite.doSpecialMetadata(document, element4, "Public");
                continue;
            }
            Element element5 = XMLTools.duplicateElement(document, element4, true);
            element3.appendChild(element5);
            bl = true;
        }
        if (bl) {
            element2.appendChild(element3);
        }
    }

    private static void doSpecialMetadata(Document document, Element element, String string) {
        String string2 = XMLTools.getNodeText(element);
        if (string2.equals("")) {
            return;
        }
        Element element2 = document.createElement(string);
        element2.setAttribute("name", element.getAttribute("name"));
        element2.setAttribute("lang", element.getAttribute("lang"));
        element2.setAttribute("assigned", "true");
        element2.setAttribute("special", "true");
        XMLTools.setNodeText(element2, string2);
        document.getDocumentElement().appendChild(element2);
    }

    private static void convertMetadataList(Document document, Document document2) {
        Node node = XMLTools.getChildByTagNameIndexed(document.getDocumentElement(), "metadataList", 0);
        Element element = node != null ? XMLTools.duplicateElement(document2, (Element)node, true) : document2.createElement("metadataList");
        document2.getDocumentElement().appendChild(element);
        String[] stringArray = new String[]{"Creator", "Maintainer", "Public"};
        String[] stringArray2 = new String[]{"creator", "maintainer", "public"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element2 = XMLTools.getNamedElement(document.getDocumentElement(), stringArray[i], "name", stringArray2[i]);
            if (element2 == null) continue;
            String string = XMLTools.getNodeText(element2);
            Element element3 = document2.createElement("metadata");
            element3.setAttribute("name", stringArray2[i]);
            element3.setAttribute("lang", "en");
            XMLTools.setNodeText(element3, string);
            element.appendChild(element3);
        }
    }

    private static void doDisplayItemList(Document document, Element element) {
        Element element2 = document.getDocumentElement();
        Node node = XMLTools.getChildByTagNameIndexed(element, "displayItemList", 0);
        if (node == null) {
            return;
        }
        NodeList nodeList = ((Element)node).getElementsByTagName("displayItem");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Element element3 = (Element)nodeList.item(i);
            String string2 = string = element3.getAttribute("name");
            if (string.equals("name")) {
                string2 = "collectionname";
            } else if (string.equals("description")) {
                string2 = "collectionextra";
            } else if (string.equals("icon")) {
                string2 = "iconcollection";
            } else if (string.equals("smallicon")) {
                string2 = "iconcollectionsmall";
            }
            Element element4 = CollectionConfigXMLReadWrite.processSingleDisplayItem(document, element3, string2, null);
            if (element4 == null) continue;
            element2.appendChild(element4);
        }
    }

    private static void convertDisplayItemList(Document document, Document document2) {
        Element element = document2.createElement("displayItemList");
        Element element2 = document2.getDocumentElement();
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put("collectionextra", "description");
        hashMap.put("collectionname", "name");
        hashMap.put("iconcollectionsmall", "smallicon");
        hashMap.put("iconcollection", "icon");
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("CollectionMetadata");
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                if (element3.getAttribute("assigned").equals("false")) continue;
                String string = element3.getAttribute("name");
                String string2 = (String)hashMap.get(string);
                if (string2 != null) {
                    string = string2;
                }
                Element element4 = CollectionConfigXMLReadWrite.constructDisplayItem(element3, document2, string);
                element.appendChild(element4);
            }
        }
        element2.appendChild(element);
    }

    private static void doGlobalFormat(Document document, Element element) {
        Element element2 = (Element)XMLTools.getChildByTagName(element, "format");
        document.getDocumentElement().appendChild(CollectionConfigXMLReadWrite.doFormat(document, element2, "global"));
    }

    private static void convertGlobalFormat(Document document, Document document2) {
        Element element = XMLTools.getNamedElement(document.getDocumentElement(), "format", "name", "global");
        document2.getDocumentElement().appendChild(CollectionConfigXMLReadWrite.convertFormat(document2, element));
    }

    private static void doDatabaseType(Document document, Element element) {
        Node node = XMLTools.getChildByTagNameIndexed(element, "infodb", 0);
        String string = "gdbm";
        if (node != null) {
            string = ((Element)node).getAttribute("type");
        }
        Element element2 = document.createElement("infodbtype");
        element2.setAttribute("name", "infodbtype");
        element2.setAttribute("language", "en");
        element2.setAttribute("assigned", "true");
        element2.setAttribute("special", "true");
        XMLTools.setNodeText(element2, string);
        CollectionConfigXMLReadWrite.appendProperly(document.getDocumentElement(), element2);
    }

    private static void convertDatabaseType(Document document, Document document2) {
        Element element = XMLTools.getNamedElement(document.getDocumentElement(), "infodbtype", "name", "infodbtype");
        if (element == null) {
            return;
        }
        String string = XMLTools.getNodeText(element);
        Element element2 = document2.createElement("infodb");
        element2.setAttribute("type", string);
        document2.getDocumentElement().appendChild(element2);
    }

    private static String doBuildType(Document document, Element element) {
        String string = element.getAttribute("type");
        Element element2 = document.createElement("BuildType");
        element2.setAttribute("name", "buildtype");
        element2.setAttribute("language", "en");
        element2.setAttribute("assigned", "true");
        element2.setAttribute("special", "true");
        XMLTools.setNodeText(element2, string);
        CollectionConfigXMLReadWrite.appendProperly(document.getDocumentElement(), element2);
        return string;
    }

    private static void convertBuildType(Document document, Document document2) {
        Element element = XMLTools.getNamedElement(document.getDocumentElement(), "BuildType", "name", "buildtype");
        if (element == null) {
            return;
        }
        String string = XMLTools.getNodeText(element);
        Element element2 = document2.createElement("search");
        element2.setAttribute("type", string);
        document2.getDocumentElement().appendChild(element2);
    }

    private static void doIndexes(Document document, Node node, boolean bl) {
        CollectionConfigXMLReadWrite.doBaseSearchPartInternal(document, node, "Indexes", "Index", "index", "index", bl);
        Element element = document.getDocumentElement();
        Element element2 = (Element)XMLTools.getChildByTagName(element, "Indexes");
        element2.setAttribute("mgpp_enabled", bl ? "false" : "true");
        boolean bl2 = !bl;
        Element element3 = document.createElement("Indexes");
        element3.setAttribute("assigned", "false");
        element3.setAttribute("mgpp_enabled", bl2 ? "false" : "true");
        String[] stringArray = new String[]{"text", "ex.Title", "ex.Source"};
        for (int i = 0; i < stringArray.length; ++i) {
            Element element4 = document.createElement("Index");
            if (bl2) {
                element4.setAttribute("level", "document");
            }
            Element element5 = document.createElement("content");
            element5.setAttribute("name", stringArray[i]);
            element4.appendChild(element5);
            element3.appendChild(element4);
        }
        element.appendChild(element3);
    }

    private static void doDefaultIndex(Document document, Node node) {
        Element element = document.getDocumentElement();
        Element element2 = document.createElement("DefaultIndex");
        element2.setAttribute("assigned", "true");
        Element element3 = (Element)XMLTools.getChildByTagName(node, "defaultIndex");
        if (element3 == null) {
            return;
        }
        String string = element3.getAttribute("name");
        boolean bl = false;
        if (string.indexOf(":") != -1) {
            bl = true;
            element2.setAttribute("level", string.substring(0, string.indexOf(":")));
            string = string.substring(string.indexOf(":") + 1);
        } else {
            element2.setAttribute("level", "");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Element element4 = document.createElement("content");
            String string2 = stringTokenizer.nextToken();
            if (!(string2.indexOf(46) != -1 || string2.equals("text") || !bl && string2.equals("allfields"))) {
                string2 = "ex." + string2;
            }
            element4.setAttribute("name", string2);
            element2.appendChild(element4);
            element4 = null;
        }
        CollectionConfigXMLReadWrite.appendProperly(element, element2);
    }

    private static void convertIndexes(Document document, Document document2, Element element, boolean bl) {
        CollectionConfigXMLReadWrite.convertBaseSearchPartInternal(document, document2, element, "Indexes", "Index", "index", "index", bl);
    }

    private static void convertDefaultIndex(Document document, Document document2, Element element, boolean bl) {
        CollectionConfigXMLReadWrite.convertBaseDefaultSearchPartInternal(document, document2, element, "DefaultIndex", "defaultIndex", bl);
    }

    private static void doSorts(Document document, Node node) {
        CollectionConfigXMLReadWrite.doBaseSearchPartInternal(document, node, "Sorts", "Sort", "sort", "sort", false);
    }

    private static void convertSorts(Document document, Document document2, Element element) {
        CollectionConfigXMLReadWrite.convertBaseSearchPartInternal(document, document2, element, "Sorts", "Sort", "sort", "sort", false);
    }

    private static void doDefaultSort(Document document, Node node) {
        Element element = document.getDocumentElement();
        Element element2 = (Element)XMLTools.getChildByTagName(node, "defaultSort");
        if (element2 == null) {
            return;
        }
        Element element3 = document.createElement("defaultSort");
        element3.setAttribute("assigned", "true");
        String string = element2.getAttribute("name");
        element3.setAttribute("name", string);
        CollectionConfigXMLReadWrite.appendProperly(element, element3);
    }

    private static void convertDefaultSort(Document document, Document document2, Element element) {
        CollectionConfigXMLReadWrite.convertBaseDefaultSearchPartInternal(document, document2, element, "defaultSort", "defaultSort", false);
    }

    private static void doFacets(Document document, Node node) {
        CollectionConfigXMLReadWrite.doBaseSearchPartInternal(document, node, "Facets", "Facet", "facet", "facet", false);
    }

    private static void convertFacets(Document document, Document document2, Element element) {
        CollectionConfigXMLReadWrite.convertBaseSearchPartInternal(document, document2, element, "Facets", "Facet", "facet", "facet", false);
    }

    private static void doLevel(Document document, Node node) {
        Element element = document.getDocumentElement();
        NodeList nodeList = ((Element)node).getElementsByTagName("level");
        int n = nodeList.getLength();
        if (n < 1) {
            Element element2 = document.createElement("IndexOption");
            element2.setAttribute("assigned", "false");
            element2.setAttribute("name", "levels");
            Element element3 = document.createElement("Option");
            element3.setAttribute("name", "document");
            element2.appendChild(element3);
            CollectionConfigXMLReadWrite.appendProperly(element, element2);
            return;
        }
        Element element4 = document.createElement("IndexOption");
        element4.setAttribute("assigned", "true");
        element4.setAttribute("name", "levels");
        for (int i = 0; i < n; ++i) {
            Element element5 = (Element)nodeList.item(i);
            String string = element5.getAttribute("name");
            Element element6 = document.createElement("Option");
            element6.setAttribute("name", string);
            element4.appendChild(element6);
            CollectionConfigXMLReadWrite.doSearchDisplayItems(document, element5, string, "level");
        }
        CollectionConfigXMLReadWrite.appendProperly(element, element4);
    }

    private static void doDefaultLevel(Document document, Node node) {
        Element element = document.getDocumentElement();
        Element element2 = document.createElement("DefaultIndexOption");
        element2.setAttribute("name", "defaultlevel");
        Element element3 = (Element)XMLTools.getChildByTagName(node, "defaultLevel");
        if (element3 != null) {
            element2.setAttribute("assigned", "true");
            String string = element3.getAttribute("name");
            element2.setAttribute("value", string);
        } else {
            element2.setAttribute("assigned", "false");
            element2.setAttribute("value", "document");
        }
        CollectionConfigXMLReadWrite.appendProperly(element, element2);
    }

    private static void convertLevels(Document document, Document document2, Element element) {
        NodeList nodeList;
        int n;
        Element element2 = document.getDocumentElement();
        Element element3 = XMLTools.getNamedElement(element2, "IndexOption", "name", "levels");
        if (element3 == null) {
            return;
        }
        if (element3.getAttribute("assigned").equals("false")) {
            DebugStream.println("For mgpp, there should be an IndexOption element for levels which is assigned 'true': possible bug.");
        }
        if ((n = (nodeList = element3.getElementsByTagName("Option")).getLength()) == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Element element4 = (Element)nodeList.item(i);
            String string = element4.getAttribute("name");
            Element element5 = document2.createElement("level");
            element5.setAttribute("name", string);
            ArrayList arrayList = CollectionConfigXMLReadWrite.getMatchingSearchMetaElements(element2, string, "level");
            if (arrayList != null) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    Element element6 = (Element)arrayList.get(j);
                    Element element7 = CollectionConfigXMLReadWrite.constructDisplayItem(element6, document2);
                    element5.appendChild(element7);
                }
            }
            element.appendChild(element5);
        }
    }

    private static void convertDefaultLevel(Document document, Document document2, Element element) {
        Element element2 = document.getDocumentElement();
        Element element3 = XMLTools.getNamedElement(element2, "DefaultIndexOption", "name", "defaultlevel");
        if (element3 == null) {
            return;
        }
        Element element4 = document2.createElement("defaultLevel");
        String string = element3.getAttribute("value");
        element4.setAttribute("name", string);
        element.appendChild(element4);
    }

    private static void doIndexOption(Document document, Node node) {
        Element element = document.getDocumentElement();
        NodeList nodeList = ((Element)node).getElementsByTagName("indexOption");
        int n = nodeList.getLength();
        if (n < 1) {
            Element element2 = document.createElement("IndexOption");
            element2.setAttribute("assigned", "false");
            element2.setAttribute("name", "indexoptions");
            String[] stringArray = new String[]{"casefold", "stem"};
            for (int i = 0; i < stringArray.length; ++i) {
                Element element3 = document.createElement("Option");
                element3.setAttribute("name", stringArray[i]);
                element2.appendChild(element3);
            }
            CollectionConfigXMLReadWrite.appendProperly(element, element2);
            return;
        }
        Element element4 = document.createElement("IndexOption");
        element4.setAttribute("assigned", "true");
        element4.setAttribute("name", "indexoptions");
        for (int i = 0; i < n; ++i) {
            String string = ((Element)nodeList.item(i)).getAttribute("name");
            Element element5 = document.createElement("Option");
            element5.setAttribute("name", string);
            element4.appendChild(element5);
        }
        CollectionConfigXMLReadWrite.appendProperly(element, element4);
    }

    private static void convertIndexOptions(Document document, Document document2, Element element) {
        int n;
        Object object;
        Element element2 = document.getDocumentElement();
        Element element3 = XMLTools.getNamedElement(element2, "IndexOption", "name", "indexoptions");
        if (element3 == null) {
            return;
        }
        if (element3.getAttribute("assigned").equals("false")) {
            DebugStream.println("There should be an IndexOption element which is assigned 'true': possible bug.");
            object = element.getAttribute("type");
            if (((String)object).equalsIgnoreCase("solr") || ((String)object).equalsIgnoreCase("lucene")) {
                return;
            }
        }
        if ((n = (object = element3.getElementsByTagName("Option")).getLength()) == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Element element4 = (Element)object.item(i);
            String string = element4.getAttribute("name");
            Element element5 = document2.createElement("indexOption");
            element5.setAttribute("name", string);
            element.appendChild(element5);
        }
    }

    private static void doSubcollection(Document document, Node node) {
        Element element = document.getDocumentElement();
        NodeList nodeList = ((Element)node).getElementsByTagName("subcollection");
        int n = nodeList.getLength();
        if (n < 1) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("name");
            String string2 = element2.getAttribute("filter");
            int n2 = string2.indexOf("/");
            Object object2 = "";
            Object object3 = "";
            String string3 = "";
            Object object4 = "";
            if (n2 == -1) {
                object2 = object3 = string2;
                string3 = "include";
            } else {
                string3 = "include";
                if (string2.startsWith("!")) {
                    string3 = "exclude";
                    string2 = string2.substring("!".length());
                }
                if ((object = string2.split("/"))[0] != null && object[0] != "") {
                    object2 = object[0];
                }
                if (!((String)object2).equals("Filename") && ((String)object2).indexOf(46) == -1) {
                    object2 = "ex." + (String)object2;
                }
                if (object[1] != null && object[1] != "") {
                    object3 = object[1];
                }
                if (((Object)object).length > 2 && object[2] != null && object[2] != "") {
                    object4 = object[2];
                }
            }
            object = document.createElement("Subcollection");
            object.setAttribute("name", string);
            object.setAttribute("content", (String)object2);
            object.setAttribute("type", string3);
            if (object4 != "") {
                object.setAttribute("options", (String)object4);
            }
            XMLTools.setNodeText((Element)object, (String)object3);
            element.appendChild((Node)object);
        }
    }

    private static void convertSubcollection(Document document, Document document2, Element element) {
        Element element2 = document.getDocumentElement();
        NodeList nodeList = element2.getElementsByTagName("Subcollection");
        if (nodeList == null) {
            return;
        }
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Element element3 = (Element)nodeList.item(i);
            if (element3.getAttribute("assigned").equals("false")) continue;
            String string = element3.getAttribute("content");
            String string2 = element3.getAttribute("name");
            String string3 = element3.getAttribute("options");
            String string4 = element3.getAttribute("type");
            String string5 = XMLTools.getNodeText(element3);
            String string6 = "";
            if (string4.equals("exclude")) {
                string6 = "!";
            }
            if (string.startsWith("ex.") && string.indexOf(46, "ex.".length()) == -1) {
                string = string.substring("ex.".length());
            }
            string6 = string6 + string + "/" + string5;
            if (string3 != null && string3 != "") {
                string6 = string6 + "/" + string3;
            }
            Element element4 = document2.createElement("subcollection");
            element4.setAttribute("filter", string6);
            element4.setAttribute("name", string2);
            element.appendChild(element4);
        }
    }

    private static void doIndexSubcollection(Document document, Node node) {
        Element element = document.getDocumentElement();
        NodeList nodeList = ((Element)node).getElementsByTagName("indexSubcollection");
        int n = nodeList.getLength();
        if (n < 1) {
            return;
        }
        Element element2 = document.createElement("SubcollectionIndexes");
        for (int i = 0; i < n; ++i) {
            Element element3 = document.createElement("Index");
            Element element4 = (Element)nodeList.item(i);
            String string = element4.getAttribute("name");
            String[] stringArray = string.split(",");
            for (int j = 0; j < stringArray.length; ++j) {
                Element element5 = document.createElement("content");
                element5.setAttribute("name", stringArray[j]);
                element3.appendChild(element5);
            }
            element2.appendChild(element3);
            CollectionConfigXMLReadWrite.doSearchDisplayItems(document, element4, string, "partition");
        }
        CollectionConfigXMLReadWrite.appendProperly(element, element2);
    }

    private static void convertSubcollectionIndexes(Document document, Document document2, Element element) {
        Element element2 = document.getDocumentElement();
        Element element3 = (Element)XMLTools.getChildByTagName(element2, "SubcollectionIndexes");
        if (element3 == null) {
            return;
        }
        NodeList nodeList = element3.getElementsByTagName("Index");
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            Element element4 = (Element)nodeList.item(i);
            if (element4.getAttribute("assigned").equals("false")) continue;
            Element element5 = document2.createElement("indexSubcollection");
            String string = "";
            NodeList nodeList2 = element4.getElementsByTagName("content");
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                Element element6 = (Element)nodeList2.item(j);
                if (element6.getAttribute("assigned").equals("false")) continue;
                object = element6.getAttribute("name");
                string = string + (String)object;
                if (j < n2 - 1) {
                    string = string + ",";
                }
                element6 = null;
            }
            element5.setAttribute("name", string);
            ArrayList arrayList = CollectionConfigXMLReadWrite.getMatchingSearchMetaElements(element2, string, "partition");
            if (arrayList != null) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    object = (Element)arrayList.get(j);
                    if (object.getAttribute("assigned").equals("false")) continue;
                    Element element7 = CollectionConfigXMLReadWrite.constructDisplayItem((Element)object, document2);
                    element5.appendChild(element7);
                }
            }
            element.appendChild(element5);
        }
    }

    private static void doIndexLanguage(Document document, Node node) {
        Element element = document.getDocumentElement();
        NodeList nodeList = ((Element)node).getElementsByTagName("indexLanguage");
        int n = nodeList.getLength();
        if (n < 1) {
            return;
        }
        Element element2 = document.createElement("Languages");
        for (int i = 0; i < n; ++i) {
            Element element3 = document.createElement("Language");
            Element element4 = (Element)nodeList.item(i);
            String string = element4.getAttribute("name");
            element3.setAttribute("name", string);
            element2.appendChild(element3);
            CollectionConfigXMLReadWrite.doSearchDisplayItems(document, element4, string, "language");
        }
        element.appendChild(element2);
    }

    private static void doDefaultIndexLanguage(Document document, Node node) {
        Element element = document.getDocumentElement();
        String string = "defaultIndexLanguage";
        String string2 = "DefaultLanguage";
        Node node2 = XMLTools.getChildByTagName(node, string);
        if (node2 == null) {
            return;
        }
        Element element2 = document.createElement(string2);
        String string3 = ((Element)node2).getAttribute("name");
        element2.setAttribute("name", string3);
        element2.setAttribute("assigned", "true");
        element.appendChild(element2);
    }

    private static void doLanguageMetadata(Document document, Node node) {
        Element element = document.getDocumentElement();
        String string = "languageMetadata";
        String string2 = "LanguageMetadata";
        Node node2 = XMLTools.getChildByTagName(node, string);
        if (node2 == null) {
            return;
        }
        Element element2 = document.createElement(string2);
        String string3 = ((Element)node2).getAttribute("name");
        if (string3.indexOf(46) == -1) {
            string3 = "ex." + string3;
        }
        element2.setAttribute("name", string3);
        element2.setAttribute("assigned", "true");
        element.appendChild(element2);
    }

    private static void convertLanguages(Document document, Document document2, Element element) {
        Object object;
        Object object2;
        Object object3;
        Element element2 = document.getDocumentElement();
        Element element3 = (Element)XMLTools.getChildByTagName(element2, "Languages");
        if (element3 == null) {
            return;
        }
        NodeList nodeList = element3.getElementsByTagName("Language");
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            object3 = (Element)nodeList.item(i);
            if (object3.getAttribute("assigned").equals("false")) continue;
            object2 = document2.createElement("indexLanguage");
            object = object3.getAttribute("name");
            object2.setAttribute("name", (String)object);
            ArrayList arrayList = CollectionConfigXMLReadWrite.getMatchingSearchMetaElements(element2, (String)object, "language");
            if (arrayList != null) {
                for (int j = 0; j < arrayList.size(); ++j) {
                    Element element4 = (Element)arrayList.get(j);
                    if (element4.getAttribute("assigned").equals("false")) continue;
                    Element element5 = CollectionConfigXMLReadWrite.constructDisplayItem(element4, document2);
                    object2.appendChild(element5);
                }
            }
            element.appendChild((Node)object2);
        }
        Element element6 = (Element)XMLTools.getChildByTagName(element2, "DefaultLanguage");
        if (element6 != null) {
            object3 = element6.getAttribute("name");
            object2 = document2.createElement("defaultIndexLanguage");
            object2.setAttribute("name", (String)object3);
            element.appendChild((Node)object2);
        }
        if ((object3 = (Element)XMLTools.getChildByTagName(element2, "LanguageMetadata")) != null) {
            object2 = object3.getAttribute("name");
            object = document2.createElement("languageMetadata");
            if (((String)object2).startsWith("ex.") && ((String)object2).indexOf(46, "ex.".length()) == -1) {
                object2 = ((String)object2).substring("ex.".length());
            }
            object.setAttribute("name", (String)object2);
            element.appendChild((Node)object);
        }
    }

    private static void doSearchType(Document document, Node node) {
        NodeList nodeList = ((Element)node).getElementsByTagName("searchType");
        int n = nodeList.getLength();
        String string = "";
        if (n < 1) {
            string = "plain,simpleform,advancedform";
        } else {
            for (int i = 0; i < n; ++i) {
                Node node2 = nodeList.item(i);
                String string2 = ((Element)node2).getAttribute("name");
                if (i > 0) {
                    string = string + ",";
                }
                string = string + string2;
            }
        }
        string = string.trim();
        Element element = document.createElement("format");
        element.setAttribute("name", "searchType");
        XMLTools.setNodeText(element, string);
        CollectionConfigXMLReadWrite.appendProperly(document.getDocumentElement(), element);
    }

    private static void convertSearchType(Document document, Document document2, Element element) {
        Element element2 = XMLTools.getNamedElement(document.getDocumentElement(), "format", "name", "searchType");
        if (element2 == null) {
            return;
        }
        String string = XMLTools.getNodeText(element2).trim();
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            Element element3 = document2.createElement("searchType");
            element3.setAttribute("name", stringArray[i]);
            element.appendChild(element3);
        }
    }

    private static void doSearchFormat(Document document, Node node) {
        NodeList nodeList = ((Element)node).getElementsByTagName("format");
        int n = nodeList.getLength();
        if (n < 1) {
            return;
        }
        Element element = null;
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.hasAttributes()) continue;
            element = (Element)node2;
        }
        if (element != null) {
            document.getDocumentElement().appendChild(CollectionConfigXMLReadWrite.doFormat(document, element, "search"));
        }
    }

    private static void convertSearchFormat(Document document, Document document2, Element element) {
        Element element2 = XMLTools.getNamedElement(document.getDocumentElement(), "format", "name", "search");
        element.appendChild(CollectionConfigXMLReadWrite.convertFormat(document2, element2));
    }

    private static void doPluginsAndPlugout(Document document, Node node) {
        Object object;
        Element element = document.getDocumentElement();
        Node node2 = XMLTools.getChildByTagNameIndexed((Element)node, "pluginList", 0);
        if (node2 == null) {
            System.out.println("There is no pluginlist set.");
        } else {
            object = ((Element)node2).getElementsByTagName("plugin");
            int n = object.getLength();
            if (n >= 1) {
                for (int i = 0; i < n; ++i) {
                    Element element2 = (Element)object.item(i);
                    String string = element2.getAttribute("name");
                    string = Utility.ensureNewPluginName(string);
                    Element element3 = document.createElement("Plugin");
                    element3.setAttribute("type", string);
                    NodeList nodeList = element2.getElementsByTagName("option");
                    for (int j = 0; j < nodeList.getLength(); ++j) {
                        Element element4 = (Element)nodeList.item(j);
                        String string2 = element4.getAttribute("name");
                        if (string2.startsWith("-")) {
                            string2 = string2.substring(1);
                        }
                        String string3 = element4.getAttribute("value");
                        Element element5 = null;
                        if (string2.equals("") && !string3.equals("")) continue;
                        element5 = document.createElement("Option");
                        element5.setAttribute("assigned", "true");
                        if (string2.equals("DirectoryPlugin") && string3.equals("use_metadata_files")) continue;
                        if (string3 != null) {
                            if (string3.startsWith("\"") && string3.endsWith("\"")) {
                                string3 = string3.substring(1, string3.length() - 1);
                            }
                            if (string2.equals("metadata")) {
                                String[] stringArray = string3.split(",");
                                string3 = "";
                                for (int k = 0; k <= stringArray.length - 1; ++k) {
                                    if (stringArray[k].indexOf(46) == -1) {
                                        stringArray[k] = "ex." + stringArray[k];
                                    }
                                    string3 = k < stringArray.length - 1 ? string3 + stringArray[k] + "," : string3 + stringArray[k];
                                }
                            }
                        }
                        if (!string2.equals("")) {
                            element5.setAttribute("name", string2);
                        }
                        if (!string3.equals("")) {
                            XMLTools.setNodeText(element5, string3);
                        }
                        element3.appendChild(element5);
                    }
                    CollectionConfigXMLReadWrite.appendProperly(element, element3);
                }
            }
        }
        object = XMLTools.getChildByTagNameIndexed((Element)node, "plugout", 0);
        if (object != null) {
            Element element6 = XMLTools.duplicateElement(document, (Element)object, true);
            element.appendChild(element6);
        }
    }

    private static void convertPluginsAndPlugout(Document document, Document document2) {
        Element element;
        int n;
        Element element2 = document2.createElement("import");
        Element element3 = document2.createElement("pluginList");
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("Plugin");
        int n2 = n = nodeList == null ? 0 : nodeList.getLength();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            element = (Element)nodeList.item(i);
            if (element.getAttribute("separator").equals("true") || element.getAttribute("assigned").equals("false")) continue;
            String string = element.getAttribute("type");
            Element element4 = document2.createElement("plugin");
            element4.setAttribute("name", string);
            NodeList nodeList2 = element.getElementsByTagName("Option");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element5 = (Element)nodeList2.item(j);
                if (!element5.getAttribute("assigned").equals("true")) continue;
                String string2 = element5.getAttribute("name");
                String string3 = XMLTools.getNodeText(element5);
                if (string2 == null && string3 == null) continue;
                Element element6 = document2.createElement("option");
                if (string2 != null && string2.equals("metadata")) {
                    String[] stringArray = string3.split(",");
                    string3 = "";
                    for (int k = 0; k <= stringArray.length - 1; ++k) {
                        if (stringArray[k].startsWith("ex.") && stringArray[k].indexOf(46, "ex.".length()) == -1) {
                            stringArray[k] = stringArray[k].substring("ex.".length());
                        }
                        string3 = k < stringArray.length - 1 ? string3 + stringArray[k] + "," : string3 + stringArray[k];
                    }
                }
                if (!string2.equals("")) {
                    if (!string2.startsWith("-")) {
                        string2 = "-" + string2;
                    }
                    element6.setAttribute("name", string2);
                }
                if (!string3.equals("")) {
                    element6.setAttribute("value", string3);
                }
                element4.appendChild(element6);
            }
            element3.appendChild(element4);
        }
        element2.appendChild(element3);
        Node node = XMLTools.getChildByTagNameIndexed(document.getDocumentElement(), "plugout", 0);
        if (node != null) {
            element = XMLTools.duplicateElement(document2, (Element)node, true);
            element2.appendChild(element);
        }
        document2.getDocumentElement().appendChild(element2);
    }

    private static void doClassifiers(Document document, Node node) {
        Element element = document.getDocumentElement();
        NodeList nodeList = ((Element)node).getElementsByTagName("classifier");
        int n = nodeList.getLength();
        if (n < 1) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute("name");
            Element element3 = document.createElement("Classify");
            element3.setAttribute("type", string);
            String string2 = "";
            NodeList nodeList2 = element2.getElementsByTagName("option");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                object = (Element)nodeList2.item(j);
                String string3 = object.getAttribute("name");
                string2 = string2 + (string3.equals("") ? "" : " " + string3);
                if (string3.startsWith("-")) {
                    string3 = string3.substring(1);
                }
                String string4 = object.getAttribute("value");
                string2 = string2 + (string3.equals("") ? "" : " " + string4);
                Element element4 = null;
                if (string3.equals("") && !string4.equals("")) continue;
                element4 = document.createElement("Option");
                element4.setAttribute("assigned", "true");
                if (!string3.equals("")) {
                    element4.setAttribute("name", string3);
                }
                if (!string4.equals("") && string3.equals("metadata")) {
                    String[] stringArray = string4.split(",");
                    string4 = "";
                    for (int k = 0; k <= stringArray.length - 1; ++k) {
                        if (stringArray[k].indexOf(46) == -1) {
                            stringArray[k] = "ex." + stringArray[k];
                        } else {
                            MetadataElement metadataElement = MetadataTools.getMetadataElementWithName(stringArray[k]);
                            if (metadataElement != null) {
                                stringArray[k] = metadataElement.getDisplayName();
                            }
                        }
                        string4 = k < stringArray.length - 1 ? string4 + stringArray[k] + "," : string4 + stringArray[k];
                    }
                }
                if (string4 != null && !string4.equals("")) {
                    XMLTools.setNodeText(element4, string4);
                }
                element3.appendChild(element4);
            }
            Element element5 = (Element)XMLTools.getChildByTagName(element2, "format");
            if (element5 != null) {
                element3.appendChild(CollectionConfigXMLReadWrite.doFormat(document, element5, null));
            }
            object = element2.getElementsByTagName("displayItem");
            XMLTools.duplicateElementList(document, element3, (NodeList)object, true);
            CollectionConfigXMLReadWrite.appendProperly(element, element3);
        }
        Element element6 = (Element)XMLTools.getChildByTagName(node, "format");
        document.getDocumentElement().appendChild(CollectionConfigXMLReadWrite.doFormat(document, element6, "browse"));
    }

    private static void convertClassifier(Document document, Document document2) {
        int n;
        Element element = document2.createElement("browse");
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("Classify");
        int n2 = n = nodeList == null ? 0 : nodeList.getLength();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            Element element2 = (Element)nodeList.item(i);
            if (element2.getAttribute("assigned").equals("false")) continue;
            String string = element2.getAttribute("type");
            Element element3 = document2.createElement("classifier");
            element3.setAttribute("name", string);
            NodeList nodeList2 = element2.getElementsByTagName("Option");
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                object = (Element)nodeList2.item(j);
                if (object.getAttribute("assigned").equals("false")) continue;
                String string2 = object.getAttribute("name");
                String string3 = XMLTools.getNodeText((Element)object);
                if (string2 == null && string3 == null) continue;
                Element element4 = document2.createElement("option");
                if (string2 != null && string2.equals("metadata")) {
                    String[] stringArray = string3.split(",");
                    string3 = "";
                    for (int k = 0; k <= stringArray.length - 1; ++k) {
                        if (stringArray[k].startsWith("ex.") && stringArray[k].indexOf(46, "ex.".length()) == -1) {
                            stringArray[k] = stringArray[k].substring("ex.".length());
                        } else {
                            MetadataElement metadataElement = MetadataTools.getMetadataElementWithDisplayName(stringArray[k]);
                            if (metadataElement != null) {
                                stringArray[k] = metadataElement.getFullName();
                            }
                        }
                        string3 = k < stringArray.length - 1 ? string3 + stringArray[k] + "," : string3 + stringArray[k];
                    }
                }
                if (!string2.equals("")) {
                    if (!string2.startsWith("-")) {
                        string2 = "-" + string2;
                    }
                    element4.setAttribute("name", string2);
                }
                if (!string3.equals("")) {
                    element4.setAttribute("value", string3);
                }
                element3.appendChild(element4);
            }
            Element element5 = (Element)XMLTools.getChildByTagName(element2, "format");
            if (element5 != null) {
                element3.appendChild(CollectionConfigXMLReadWrite.convertFormat(document2, element5));
            }
            object = element2.getElementsByTagName("displayItem");
            XMLTools.duplicateElementList(document2, element3, (NodeList)object, true);
            element.appendChild(element3);
        }
        Element element6 = XMLTools.getNamedElement(document.getDocumentElement(), "format", "name", "browse");
        element.appendChild(CollectionConfigXMLReadWrite.convertFormat(document2, element6));
        document2.getDocumentElement().appendChild(element);
    }

    private static void doDisplayFormat(Document document, Element element) {
        Element element2 = (Element)XMLTools.getChildByTagName(element, "display");
        if (element2 == null) {
            return;
        }
        Element element3 = (Element)XMLTools.getChildByTagName(element2, "format");
        document.getDocumentElement().appendChild(CollectionConfigXMLReadWrite.doFormat(document, element3, "display"));
    }

    private static void convertDisplayFormat(Document document, Document document2) {
        Element element = XMLTools.getNamedElement(document.getDocumentElement(), "format", "name", "display");
        if (element == null) {
            return;
        }
        Element element2 = document2.createElement("display");
        element2.appendChild(CollectionConfigXMLReadWrite.convertFormat(document2, element));
        document2.getDocumentElement().appendChild(element2);
    }

    private static void doReplaceList(Document document, Element element) {
        Element element2 = document.getDocumentElement();
        Node node = XMLTools.getChildByTagName(element, "replaceList");
        if (node == null) {
            return;
        }
        Element element3 = XMLTools.duplicateElement(document, (Element)node, true);
        element2.appendChild(element3);
    }

    private static void convertReplaceList(Document document, Document document2) {
        Element element = document2.getDocumentElement();
        Node node = XMLTools.getChildByTagName(document.getDocumentElement(), "replaceList");
        if (node == null) {
            return;
        }
        Element element2 = XMLTools.duplicateElement(document2, (Element)node, true);
        element.appendChild(element2);
    }

    private static void doReplaceListRef(Document document, Element element) {
        Element element2 = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("replaceListRef");
        XMLTools.duplicateElementList(document, element2, nodeList, true);
    }

    private static void convertReplaceListRef(Document document, Document document2) {
        Element element = document2.getDocumentElement();
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("replaceListRef");
        XMLTools.duplicateElementList(document2, element, nodeList, true);
    }

    private static void doServiceRackList(Document document, Element element) {
        Element element2 = document.getDocumentElement();
        Node node = XMLTools.getChildByTagName(element, "serviceRackList");
        if (node == null) {
            return;
        }
        Element element3 = XMLTools.duplicateElement(document, (Element)node, true);
        element2.appendChild(element3);
    }

    private static void convertServiceRackList(Document document, Document document2) {
        Element element = document2.getDocumentElement();
        Node node = XMLTools.getChildByTagName(document.getDocumentElement(), "serviceRackList");
        if (node == null) {
            return;
        }
        Element element2 = XMLTools.duplicateElement(document2, (Element)node, true);
        element.appendChild(element2);
    }

    private static void doUnknownElements(Document document, Element element) {
        Element element2 = document.getDocumentElement();
        Element element3 = document.createElement("Unknown");
        element2.appendChild(element3);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1 || known_element_names.contains(node.getNodeName())) continue;
            element3.appendChild(XMLTools.duplicateElement(document, (Element)node, true));
        }
    }

    private static void convertUnknownElements(Document document, Document document2) {
        Element element = document2.getDocumentElement();
        Node node = XMLTools.getChildByTagName(document.getDocumentElement(), "Unknown");
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Element element2 = XMLTools.duplicateElement(document2, (Element)node2, true);
            element.appendChild(element2);
        }
    }

    private static void doBaseSearchPartInternal(Document document, Node node, String string, String string2, String string3, String string4, boolean bl) {
        Element element = document.getDocumentElement();
        Element element2 = document.createElement(string);
        element2.setAttribute("assigned", "true");
        NodeList nodeList = ((Element)node).getElementsByTagName(string3);
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            String string5;
            Element element3 = document.createElement(string2);
            Element element4 = (Element)nodeList.item(i);
            String string6 = string5 = element4.getAttribute("name");
            if (!bl) {
                String string7 = "";
                object2 = element4.getElementsByTagName("option");
                if (object2 != null) {
                    for (int j = 0; j < object2.getLength(); ++j) {
                        object = (Element)object2.item(j);
                        String string8 = object.getAttribute("name");
                        string7 = string7 + (string8.equals("") ? "" : " " + string8);
                        String string9 = object.getAttribute("value");
                        string7 = string7 + (string8.equals("") ? "" : " " + string9);
                        if (string8.equals("") && !string9.equals("")) continue;
                        Element element5 = null;
                        element5 = document.createElement("Option");
                        element5.setAttribute("assigned", "true");
                        if (!string8.equals("")) {
                            element5.setAttribute("name", string8);
                        }
                        if (string9 != null && !string9.equals("")) {
                            XMLTools.setNodeText(element5, string9);
                        }
                        element3.appendChild(element5);
                    }
                }
            }
            int n2 = string5.indexOf(":");
            if (!bl && n2 != -1) {
                System.err.println("Something is wrong! the " + string3 + " should NOT be level:source tuplets style.");
                string5 = string5.substring(n2 + 1);
            }
            if (bl) {
                if (n2 == -1) {
                    System.err.println("Something is wrong! the index should be level:source tuplets.");
                    element3.setAttribute("level", "document");
                } else {
                    element3.setAttribute("level", string5.substring(0, n2));
                    string5 = string5.substring(string5.indexOf(":") + 1);
                }
            }
            object2 = new StringTokenizer(string5, ",");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                Element element6 = document.createElement("content");
                object = ((StringTokenizer)object2).nextToken();
                if (!(((String)object).indexOf(46) != -1 || ((String)object).equals("text") || ((String)object).equals("allfields") || ((String)object).equals("none") || ((String)object).equals("rank"))) {
                    object = "ex." + (String)object;
                }
                element6.setAttribute("name", (String)object);
                element3.appendChild(element6);
                element6 = null;
            }
            element2.appendChild(element3);
            element3 = null;
            CollectionConfigXMLReadWrite.doSearchDisplayItems(document, element4, string6, string4);
        }
        element.appendChild(element2);
    }

    private static void convertBaseSearchPartInternal(Document document, Document document2, Element element, String string, String string2, String string3, String string4, boolean bl) {
        Element element2 = document.getDocumentElement();
        Element element3 = XMLTools.getNamedElement(element2, string, "assigned", "true");
        if (element3 == null) {
            return;
        }
        NodeList nodeList = element3.getElementsByTagName(string2);
        int n = nodeList.getLength();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            Element element4;
            Object object;
            Element element5 = (Element)nodeList.item(i);
            if (element5.getAttribute("assigned").equals("false")) continue;
            Element element6 = document2.createElement(string3);
            String string5 = "";
            String string6 = "";
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                string6 = element5.getAttribute("level");
                stringBuffer.append(string6).append(":");
                string5 = string6 + ":";
            }
            NodeList nodeList2 = element5.getElementsByTagName("content");
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                object = (Element)nodeList2.item(j);
                if (object.getAttribute("assigned").equals("false")) continue;
                String string7 = object.getAttribute("name");
                string5 = string5 + string7;
                if (j < n2 - 1) {
                    string5 = string5 + ",";
                }
                if (string7.startsWith("ex.") && string7.indexOf(46, "ex.".length()) == -1) {
                    string7 = string7.substring("ex.".length());
                }
                stringBuffer.append(string7);
                string7 = null;
                if (j < n2 - 1) {
                    stringBuffer.append(",");
                }
                object = null;
            }
            String string8 = stringBuffer.toString();
            element6.setAttribute("name", string8);
            object = CollectionConfigXMLReadWrite.getMatchingSearchMetaElements(element2, string8, string4);
            if (object == null) {
                object = CollectionConfigXMLReadWrite.getMatchingSearchMetaElements(element2, string5, string4);
            }
            if (object != null) {
                for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                    Element element7 = (Element)((ArrayList)object).get(j);
                    if (element7.getAttribute("assigned").equals("false")) continue;
                    element4 = CollectionConfigXMLReadWrite.constructDisplayItem(element7, document2);
                    element6.appendChild(element4);
                }
            }
            if (!bl) {
                NodeList nodeList3 = element5.getElementsByTagName("Option");
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    element4 = (Element)nodeList3.item(j);
                    if (element4.getAttribute("assigned").equals("false")) continue;
                    String string9 = element4.getAttribute("name");
                    String string10 = XMLTools.getNodeText(element4);
                    if (string9 == null && string10 == null) continue;
                    Element element8 = document2.createElement("option");
                    if (!string9.equals("")) {
                        element8.setAttribute("name", string9);
                    }
                    if (!string10.equals("")) {
                        element8.setAttribute("value", string10);
                    }
                    element6.appendChild(element8);
                }
            }
            element.appendChild(element6);
        }
    }

    private static ArrayList getMatchingSearchMetaElements(Element element, String string, String string2) {
        return XMLTools.getNamedElementList(element, "SearchMetadata", new String[]{"name", "type"}, new String[]{string, string2});
    }

    private static void convertBaseDefaultSearchPartInternal(Document document, Document document2, Element element, String string, String string2, boolean bl) {
        NodeList nodeList;
        int n;
        Element element2 = document.getDocumentElement();
        Element element3 = (Element)XMLTools.getChildByTagName(element2, string);
        if (element3 == null) {
            return;
        }
        String string3 = "";
        if (bl && (string3 = element3.getAttribute("level")).equals("")) {
            System.out.println("Bug: DefaultIndex should have its level attribute not empty. Setting it to document");
            string3 = "document";
        }
        if ((n = (nodeList = element3.getElementsByTagName("content")).getLength()) == 0) {
            return;
        }
        String string4 = "";
        if (bl) {
            string4 = string3 + ":";
        }
        for (int i = 0; i < n; ++i) {
            Element element4 = (Element)nodeList.item(i);
            if (element4.getAttribute("assigned").equals("false")) continue;
            String string5 = element4.getAttribute("name");
            if (string5.startsWith("ex.") && string5.indexOf(46, "ex.".length()) == -1) {
                string5 = string5.substring("ex.".length());
            }
            string4 = string4 + string5;
            if (i < n - 1) {
                string4 = string4 + ",";
            }
            element4 = null;
        }
        Element element5 = document2.createElement(string2);
        element5.setAttribute("name", string4);
        element.appendChild(element5);
    }

    private static Element doFormat(Document document, Element element, String string) {
        Element element2 = document.createElement("format");
        if (string != null) {
            element2.setAttribute("name", string);
        }
        if (element != null && element.hasChildNodes()) {
            String string2 = XMLTools.xmlNodeToString(element);
            int n = string2.indexOf("<format>") + "<format>".length();
            int n2 = string2.lastIndexOf("</format>");
            string2 = string2.substring(n, n2);
            XMLTools.setNodeText(element2, string2);
        }
        return element2;
    }

    private static Element convertFormat(Document document, Element element) {
        String string = XMLTools.getNodeText(element);
        Element element2 = document.createElement("format");
        XMLTools.setNodeText(element2, string);
        return element2;
    }

    private static void doSearchDisplayItems(Document document, Element element, String string, String string2) {
        Element element2 = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("displayItem");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element3 = (Element)nodeList.item(i);
            Element element4 = CollectionConfigXMLReadWrite.processSingleDisplayItem(document, element3, string, string2);
            if (element4 == null) {
                System.err.println("search meta is null " + string + ", " + string2);
                continue;
            }
            element2.appendChild(element4);
        }
    }

    private static Element processSingleDisplayItem(Document document, Element element, String string, String string2) {
        String string3;
        boolean bl = string.equals("collectionextra");
        String string4 = string3 = bl ? CollectionConfigXMLReadWrite.preserveHTMLInDescriptionDisplayItem(element) : XMLTools.getNodeText(element);
        if (element.hasAttribute("lang") && string3.equals("")) {
            return null;
        }
        String string5 = element.getAttribute("lang");
        String string6 = element.getAttribute("key");
        String string7 = string != null ? string : element.getAttribute("name");
        Element element2 = string2 == null ? document.createElement("CollectionMetadata") : document.createElement("SearchMetadata");
        element2.setAttribute("assigned", "true");
        element2.setAttribute("name", string7);
        if (string2 != null) {
            element2.setAttribute("type", string2);
        }
        if (!string5.equals("")) {
            element2.setAttribute("language", string5);
            string3 = string3.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            XMLTools.setNodeText(element2, string3);
        } else if (!string6.equals("")) {
            element2.setAttribute("key", string6);
            String string8 = element.getAttribute("dictionary");
            if (!string8.equals("")) {
                element2.setAttribute("dictionary", string8);
            }
        }
        return element2;
    }

    private static Element constructDisplayItem(Element element, Document document, String string) {
        String string2 = element.getAttribute("language");
        String string3 = element.getAttribute("key");
        String string4 = element.getAttribute("dictionary");
        String string5 = XMLTools.getNodeText(element);
        Element element2 = document.createElement("displayItem");
        element2.setAttribute("name", string);
        if (!string2.equals("")) {
            element2.setAttribute("lang", string2);
            if (string.equals("description")) {
                string5 = Codec.transform(string5, "REINSTATE_HTML_TAGS");
            }
            XMLTools.setNodeText(element2, string5);
        }
        if (!string3.equals("")) {
            element2.setAttribute("key", string3);
            if (!string4.equals("")) {
                element2.setAttribute("dictionary", string4);
            }
        }
        return element2;
    }

    private static Element constructDisplayItem(Element element, Document document) {
        return CollectionConfigXMLReadWrite.constructDisplayItem(element, document, "name");
    }

    private static void appendProperly(Element element, Element element2) {
        if (element2 == null) {
            return;
        }
        Node node = CollectionConfigXMLReadWrite.findInsertionPoint(element, element2);
        if (node != null) {
            element.insertBefore(element2, node);
        } else {
            element.appendChild(element2);
        }
    }

    private static Node findInsertionPoint(Element element, Element element2) {
        int n;
        String string = element2.getNodeName();
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() != 0) {
            if (string.equals("CollectionMetadata")) {
                if (element2.getAttribute("special").equals("true")) {
                    int n2 = 0;
                    Element element3 = (Element)nodeList.item(n2);
                    Element element4 = (Element)element3.getNextSibling();
                    while (element4.getAttribute("special").equals("true")) {
                        element3 = (Element)nodeList.item(++n2);
                        element4 = (Element)element3.getNextSibling();
                    }
                    if (element4.getNodeName().equals("NewLine")) {
                        Element element5 = element.getOwnerDocument().createElement("NewLine");
                        element.insertBefore(element5, element4);
                    }
                    return element4;
                }
                int n3 = 0;
                string = element2.getAttribute("name");
                boolean bl = false;
                Element element6 = (Element)nodeList.item(n3);
                while (element6.getAttribute("special").equals("true")) {
                    element6 = (Element)nodeList.item(++n3);
                }
                while (!bl && element6 != null) {
                    if (element6.getAttribute("name").equals(string)) {
                        bl = true;
                        continue;
                    }
                    element6 = (Element)nodeList.item(++n3);
                }
                if (bl) {
                    Element element7 = element6;
                    Element element8 = (Element)nodeList.item(++n3);
                    while (element8 != null && element8.getAttribute("name").equals(string)) {
                        element7 = element8;
                        element8 = (Element)nodeList.item(++n3);
                    }
                    return element7.getNextSibling();
                }
                Element element9 = (Element)nodeList.item(nodeList.getLength() - 1);
                return element9.getNextSibling();
            }
            Element element10 = (Element)nodeList.item(nodeList.getLength() - 1);
            Node node = element10.getNextSibling();
            if (node != null && node.getNodeName().equals("NewLine")) {
                Element element11 = element.getOwnerDocument().createElement("NewLine");
                element.insertBefore(element11, node);
            }
            return node;
        }
        int n4 = -1;
        for (n = 0; n4 == -1 && n < CollectionConfiguration.COMMAND_ORDER.length; ++n) {
            if (!CollectionConfiguration.COMMAND_ORDER[n].equals(string)) continue;
            n4 = n;
        }
        for (n = n4 - 1; n >= 0; --n) {
            nodeList = element.getElementsByTagName(CollectionConfiguration.COMMAND_ORDER[n]);
            if (nodeList.getLength() <= 0) continue;
            Element element12 = (Element)nodeList.item(nodeList.getLength() - 1);
            Node node = element12.getNextSibling();
            if (node != null && node.getNodeName().equals("NewLine")) {
                Element element13 = element.getOwnerDocument().createElement("NewLine");
                element.insertBefore(element13, node);
            }
            return node;
        }
        for (int i = n4 + 1; i < CollectionConfiguration.COMMAND_ORDER.length; ++i) {
            nodeList = element.getElementsByTagName(CollectionConfiguration.COMMAND_ORDER[i]);
            if (nodeList.getLength() <= 0) continue;
            Element element14 = (Element)nodeList.item(0);
            Node node = element14.getPreviousSibling();
            if (node != null && node.getNodeName().equals("NewLine")) {
                Element element15 = element.getOwnerDocument().createElement("NewLine");
                element.insertBefore(element15, node);
            }
            return node;
        }
        return null;
    }

    private static String preserveHTMLInDescriptionDisplayItem(Element element) {
        String string;
        String string2 = XMLTools.elementToString(element, true);
        int n = string2.indexOf(string = "<displayItem");
        if (n != -1) {
            n += string.length();
            n = string2.indexOf(">", n);
            string2 = string2.substring(n + 1).trim();
        }
        if (string2.equals("")) {
            return "";
        }
        string = "</displayItem>";
        int n2 = string2.indexOf(string);
        if (n2 == -1) {
            return "";
        }
        string2 = string2.substring(0, n2);
        String[] stringArray = string2.split("\\r?\\n");
        string2 = "";
        if (stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + stringArray[i].trim() + "\n";
            }
        }
        string2 = string2.replaceAll("&amp;", "&");
        return string2;
    }

    private static void appendArrayList(Element element, ArrayList arrayList) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            CollectionConfigXMLReadWrite.appendProperly(element, (Element)arrayList.get(i));
        }
    }
}

