/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.io.File;
import java.util.ArrayList;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.cdm.ArgumentContainer;
import org.greenstone.gatherer.cdm.DOMProxyListEntry;
import org.greenstone.gatherer.greenstone.Plugins;
import org.w3c.dom.Element;

public class Plugin
extends ArgumentContainer {
    private String default_block_expression = "";
    private String default_process_expression = "";
    private boolean does_explode_metadata_databases = false;
    private boolean does_replace_srcdocs_with_html = false;
    private boolean has_loaded_options = false;

    public Plugin() {
    }

    public Plugin(Element element, Plugin plugin) {
        super(element, plugin);
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof Plugin) {
            return this.name.compareTo(((Plugin)object).getName());
        }
        return -1;
    }

    @Override
    public DOMProxyListEntry create(Element element) {
        String string = element.getAttribute("type");
        Plugin plugin = Plugins.getPlugin(string, true);
        Plugin plugin2 = new Plugin(element, plugin);
        if (plugin == null) {
            plugin2.setAssigned(false);
        }
        plugin = null;
        string = null;
        return plugin2;
    }

    public boolean hasLoadedOptions() {
        return this.has_loaded_options;
    }

    public boolean doesExplodeMetadataDatabases() {
        Plugin plugin = Plugins.getPlugin(this.getName(), false);
        if (plugin == null) {
            return false;
        }
        return plugin.does_explode_metadata_databases;
    }

    public boolean doesReplaceSrcDocsWithHtml() {
        Plugin plugin = Plugins.getPlugin(this.getName(), false);
        if (plugin == null) {
            return false;
        }
        return plugin.does_replace_srcdocs_with_html;
    }

    public boolean doesBlockFile(File file) {
        ArrayList arrayList = this.getArguments();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            Argument argument = (Argument)arrayList.get(i);
            if (!argument.getName().equals("block_exp") || ((string = argument.getValue()) == null || string.equals("")) && (string = argument.getDefaultValue()).equals("") || !this.doesFileMatchRegularExpression(file, string)) continue;
            return true;
        }
        return !this.default_block_expression.equals("") && this.doesFileMatchRegularExpression(file, this.default_block_expression);
    }

    public boolean doesProcessFile(File file) {
        ArrayList arrayList = this.getArguments();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string;
            Argument argument = (Argument)arrayList.get(i);
            if (!argument.getName().equals("process_exp") || ((string = argument.getValue()) == null || string.equals("")) && (string = argument.getDefaultValue()).equals("") || !this.doesFileMatchRegularExpression(file, string)) continue;
            return true;
        }
        return !this.default_process_expression.equals("") && this.doesFileMatchRegularExpression(file, this.default_process_expression);
    }

    private boolean doesFileMatchRegularExpression(File file, String string) {
        string = string.startsWith("(?i)") ? "(?i).*" + string.substring("(?i)".length()) : ".*" + string;
        return file.getName().matches(string);
    }

    public boolean isSeparator() {
        return this.element != null && this.element.getAttribute("separator").equals("true");
    }

    public void setDefaultBlockExpression(String string) {
        this.default_block_expression = string;
    }

    public void setDefaultProcessExpression(String string) {
        this.default_process_expression = string;
    }

    public void setDoesExplodeMetadataDatabases(boolean bl) {
        this.does_explode_metadata_databases = bl;
    }

    public void setDoesReplaceSrcDocsWithHtml(boolean bl) {
        this.does_replace_srcdocs_with_html = bl;
    }

    public void setHasLoadedOptions(boolean bl) {
        this.has_loaded_options = bl;
    }
}

