/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.collection;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.CollectionMeta;
import org.greenstone.gatherer.cdm.CommandTokenizer;
import org.greenstone.gatherer.collection.Collection;
import org.greenstone.gatherer.collection.CollectionContentsChangedListener;
import org.greenstone.gatherer.collection.CollectionTree;
import org.greenstone.gatherer.collection.CollectionTreeModel;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.collection.FullCollectionTree;
import org.greenstone.gatherer.collection.FullCollectionTreeModel;
import org.greenstone.gatherer.collection.FullCollectionTreeNode;
import org.greenstone.gatherer.collection.LegacyCollectionImporter;
import org.greenstone.gatherer.greenstone.Classifiers;
import org.greenstone.gatherer.greenstone.LocalGreenstone;
import org.greenstone.gatherer.greenstone.LocalLibraryServer;
import org.greenstone.gatherer.greenstone.Plugins;
import org.greenstone.gatherer.greenstone3.ServletConfiguration;
import org.greenstone.gatherer.gui.LockFileDialog;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.ModalProgressPopup;
import org.greenstone.gatherer.gui.WarningDialog;
import org.greenstone.gatherer.metadata.DocXMLFileManager;
import org.greenstone.gatherer.metadata.FilenameEncoding;
import org.greenstone.gatherer.metadata.MetadataChangedListener;
import org.greenstone.gatherer.metadata.MetadataSet;
import org.greenstone.gatherer.metadata.MetadataSetManager;
import org.greenstone.gatherer.metadata.MetadataXMLFileManager;
import org.greenstone.gatherer.metadata.ProfileXMLFileManager;
import org.greenstone.gatherer.shell.GShell;
import org.greenstone.gatherer.shell.GShellEvent;
import org.greenstone.gatherer.shell.GShellListener;
import org.greenstone.gatherer.shell.GShellProgressMonitor;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CollectionManager
implements GShellListener,
MetadataChangedListener {
    private static boolean building = false;
    private static boolean importing = false;
    private static boolean scheduling = false;
    private static ArrayList collection_contents_changed_listeners = new ArrayList();
    private static Collection collection = null;
    private static CollectionTree collection_tree = null;
    private static FullCollectionTree full_collection_tree = null;
    private static CollectionTreeModel collection_tree_model = null;
    private static FullCollectionTreeModel full_collection_tree_model = null;
    private static FMTreeModelListener fm_tree_model_listener = null;
    private static GShellProgressMonitor build_monitor = null;
    private static GShellProgressMonitor import_monitor = null;
    private static GShellProgressMonitor schedule_monitor = null;
    private static String delete_collection_name = null;
    public static final String LOCK_FILE = "gli.lck";
    public static final int COLLECT = 3;
    public static final int BUILDING = 5;
    public static final int SCHEDULING = 7;
    private static String scriptPath = "";
    private Boolean canPreview = null;
    LockFileDialog lockFileDialog = null;

    public CollectionManager() {
        building = false;
        importing = false;
        scheduling = false;
        collection = null;
        MetadataXMLFileManager.addMetadataChangedListener(this);
        if (Gatherer.isGsdlRemote) {
            System.err.println("Deleting user's local collect directory...");
            Utility.delete(new File(Gatherer.getCollectDirectoryPath()));
            System.err.println("Done.");
            new File(Gatherer.getCollectDirectoryPath()).mkdirs();
            scriptPath = "";
        } else {
            scriptPath = LocalGreenstone.getBinScriptDirectoryPath();
        }
    }

    public static void addCollectionContentsChangedListener(CollectionContentsChangedListener collectionContentsChangedListener) {
        collection_contents_changed_listeners.add(collectionContentsChangedListener);
    }

    public void buildCollection() {
        Object object;
        DebugStream.println("In CollectionManager.buildCollection(), CollectionDesignManager.isCompleteBuild(): " + CollectionDesignManager.isCompleteBuild());
        DebugStream.println("Is event dispatch thread: " + SwingUtilities.isEventDispatchThread());
        building = true;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!Gatherer.isGsdlRemote) {
            arrayList.add(Configuration.perl_path);
            arrayList.add("-S");
        }
        if (Configuration.fedora_info.isActive()) {
            arrayList.add(scriptPath + "g2f-buildcol.pl");
            arrayList.add("-hostname");
            arrayList.add(Configuration.fedora_info.getHostname());
            arrayList.add("-port");
            arrayList.add(Configuration.fedora_info.getPort());
            arrayList.add("-username");
            arrayList.add(Configuration.fedora_info.getUsername());
            arrayList.add("-password");
            arrayList.add(Configuration.fedora_info.getPassword());
            arrayList.add("-protocol");
            arrayList.add(Configuration.fedora_info.getProtocol());
        } else if (!CollectionDesignManager.isCompleteBuild() && CollectionDesignManager.index_manager.isLucene()) {
            arrayList.add(scriptPath + "incremental-buildcol.pl");
            CollectionDesignManager.setBuildcolWasFull(false);
        } else {
            arrayList.add(scriptPath + "full-buildcol.pl");
            CollectionDesignManager.setBuildcolWasFull(true);
        }
        arrayList.add("-gli");
        arrayList.add("-language");
        arrayList.add(Configuration.getLanguage());
        arrayList.add("-activate");
        if (Gatherer.GS3) {
            arrayList.add("-site");
            arrayList.add(Configuration.site_name);
            arrayList.add("-library_name");
            object = Configuration.servlet_path;
            if (((String)object).charAt(0) == '/') {
                object = ((String)object).substring(1);
            }
            arrayList.add(object);
        }
        if (!Gatherer.isGsdlRemote) {
            arrayList.add("-collectdir");
            arrayList.add(this.getCollectDirectory());
        }
        object = CollectionManager.collection.build_options.getValues();
        for (int i = 0; i < ((String[])object).length; ++i) {
            arrayList.add(object[i]);
        }
        arrayList.add(collection.getGroupQualifiedName(false));
        String[] stringArray = arrayList.toArray(new String[0]);
        GShell gShell = new GShell(stringArray, 0, 5, this, build_monitor, GShell.GSHELL_BUILD);
        gShell.addGShellListener(Gatherer.g_man.create_pane);
        Gatherer.g_man.create_pane.setGShell(gShell);
        gShell.addGShellListener(Gatherer.g_man.format_pane);
        gShell.start();
    }

    public void scheduleBuild() {
        Object object;
        DebugStream.println("In CollectionManager.scheduleBuild(), CollectionDesignManager.isCompleteBuild(): " + CollectionDesignManager.isCompleteBuild());
        DebugStream.println("Is event dispatch thread: " + SwingUtilities.isEventDispatchThread());
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!Gatherer.isGsdlRemote) {
            arrayList.add(Configuration.perl_path);
            arrayList.add("-S");
        }
        arrayList.add(scriptPath + "schedule.pl");
        arrayList.add("-colname");
        arrayList.add(collection.getName());
        arrayList.add("-gli");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (!Gatherer.isGsdlRemote) {
            arrayList2.add(Configuration.perl_path);
            arrayList2.add("-S");
        }
        String string = CollectionDesignManager.isCompleteBuild() ? "full-" : "incremental-";
        arrayList2.add(scriptPath + string + "import.pl");
        arrayList2.add("-language");
        arrayList2.add(Configuration.getLanguage());
        if (Gatherer.GS3) {
            arrayList2.add("-site");
            arrayList2.add(Configuration.site_name);
        }
        if (!Gatherer.isGsdlRemote) {
            arrayList2.add("-collectdir");
            arrayList2.add(this.getCollectDirectory());
        }
        String[] stringArray = CollectionManager.collection.import_options.getValues();
        int n = 0;
        for (n = 0; n < stringArray.length; ++n) {
            arrayList2.add(stringArray[n]);
        }
        arrayList2.add(collection.getGroupQualifiedName(false));
        String[] stringArray2 = arrayList2.toArray(new String[0]);
        String string2 = "";
        n = 0;
        for (n = 0; n < stringArray2.length - 1; ++n) {
            string2 = string2 + stringArray2[n] + " ";
        }
        string2 = string2 + stringArray2[n];
        arrayList.add("-import");
        arrayList.add("\"" + string2 + "\"");
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        if (!Gatherer.isGsdlRemote) {
            arrayList3.add(Configuration.perl_path);
            arrayList3.add("-S");
        }
        String string3 = new CollectionMeta(CollectionDesignManager.collect_config.getBuildType()).getValue(true);
        if (!CollectionDesignManager.isCompleteBuild() && string3.equals("lucene")) {
            arrayList3.add(scriptPath + "incremental-buildcol.pl");
        } else {
            arrayList3.add(scriptPath + "full-buildcol.pl");
        }
        arrayList3.add("-language");
        arrayList3.add(Configuration.getLanguage());
        if (Gatherer.GS3) {
            arrayList3.add("-site");
            arrayList3.add(Configuration.site_name);
            arrayList3.add("-library_name");
            object = Configuration.servlet_path;
            if (((String)object).startsWith("/")) {
                object = ((String)object).substring(1);
            }
            arrayList3.add(object);
        }
        if (!Gatherer.isGsdlRemote) {
            arrayList3.add("-collectdir");
            arrayList3.add(this.getCollectDirectory());
        }
        object = CollectionManager.collection.build_options.getValues();
        for (n = 0; n < ((String[])object).length; ++n) {
            arrayList3.add(object[n]);
        }
        arrayList3.add(collection.getGroupQualifiedName(false));
        String[] stringArray3 = arrayList3.toArray(new String[0]);
        String string4 = "";
        for (n = 0; n < stringArray3.length - 1; ++n) {
            string4 = string4 + stringArray3[n] + " ";
        }
        string4 = string4 + stringArray3[n];
        arrayList.add("-build");
        arrayList.add("\"" + string4 + "\"");
        String[] stringArray4 = CollectionManager.collection.schedule_options.getValues();
        for (n = 0; n < stringArray4.length; ++n) {
            arrayList.add(stringArray4[n]);
        }
        String[] stringArray5 = arrayList.toArray(new String[0]);
        GShell gShell = new GShell(stringArray5, 8, 7, this, schedule_monitor, GShell.GSHELL_SCHEDULE);
        gShell.addGShellListener(Gatherer.g_man.create_pane);
        Gatherer.g_man.create_pane.setGShell(gShell);
        gShell.addGShellListener(Gatherer.g_man.format_pane);
        gShell.start();
    }

    public boolean previewAvailable() {
        if (this.canPreview == null) {
            this.built();
        }
        return this.canPreview;
    }

    public boolean built() {
        boolean bl = false;
        if (collection != null) {
            String string = "";
            string = Configuration.fedora_info != null && Configuration.fedora_info.isActive() ? CollectionManager.getLoadedCollectionExportDirectoryPath() + "archiveinf-doc.gdb" : (Gatherer.GS3 ? CollectionManager.getLoadedCollectionIndexDirectoryPath() + "buildConfig.xml" : CollectionManager.getLoadedCollectionIndexDirectoryPath() + "build.cfg");
            File file = new File(string);
            bl = Gatherer.isGsdlRemote ? Gatherer.remoteGreenstoneServer.exists(collection.getGroupQualifiedName(false), file) : file.exists();
        }
        this.canPreview = bl ? Boolean.FALSE : Boolean.TRUE;
        return bl;
    }

    public boolean imported() {
        if (collection != null) {
            String string = CollectionManager.getLoadedCollectionDirectoryPath() + "archives";
            File file = new File(string);
            return file.exists();
        }
        return false;
    }

    private static boolean canDelete(File file) {
        if (!file.isDirectory()) {
            return file.canWrite();
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (CollectionManager.canDelete(fileArray[i])) continue;
            return false;
        }
        return true;
    }

    public void closeCollection() {
        if (collection == null) {
            return;
        }
        DebugStream.println("Close collection: " + collection.getName());
        File file = new File(CollectionManager.getLoadedCollectionDirectoryPath() + LOCK_FILE);
        file.delete();
        if (file.exists()) {
            System.err.println("Warning: Lockfile was not successfully deleted.");
        }
        if (Gatherer.isGsdlRemote) {
            Gatherer.remoteGreenstoneServer.deleteCollectionFile(collection.getGroupQualifiedName(false), file);
        }
        Gatherer.g_man.create_pane.options_pane.closeCurrentLogDocument();
        MetadataSetManager.clearMetadataSets();
        MetadataXMLFileManager.clearMetadataXMLFiles();
        DocXMLFileManager.clearDocXMLFiles();
        ProfileXMLFileManager.clearProfileXMLFile();
        collection.destroy();
        collection = null;
        collection_tree_model = null;
        full_collection_tree_model = null;
        Gatherer.refresh(1);
        if (Gatherer.g_man != null) {
            Gatherer.g_man.updateUI();
        }
    }

    private boolean copyExtraBaseCollStuff(File file, File file2) {
        if (!file.isDirectory() || !file2.isDirectory()) {
            return false;
        }
        DebugStream.println("Copying extra dirs from the base collection");
        File[] fileArray = file2.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            String string;
            File file3 = fileArray[i];
            if (!file3.isDirectory() || (string = file3.getName()).startsWith("import") || string.startsWith("archives") || string.startsWith("building") || string.startsWith("index") || string.startsWith("etc") || string.startsWith("metadata") || string.startsWith("log") || string.startsWith("tmp")) continue;
            try {
                File file4 = new File(file, string);
                file4.mkdirs();
                Gatherer.f_man.getQueue().copyDirectoryContents(file3, file4, true);
                continue;
            }
            catch (Exception exception) {
                DebugStream.println("Couldn't copy over the" + file3 + " dir from the base collection: " + exception.toString());
            }
        }
        return true;
    }

    public void createCollection(String string, String string2, String string3, String string4, File file, ArrayList arrayList) {
        ModalProgressPopup modalProgressPopup = new ModalProgressPopup(Dictionary.get("CollectionManager.Creating_Collection"), Dictionary.get("CollectionManager.Creating_Collection_Please_Wait"));
        modalProgressPopup.display();
        new CreateCollectionTask(string, string2, string3, string4, file, arrayList, modalProgressPopup).start();
    }

    private void createCollectionInternal(String string, String string2, String string3, String string4, File file, ArrayList arrayList) {
        try {
            CollectionMeta collectionMeta;
            int n;
            ArrayList arrayList2;
            Object object;
            File file2 = new File(this.getDefaultCollectDirectory());
            if (!file2.exists()) {
                file2.mkdirs();
            }
            this.makeCollection(string3, string2);
            String string5 = CollectionManager.getCollectionDirectoryPath(string3);
            if (!new File(string5).exists()) {
                return;
            }
            String string6 = Gatherer.GS3 ? "collectionConfig.xml" : "collect.cfg";
            File file3 = new File(string5 + "etc" + File.separator + string6);
            if (!file3.exists()) {
                System.err.println("Error: no " + string6 + " file has been created!");
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CollectionManager.Cannot_Create_Collection_With_Reason", Dictionary.get("CollectionManager.No_Config_File")), Dictionary.get("General.Error"), 0);
                return;
            }
            File file4 = new File(string5 + "log");
            file4.mkdirs();
            File file5 = new File(string5 + "import");
            if (!file5.exists()) {
                file5.mkdirs();
                if (Gatherer.isGsdlRemote) {
                    Gatherer.remoteGreenstoneServer.newCollectionDirectory(string3, file5);
                }
            }
            collection = new Collection(new File(string5, "gli.col"));
            if (CollectionManager.canDoScheduling()) {
                this.scheduling();
            }
            MetadataSetManager.clearMetadataSets();
            MetadataXMLFileManager.clearMetadataXMLFiles();
            DocXMLFileManager.clearDocXMLFiles();
            ProfileXMLFileManager.loadProfileXMLFile(new File(string5 + "metadata"));
            if (file != null) {
                DebugStream.println("Basing new collection on existing one: " + file);
                if (Gatherer.isGsdlRemote) {
                    object = file.getName();
                    Gatherer.remoteGreenstoneServer.downloadCollection((String)object);
                }
                collection.setBaseCollection(file.getAbsolutePath());
                this.copyExtraBaseCollStuff(new File(string5), file);
                object = new File(file, "metadata");
                arrayList2 = MetadataSetManager.listMetadataSets((File)object);
                if (arrayList2 != null) {
                    for (n = 0; n < arrayList2.size(); ++n) {
                        this.importMetadataSet((MetadataSet)arrayList2.get(n));
                    }
                } else {
                    DebugStream.println("This base collection has no metadata directory.");
                }
                DebugStream.println("Copy and update " + string6 + " from base collection.");
                if (Gatherer.GS3) {
                    this.updateCollectionConfigXML(new File(file, Utility.CONFIG_GS3_FILE), new File(string5, Utility.CONFIG_GS3_FILE));
                } else {
                    this.updateCollectionCFG(new File(file, Utility.CONFIG_FILE), new File(string5, Utility.CONFIG_FILE), string, string2, string4);
                }
            } else {
                this.addDefaultMetadataSets();
                this.addRequiredMetadataSets();
            }
            CollectionManager.collection.cdm = new CollectionDesignManager(new File(CollectionManager.getLoadedCollectionCfgFilePath()));
            CollectionDesignManager cfr_ignored_0 = CollectionManager.collection.cdm;
            object = CollectionDesignManager.collectionmeta_manager.getMetadata("collectionname");
            CollectionDesignManager cfr_ignored_1 = CollectionManager.collection.cdm;
            arrayList2 = CollectionDesignManager.collectionmeta_manager.getMetadata("collectionextra");
            for (n = 0; n < ((ArrayList)object).size(); ++n) {
                collectionMeta = (CollectionMeta)((ArrayList)object).get(n);
                collectionMeta.setValue("");
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                collectionMeta = (CollectionMeta)arrayList2.get(n);
                collectionMeta.setValue("");
            }
            CollectionDesignManager cfr_ignored_2 = CollectionManager.collection.cdm;
            CollectionMeta collectionMeta2 = CollectionDesignManager.collectionmeta_manager.getMetadatum("collectionname");
            collectionMeta2.setValue(string4);
            CollectionDesignManager cfr_ignored_3 = CollectionManager.collection.cdm;
            collectionMeta = CollectionDesignManager.collectionmeta_manager.getMetadatum("collectionextra");
            collectionMeta.setValue(string);
            if (file != null) {
                CollectionDesignManager cfr_ignored_4 = CollectionManager.collection.cdm;
                CollectionMeta collectionMeta3 = new CollectionMeta(CollectionDesignManager.collect_config.getCreator());
                collectionMeta3.setValue(string2);
                collectionMeta3 = null;
                CollectionDesignManager cfr_ignored_5 = CollectionManager.collection.cdm;
                CollectionMeta collectionMeta4 = new CollectionMeta(CollectionDesignManager.collect_config.getMaintainer());
                collectionMeta4.setValue(string2);
                collectionMeta4 = null;
                CollectionDesignManager cfr_ignored_6 = CollectionManager.collection.cdm;
                CollectionMeta collectionMeta5 = new CollectionMeta(CollectionDesignManager.collect_config.getPublic());
                collectionMeta5.setValue("true");
                collectionMeta5 = null;
                CollectionDesignManager cfr_ignored_7 = CollectionManager.collection.cdm;
                CollectionMeta collectionMeta6 = CollectionDesignManager.collectionmeta_manager.getMetadatum("iconcollection");
                collectionMeta6.setValue("");
                collectionMeta6 = null;
                CollectionDesignManager cfr_ignored_8 = CollectionManager.collection.cdm;
                CollectionMeta collectionMeta7 = CollectionDesignManager.collectionmeta_manager.getMetadatum("iconcollectionsmall");
                collectionMeta7.setValue("");
                collectionMeta7 = null;
            }
            this.saveCollection();
            this.createLockFile(new File(string5, LOCK_FILE));
            Gatherer.refresh(0);
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    private void scheduling() throws Exception {
        String string;
        String string2 = Configuration.getEmail();
        if (string2 != null) {
            CollectionManager.collection.schedule_options.setValue("toaddr", false, Configuration.getEmail());
        }
        File file = new File(LocalGreenstone.getDirectoryPath() + File.separator + "etc" + File.separator + "main.cfg");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        string2 = "";
        String string3 = "";
        while ((string2 = bufferedReader.readLine()) != null) {
            if (!string2.startsWith("maintainer")) continue;
            string3 = string2.substring(10);
            string3 = string3.trim();
            break;
        }
        bufferedReader.close();
        if (!string3.equals("NULL") && !string3.equals("null")) {
            CollectionManager.collection.schedule_options.setValue("fromaddr", false, string3);
        }
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        String string4 = "NULL";
        while ((string2 = bufferedReader.readLine()) != null) {
            if (!string2.startsWith("MailServer")) continue;
            string4 = string2.substring(10);
            string4 = string4.trim();
            break;
        }
        bufferedReader.close();
        if ((string4.equals("NULL") || string4.equals("null")) && !(string = string3).equals("NULL") && !string.equals("null")) {
            int n = string.indexOf(64);
            string = string.substring(n + 1);
            string4 = "mail." + string;
        }
        if (!string4.equals("NULL") && !string4.equals("null")) {
            CollectionManager.collection.schedule_options.setValue("smtp", false, string4);
        }
    }

    private void createLockFile(File file) {
        try {
            Document document = XMLTools.parseXMLFile("xml/gli.lck", true);
            String string = System.getProperty("user.name");
            if (Gatherer.isWebswing) {
                string = Gatherer.webswingAuthenticator.getUsername();
            }
            Element element = (Element)XMLTools.getNodeFromNamed(document.getDocumentElement(), "User");
            element.appendChild(document.createTextNode(string));
            element = null;
            string = null;
            String string2 = Utility.getMachineName();
            Element element2 = (Element)XMLTools.getNodeFromNamed(document.getDocumentElement(), "Machine");
            element2.appendChild(document.createTextNode(string2));
            element2 = null;
            string2 = null;
            String string3 = Utility.getDateString();
            Element element3 = (Element)XMLTools.getNodeFromNamed(document.getDocumentElement(), "Date");
            element3.appendChild(document.createTextNode(string3));
            element3 = null;
            string3 = null;
            XMLTools.writeXMLFile(file, document);
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    public boolean deleteCollection(String string) {
        if (LocalLibraryServer.isRunning()) {
            LocalLibraryServer.releaseCollection(string);
        }
        if (Configuration.fedora_info.isActive()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!Gatherer.isGsdlRemote) {
                arrayList.add(Configuration.perl_path);
                arrayList.add("-S");
            }
            arrayList.add(scriptPath + "g2f-deletecol.pl");
            arrayList.add("-hostname");
            arrayList.add(Configuration.fedora_info.getHostname());
            arrayList.add("-port");
            arrayList.add(Configuration.fedora_info.getPort());
            arrayList.add("-username");
            arrayList.add(Configuration.fedora_info.getUsername());
            arrayList.add("-password");
            arrayList.add(Configuration.fedora_info.getPassword());
            arrayList.add("-protocol");
            arrayList.add(Configuration.fedora_info.getProtocol());
            arrayList.add("-gli");
            arrayList.add("-language");
            arrayList.add(Configuration.getLanguage());
            if (Gatherer.GS3) {
                arrayList.add("-site");
                arrayList.add(Configuration.site_name);
            }
            if (!Gatherer.isGsdlRemote) {
                arrayList.add("-collectdir");
                arrayList.add(this.getCollectDirectory());
            }
            arrayList.add(string);
            String[] stringArray = arrayList.toArray(new String[0]);
            GShell gShell = new GShell(stringArray, 9, 3, this, null, GShell.GSHELL_FEDORA_COLDELETE);
            gShell.start();
            delete_collection_name = string;
            return true;
        }
        if (Gatherer.isGsdlRemote) {
            Gatherer.remoteGreenstoneServer.deleteCollection(string);
        }
        if (Gatherer.GS3) {
            Gatherer.configGS3Server(Configuration.site_name, ServletConfiguration.DEACTIVATE_COMMAND + string);
        }
        return Utility.delete(new File(CollectionManager.getCollectionDirectoryPath(string)));
    }

    public void fireFileAddedToCollection(File file) {
        for (int i = 0; i < collection_contents_changed_listeners.size(); ++i) {
            ((CollectionContentsChangedListener)collection_contents_changed_listeners.get(i)).fileAddedToCollection(file);
        }
    }

    public Collection getCollection() {
        return collection;
    }

    public static String getCollectionDirectoryPath(String string) {
        return Gatherer.getCollectDirectoryPath() + string + File.separator;
    }

    public static String getLoadedCollectionArchivesDirectoryPath() {
        return CollectionManager.getLoadedCollectionDirectoryPath() + "archives" + File.separator;
    }

    public static String getLoadedCollectionArchivesKeepOldDirectoryPath() {
        return CollectionManager.getLoadedCollectionDirectoryPath() + "archives_keepold" + File.separator;
    }

    public static String getLoadedCollectionExportDirectoryPath() {
        return CollectionManager.getLoadedCollectionDirectoryPath() + "export" + File.separator;
    }

    public static String getLoadedCollectionBuildingDirectoryPath() {
        return CollectionManager.getLoadedCollectionDirectoryPath() + "building" + File.separator;
    }

    public static String getLoadedCollectionCfgFilePath() {
        String string = Gatherer.GS3 ? "collectionConfig.xml" : "collect.cfg";
        return CollectionManager.getLoadedCollectionEtcDirectoryPath() + string;
    }

    public static String getLoadedCollectionDirectoryPath() {
        return collection.getCollectionDirectory().getPath() + File.separator;
    }

    public static String getLoadedCollectionEtcDirectoryPath() {
        return CollectionManager.getLoadedCollectionDirectoryPath() + "etc" + File.separator;
    }

    public static String getLoadedCollectionColFilePath() {
        return CollectionManager.getLoadedCollectionDirectoryPath() + "gli.col";
    }

    public static String getLoadedCollectionImagesDirectoryPath() {
        return CollectionManager.getLoadedCollectionDirectoryPath() + "images" + File.separator;
    }

    public static String getLoadedCollectionImportDirectoryPath() {
        return CollectionManager.getLoadedCollectionDirectoryPath() + "import" + File.separator;
    }

    public static String getLoadedCollectionIndexDirectoryPath() {
        return CollectionManager.getLoadedCollectionDirectoryPath() + "index" + File.separator;
    }

    public static String getLoadedCollectionLogDirectoryPath() {
        return CollectionManager.getLoadedCollectionDirectoryPath() + "log" + File.separator;
    }

    public static String getLoadedCollectionMacrosDirectoryPath() {
        return CollectionManager.getLoadedCollectionDirectoryPath() + "macros" + File.separator;
    }

    public static String getLoadedCollectionMetadataDirectoryPath() {
        return CollectionManager.getLoadedCollectionDirectoryPath() + "metadata" + File.separator;
    }

    public static String getLoadedCollectionName() {
        return CollectionManager.getLoadedCollectionName(false);
    }

    public static String getLoadedCollectionName(boolean bl) {
        if (collection != null) {
            return collection.getGroupQualifiedName(bl);
        }
        return null;
    }

    public static String getLoadedCollectionGroupName() {
        if (collection != null) {
            return collection.getCollectionGroupName();
        }
        return null;
    }

    public static String getLoadedCollectionTailName() {
        if (collection != null) {
            return collection.getCollectionTailName();
        }
        return null;
    }

    public static String getLoadedGroupQualifiedCollectionName(boolean bl) {
        if (collection != null) {
            return collection.getGroupQualifiedName(bl);
        }
        return null;
    }

    public CollectionTree getCollectionTree() {
        if (collection_tree == null) {
            collection_tree = new CollectionTree(collection_tree_model, true);
        }
        return collection_tree;
    }

    public FullCollectionTree getFullCollectionTree() {
        if (full_collection_tree == null) {
            full_collection_tree = new FullCollectionTree(full_collection_tree_model, true);
        }
        return full_collection_tree;
    }

    public CollectionTreeModel getCollectionTreeModel() {
        if (collection_tree_model == null && collection != null) {
            collection_tree_model = new CollectionTreeModel(new CollectionTreeNode(new File(CollectionManager.getLoadedCollectionImportDirectoryPath())));
            if (fm_tree_model_listener == null) {
                fm_tree_model_listener = new FMTreeModelListener();
            }
            collection_tree_model.addTreeModelListener(fm_tree_model_listener);
        }
        return collection_tree_model;
    }

    public FullCollectionTreeModel getFullCollectionTreeModel() {
        if (full_collection_tree_model == null && collection != null) {
            full_collection_tree_model = new FullCollectionTreeModel(new FullCollectionTreeNode(new File(CollectionManager.getLoadedCollectionDirectoryPath())));
            if (fm_tree_model_listener == null) {
                fm_tree_model_listener = new FMTreeModelListener();
            }
            full_collection_tree_model.addTreeModelListener(fm_tree_model_listener);
        }
        return full_collection_tree_model;
    }

    public void importCollection() {
        String[] stringArray;
        importing = true;
        if (!this.saved()) {
            DebugStream.println("CollectionManager.importCollection().forcesave");
            import_monitor.saving();
            this.saveCollection();
        }
        DebugStream.println("CollectionManager.importCollection()");
        DebugStream.println("Is event dispatch thread: " + SwingUtilities.isEventDispatchThread());
        File file = new File(CollectionManager.getLoadedCollectionIndexDirectoryPath());
        if (file.exists()) {
            DebugStream.println("Old Index = " + file.getAbsolutePath() + ", testing for deletability");
            if (!CollectionManager.canDelete(file)) {
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CollectionManager.Cannot_Delete_Index"), Dictionary.get("General.Error"), 0);
                GShellEvent gShellEvent = new GShellEvent(this, 0, 1, Dictionary.get("CollectionManager.Cannot_Delete_Index_Log"), 0);
                Gatherer.g_man.create_pane.message(gShellEvent);
                gShellEvent = new GShellEvent(this, 0, 1, "", 0);
                Gatherer.g_man.create_pane.processComplete(gShellEvent);
                importing = false;
                return;
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!Gatherer.isGsdlRemote) {
            arrayList.add(Configuration.perl_path);
            arrayList.add("-S");
        }
        if (Configuration.fedora_info != null && Configuration.fedora_info.isActive()) {
            arrayList.add(scriptPath + "g2f-import.pl");
            arrayList.add("-hostname");
            arrayList.add(Configuration.fedora_info.getHostname());
            arrayList.add("-port");
            arrayList.add(Configuration.fedora_info.getPort());
            arrayList.add("-username");
            arrayList.add(Configuration.fedora_info.getUsername());
            arrayList.add("-password");
            arrayList.add(Configuration.fedora_info.getPassword());
            arrayList.add("-protocol");
            arrayList.add(Configuration.fedora_info.getProtocol());
        } else {
            stringArray = null;
            if (CollectionDesignManager.isCompleteBuild()) {
                stringArray = "full-";
                CollectionDesignManager.setImportWasFull(true);
            } else {
                stringArray = "incremental-";
                CollectionDesignManager.setImportWasFull(false);
            }
            arrayList.add(scriptPath + (String)stringArray + "import.pl");
        }
        arrayList.add("-gli");
        arrayList.add("-language");
        arrayList.add(Configuration.getLanguage());
        if (Gatherer.GS3) {
            arrayList.add("-site");
            arrayList.add(Configuration.site_name);
        }
        if (!Gatherer.isGsdlRemote) {
            arrayList.add("-collectdir");
            arrayList.add(this.getCollectDirectory());
        }
        stringArray = CollectionManager.collection.import_options.getValues();
        for (int i = 0; i < stringArray.length; ++i) {
            System.err.println("Tacking on option: " + stringArray[i]);
            arrayList.add(stringArray[i]);
        }
        arrayList.add(collection.getGroupQualifiedName(false));
        String[] stringArray2 = arrayList.toArray(new String[0]);
        GShell gShell = new GShell(stringArray2, 1, 5, this, import_monitor, GShell.GSHELL_IMPORT);
        gShell.addGShellListener(Gatherer.g_man.create_pane);
        Gatherer.g_man.create_pane.setGShell(gShell);
        gShell.addGShellListener(Gatherer.g_man.format_pane);
        gShell.start();
        DebugStream.println("CollectionManager.importCollection().return");
        importing = false;
    }

    public void importMetadataSet(MetadataSet metadataSet) {
        File file = metadataSet.getMetadataSetFile();
        if (file.getName().equals("hidden.mds")) {
            return;
        }
        File file2 = new File(CollectionManager.getLoadedCollectionMetadataDirectoryPath(), file.getName());
        if (!file2.exists()) {
            try {
                Gatherer.f_man.getQueue().copyFile(file, file2, false);
                if (Gatherer.isGsdlRemote) {
                    Gatherer.remoteGreenstoneServer.uploadCollectionFile(collection.getGroupQualifiedName(false), file2);
                }
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
            MetadataSetManager.loadMetadataSet(file2);
        }
    }

    public void updateMetadataSet(MetadataSet metadataSet) {
        try {
            File file = metadataSet.getMetadataSetFile();
            File file2 = new File(CollectionManager.getLoadedCollectionMetadataDirectoryPath(), file.getName());
            if (Gatherer.isGsdlRemote) {
                Gatherer.remoteGreenstoneServer.uploadCollectionFile(collection.getGroupQualifiedName(false), file2);
            }
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    public boolean isImporting() {
        return importing;
    }

    public void reloadAfterConfigFileEdited() {
        CollectionManager.collection.cdm.reloadConfig();
        DebugStream.println(Dictionary.get("CollectionManager.Loading_Successful", collection.getName()));
        Gatherer.refresh(0);
    }

    public void loadCollection(String string) {
        ModalProgressPopup modalProgressPopup = new ModalProgressPopup(Dictionary.get("CollectionManager.Loading_Collection"), Dictionary.get("CollectionManager.Loading_Collection_Please_Wait"));
        modalProgressPopup.display();
        new LoadCollectionTask(string, modalProgressPopup).start();
    }

    private void loadCollectionInternal(String string) {
        Object object;
        Serializable serializable;
        DebugStream.println("Loading collection " + string + "...");
        if (!string.endsWith(".col")) {
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CollectionManager.Not_Col_File", string), Dictionary.get("General.Error"), 0);
            DebugStream.println("CollectionManager.loadCollection: Haven't been given a .col file.");
            return;
        }
        File file = new File(string);
        String string2 = "";
        File file2 = file.getParentFile();
        int n = file2.getAbsolutePath().indexOf(Gatherer.getCollectDirectoryPath());
        if (n == -1) {
            System.err.println("*** ERROR: collection directory " + file2 + " is not located in collect folder: " + Gatherer.getCollectDirectoryPath());
        } else {
            string2 = file2.getAbsolutePath().substring(n += Gatherer.getCollectDirectoryPath().length());
        }
        if (Gatherer.isGsdlRemote && Gatherer.remoteGreenstoneServer.downloadCollection(string2).equals("")) {
            return;
        }
        if (file2 == null || !file2.exists()) {
            System.err.println("CollectionManager.loadCollection: No collection directory.");
            return;
        }
        String string3 = Gatherer.GS3 ? Utility.CONFIG_GS3_FILE : Utility.CONFIG_FILE;
        File file3 = new File(file2, string3);
        if (!file3.exists()) {
            System.err.println("CollectionManager.loadCollection: No config file.");
            file2 = null;
            return;
        }
        File file4 = new File(file2, "import");
        if (!file4.exists()) {
            file4.mkdir();
        }
        boolean bl = false;
        File file5 = new File(file2, "metadata");
        if (!file5.exists()) {
            DebugStream.println("Loading non-gatherer collection...");
            bl = true;
            serializable = new WarningDialog("warning.LegacyCollection", Dictionary.get("LegacyCollection.Title"), Dictionary.get("LegacyCollection.Message"), null, true);
            if (((WarningDialog)serializable).display() == 2) {
                ((ModalDialog)serializable).dispose();
                file2 = null;
                return;
            }
            ((ModalDialog)serializable).dispose();
        }
        serializable = new File(file.getParentFile(), LOCK_FILE);
        final String string4 = string2;
        if (((File)serializable).exists()) {
            Gatherer.invokeInEDT_replacesProceedInCurrThread("CollectionManager.loadCollectionInternal() - lockfile", true, new Runnable((File)serializable){
                final /* synthetic */ File val$lock_file;
                {
                    this.val$lock_file = file;
                }

                @Override
                public void run() {
                    CollectionManager.this.lockFileDialog = new LockFileDialog(Gatherer.g_man, string4, this.val$lock_file);
                }
            });
            if (this.lockFileDialog.getChoice() != 1) {
                file2 = null;
                return;
            }
            this.lockFileDialog.dispose();
            this.lockFileDialog = null;
            ((File)serializable).delete();
        }
        if (!file.exists() && ((File)(object = new File(file2, string2 + ".col"))).exists()) {
            try {
                ((File)object).renameTo(file);
            }
            catch (Exception exception) {
                DebugStream.println("Couldn't rename " + ((File)object).getName() + " to gli.col. Will just carry on with default gli.col");
            }
        }
        try {
            this.createLockFile((File)serializable);
            if (!((File)serializable).canWrite()) {
                System.err.println("Cannot write lock file!");
                object = new String[]{string, Dictionary.get("FileActions.Write_Not_Permitted_Message", new String[]{((File)serializable).getAbsolutePath()})};
                if (Gatherer.client_operating_system.toUpperCase().indexOf("WINDOWS") != -1) {
                    Object object2 = object;
                    object2[1] = (String)object2[1] + Dictionary.get("FileActions.File_Permission_Detail", new String[]{Configuration.gsdl_path, System.getProperty("user.name")});
                }
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CollectionManager.Cannot_Open_With_Reason", (String[])object), Dictionary.get("General.Error"), 0);
                object = null;
                return;
            }
            if (CollectionManager.canDoScheduling() && file.exists()) {
                Object object3;
                object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                boolean bl2 = false;
                try {
                    object3 = new String();
                    while ((object3 = ((BufferedReader)object).readLine()) != null) {
                        if (!((String)(object3 = ((String)object3).trim())).equals("<Schedule>") && !((String)object3).equals("<Schedule/>")) continue;
                        bl2 = true;
                        break;
                    }
                    ((BufferedReader)object).close();
                }
                catch (IOException iOException) {
                    DebugStream.printStackTrace(iOException);
                }
                if (!bl2) {
                    object3 = new File(file2.getAbsolutePath() + "/tmp.col");
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), "UTF-8"));
                    object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    try {
                        String string5 = new String();
                        while ((string5 = ((BufferedReader)object).readLine()) != null) {
                            String string6 = string5.trim();
                            if (string6.startsWith("<!ELEMENT Argument")) {
                                bufferedWriter.write("  <!ELEMENT Schedule          (Arguments*)>\n");
                            } else if (string6.equals("</BuildConfig>")) {
                                bufferedWriter.write("      <Schedule/>\n");
                            }
                            bufferedWriter.write(string5 + "\n");
                        }
                        ((BufferedReader)object).close();
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        DebugStream.printStackTrace(iOException);
                    }
                    try {
                        file.delete();
                        ((File)object3).renameTo(file);
                    }
                    catch (Exception exception) {
                        DebugStream.printStackTrace(exception);
                    }
                }
            }
            collection = new Collection(file);
            if (CollectionManager.collection.error) {
                collection = null;
                if (((File)serializable).exists()) {
                    ((File)serializable).delete();
                }
                throw new Exception(Dictionary.get("CollectionManager.Missing_Config"));
            }
            if (CollectionManager.canDoScheduling()) {
                this.scheduling();
            }
            CollectionManager.collection.import_options.removeValue("removeold");
            CollectionManager.collection.import_options.removeValue("keepold");
            MetadataSetManager.clearMetadataSets();
            MetadataSetManager.loadMetadataSets(file5);
            this.addRequiredMetadataSets();
            ProfileXMLFileManager.loadProfileXMLFile(file5);
            if (bl) {
                this.addDefaultMetadataSets();
                LegacyCollectionImporter.backupMetadataXMLFiles(file2);
            }
            MetadataXMLFileManager.clearMetadataXMLFiles();
            MetadataXMLFileManager.loadMetadataXMLFiles(file4, collection.toSkimFile());
            DocXMLFileManager.clearDocXMLFiles();
            if (Configuration.fedora_info.isActive()) {
                object = new File(CollectionManager.getLoadedCollectionExportDirectoryPath());
                DocXMLFileManager.loadDocXMLFiles((File)object, "docmets.xml");
            } else {
                object = new File(CollectionManager.getLoadedCollectionArchivesDirectoryPath());
                DocXMLFileManager.loadDocXMLFiles((File)object, "doc.xml");
            }
            Classifiers.loadClassifiersList(string2);
            Plugins.loadPluginsList(string2);
            CollectionManager.collection.cdm = new CollectionDesignManager(file3);
            if (bl) {
                LegacyCollectionImporter.updateClassifiers(CollectionManager.collection.cdm);
            }
            DebugStream.println(Dictionary.get("CollectionManager.Loading_Successful", string2));
            Gatherer.refresh(0);
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
            exception.printStackTrace();
            if (exception.getMessage() != null) {
                String[] stringArray = new String[]{string, exception.getMessage()};
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CollectionManager.Cannot_Open_With_Reason", stringArray), Dictionary.get("General.Error"), 0);
            }
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CollectionManager.Cannot_Open", string), Dictionary.get("General.Error"), 0);
        }
        file2 = null;
    }

    public static boolean canDoScheduling() {
        if (Gatherer.isGsdlRemote) {
            return false;
        }
        if (Gatherer.GS3) {
            return false;
        }
        if (Configuration.fedora_info.isActive()) {
            return false;
        }
        File file = new File(LocalGreenstone.getDirectoryPath() + File.separator + "etc" + File.separator + "main.cfg");
        if (!file.exists()) {
            System.out.println("Cannot do scheduling, since there is no file: " + file.getAbsolutePath() + ".\nScheduling presently depends on GLI running from inside a GS2.");
            return false;
        }
        return true;
    }

    private void makeCollection(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!Gatherer.isGsdlRemote) {
            arrayList.add(Configuration.perl_path);
            arrayList.add("-S");
        }
        arrayList.add(scriptPath + "mkcol.pl");
        if (Gatherer.GS3) {
            arrayList.add("-gs3mode");
            arrayList.add("-site");
            arrayList.add(Configuration.site_name);
        }
        if (!Gatherer.isGsdlRemote) {
            arrayList.add("-collectdir");
            arrayList.add(this.getDefaultCollectDirectory());
        }
        if (string2 != null && !string2.equals("")) {
            arrayList.add("-creator");
            arrayList.add(string2);
        }
        arrayList.add(string);
        String[] stringArray = arrayList.toArray(new String[0]);
        GShell gShell = new GShell(stringArray, 2, 3, this, null, GShell.GSHELL_NEW);
        gShell.run();
    }

    @Override
    public synchronized void message(GShellEvent gShellEvent) {
    }

    @Override
    public void metadataChanged(CollectionTreeNode[] collectionTreeNodeArray) {
        if (collection != null) {
            collection.setMetadataChanged(true);
            if (FilenameEncoding.isRefreshRequired()) {
                TreePath[] treePathArray = collection_tree.getSelectionPaths();
                if (treePathArray != null) {
                    for (int i = 0; i < treePathArray.length; ++i) {
                        collection_tree_model.refresh(treePathArray[i]);
                        collection_tree.setSelectionPath(treePathArray[i]);
                    }
                }
                FilenameEncoding.setRefreshRequired(false);
            }
        }
    }

    public void openCollectionFromLastTime() {
        this.loadCollection(Gatherer.open_collection_file_path);
    }

    @Override
    public synchronized void processBegun(GShellEvent gShellEvent) {
        DebugStream.println("CollectionManager.processBegun(" + gShellEvent.getType() + ")");
        Gatherer.g_man.lockCollection(gShellEvent.getType() == 1, true);
    }

    @Override
    public synchronized void processComplete(GShellEvent gShellEvent) {
        Gatherer.g_man.lockCollection(gShellEvent.getType() == 1, false);
        if (gShellEvent.getType() == 1 && gShellEvent.getStatus() == 1) {
            collection.setImported(true);
            collection.setFilesChanged(false);
            collection.setMetadataChanged(false);
            this.buildCollection();
        } else if (gShellEvent.getType() == 8 && gShellEvent.getStatus() == 1) {
            WarningDialog warningDialog = new WarningDialog("warning.ScheduleBuilt", Dictionary.get("ScheduleBuilt.Title"), Dictionary.get("ScheduleBuilt.Message"), null, false);
            warningDialog.setMessageOnly(true);
            warningDialog.display();
            warningDialog.dispose();
            warningDialog = null;
        } else if (gShellEvent.getType() == 0 && gShellEvent.getStatus() == 1) {
            if (CollectionDesignManager.buildcolWasFull()) {
                if (CollectionManager.isSolrCollection()) {
                    DebugStream.println("Solr collection build complete: building already moved to index by activate.pl.");
                } else if (this.installCollection()) {
                    if (LocalLibraryServer.isRunning()) {
                        LocalLibraryServer.addCollection(collection.getName());
                    } else if (Gatherer.GS3) {
                        Gatherer.configGS3Server(Configuration.site_name, ServletConfiguration.ADD_COMMAND + collection.getName());
                    }
                    Gatherer.refresh(2);
                    WarningDialog warningDialog = new WarningDialog("warning.CollectionBuilt", Dictionary.get("CollectionBuilt.Title"), Dictionary.get("CollectionBuilt.Message"), null, false);
                    warningDialog.setMessageOnly(true);
                    warningDialog.display();
                    warningDialog.dispose();
                    warningDialog = null;
                    CollectionDesignManager.resetRebuildTypeRequired();
                } else {
                    JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CollectionManager.Preview_Ready_Failed"), Dictionary.get("CollectionManager.Preview_Ready_Title"), 0);
                    Gatherer.refresh(2);
                    DebugStream.println("Status is ok but !installCollection()");
                }
            }
        } else if (gShellEvent.getType() == 9) {
            if (gShellEvent.getStatus() == 0) {
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("DeleteCollectionPrompt.Failed_Fedora_Delete", new String[]{delete_collection_name}), Dictionary.get("DeleteCollectionPrompt.Failed_Title"), 2);
                delete_collection_name = null;
            } else if (gShellEvent.getStatus() == 1 && delete_collection_name != null) {
                boolean bl;
                if (Gatherer.isGsdlRemote) {
                    Gatherer.remoteGreenstoneServer.deleteCollection(delete_collection_name);
                }
                if (Gatherer.GS3) {
                    Gatherer.configGS3Server(Configuration.site_name, ServletConfiguration.DEACTIVATE_COMMAND + delete_collection_name);
                }
                if (!(bl = Utility.delete(new File(CollectionManager.getCollectionDirectoryPath(delete_collection_name))))) {
                    JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("DeleteCollectionPrompt.Failed_Delete", new String[]{delete_collection_name}), Dictionary.get("DeleteCollectionPrompt.Failed_Title"), 2);
                }
                delete_collection_name = null;
            }
        } else if (gShellEvent.getStatus() == 2) {
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CollectionManager.Build_Cancelled"), Dictionary.get("General.Error"), 0);
            Gatherer.g_man.repaint();
        } else if (gShellEvent.getStatus() == 0) {
            if (gShellEvent.getType() == 2) {
                String string = gShellEvent.getMessage();
                String string2 = CollectionManager.getCollectionDirectoryPath(string);
                String string3 = "";
                if (!new File(CollectionManager.getCollectionDirectoryPath(string)).exists() || !new File(CollectionManager.getCollectionDirectoryPath(string)).canWrite()) {
                    String string4 = Dictionary.get("FileActions.Write_Not_Permitted_Message", new String[]{string2});
                    string3 = Dictionary.get("CollectionManager.Cannot_Create_Collection_With_Reason", new String[]{string4});
                    if (Gatherer.client_operating_system.toUpperCase().indexOf("WINDOWS") != -1) {
                        string3 = string3 + Dictionary.get("FileActions.File_Permission_Detail", new String[]{Configuration.gsdl_path, System.getProperty("user.name")});
                    }
                } else {
                    string3 = Dictionary.get("CollectionManager.Cannot_Create_Collection");
                }
                JOptionPane.showMessageDialog(Gatherer.g_man, string3, Dictionary.get("General.Error"), 0);
            } else if (gShellEvent.getType() == 8) {
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CollectionManager.Schedule_Failed"), Dictionary.get("CollectionManager.Schedule_Ready_Title"), 0);
            } else {
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CollectionManager.Preview_Ready_Failed"), Dictionary.get("CollectionManager.Preview_Ready_Title"), 0);
                Gatherer.refresh(2);
            }
            Gatherer.g_man.repaint();
        }
    }

    public static synchronized boolean ready() {
        return collection != null;
    }

    public void registerBuildMonitor(GShellProgressMonitor gShellProgressMonitor) {
        build_monitor = gShellProgressMonitor;
    }

    public void registerImportMonitor(GShellProgressMonitor gShellProgressMonitor) {
        import_monitor = gShellProgressMonitor;
    }

    public void registerScheduleMonitor(GShellProgressMonitor gShellProgressMonitor) {
        schedule_monitor = gShellProgressMonitor;
    }

    public static void removeCollectionContentsChangedListener(CollectionContentsChangedListener collectionContentsChangedListener) {
        collection_contents_changed_listeners.remove(collectionContentsChangedListener);
    }

    public void removeMetadataSet(MetadataSet metadataSet) {
        DebugStream.println("Removing metadata set...");
        File file = metadataSet.getMetadataSetFile();
        if (file.getName().equals("ex.mds")) {
            return;
        }
        if (file.exists()) {
            file.delete();
            MetadataSetManager.unloadMetadataSet(metadataSet);
            if (Gatherer.isGsdlRemote) {
                Gatherer.remoteGreenstoneServer.deleteCollectionFile(collection.getGroupQualifiedName(false), file);
            }
        }
    }

    public boolean saved() {
        boolean bl = true;
        if (collection != null) {
            bl = collection.getSaved();
        }
        return bl;
    }

    public void saveCollection() {
        if (collection == null) {
            return;
        }
        DebugStream.println("Saving collection " + collection.getName() + "...");
        Gatherer.g_man.wait(true);
        File file = new File(CollectionManager.getLoadedCollectionColFilePath());
        if (file.exists()) {
            File file2 = new File(file.getAbsolutePath() + "~");
            if (!file.renameTo(file2)) {
                DebugStream.println("Error in CollectionManager.saveCollection(): could not create backup file.");
            }
            file2.deleteOnExit();
        }
        collection.save();
        CollectionManager.collection.cdm.save();
        Gatherer.g_man.wait(false);
    }

    private void addDefaultMetadataSets() {
        File file;
        File file2 = new File(Gatherer.getGLIMetadataDirectoryPath() + "dublin.mds");
        if (file2.exists()) {
            this.importMetadataSet(new MetadataSet(file2));
        }
        if ((file = new File(Gatherer.getGLIMetadataDirectoryPath() + "greenstone.mds")).exists()) {
            this.importMetadataSet(new MetadataSet(file));
        }
    }

    private void addRequiredMetadataSets() {
        File file = new File(Gatherer.getGLIMetadataDirectoryPath() + "ex" + ".mds");
        this.importMetadataSet(new MetadataSet(file));
    }

    private String getDefaultCollectDirectory() {
        String string = Gatherer.getCollectDirectoryPath();
        if (string.length() > 2 && string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private String getCollectDirectory() {
        String string = Gatherer.getCollectDirectoryPath();
        return string.substring(0, string.length() - 1);
    }

    public static String getBuildType() {
        String string = new CollectionMeta(CollectionDesignManager.collect_config.getBuildType()).getValue(true);
        return string;
    }

    public static boolean isSolrCollection() {
        return Gatherer.GS3 && CollectionManager.getBuildType().equals("solr");
    }

    private boolean installCollection() {
        if (Configuration.fedora_info.isActive()) {
            DebugStream.println("Fedora build complete. No need to move files.");
            return true;
        }
        DebugStream.println("Build complete. Moving files.");
        try {
            if (LocalLibraryServer.isRunning()) {
                LocalLibraryServer.releaseCollection(CollectionManager.getLoadedCollectionName(true));
            }
            if (Gatherer.GS3 && !Gatherer.isGsdlRemote) {
                Gatherer.configGS3Server(Configuration.site_name, ServletConfiguration.DEACTIVATE_COMMAND + collection.getName());
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CollectionManager.Install_Exception", exception.getMessage()), "Error", 0);
            return false;
        }
        return true;
    }

    private void moveContentsInto(File file, File file2) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file3 = fileArray[i];
            File file4 = new File(file2, file3.getName());
            if (file3.isDirectory()) {
                this.moveContentsInto(file3, file4);
                file3.delete();
                continue;
            }
            if (file4.exists()) {
                file4.delete();
            }
            file3.renameTo(file4);
        }
    }

    private void updateCollectionConfigXML(File file, File file2) {
        Object object;
        String string;
        Element element;
        int n;
        NodeList nodeList;
        Element element2;
        int n2;
        Document document = XMLTools.parseXMLFile(file);
        XMLTools.writeXMLFile(file2, document);
        Document document2 = XMLTools.parseXMLFile(file2);
        Element element3 = document2.getDocumentElement();
        Node node = XMLTools.getChildByTagNameIndexed(element3, "browse", 0);
        NodeList nodeList2 = ((Element)node).getElementsByTagName("classifier");
        int n3 = nodeList2.getLength();
        if (n3 < 1) {
            return;
        }
        Object object2 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (n2 = 0; n2 < n3; ++n2) {
            element2 = (Element)nodeList2.item(n2);
            nodeList = element2.getElementsByTagName("option");
            for (n = 0; n < nodeList.getLength(); ++n) {
                String string5;
                element = (Element)nodeList.item(n);
                string = element.getAttribute("name");
                object = element.getAttribute("value");
                if (string == null || string.equals("")) continue;
                if (string != null && object == null) {
                    object = "";
                }
                if (string.equals("hfile")) {
                    string2 = object;
                    continue;
                }
                if (string.equals("metadata") && object != null) {
                    string5 = ProfileXMLFileManager.getMetadataElementFor((String)object);
                    if (string5 == null || string5.equals("")) continue;
                    string3 = string5;
                    continue;
                }
                if (string.equals("sort") && object != null) {
                    string5 = ProfileXMLFileManager.getMetadataElementFor((String)object);
                    if (string5 == null || string5.equals("")) continue;
                    string4 = string5;
                    continue;
                }
                if (!string.equals("buttonname") || object == null) continue;
                object2 = object;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            element2 = (Element)nodeList2.item(n2);
            nodeList = element2.getElementsByTagName("option");
            for (n = 0; n < nodeList.getLength(); ++n) {
                element = (Element)nodeList.item(n);
                string = element.getAttribute("name");
                if (string.equals("metadata") && string3 != null) {
                    element.setAttribute("value", string3);
                    continue;
                }
                if (string.equals("hfile") && string2 != null) {
                    element.setAttribute("value", string3 + ".txt");
                    continue;
                }
                if (string.equals("sort") && string4 != null) {
                    element.setAttribute("value", string4);
                    continue;
                }
                if (!string.equals("buttonname") || object2 != "" && object2 != null) continue;
                object = document2.createElement("option");
                object.setAttribute("name", "buttonname");
                element.setAttribute("value", string3);
                element2.appendChild((Node)object);
            }
        }
    }

    private void updateCollectionCFG(File file, File file2, String string, String string2, String string3) {
        boolean bl = true;
        boolean bl2 = true;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                String string5;
                Object object;
                String string6;
                StringBuffer stringBuffer;
                Object object2;
                if (string4.length() == 0) {
                    bufferedWriter.newLine();
                    continue;
                }
                while (string4.trim().endsWith("\\")) {
                    string4 = string4.substring(0, string4.lastIndexOf("\\"));
                    object2 = bufferedReader.readLine();
                    if (object2 == null) continue;
                    string4 = string4 + (String)object2;
                }
                object2 = new CommandTokenizer(string4, bufferedReader, false);
                String string7 = ((CommandTokenizer)object2).nextToken().toLowerCase();
                if (string7.equals("collectionmeta")) {
                    stringBuffer = new StringBuffer(string7);
                    string6 = ((CommandTokenizer)object2).nextToken();
                    stringBuffer.append(' ');
                    stringBuffer.append(string6);
                    while (((CommandTokenizer)object2).hasMoreTokens()) {
                        stringBuffer.append(' ');
                        stringBuffer.append(((CommandTokenizer)object2).nextToken());
                    }
                    if (!(string6.equals("collectionname") || string6.equals("collectionextra") || string6.equals("iconcollection") || string6.equals("iconcollectionsmall"))) {
                        this.write(bufferedWriter, stringBuffer.toString());
                    }
                    stringBuffer = null;
                    continue;
                }
                if (string7.equals("classify")) {
                    stringBuffer = new StringBuffer(string7);
                    string6 = null;
                    object = null;
                    Object object3 = null;
                    String string8 = null;
                    while (((CommandTokenizer)object2).hasMoreTokens()) {
                        String string9;
                        String string10;
                        string5 = ((CommandTokenizer)object2).nextToken();
                        if (string5.equals("-hfile")) {
                            if (((CommandTokenizer)object2).hasMoreTokens()) {
                                stringBuffer.append(" ");
                                stringBuffer.append(string5);
                                string5 = ((CommandTokenizer)object2).nextToken();
                                object = string5;
                            }
                        } else if (string5.equals("-metadata")) {
                            if (((CommandTokenizer)object2).hasMoreTokens()) {
                                stringBuffer.append(" ");
                                stringBuffer.append(string5);
                                string10 = ((CommandTokenizer)object2).nextToken();
                                string9 = ProfileXMLFileManager.getMetadataElementFor(string10);
                                if (string9 != null && !string9.equals("")) {
                                    string5 = string9;
                                    string8 = string10;
                                    object3 = string9;
                                } else {
                                    string5 = string10;
                                }
                                string10 = null;
                                string9 = null;
                            }
                        } else if (string5.equals("-sort")) {
                            if (((CommandTokenizer)object2).hasMoreTokens()) {
                                stringBuffer.append(" ");
                                stringBuffer.append(string5);
                                string10 = ((CommandTokenizer)object2).nextToken();
                                string9 = ProfileXMLFileManager.getMetadataElementFor(string10);
                                string5 = string9 != null && !string9.equals("") ? string9 : string10;
                                string10 = null;
                                string9 = null;
                            }
                        } else if (string5.equals("-buttonname")) {
                            string6 = string5;
                        }
                        stringBuffer.append(' ');
                        stringBuffer.append(string5);
                        string5 = null;
                    }
                    if (string8 != null && object3 != null && string6 == null) {
                        stringBuffer.append(' ');
                        stringBuffer.append("-buttonname");
                        stringBuffer.append(' ');
                        stringBuffer.append(string8);
                    }
                    string4 = stringBuffer.toString();
                    if (object != null && object3 != null) {
                        string4 = string4.replaceAll((String)object, object3 + ".txt");
                    }
                    string6 = null;
                    object = null;
                    object3 = null;
                    string8 = null;
                    this.write(bufferedWriter, string4);
                } else {
                    stringBuffer = new StringBuffer(string7);
                    while (((CommandTokenizer)object2).hasMoreTokens()) {
                        stringBuffer.append(' ');
                        stringBuffer.append(((CommandTokenizer)object2).nextToken());
                    }
                    string4 = stringBuffer.toString();
                    boolean bl3 = string7.equals("format");
                    object = ProfileXMLFileManager.getMetadataMapping();
                    if (object != null) {
                        for (String string8 : ((HashMap)object).keySet()) {
                            string5 = (String)((HashMap)object).get(string8);
                            if (string5 == null || string5.equals("")) continue;
                            if (bl3) {
                                string8 = "\\[" + string8 + "\\]";
                                string5 = "{Or}{[" + string5 + "]," + string8 + "}";
                            }
                            string4 = string4.replaceAll(string8, string5);
                        }
                    }
                    this.write(bufferedWriter, string4);
                }
                object2 = null;
            }
            bufferedReader.close();
            bufferedReader = null;
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedWriter = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    private void write(BufferedWriter bufferedWriter, String string) throws Exception {
        bufferedWriter.write(string, 0, string.length());
        bufferedWriter.newLine();
    }

    private class FMTreeModelListener
    implements TreeModelListener {
        private FMTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            if (collection != null) {
                collection.setSaved(false);
                collection.setFilesChanged(true);
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            if (collection != null) {
                collection.setSaved(false);
                collection.setFilesChanged(true);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            if (collection != null) {
                collection.setSaved(false);
                collection.setFilesChanged(true);
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (collection != null) {
                collection.setSaved(false);
            }
        }
    }

    private class LoadCollectionTask
    extends Thread {
        private String collection_file_path = null;
        private ModalProgressPopup load_collection_progress_popup = null;

        public LoadCollectionTask(String string, ModalProgressPopup modalProgressPopup) {
            this.collection_file_path = string;
            this.load_collection_progress_popup = modalProgressPopup;
        }

        @Override
        public void run() {
            CollectionManager.this.loadCollectionInternal(this.collection_file_path);
            this.load_collection_progress_popup.close();
            Gatherer.setMenuBarEnabled(true);
        }
    }

    private class CreateCollectionTask
    extends Thread {
        private String description = null;
        private String email = null;
        private String name = null;
        private String title = null;
        private File base_collection_directory = null;
        private ArrayList metadata_sets = null;
        private ModalProgressPopup create_collection_progress_popup = null;

        public CreateCollectionTask(String string, String string2, String string3, String string4, File file, ArrayList arrayList, ModalProgressPopup modalProgressPopup) {
            this.description = string;
            this.email = string2;
            this.name = string3;
            this.title = string4;
            this.base_collection_directory = file;
            this.metadata_sets = arrayList;
            this.create_collection_progress_popup = modalProgressPopup;
        }

        @Override
        public void run() {
            CollectionManager.this.createCollectionInternal(this.description, this.email, this.name, this.title, this.base_collection_directory, this.metadata_sets);
            this.create_collection_progress_popup.close();
        }
    }
}

