/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.download;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.download.Download;
import org.greenstone.gatherer.download.DownloadProgressBar;
import org.greenstone.gatherer.download.DownloadScrollPane;
import org.greenstone.gatherer.greenstone.LocalGreenstone;
import org.greenstone.gatherer.util.AppendLineOnlyFileDocument;
import org.greenstone.gatherer.util.SafeProcess;
import org.greenstone.gatherer.util.Utility;

public class DownloadJob
implements ActionListener,
SafeProcess.MainProcessHandler {
    private AppendLineOnlyFileDocument download_log;
    private DownloadProgressBar progress;
    private int previous_state;
    private int state;
    private SafeProcess prcs = null;
    private final String download_url;
    private boolean wasClosed = false;
    private final String proxy_pass;
    private final String proxy_user;
    private Download download;
    private DownloadScrollPane mummy;
    private HashMap download_option;
    public static final int COMPLETE = 0;
    public static final int PAUSED = 1;
    public static final int RUNNING = 2;
    public static final int STOPPED = 3;
    public static final int UNKNOWN_MAX = 0;
    public static final int DEFINED_MAX = 1;
    public static final int UNDEFINED_MAX = 2;
    private static final int PORT_BASE = 50000;
    private static final int PORT_BLOCK_SIZE = 100;
    private static int nextFreePort = 50000;
    int port;
    private final String mode;
    private Properties proxy_urls;

    public DownloadJob(Download download, String string, String string2, DownloadScrollPane downloadScrollPane, String string3, Properties properties) {
        Comparable comparable;
        Object object;
        Object var7_7 = null;
        this.proxy_urls = properties;
        this.download_option = this.downloadToHashMap(download);
        if (!string3.equals("Z3950") && !string3.equals("SRW")) {
            object = (Argument)this.download_option.get("url");
            this.download_url = ((Argument)object).getValue();
        } else {
            object = (Argument)this.download_option.get("host");
            comparable = (Argument)this.download_option.get("port");
            this.download_url = ((Argument)object).getValue() + ":" + ((Argument)comparable).getValue();
        }
        int n = this.download_url.hashCode();
        object = Utility.getLogDir(null) + "download-" + string3 + n + ".log";
        comparable = new File((String)object);
        if (((File)comparable).exists()) {
            ((File)comparable).delete();
        }
        File file = ((File)comparable).getParentFile();
        file.mkdirs();
        file = null;
        comparable = null;
        this.download_log = new AppendLineOnlyFileDocument((String)object, false);
        this.proxy_pass = string;
        this.proxy_user = string2;
        this.mummy = downloadScrollPane;
        this.mode = string3;
        this.download = download;
        this.progress = new DownloadProgressBar(this, this.download_url, true);
        this.previous_state = 3;
        this.state = 3;
    }

    private HashMap downloadToHashMap(Download download) {
        HashMap<String, Argument> hashMap = new HashMap<String, Argument>();
        ArrayList arrayList = download.getArguments(true, false);
        for (int i = 0; i < arrayList.size(); ++i) {
            Argument argument = (Argument)arrayList.get(i);
            hashMap.put(argument.getName(), argument);
        }
        return hashMap;
    }

    public void old_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.progress.stop_start_button) {
            this.previous_state = this.state;
            if (this.state == 2) {
                this.state = 3;
            } else {
                this.state = 2;
                this.mummy.resumeThread();
            }
        } else if (actionEvent.getSource() == this.progress.close_button) {
            if (this.state == 2) {
                this.previous_state = this.state;
                this.state = 3;
            }
            this.mummy.deleteDownloadJob(this);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.progress.stop_start_button) {
            this.previous_state = this.getState();
            if (this.getState() == 2) {
                this.stopDownload();
            } else {
                this.setState(2);
                this.mummy.resumeThread();
            }
        } else if (actionEvent.getSource() == this.progress.close_button) {
            this.setClosed();
            SafeProcess.log("@@@ Progress bar close button pressed");
            if (this.getState() == 2) {
                this.previous_state = this.getState();
                this.stopDownload();
            }
            this.mummy.deleteDownloadJob(this);
        }
    }

    public static boolean isPortAvailable(int n) {
        Socket socket = null;
        try {
            socket = new Socket("localhost", n);
            socket.close();
            return false;
        }
        catch (ConnectException connectException) {
            System.err.println("Port " + n + " not yet in use.");
            socket = null;
            return true;
        }
        catch (Exception exception) {
            socket = null;
            return false;
        }
    }

    private void incrementNextFreePort() {
        int n = nextFreePort - 50000;
        n = (n + 1) % 100;
        nextFreePort = 50000 + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void old_callDownload() {
        block44: {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(Configuration.perl_path);
            arrayList.add("-S");
            arrayList.add(LocalGreenstone.getBinScriptDirectoryPath() + "downloadfrom.pl");
            arrayList.add("-download_mode");
            arrayList.add(this.mode);
            arrayList.add("-cache_dir");
            arrayList.add(Gatherer.getGLIUserCacheDirectoryPath());
            arrayList.add("-gli");
            ArrayList arrayList2 = this.download.getArguments(true, false);
            for (int i = 0; i < arrayList2.size(); ++i) {
                object = (Argument)arrayList2.get(i);
                if (!((Argument)object).isAssigned()) continue;
                arrayList.add("-" + ((Argument)object).getName());
                if (((Argument)object).getType() == 1) continue;
                arrayList.add(((Argument)object).getValue());
            }
            String[] stringArray = arrayList.toArray(new String[0]);
            DebugStream.println("Download job, " + arrayList);
            if (this.previous_state == 0) {
                this.progress.mirrorBegun(true, true);
            } else {
                this.progress.mirrorBegun(false, true);
            }
            try {
                Object object2;
                Object object3;
                Object object4;
                object = Runtime.getRuntime();
                String[] stringArray2 = null;
                Process process = null;
                if (this.proxy_urls.size() != 0) {
                    stringArray2 = new String[4 + this.proxy_urls.size()];
                    stringArray2[0] = "GSDLHOME=" + Configuration.gsdl_path;
                    stringArray2[1] = "GSDLOS=" + Gatherer.client_operating_system;
                    stringArray2[2] = "GSWGETRC=" + System.getenv("GSWGETRC");
                    stringArray2[3] = "PATH=" + System.getenv("PATH");
                    int n = 4;
                    object4 = this.proxy_urls.getProperty("HTTP");
                    if (object4 != null) {
                        stringArray2[n] = "http_proxy=" + (String)object4;
                        ++n;
                    }
                    if ((object4 = this.proxy_urls.getProperty("HTTPS")) != null) {
                        stringArray2[n] = "https_proxy=" + (String)object4;
                        ++n;
                    }
                    if ((object4 = this.proxy_urls.getProperty("FTP")) != null) {
                        stringArray2[n] = "ftp_proxy=" + (String)object4;
                        ++n;
                    }
                    process = ((Runtime)object).exec(stringArray, stringArray2);
                } else if (Gatherer.isGsdlRemote && Gatherer.isDownloadEnabled && !Utility.isWindows()) {
                    stringArray2 = new String[]{"GSDLHOME=" + Configuration.gsdl_path, "GSDLOS=" + Gatherer.client_operating_system, "GSWGETRC=" + System.getenv("GSWGETRC")};
                    process = ((Runtime)object).exec(stringArray, stringArray2);
                } else {
                    process = ((Runtime)object).exec(stringArray);
                }
                InputStream inputStream = process.getInputStream();
                object4 = new BufferedReader(new InputStreamReader(inputStream));
                if (this.mode.equals("Web") || this.mode.equals("MediaWiki")) {
                    try {
                        boolean bl = false;
                        for (int i = 0; i < 100; ++i) {
                            if (DownloadJob.isPortAvailable(nextFreePort)) {
                                bl = true;
                                break;
                            }
                            this.incrementNextFreePort();
                        }
                        if (!bl) {
                            throw new Exception("Cannot find an available port in the range 50000-50100\nwhich is necessary for forcibly terminating wget.");
                        }
                        this.port = nextFreePort;
                        this.incrementNextFreePort();
                        object3 = process.getOutputStream();
                        String string = "" + this.port + "\n";
                        System.err.println("Portnumber found: " + string);
                        ((OutputStream)object3).write(string.getBytes());
                        ((OutputStream)object3).close();
                    }
                    catch (Exception exception) {
                        System.err.println("Sent available portnumber " + this.port + " to process' outputstream.\nBut got exception: " + exception);
                    }
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                object3 = "";
                boolean bl = false;
                int n = 0;
                while ((object3 = bufferedReader.readLine()) != null && !((String)object3).trim().equals("<<Finished>>") && this.state != 3) {
                    String string;
                    if (n == 0) {
                        if (((String)object3).lastIndexOf("<<Defined Maximum>>") != -1) {
                            n = 1;
                            continue;
                        }
                        if (((String)object3).lastIndexOf("<<Undefined Maximum>>") == -1) continue;
                        n = 2;
                        continue;
                    }
                    if (n == 2) {
                        DebugStream.println((String)object3);
                        this.download_log.appendLine((String)object3);
                        if (((String)object3).lastIndexOf("robots.txt;") != -1) {
                            DebugStream.println("***** Requesting robot.txt");
                            bl = true;
                            continue;
                        }
                        if (((String)object3).lastIndexOf("=> `") != -1) {
                            if (bl) continue;
                            string = ((String)object3).substring(((String)object3).indexOf("`") + 1, ((String)object3).lastIndexOf("'"));
                            this.progress.addDownload("file");
                            continue;
                        }
                        if (((String)object3).lastIndexOf("/s) - `") != -1) {
                            string = ((String)object3).substring(((String)object3).indexOf("`") + 1, ((String)object3).lastIndexOf("'"));
                            if (!bl) {
                                DebugStream.println("Not ignore for robots");
                                this.downloadComplete(string);
                                continue;
                            }
                            DebugStream.println("Ignore for robots");
                            bl = false;
                            continue;
                        }
                        if (((String)object3).lastIndexOf(" `") != -1) {
                            DebugStream.println("Already there.");
                            string = ((String)object3).substring(((String)object3).indexOf("`") + 1, ((String)object3).lastIndexOf("'"));
                            this.progress.addDownload("file");
                            this.downloadWarning();
                            continue;
                        }
                        if (((String)object3).length() <= 7 || ((String)object3).charAt(2) != ':' || ((String)object3).charAt(5) != ':') continue;
                        if (!bl) {
                            DebugStream.println("Error.");
                            this.downloadFailed();
                            continue;
                        }
                        bl = false;
                        continue;
                    }
                    if (n == 1) {
                        if (((String)object3).lastIndexOf("<<Total number of record(s):") != -1) {
                            string = ((String)object3).substring(((String)object3).indexOf(":") + 1, ((String)object3).indexOf(">"));
                            this.progress.setTotalDownload(Integer.valueOf(string));
                            this.progress.resetFileCount();
                            this.progress.addDownload("files");
                        } else if (((String)object3).lastIndexOf("<<Done>>") != -1) {
                            this.progress.increaseFileCount();
                        } else if (((String)object3).lastIndexOf("<<Done:") != -1) {
                            string = ((String)object3).substring(((String)object3).indexOf(":") + 1, ((String)object3).indexOf(">"));
                            this.progress.increaseFileCount(Integer.valueOf(string));
                        }
                        DebugStream.println((String)object3);
                        this.download_log.appendLine((String)object3);
                        continue;
                    }
                    System.out.println("Error!!");
                    System.exit(-1);
                }
                if (this.state != 3) break block44;
                boolean bl2 = true;
                if (process != null && (this.mode.equals("Web") || this.mode.equals("MediaWiki")) && (object2 = null) == null) {
                    try {
                        object2 = new Socket("localhost", this.port);
                        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(((Socket)object2).getInputStream()));
                        String string = bufferedReader2.readLine();
                        System.err.println("Communicating with perl download script on port " + this.port + "\nGot response from perl: " + string);
                        OutputStream outputStream = ((Socket)object2).getOutputStream();
                        String string2 = "<<STOP>>\n";
                        outputStream.write(string2.getBytes());
                        string = bufferedReader2.readLine();
                        System.err.println("GLI sent STOP signal to perl to terminate wget.\nGot response from perl: " + string);
                        string = bufferedReader2.readLine();
                        System.err.println("Got another response from perl: " + string);
                        outputStream.close();
                        bufferedReader2.close();
                        ((Socket)object2).close();
                        bufferedReader2 = null;
                        object2 = null;
                        if (string == null) {
                            bl2 = false;
                        }
                    }
                    catch (IOException iOException) {
                        System.err.println("Tried to communicate through client socket - port " + this.port + ", but got exception: " + iOException);
                    }
                    catch (Exception exception) {
                        System.err.println("Tried to open client socket, but got exception: " + exception);
                    }
                }
                process.getErrorStream().close();
                bufferedReader.close();
                bufferedReader = null;
                if (bl2) {
                    process.destroy();
                    process = null;
                }
                object2 = this;
                synchronized (object2) {
                    this.notify();
                }
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
        }
        if (this.state == 2) {
            this.progress.mirrorComplete();
            this.previous_state = this.state;
            this.state = 0;
        }
        Gatherer.g_man.refreshWorkspaceTree(11);
    }

    public void callDownload() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Configuration.perl_path);
        arrayList.add("-S");
        arrayList.add(LocalGreenstone.getBinScriptDirectoryPath() + "downloadfrom.pl");
        arrayList.add("-download_mode");
        arrayList.add(this.mode);
        arrayList.add("-cache_dir");
        arrayList.add(Gatherer.getGLIUserCacheDirectoryPath());
        arrayList.add("-gli");
        ArrayList arrayList2 = this.download.getArguments(true, false);
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = (Argument)arrayList2.get(i);
            if (!((Argument)object).isAssigned()) continue;
            arrayList.add("-" + ((Argument)object).getName());
            if (((Argument)object).getType() == 1) continue;
            arrayList.add(((Argument)object).getValue());
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        DebugStream.println("Download job, " + arrayList);
        if (this.previous_state == 0) {
            this.progress.mirrorBegun(true, true);
        } else {
            this.progress.mirrorBegun(false, true);
        }
        try {
            Object object2;
            int n;
            object = Runtime.getRuntime();
            String[] stringArray2 = null;
            if (this.proxy_urls.size() != 0) {
                stringArray2 = new String[4 + this.proxy_urls.size()];
                stringArray2[0] = "GSDLHOME=" + Configuration.gsdl_path;
                stringArray2[1] = "GSDLOS=" + Gatherer.client_operating_system;
                stringArray2[2] = "GSWGETRC=" + System.getenv("GSWGETRC");
                stringArray2[3] = "PATH=" + System.getenv("PATH");
                n = 4;
                object2 = this.proxy_urls.getProperty("HTTP");
                if (object2 != null) {
                    stringArray2[n] = "http_proxy=" + (String)object2;
                    ++n;
                }
                if ((object2 = this.proxy_urls.getProperty("HTTPS")) != null) {
                    stringArray2[n] = "https_proxy=" + (String)object2;
                    ++n;
                }
                if ((object2 = this.proxy_urls.getProperty("FTP")) != null) {
                    stringArray2[n] = "ftp_proxy=" + (String)object2;
                    ++n;
                }
                this.prcs = new SafeProcess(stringArray, stringArray2, null);
            } else if (Gatherer.isGsdlRemote && Gatherer.isDownloadEnabled && !Utility.isWindows()) {
                stringArray2 = new String[]{"GSDLHOME=" + Configuration.gsdl_path, "GSDLOS=" + Gatherer.client_operating_system, "GSWGETRC=" + System.getenv("GSWGETRC")};
                this.prcs = new SafeProcess(stringArray, stringArray2, null);
            } else {
                this.prcs = new SafeProcess(stringArray);
            }
            this.prcs.setMainHandler(this);
            if (this.mode.equals("Web") || this.mode.equals("MediaWiki")) {
                try {
                    n = 0;
                    for (int i = 0; i < 100; ++i) {
                        if (DownloadJob.isPortAvailable(nextFreePort)) {
                            n = 1;
                            break;
                        }
                        this.incrementNextFreePort();
                    }
                    if (n == 0) {
                        throw new Exception("Cannot find an available port in the range 50000-50100\nwhich is necessary for forcibly terminating wget.");
                    }
                    this.port = nextFreePort;
                    this.incrementNextFreePort();
                    object2 = "" + this.port + "\n";
                    System.err.println("Portnumber found: " + (String)object2);
                    this.prcs.setInputString((String)object2);
                }
                catch (Exception exception) {
                    System.err.println("Sent available portnumber " + this.port + " to process' outputstream.\nBut got exception: " + exception);
                }
            }
            ProcessErrHandler processErrHandler = new ProcessErrHandler();
            object2 = new ProcessOutHandler();
            int n2 = this.prcs.runProcess(null, (SafeProcess.CustomProcessHandler)object2, processErrHandler);
        }
        catch (Exception exception) {
            SafeProcess.log(exception);
            DebugStream.printStackTrace(exception);
        }
        this.prcs = null;
        if (this.getState() == 2) {
            this.progress.mirrorComplete();
            this.previous_state = this.getState();
            this.setState(0);
        }
        SafeProcess.log("@@@@ DONE callDownload()");
        Gatherer.g_man.refreshWorkspaceTree(11);
    }

    private synchronized boolean isStopped() {
        return this.state == 3;
    }

    public void stopDownload() {
        if (this.prcs != null) {
            SafeProcess.log("@@@ Going to cancel the SafeProcess...");
            boolean bl = this.prcs.cancelRunningProcess();
        } else {
            System.err.println("@@@@ No SafeProcess to cancel");
        }
    }

    @Override
    public void beforeProcessDestroy() {
    }

    @Override
    public void afterProcessDestroy() {
    }

    @Override
    public boolean afterStreamsEnded(boolean bl) {
        return bl;
    }

    @Override
    public void doneCleanup(boolean bl) {
        this.progress.enableCancelJob(true);
        if (bl) {
            this.setState(3);
            if (this.wasClosed()) {
                this.mummy.deleteCurrentDownloadJob(this);
            }
        }
    }

    @Override
    public boolean beforeWaitingForStreamsToEnd(boolean bl) {
        this.progress.enableCancelJob(false);
        SafeProcess.log("**** in beforeWaitingForStreamsToEnd()");
        if (!bl) {
            SafeProcess.log("*** Process not (yet) cancelled/state not (yet) stopped");
            SafeProcess.log("*** But process has naturally terminated (process streams are being closed before any interruption signal can be received), so won't be destroying process even on interrupt");
            return false;
        }
        return this.tellPerlToTerminateWget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean tellPerlToTerminateWget() {
        SafeProcess.log("**** in tellPerlToTerminateWget()");
        boolean bl = true;
        if (this.mode.equals("Web") || this.mode.equals("MediaWiki")) {
            SafeProcess.log("@@@ Socket communication to end wget");
            Socket socket = null;
            BufferedReader bufferedReader = null;
            OutputStream outputStream = null;
            if (socket == null) {
                block9: {
                    try {
                        socket = new Socket("localhost", this.port);
                        bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        String string = bufferedReader.readLine();
                        System.err.println("Communicating with perl download script on port " + this.port + "\nGot response from perl: " + string);
                        outputStream = socket.getOutputStream();
                        String string2 = "<<STOP>>\n";
                        outputStream.write(string2.getBytes());
                        string = bufferedReader.readLine();
                        System.err.println("GLI sent STOP signal to perl to terminate wget.\nGot response from perl: " + string);
                        string = bufferedReader.readLine();
                        System.err.println("Got another response from perl: " + string);
                        if (string != null) break block9;
                        bl = false;
                    }
                    catch (IOException iOException) {
                        block10: {
                            if (iOException instanceof IOException && iOException.getMessage().indexOf("Connection refused") != -1) {
                                bl = false;
                                System.err.println("Tried to communicate through client socket - port " + this.port + ", but the process seems to have already ended naturally");
                                break block10;
                            }
                            System.err.println("Tried to communicate through client socket - port " + this.port + ", but got exception: " + iOException);
                        }
                        SafeProcess.closeResource(outputStream);
                        SafeProcess.closeResource(bufferedReader);
                        SafeProcess.closeSocket(socket);
                        outputStream = null;
                        bufferedReader = null;
                        socket = null;
                    }
                    catch (Exception exception) {
                        System.err.println("Tried to open client socket, but got exception: " + exception);
                        {
                            catch (Throwable throwable) {
                                SafeProcess.closeResource(outputStream);
                                SafeProcess.closeResource(bufferedReader);
                                SafeProcess.closeSocket(socket);
                                outputStream = null;
                                bufferedReader = null;
                                socket = null;
                                throw throwable;
                            }
                        }
                        SafeProcess.closeResource(outputStream);
                        SafeProcess.closeResource(bufferedReader);
                        SafeProcess.closeSocket(socket);
                        outputStream = null;
                        bufferedReader = null;
                        socket = null;
                    }
                }
                SafeProcess.closeResource(outputStream);
                SafeProcess.closeResource(bufferedReader);
                SafeProcess.closeSocket(socket);
                outputStream = null;
                bufferedReader = null;
                socket = null;
            }
        }
        return bl;
    }

    public void downloadComplete() {
        this.progress.downloadComplete();
    }

    public void downloadComplete(String string) {
        this.progress.downloadComplete();
        DebugStream.println("Download complete: " + string);
    }

    public void downloadFailed() {
        this.progress.downloadFailed();
    }

    public void downloadWarning() {
        this.progress.downloadWarning();
    }

    public AppendLineOnlyFileDocument getLogDocument() {
        return this.download_log;
    }

    public DownloadProgressBar getProgressBar() {
        return this.progress;
    }

    public synchronized int getState() {
        return this.state;
    }

    private synchronized boolean wasClosed() {
        return this.wasClosed;
    }

    public synchronized boolean hasSignalledStop() {
        return this.state == 3 || this.state == 1 || this.state == 0;
    }

    public synchronized void setState(int n) {
        this.previous_state = this.state;
        this.state = n;
    }

    private synchronized void setClosed() {
        this.wasClosed = true;
    }

    public String toString() {
        return this.download_url;
    }

    public void updateProgress(long l, long l2) {
        this.progress.updateProgress(l, l2);
    }

    private class ProcessErrHandler
    extends SafeProcess.CustomProcessHandler {
        public ProcessErrHandler() {
            super(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Closeable closeable) {
            BufferedReader bufferedReader;
            block23: {
                InputStream inputStream = (InputStream)closeable;
                bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    String string = "";
                    boolean bl = false;
                    int n = 0;
                    DownloadProgressBar downloadProgressBar = DownloadJob.this.progress;
                    AppendLineOnlyFileDocument appendLineOnlyFileDocument = DownloadJob.this.download_log;
                    boolean bl2 = false;
                    while (!Thread.currentThread().isInterrupted() && (string = bufferedReader.readLine()) != null && !string.trim().equals("<<Finished>>")) {
                        String string2;
                        if (n == 0) {
                            if (string.lastIndexOf("<<Defined Maximum>>") != -1) {
                                n = 1;
                                continue;
                            }
                            if (string.lastIndexOf("<<Undefined Maximum>>") == -1) continue;
                            n = 2;
                            continue;
                        }
                        if (n == 2) {
                            DebugStream.println(string);
                            appendLineOnlyFileDocument.appendLine(string);
                            if (string.lastIndexOf("robots.txt;") != -1) {
                                DebugStream.println("***** Requesting robot.txt");
                                bl = true;
                                continue;
                            }
                            if (string.indexOf("--no-check-certificate") != -1) {
                                DownloadJob.this.downloadWarning();
                                bl2 = true;
                                continue;
                            }
                            if (string.lastIndexOf("=> `") != -1) {
                                if (bl) continue;
                                string2 = string.substring(string.indexOf("`") + 1, string.lastIndexOf("'"));
                                downloadProgressBar.addDownload("file");
                                continue;
                            }
                            if (string.lastIndexOf("/s) - `") != -1 || string.lastIndexOf("/s) - '") != -1) {
                                string2 = string.lastIndexOf("/s) - `") != -1 ? "`" : "'";
                                String string3 = string.substring(string.indexOf(string2) + 1, string.lastIndexOf("'"));
                                if (!bl) {
                                    DebugStream.println("Not ignore for robots");
                                    DownloadJob.this.downloadComplete(string3);
                                    continue;
                                }
                                DebugStream.println("Ignore for robots");
                                bl = false;
                                continue;
                            }
                            if (string.lastIndexOf(" `") != -1) {
                                DebugStream.println("Already there.");
                                string2 = string.substring(string.indexOf("`") + 1, string.lastIndexOf("'"));
                                downloadProgressBar.addDownload("file");
                                DownloadJob.this.downloadWarning();
                                continue;
                            }
                            if (string.length() <= 7 || string.charAt(2) != ':' || string.charAt(5) != ':') continue;
                            if (!bl) {
                                DebugStream.println("Error.");
                                DownloadJob.this.downloadFailed();
                                continue;
                            }
                            bl = false;
                            continue;
                        }
                        if (n == 1) {
                            if (string.lastIndexOf("<<Total number of record(s):") != -1) {
                                string2 = string.substring(string.indexOf(":") + 1, string.indexOf(">"));
                                downloadProgressBar.setTotalDownload(Integer.valueOf(string2));
                                downloadProgressBar.resetFileCount();
                                downloadProgressBar.addDownload("files");
                            } else if (string.lastIndexOf("<<Done>>") != -1) {
                                downloadProgressBar.increaseFileCount();
                            } else if (string.lastIndexOf("<<Done:") != -1) {
                                string2 = string.substring(string.indexOf(":") + 1, string.indexOf(">"));
                                downloadProgressBar.increaseFileCount(Integer.valueOf(string2));
                            }
                            DebugStream.println(string);
                            appendLineOnlyFileDocument.appendLine(string);
                            continue;
                        }
                        System.out.println("Error!!");
                        System.exit(-1);
                    }
                    if (bl2) {
                        appendLineOnlyFileDocument.appendLine("************");
                        appendLineOnlyFileDocument.appendLine(Dictionary.get("Mirroring.DownloadJob.Warning_No_Valid_Certificate"));
                        appendLineOnlyFileDocument.appendLine(Dictionary.get("Mirroring.DownloadJob.Enable_NoCheckCertificate"));
                        appendLineOnlyFileDocument.appendLine("************");
                    }
                    if (!Thread.currentThread().isInterrupted()) break block23;
                }
                catch (IOException iOException) {
                    block24: {
                        try {
                            DebugStream.printStackTrace(iOException);
                            if (!Thread.currentThread().isInterrupted()) break block24;
                        }
                        catch (Throwable throwable) {
                            if (Thread.currentThread().isInterrupted()) {
                                SafeProcess.log("@@@ Successfully interrupted " + Thread.currentThread().getName() + ".");
                            }
                            SafeProcess.closeResource(bufferedReader);
                            bufferedReader = null;
                            throw throwable;
                        }
                        SafeProcess.log("@@@ Successfully interrupted " + Thread.currentThread().getName() + ".");
                    }
                    SafeProcess.closeResource(bufferedReader);
                    bufferedReader = null;
                }
                SafeProcess.log("@@@ Successfully interrupted " + Thread.currentThread().getName() + ".");
            }
            SafeProcess.closeResource(bufferedReader);
            bufferedReader = null;
        }
    }

    private class ProcessOutHandler
    extends SafeProcess.CustomProcessHandler {
        public ProcessOutHandler() {
            super(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Closeable closeable) {
            BufferedReader bufferedReader;
            block8: {
                InputStream inputStream = (InputStream)closeable;
                bufferedReader = null;
                try {
                    String string = null;
                    bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    while (!Thread.currentThread().isInterrupted() && (string = bufferedReader.readLine()) != null) {
                        if (string.equals("\n")) continue;
                        System.err.println("**** Perl STDOUT: " + string);
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        System.err.println("**** Perl INTERRUPTed.");
                    } else {
                        System.err.println("**** Perl ENDed.");
                    }
                    if (!Thread.currentThread().isInterrupted()) break block8;
                }
                catch (Exception exception) {
                    block9: {
                        try {
                            System.err.println("Thread - caught exception: " + exception);
                            if (!Thread.currentThread().isInterrupted()) break block9;
                        }
                        catch (Throwable throwable) {
                            if (Thread.currentThread().isInterrupted()) {
                                SafeProcess.log("@@@ Successfully interrupted " + Thread.currentThread().getName() + ".");
                            }
                            SafeProcess.closeResource(bufferedReader);
                            bufferedReader = null;
                            throw throwable;
                        }
                        SafeProcess.log("@@@ Successfully interrupted " + Thread.currentThread().getName() + ".");
                    }
                    SafeProcess.closeResource(bufferedReader);
                    bufferedReader = null;
                }
                SafeProcess.log("@@@ Successfully interrupted " + Thread.currentThread().getName() + ".");
            }
            SafeProcess.closeResource(bufferedReader);
            bufferedReader = null;
        }
    }
}

