/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.file;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.file.WorkspaceTreeModel;
import org.greenstone.gatherer.file.WorkspaceTreeNode;
import org.greenstone.gatherer.gui.CreateShortcutPrompt;
import org.greenstone.gatherer.gui.tree.DragTree;
import org.greenstone.gatherer.util.Utility;

public class WorkspaceTree
extends DragTree
implements MouseListener {
    public static final int LIBRARY_CONTENTS_CHANGED = 10;
    public static final int DOWNLOADED_FILES_CHANGED = 11;
    public static final int FOLDER_SHORTCUTS_CHANGED = 12;
    protected int current_mode;
    protected WorkspaceTreeModel workspace_tree_model;

    public WorkspaceTree(int n) {
        super(WorkspaceTreeModel.getWorkspaceTreeModel(n), true);
        this.current_mode = n;
        this.addMouseListener(this);
        this.setBackgroundNonSelectionColor(Configuration.getColor("coloring.workspace_tree_background", false));
        this.setBackgroundSelectionColor(Configuration.getColor("coloring.workspace_selection_background", false));
        this.setTextNonSelectionColor(Configuration.getColor("coloring.workspace_tree_foreground", false));
        this.setTextSelectionColor(Configuration.getColor("coloring.workspace_selection_foreground", false));
        this.filter.setBackground(Configuration.getColor("coloring.workspace_heading_background", false));
        this.filter.setEditable(Configuration.getMode() >= 2);
        this.workspace_tree_model = (WorkspaceTreeModel)this.getModel();
    }

    public void addDirectoryMapping(String string, File file) {
        Configuration.addDirectoryMapping(string, file);
        Gatherer.g_man.refreshWorkspaceTree(12);
    }

    @Override
    public boolean isDraggable() {
        return true;
    }

    @Override
    public boolean isDroppable() {
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            new WorkspaceTreeRightClickMenu(this, mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void refresh(int n) {
        String string;
        DebugStream.println("WorkspaceTree::refresh()... ");
        if (n == 0) {
            DebugStream.println("...Reason: tree display changed.");
            this.updateUI();
        }
        if (n == 1) {
            DebugStream.println("...Reason: loaded collection changed.");
        }
        if (n == 2) {
            DebugStream.println("...Reason: collection contents changed.");
            string = CollectionManager.getLoadedCollectionImportDirectoryPath();
            this.refreshEveryNodeShowingFolder(string);
        }
        if (n == 10) {
            DebugStream.println("...Reason: library contents changed.");
            string = Gatherer.getCollectDirectoryPath();
            this.refreshEveryNodeShowingFolder(string);
            this.workspace_tree_model.refreshGreenstoneCollectionsNode();
        }
        if (n == 11) {
            DebugStream.println("...Reason: downloaded files changed.");
            this.workspace_tree_model.refreshDownloadedFilesNode();
        }
        if (n == 12) {
            DebugStream.println("...Reason: folder shortcuts changed.");
            this.workspace_tree_model.refreshFolderShortcuts();
        }
    }

    private void refreshEveryNodeShowingFolder(String string) {
        TreePath treePath = new TreePath(this.getModel().getRoot());
        Enumeration<TreePath> enumeration = this.getExpandedDescendants(treePath);
        while (enumeration.hasMoreElements()) {
            TreePath treePath2 = enumeration.nextElement();
            WorkspaceTreeNode workspaceTreeNode = (WorkspaceTreeNode)treePath2.getLastPathComponent();
            File file = workspaceTreeNode.getFile();
            if (file == null) continue;
            String string2 = file.toString();
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            if (!string2.equals(string)) continue;
            this.workspace_tree_model.refresh(treePath2);
        }
    }

    public void removeDirectoryMapping(WorkspaceTreeNode workspaceTreeNode) {
        Configuration.removeDirectoryMapping(workspaceTreeNode.toString());
        Gatherer.g_man.refreshWorkspaceTree(12);
    }

    @Override
    public String toString() {
        return "Workspace";
    }

    private class WorkspaceTreeRightClickMenu
    extends JPopupMenu
    implements ActionListener {
        private WorkspaceTree workspace_tree = null;
        private TreePath[] selection_paths = null;
        private WorkspaceTreeNode node = null;
        private JMenuItem create_shortcut = null;
        private JMenuItem delete_shortcut = null;
        private JMenuItem collapse_folder = null;
        private JMenuItem expand_folder = null;
        private JMenuItem explode_metadata_database = null;
        private JMenuItem delete = null;
        private JMenuItem metaaudit = null;
        private JMenuItem new_folder = null;
        private JMenuItem new_dummy_doc = null;
        private JMenuItem open_externally = null;
        private JMenuItem rename = null;
        private JMenuItem replace = null;
        private JMenuItem copy_collection = null;
        private JMenuItem move_collection = null;

        private WorkspaceTreeRightClickMenu(WorkspaceTree workspaceTree2, MouseEvent mouseEvent) {
            this.workspace_tree = workspaceTree2;
            TreePath treePath = workspaceTree2.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                this.selection_paths = null;
                workspaceTree2.setImmediate(true);
                workspaceTree2.clearSelection();
                workspaceTree2.setImmediate(false);
            } else {
                this.selection_paths = workspaceTree2.getSelectionPaths();
                if (this.selection_paths == null) {
                    this.selection_paths = new TreePath[1];
                    this.selection_paths[0] = treePath;
                    workspaceTree2.setImmediate(true);
                    workspaceTree2.setSelectionPath(treePath);
                    workspaceTree2.setImmediate(false);
                } else if (this.selection_paths.length == 1 && !this.selection_paths[0].equals(treePath)) {
                    workspaceTree2.setImmediate(true);
                    workspaceTree2.clearSelection();
                    workspaceTree2.setSelectionPath(treePath);
                    workspaceTree2.setImmediate(false);
                    this.selection_paths[0] = treePath;
                } else {
                    boolean bl = false;
                    for (int i = 0; i < this.selection_paths.length; ++i) {
                        if (!this.selection_paths[i].equals(treePath)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        workspaceTree2.setImmediate(true);
                        workspaceTree2.clearSelection();
                        workspaceTree2.setSelectionPath(treePath);
                        workspaceTree2.setImmediate(false);
                        this.selection_paths = new TreePath[1];
                        this.selection_paths[0] = treePath;
                    }
                }
            }
            this.buildContextMenu(this.selection_paths);
            this.show(workspaceTree2, mouseEvent.getX(), mouseEvent.getY());
        }

        private void buildContextMenu(TreePath[] treePathArray) {
            if (treePathArray == null) {
                return;
            }
            if (treePathArray.length > 1) {
                return;
            }
            TreePath treePath = treePathArray[0];
            this.node = (WorkspaceTreeNode)treePath.getLastPathComponent();
            if (this.node.isLeaf()) {
                this.open_externally = new JMenuItem(Dictionary.get("Menu.Open_Externally"), 79);
                this.open_externally.addActionListener(this);
                this.add(this.open_externally);
                return;
            }
            if (this.workspace_tree.isExpanded(treePath)) {
                this.collapse_folder = new JMenuItem(Dictionary.get("Menu.Collapse"), 67);
                this.collapse_folder.addActionListener(this);
                this.add(this.collapse_folder);
            } else {
                this.expand_folder = new JMenuItem(Dictionary.get("Menu.Expand"), 79);
                this.expand_folder.addActionListener(this);
                this.add(this.expand_folder);
            }
            if (this.workspace_tree == this.workspace_tree) {
                String string = this.node.toString();
                if (string.equals(Dictionary.get("Tree.World")) || string.equals(Dictionary.get("Tree.Root")) || string.equals(Dictionary.get("Tree.DownloadedFiles"))) {
                    return;
                }
                WorkspaceTreeNode workspaceTreeNode = (WorkspaceTreeNode)this.workspace_tree.getModel().getRoot();
                if (workspaceTreeNode.getIndex(this.node) != -1) {
                    this.delete_shortcut = new JMenuItem(Dictionary.get("MappingPrompt.Unmap"), 82);
                    this.delete_shortcut.addActionListener(this);
                    this.add(this.delete_shortcut);
                } else {
                    WorkspaceTreeNode workspaceTreeNode2 = (WorkspaceTreeNode)treePath.getPathComponent(1);
                    if (workspaceTreeNode2.toString().equals(Dictionary.get("Tree.World"))) {
                        this.copy_collection = new JMenuItem(Dictionary.get("Menu.Copy_Collection"), 80);
                        this.copy_collection.addActionListener(this);
                        this.add(this.copy_collection);
                        this.move_collection = new JMenuItem(Dictionary.get("Menu.Move_Collection"), 77);
                        this.move_collection.addActionListener(this);
                        this.add(this.move_collection);
                    }
                    this.create_shortcut = new JMenuItem(Dictionary.get("MappingPrompt.Map"), 83);
                    this.create_shortcut.addActionListener(this);
                    this.add(this.create_shortcut);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.create_shortcut) {
                if (!this.node.getFile().exists()) {
                    JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("FileActions.Folder_Does_Not_Exist"), Dictionary.get("General.Error"), 0);
                    return;
                }
                CreateShortcutPrompt createShortcutPrompt = new CreateShortcutPrompt(this.workspace_tree, this.node.getFile());
                createShortcutPrompt.destroy();
            } else if (object == this.delete_shortcut) {
                this.workspace_tree.removeDirectoryMapping(this.node);
            } else if (object == this.collapse_folder) {
                this.workspace_tree.collapsePath(this.selection_paths[0]);
            } else if (object == this.expand_folder) {
                this.workspace_tree.expandPath(this.selection_paths[0]);
            } else if (object == this.open_externally) {
                Gatherer.f_man.openFileInExternalApplication(this.node.getFile());
            } else if (object == this.move_collection || object == this.copy_collection) {
                JFileChooser jFileChooser = new JFileChooser(Gatherer.getCollectDirectoryPath());
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setDialogTitle(Dictionary.get("FileActions.ChooseDestinationDirectory"));
                int n = jFileChooser.showOpenDialog(Gatherer.g_man.gather_pane);
                if (n == 0) {
                    String string;
                    File file;
                    File file2 = this.node.getFile();
                    if (file2.getName().equals("import")) {
                        file2 = file2.getParentFile();
                    }
                    if ((file = new File((string = jFileChooser.getSelectedFile().getAbsolutePath()) + File.separator + file2.getName())).equals(file2)) {
                        JOptionPane.showMessageDialog(Gatherer.g_man, "Can't move " + file2 + " to itself\n(" + file + ").", "Source and destination directories are the same", 0);
                        return;
                    }
                    if (file.exists()) {
                        if (JOptionPane.showConfirmDialog(Gatherer.g_man, "Directory " + file + " already exists. Overwrite?", "Destination directory already exists", 0) == 1) {
                            return;
                        }
                        Utility.delete(file);
                    }
                    int n2 = object == this.move_collection ? 1 : 0;
                    Gatherer.f_man.action(file2, file, n2);
                }
            }
        }
    }
}

