/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.file;

import java.io.File;
import java.util.ArrayList;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.BasicCollectionConfiguration;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.util.ArrayTools;
import org.greenstone.gatherer.util.Utility;

public class WorkspaceTreeNode
extends FileNode {
    private boolean is_gs3_site_node = false;
    private boolean is_group_node = false;
    private boolean is_in_loaded_collection = false;
    private boolean is_in_coll_all_files_mode = false;
    private String title = null;

    public WorkspaceTreeNode(File file) {
        super(file);
    }

    public WorkspaceTreeNode(File file, String string) {
        this(file);
        this.title = string;
    }

    public WorkspaceTreeNode(File file, String string, int n) {
        this(file);
        this.title = string;
        if (n == Utility.FILES_MODE) {
            this.is_in_coll_all_files_mode = true;
        }
    }

    @Override
    public FileNode addChildNode(File file) {
        WorkspaceTreeNode workspaceTreeNode = new WorkspaceTreeNode(file);
        workspaceTreeNode.setModel(this.model);
        workspaceTreeNode.setParent(this);
        return workspaceTreeNode;
    }

    @Override
    public boolean isInLoadedCollection() {
        if (this.is_in_loaded_collection) {
            return true;
        }
        FileNode fileNode = (FileNode)this.getParent();
        if (fileNode != null) {
            return fileNode.isInLoadedCollection();
        }
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void map() {
        if (this.file == null) {
            if (this.child_nodes != null) {
                return;
            }
            this.child_nodes = new ArrayList();
            if ((this.title.equals(Dictionary.get("Tree.World")) || this.title.equals(Dictionary.get("Tree.CollFiles"))) && Gatherer.GS3) {
                File file = new File(Utility.getSitesDir(Configuration.gsdl3_web_path));
                File[] fileArray = file.listFiles();
                ArrayTools.sort(fileArray);
                for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                    File file2 = new File(fileArray[i], "collect");
                    if (!file2.exists() || !this.is_in_coll_all_files_mode && fileArray[i].getName().equals("modelsite")) continue;
                    WorkspaceTreeNode workspaceTreeNode = new WorkspaceTreeNode(null, fileArray[i].getName());
                    workspaceTreeNode.is_gs3_site_node = true;
                    workspaceTreeNode.is_in_coll_all_files_mode = this.is_in_coll_all_files_mode;
                    workspaceTreeNode.unmap();
                    workspaceTreeNode.setModel(this.model);
                    workspaceTreeNode.setParent(this);
                    workspaceTreeNode.map();
                    this.child_nodes.add(workspaceTreeNode);
                }
                this.model.nodeStructureChanged(this);
            } else if (this.title.equals(Dictionary.get("Tree.World")) || this.title.equals(Dictionary.get("Tree.CollFiles")) || this.is_gs3_site_node || this.is_group_node) {
                File file = this.is_gs3_site_node ? new File(Gatherer.getSitesDirectoryPath() + this.title + File.separator + "collect" + File.separator) : (this.is_group_node ? new File(Gatherer.getCollectDirectoryPath() + this.title) : new File(Gatherer.getCollectDirectoryPath()));
                File[] fileArray = file.listFiles();
                ArrayTools.sort(fileArray);
                for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                    Object object;
                    if (!this.is_in_coll_all_files_mode && fileArray[i].getName().equals("modelcol")) continue;
                    String string = Gatherer.GS3 ? Utility.CONFIG_GS3_FILE : Utility.CONFIG_FILE;
                    BasicCollectionConfiguration basicCollectionConfiguration = new BasicCollectionConfiguration(new File(fileArray[i], string));
                    if (basicCollectionConfiguration.getCollectGroup().equals("true")) {
                        object = new WorkspaceTreeNode(null, fileArray[i].getName());
                        ((WorkspaceTreeNode)object).is_group_node = true;
                        ((FileNode)object).unmap();
                        ((FileNode)object).setModel(this.model);
                        ((FileNode)object).setParent(this);
                        ((WorkspaceTreeNode)object).map();
                        this.child_nodes.add(object);
                        continue;
                    }
                    if (this.is_in_coll_all_files_mode) {
                        object = fileArray[i];
                    } else {
                        object = new File(fileArray[i], "import");
                        if (!((File)object).exists()) continue;
                    }
                    WorkspaceTreeNode workspaceTreeNode = new WorkspaceTreeNode((File)object, basicCollectionConfiguration.toString());
                    workspaceTreeNode.setParent(this);
                    workspaceTreeNode.setModel(this.model);
                    String string2 = fileArray[i].getName();
                    if (this.is_group_node) {
                        string2 = this.title + File.separator + fileArray[i].getName();
                    }
                    workspaceTreeNode.is_in_loaded_collection = string2.equals(CollectionManager.getLoadedCollectionName());
                    this.child_nodes.add(workspaceTreeNode);
                }
                this.model.nodeStructureChanged(this);
            } else if (this.title.equals(Dictionary.get("Tree.Root"))) {
                File[] fileArray = File.listRoots();
                ArrayTools.sort(fileArray);
                for (int i = 0; i < fileArray.length; ++i) {
                    this.child_nodes.add(this.addChildNode(fileArray[i]));
                }
            }
        } else {
            super.map();
        }
    }

    @Override
    public String toString() {
        if (this.title != null) {
            return this.title;
        }
        return super.toString();
    }
}

