/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gems;

import java.util.ArrayList;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.gems.Attribute;

public class AttributeContainer {
    protected ArrayList attributes;
    protected ArrayList language_dependent_attributes;
    String[] required_attribute_names = null;
    String[] language_dependent_attribute_names = null;

    public AttributeContainer() {
    }

    public AttributeContainer(String[] stringArray, String[] stringArray2) {
        Attribute attribute;
        String string;
        int n;
        this.attributes = new ArrayList();
        this.language_dependent_attributes = new ArrayList();
        if (stringArray != null) {
            this.required_attribute_names = stringArray;
            for (n = 0; n < stringArray.length; ++n) {
                string = stringArray[n];
                attribute = new Attribute(string, "", true);
                this.attributes.add(attribute);
            }
        }
        if (stringArray2 != null) {
            this.language_dependent_attribute_names = stringArray2;
            for (n = 0; n < stringArray2.length; ++n) {
                string = stringArray2[n];
                attribute = new Attribute(string, "", Configuration.getLanguage(), true);
                this.language_dependent_attributes.add(attribute);
            }
        }
    }

    public ArrayList getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ArrayList arrayList) {
        this.attributes.clear();
        this.attributes = arrayList;
    }

    public String[] getLanguageDependentAttributeNames() {
        return this.language_dependent_attribute_names;
    }

    public ArrayList getLanguageDependentAttributes() {
        return this.language_dependent_attributes;
    }

    public void setLanguageDependentAttributes(ArrayList arrayList) {
        this.language_dependent_attributes.clear();
        this.language_dependent_attributes = arrayList;
    }

    protected ArrayList getAllLanguages() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.language_dependent_attributes.size(); ++i) {
            Attribute attribute = (Attribute)this.language_dependent_attributes.get(i);
            if (arrayList.contains(attribute.getLanguage()) || attribute.getLanguage().trim().equals("")) continue;
            arrayList.add(attribute.getLanguage());
        }
        return arrayList;
    }

    public int languageExists(String string) {
        for (int i = 0; i < this.language_dependent_attributes.size(); ++i) {
            Attribute attribute = (Attribute)this.language_dependent_attributes.get(i);
            if (!attribute.getLanguage().trim().equals(string.trim())) continue;
            return i;
        }
        return -1;
    }

    protected Attribute getAttributeByName(String string) {
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute attribute = (Attribute)this.attributes.get(i);
            if (attribute.getName() == null || !attribute.getName().trim().equals(string.trim())) continue;
            return attribute;
        }
        return null;
    }

    protected Attribute getAttributeByNameAndLanguage(String string, String string2) {
        for (int i = 0; i < this.language_dependent_attributes.size(); ++i) {
            Attribute attribute = (Attribute)this.language_dependent_attributes.get(i);
            if (attribute.getName() == null && attribute.getLanguage() == null || !attribute.getName().trim().equals(string.trim()) || !attribute.getLanguage().trim().equals(string2.trim())) continue;
            return attribute;
        }
        return null;
    }

    protected ArrayList getAttributesByLanguage(String string) {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (int i = 0; i < this.language_dependent_attributes.size(); ++i) {
            Attribute attribute = (Attribute)this.language_dependent_attributes.get(i);
            if (attribute.getLanguage().trim().equals("") || !attribute.getLanguage().trim().equals(string)) continue;
            arrayList.add(attribute);
        }
        return arrayList;
    }

    protected boolean isAttributeRequired(String string) {
        for (int i = 0; i < this.required_attribute_names.length; ++i) {
            if (!string.equals(this.required_attribute_names[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean isLangDependentAttributeRequired(String string) {
        for (int i = 0; i < this.language_dependent_attribute_names.length; ++i) {
            if (!string.equals(this.language_dependent_attribute_names[i])) continue;
            return true;
        }
        return false;
    }
}

