/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gems;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gems.GEMSConstants;
import org.greenstone.gatherer.gems.MetadataElementModel;
import org.greenstone.gatherer.gems.MetadataSetCellRenderer;
import org.greenstone.gatherer.gems.MetadataSetInfo;
import org.greenstone.gatherer.gems.MetadataSetModel;
import org.greenstone.gatherer.gems.NewMetadataElementNamePrompt;

public class MetadataSetTree
extends JTree
implements Observer,
ActionListener,
MouseListener {
    private MetadataSetTree self;
    private MetadataSetModel metadata_model;
    protected JFrame parent_frame;

    public MetadataSetTree(JFrame jFrame) {
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setCellRenderer(new MetadataSetCellRenderer());
        this.setRowHeight(20);
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setModel(null);
        this.self = this;
        this.parent_frame = jFrame;
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            new MetadataSetTreeRightClickMenu(this, mouseEvent);
        } else {
            TreePath treePath = this.self.getSelectionPath();
            if (treePath != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof MetadataElementModel) {
                    ((MetadataElementModel)object).notifyListeners(false);
                } else if (object instanceof MetadataSetInfo) {
                    ((MetadataSetInfo)object).notifyListeners();
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void update(Observable observable, Object object) {
        Boolean bl;
        if (object != null && !(bl = (Boolean)object).booleanValue()) {
            this.repaint();
            this.expandAll();
        }
        this.metadata_model = (MetadataSetModel)observable;
        this.populateMetadataSetTree(this.metadata_model);
    }

    private void expandAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.expandRow(i);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(GEMSConstants.ADD_ELEMENT)) {
            this.addElement(false);
            return;
        }
        if (string.equals(GEMSConstants.ADD_SUBELEMENT)) {
            this.addElement(true);
            return;
        }
        if (string.equals(GEMSConstants.DELETE_ELEMENT)) {
            this.deleteElement();
        }
        if (string.equals(GEMSConstants.MOVE_UP)) {
            this.moveUpElement();
        }
        if (string.equals(GEMSConstants.MOVE_DOWN)) {
            this.moveDownElement();
        }
    }

    public void addElement(boolean bl) {
        NewMetadataElementNamePrompt newMetadataElementNamePrompt;
        TreePath treePath = this.self.getSelectionPath();
        if (treePath == null) {
            return;
        }
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof MetadataSetInfo) {
            object = this.metadata_model;
        }
        if ((newMetadataElementNamePrompt = new NewMetadataElementNamePrompt((Frame)this.parent_frame, bl, object)).isCancelled()) {
            return;
        }
        String string = newMetadataElementNamePrompt.getName();
        MetadataElementModel metadataElementModel = new MetadataElementModel(this.metadata_model.getMetadataSetInfo(), string);
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(metadataElementModel);
        defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
        if (object instanceof MetadataElementModel) {
            ((MetadataElementModel)object).addChild(metadataElementModel);
        } else if (object instanceof MetadataSetModel) {
            ((MetadataSetModel)object).addChild(metadataElementModel);
        }
        defaultTreeModel.reload(defaultMutableTreeNode);
        this.expandPath(treePath);
        treePath = treePath.pathByAddingChild(defaultMutableTreeNode2);
        this.self.setSelectionPath(treePath);
        metadataElementModel.notifyListeners(false);
    }

    public void deleteElement() {
        TreePath treePath = this.self.getSelectionPath();
        if (treePath != null) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.getModel();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            defaultMutableTreeNode.removeFromParent();
            Object object = defaultMutableTreeNode2.getUserObject();
            Object object2 = defaultMutableTreeNode.getUserObject();
            MetadataElementModel metadataElementModel = null;
            if (object instanceof MetadataElementModel) {
                MetadataElementModel metadataElementModel2 = (MetadataElementModel)object;
                metadataElementModel = (MetadataElementModel)object2;
                metadataElementModel2.removeChild(metadataElementModel);
                metadataElementModel2.notifyListeners(false);
            } else if (object instanceof MetadataSetInfo) {
                metadataElementModel = (MetadataElementModel)object2;
                this.metadata_model.removeChild(metadataElementModel);
                ((MetadataSetInfo)object).notifyListeners();
            }
            defaultTreeModel.reload(defaultMutableTreeNode2);
            this.self.setSelectionPath(treePath.getParentPath());
        }
    }

    private void moveUpElement() {
        TreePath treePath = this.self.getSelectionPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            int n = this.getSelectionRows()[0];
            boolean bl = false;
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof MetadataElementModel) {
                Object object2;
                MetadataElementModel metadataElementModel = (MetadataElementModel)object;
                if (metadataElementModel.getParent() == null) {
                    bl = this.metadata_model.moveUp(metadataElementModel);
                } else {
                    object2 = metadataElementModel.getParent();
                    bl = ((MetadataElementModel)object2).moveUp(metadataElementModel);
                }
                if (bl) {
                    object2 = (DefaultTreeModel)this.getModel();
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    int n2 = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
                    ((DefaultTreeModel)object2).removeNodeFromParent(defaultMutableTreeNode);
                    ((DefaultTreeModel)object2).insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, --n2);
                    ((DefaultTreeModel)object2).reload(defaultMutableTreeNode2);
                    this.setSelectionRow(--n);
                }
            }
        }
    }

    private void moveDownElement() {
        TreePath treePath = this.self.getSelectionPath();
        if (treePath != null) {
            boolean bl = false;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            int n = this.getSelectionRows()[0];
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof MetadataElementModel) {
                Object object2;
                MetadataElementModel metadataElementModel = (MetadataElementModel)object;
                if (metadataElementModel.getParent() == null) {
                    bl = this.metadata_model.moveDown(metadataElementModel);
                } else {
                    object2 = metadataElementModel.getParent();
                    bl = ((MetadataElementModel)object2).moveDown(metadataElementModel);
                }
                if (bl) {
                    object2 = (DefaultTreeModel)this.getModel();
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    int n2 = defaultMutableTreeNode2.getIndex(defaultMutableTreeNode);
                    ((DefaultTreeModel)object2).removeNodeFromParent(defaultMutableTreeNode);
                    ((DefaultTreeModel)object2).insertNodeInto(defaultMutableTreeNode, defaultMutableTreeNode2, ++n2);
                    ((DefaultTreeModel)object2).reload(defaultMutableTreeNode2);
                    this.setSelectionRow(++n);
                }
            }
        }
    }

    private void populateMetadataSetTree(MetadataSetModel metadataSetModel) {
        this.setModel(null);
        MetadataSetInfo metadataSetInfo = metadataSetModel.getMetadataSetInfo();
        if (metadataSetInfo == null) {
            this.repaint();
            return;
        }
        ArrayList arrayList = metadataSetModel.getMetadataSetModel();
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(metadataSetInfo));
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
        for (int i = 0; i < arrayList.size(); ++i) {
            MetadataElementModel metadataElementModel = (MetadataElementModel)arrayList.get(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(metadataElementModel);
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            ArrayList arrayList2 = metadataElementModel.getChildElements();
            for (int j = 0; j < arrayList2.size(); ++j) {
                MetadataElementModel metadataElementModel2 = (MetadataElementModel)arrayList2.get(j);
                DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(metadataElementModel2);
                defaultTreeModel.insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode2, defaultMutableTreeNode2.getChildCount());
            }
        }
        defaultTreeModel.reload(defaultMutableTreeNode);
        this.setModel(defaultTreeModel);
    }

    private class MetadataSetTreeRightClickMenu
    extends JPopupMenu {
        private MetadataSetTreeRightClickMenu(MetadataSetTree metadataSetTree2, MouseEvent mouseEvent) {
            boolean bl = false;
            boolean bl2 = false;
            TreePath treePath = metadataSetTree2.getPathForRow(0);
            TreePath treePath2 = metadataSetTree2.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath2 == null) {
                treePath2 = treePath;
                bl = true;
            } else if (treePath2.equals(treePath)) {
                bl = true;
            } else if (treePath2.getParentPath().equals(treePath)) {
                bl2 = true;
            }
            metadataSetTree2.clearSelection();
            metadataSetTree2.setSelectionPath(treePath2);
            JMenuItem jMenuItem = new JMenuItem();
            if (bl) {
                jMenuItem.setText(Dictionary.get("GEMS.Popup.AddElement"));
                jMenuItem.setActionCommand(GEMSConstants.ADD_ELEMENT);
            } else {
                jMenuItem.setText(Dictionary.get("GEMS.Popup.AddSubElement"));
                jMenuItem.setActionCommand(GEMSConstants.ADD_SUBELEMENT);
            }
            jMenuItem.addActionListener(metadataSetTree2);
            this.add(jMenuItem);
            if (!bl) {
                JMenuItem jMenuItem2 = new JMenuItem();
                if (bl2) {
                    jMenuItem2.setText(Dictionary.get("GEMS.Popup.DeleteElement"));
                } else {
                    jMenuItem2.setText(Dictionary.get("GEMS.Popup.DeleteSubElement"));
                }
                jMenuItem2.addActionListener(metadataSetTree2);
                jMenuItem2.setActionCommand(GEMSConstants.DELETE_ELEMENT);
                this.add(jMenuItem2);
            }
            this.show(metadataSetTree2, mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

