/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.BasicCollectionConfiguration;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.util.ArrayTools;
import org.greenstone.gatherer.util.Utility;

public class DeleteCollectionPrompt
extends ModalDialog {
    private BasicCollectionConfiguration collection = null;
    private DefaultListModel list_model = null;
    private DeleteCollectionPrompt prompt = null;
    private JButton close_button = new GLIButton(Dictionary.get("General.Close"), Dictionary.get("General.Close_Tooltip"));
    private JButton ok_button = null;
    private JCheckBox confirmation = null;
    private JLabel details_label = null;
    private JLabel list_label = null;
    private JList list = null;
    private JTextArea details = null;
    private String[] args = null;
    private boolean current_coll_deleted = false;
    public static final Dimension SIZE = new Dimension(500, 500);

    public DeleteCollectionPrompt() {
        super(Gatherer.g_man);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.confirmation = new JCheckBox(Dictionary.get("DeleteCollectionPrompt.Confirm_Delete"));
        this.confirmation.setComponentOrientation(Dictionary.getOrientation());
        this.details = new JTextArea(Dictionary.get("DeleteCollectionPrompt.No_Collection"));
        this.details.setComponentOrientation(Dictionary.getOrientation());
        this.details.setEditable(false);
        this.details_label = new JLabel(Dictionary.get("DeleteCollectionPrompt.Collection_Details"));
        this.details_label.setComponentOrientation(Dictionary.getOrientation());
        this.list = new JList();
        this.list.setComponentOrientation(Dictionary.getOrientation());
        this.list_label = new JLabel(Dictionary.get("DeleteCollectionPrompt.Collection_List"));
        this.list_label.setComponentOrientation(Dictionary.getOrientation());
        this.list_model = new DefaultListModel();
        this.ok_button = new GLIButton(Dictionary.get("DeleteCollectionPrompt.Delete"), Dictionary.get("DeleteCollectionPrompt.Delete_Tooltip"));
        this.prompt = this;
        this.setModal(true);
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("DeleteCollectionPrompt.Title"));
        this.setJMenuBar(new SimpleMenuBar("deletingcollections"));
        this.close_button.addActionListener(new CloseButtonListener());
        this.confirmation.addActionListener(new ConfirmationCheckBoxListener());
        this.confirmation.setEnabled(false);
        this.confirmation.setSelected(false);
        this.list.addListSelectionListener(new CollectionListListener());
        this.list.clearSelection();
        this.list.getSelectionModel().setSelectionMode(0);
        this.list.setModel(this.list_model);
        this.ok_button.addActionListener(new OKButtonListener());
        this.ok_button.setEnabled(false);
        this.scanForCollections();
    }

    public void destroy() {
        this.list_model.clear();
        this.list_model = null;
        this.close_button = null;
        this.confirmation = null;
        this.details = null;
        this.details_label = null;
        this.list = null;
        this.ok_button = null;
        this.prompt = null;
    }

    public boolean display() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.add((Component)this.list_label, "North");
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.add((Component)this.details_label, "North");
        jScrollPane = new JScrollPane(this.details);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        jPanel3.add(jPanel);
        jPanel3.add(jPanel2);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        jPanel4.add((Component)this.confirmation, "Center");
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JPanel jPanel5 = new JPanel(new GridLayout(1, 2));
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        jPanel5.add(this.ok_button);
        jPanel5.add(this.close_button);
        jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setComponentOrientation(Dictionary.getOrientation());
        jPanel6.add((Component)jPanel4, "North");
        jPanel6.add((Component)jPanel5, "South");
        jPanel6.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        JPanel jPanel7 = (JPanel)this.getContentPane();
        jPanel7.setComponentOrientation(Dictionary.getOrientation());
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)jPanel3, "Center");
        jPanel7.add((Component)jPanel6, "South");
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - DeleteCollectionPrompt.SIZE.width) / 2, (dimension.height - DeleteCollectionPrompt.SIZE.height) / 2);
        this.setVisible(true);
        return this.current_coll_deleted;
    }

    public void resultPrompt(boolean bl) {
        this.args = new String[1];
        this.args[0] = this.collection.getName();
        if (bl) {
            JOptionPane.showMessageDialog(this.prompt, Dictionary.get("DeleteCollectionPrompt.Successful_Delete", this.args), Dictionary.get("DeleteCollectionPrompt.Successful_Title"), 1);
        } else {
            JOptionPane.showMessageDialog(this.prompt, Dictionary.get("DeleteCollectionPrompt.Failed_Delete", this.args), Dictionary.get("DeleteCollectionPrompt.Failed_Title"), 2);
        }
    }

    private void scanForCollections() {
        File file = new File(Gatherer.getCollectDirectoryPath());
        if (file.exists()) {
            this.loadCollectionConfigs(file);
        }
    }

    private void loadCollectionConfigs(File file) {
        File[] fileArray = file.listFiles();
        String string = Gatherer.GS3 ? Utility.CONFIG_GS3_FILE : Utility.CONFIG_FILE;
        ArrayTools.sort(fileArray);
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            File file2;
            File file3 = fileArray[i];
            String string2 = file3.getName();
            if (!file3.isDirectory() || string2.equals("modelcol") || !(file2 = new File(file3, string)).exists()) continue;
            BasicCollectionConfiguration basicCollectionConfiguration = new BasicCollectionConfiguration(file2);
            if (basicCollectionConfiguration.getCollectGroup().equals("true")) {
                this.loadCollectionConfigs(file3);
                continue;
            }
            if (Gatherer.isWebswing) {
                if (Gatherer.webswingAuthenticator.canEditCollection(string2)) {
                    this.list_model.addElement(basicCollectionConfiguration);
                }
            } else {
                this.list_model.addElement(basicCollectionConfiguration);
            }
            basicCollectionConfiguration = null;
        }
    }

    static /* synthetic */ String[] access$902(DeleteCollectionPrompt deleteCollectionPrompt, String[] stringArray) {
        deleteCollectionPrompt.args = stringArray;
        return stringArray;
    }

    private class OKButtonListener
    implements ActionListener {
        private OKButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Gatherer.c_man.deleteCollection(DeleteCollectionPrompt.this.collection.getShortName())) {
                Gatherer.g_man.refreshWorkspaceTree(10);
                if (DeleteCollectionPrompt.this.collection.getShortName().equals(CollectionManager.getLoadedCollectionName())) {
                    DeleteCollectionPrompt.this.current_coll_deleted = true;
                }
                DeleteCollectionPrompt.this.list_model.removeElement(DeleteCollectionPrompt.this.collection);
                if (!Configuration.fedora_info.isActive()) {
                    DeleteCollectionPrompt.this.resultPrompt(true);
                }
                DeleteCollectionPrompt.this.details.setText(Dictionary.get("DeleteCollectionPrompt.No_Collection"));
                DeleteCollectionPrompt.this.confirmation.setEnabled(false);
                DeleteCollectionPrompt.this.confirmation.setSelected(false);
                DeleteCollectionPrompt.this.ok_button.setEnabled(false);
                DeleteCollectionPrompt.this.collection = null;
            } else {
                DeleteCollectionPrompt.this.resultPrompt(false);
            }
        }
    }

    private class ConfirmationCheckBoxListener
    implements ActionListener {
        private ConfirmationCheckBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DeleteCollectionPrompt.this.ok_button.setEnabled(DeleteCollectionPrompt.this.confirmation.isSelected());
        }
    }

    private class CollectionListListener
    implements ListSelectionListener {
        private CollectionListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            DeleteCollectionPrompt.this.ok_button.setEnabled(false);
            DeleteCollectionPrompt.this.confirmation.setSelected(false);
            if (!DeleteCollectionPrompt.this.list.isSelectionEmpty()) {
                String string;
                DeleteCollectionPrompt.this.collection = (BasicCollectionConfiguration)DeleteCollectionPrompt.this.list.getSelectedValue();
                String string2 = string = Gatherer.c_man.getCollection() == null ? "" : Gatherer.c_man.getCollection().getName();
                if (!DeleteCollectionPrompt.this.collection.getShortName().equals(string)) {
                    DeleteCollectionPrompt.this.confirmation.setEnabled(true);
                    DeleteCollectionPrompt.this.confirmation.setToolTipText(null);
                    DeleteCollectionPrompt.this.ok_button.setToolTipText(null);
                    DeleteCollectionPrompt.access$902(DeleteCollectionPrompt.this, new String[3]);
                    ((DeleteCollectionPrompt)DeleteCollectionPrompt.this).args[0] = DeleteCollectionPrompt.this.collection.getCreator();
                    ((DeleteCollectionPrompt)DeleteCollectionPrompt.this).args[1] = DeleteCollectionPrompt.this.collection.getMaintainer();
                    ((DeleteCollectionPrompt)DeleteCollectionPrompt.this).args[2] = DeleteCollectionPrompt.this.collection.getDescription();
                    DeleteCollectionPrompt.this.details.setText(Dictionary.get("DeleteCollectionPrompt.Details", DeleteCollectionPrompt.this.args));
                    DeleteCollectionPrompt.this.details.setCaretPosition(0);
                } else {
                    String string3 = Dictionary.get("DeleteCollectionPrompt.Cannot_Delete_Open_Collection_Tooltip", DeleteCollectionPrompt.this.collection.getName());
                    DeleteCollectionPrompt.this.confirmation.setToolTipText(string3);
                    DeleteCollectionPrompt.this.ok_button.setToolTipText(string3);
                    DeleteCollectionPrompt.this.ok_button.setEnabled(false);
                    DeleteCollectionPrompt.this.confirmation.setEnabled(false);
                    DeleteCollectionPrompt.this.confirmation.setSelected(false);
                }
            } else {
                DeleteCollectionPrompt.this.confirmation.setEnabled(false);
                DeleteCollectionPrompt.this.details.setText(Dictionary.get("DeleteCollectionPrompt.No_Collection"));
            }
        }
    }

    private class CloseButtonListener
    implements ActionListener {
        private CloseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DeleteCollectionPrompt.this.prompt.dispose();
        }
    }
}

