/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.BasicCollectionConfiguration;
import org.greenstone.gatherer.greenstone.LocalGreenstone;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.gui.SimpleResultDialog;
import org.greenstone.gatherer.shell.GDefaultProgressMonitor;
import org.greenstone.gatherer.shell.GShell;
import org.greenstone.gatherer.shell.GShellEvent;
import org.greenstone.gatherer.shell.GShellListener;
import org.greenstone.gatherer.util.ArrayTools;
import org.greenstone.gatherer.util.Utility;

public class ExportAsPrompt
extends ModalDialog
implements GShellListener {
    private static final Dimension LABEL_SIZE = new Dimension(120, 25);
    private OKButtonListener ok_button_listener;
    private JLabel saveas_label = null;
    private JComboBox saveas_combobox = null;
    private ArrayList all_collections = null;
    private BasicCollectionConfiguration selected_collection = null;
    private JList list = null;
    private BasicCollectionConfiguration collection = null;
    private ExportAsPrompt prompt = null;
    private JButton cancel_button = null;
    private JButton ok_button = null;
    private JLabel details_label = null;
    private JLabel list_label = null;
    private JTextArea details_textarea = null;
    private JTextArea instructions_textarea;
    private JTextField title_field = null;
    private JLabel title_label = null;
    private String[] args = null;
    private String cd_title = null;
    private boolean successful = false;
    private boolean exporting = false;
    private StringBuffer error_message = null;
    public static final Dimension SIZE = new Dimension(500, 540);
    private GDefaultProgressMonitor progress_monitor;
    private JButton convert_xml_button1 = null;
    private JButton convert_xml_button2 = null;
    private JButton convert_xml_button3 = null;
    private JButton folder_button = null;
    private JPanel instructions_pane = null;
    private JPanel convert_xml_pane1 = null;
    private JPanel convert_xml_pane2 = null;
    private JPanel mapping_xml_pane = null;
    private JCheckBox convert_xml_checkbox1 = null;
    private JCheckBox convert_xml_checkbox2 = null;
    private JCheckBox mapping_xml_checkbox = null;
    private JCheckBox output_single_checkbox = null;
    private JTextField convert_xml_field1 = null;
    private JTextField convert_xml_field2 = null;
    private JTextField mapping_xml_field = null;
    private File xsl_file1 = null;
    private File xsl_file2 = null;
    private File mapping_file = null;
    private JPanel convert_xml_pane = null;
    private HashMap plugoutMap = new HashMap();

    public ExportAsPrompt() {
        super((Frame)Gatherer.g_man, true);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.plugoutMap.clear();
        this.plugoutMap.put("DSpace", "dublin-core.xml");
        this.plugoutMap.put("MARCXML", "doc.xml");
        this.plugoutMap.put("GreenstoneMETS", "doctxt.xml,docmets.xml");
        this.plugoutMap.put("FedoraMETS", "doctxt.xml,docmets.xml");
        String[] stringArray = new String[]{"GreenstoneMETS", "FedoraMETS", "MARCXML", "DSpace"};
        this.cancel_button = new GLIButton(Dictionary.get("General.Close"), Dictionary.get("General.Close_Tooltip"));
        this.details_textarea = new JTextArea(Dictionary.get("DeleteCollectionPrompt.No_Collection"));
        this.details_textarea.setEditable(false);
        this.details_textarea.setComponentOrientation(Dictionary.getOrientation());
        this.details_label = new JLabel(Dictionary.get("DeleteCollectionPrompt.Collection_Details"));
        this.details_label.setComponentOrientation(Dictionary.getOrientation());
        this.instructions_textarea = new JTextArea(Dictionary.get("ExportAsPrompt.Instructions"));
        this.instructions_textarea.setCaretPosition(0);
        this.instructions_textarea.setEditable(false);
        this.instructions_textarea.setLineWrap(true);
        this.instructions_textarea.setRows(4);
        this.instructions_textarea.setWrapStyleWord(true);
        this.instructions_textarea.setComponentOrientation(Dictionary.getOrientation());
        this.saveas_label = new JLabel(Dictionary.get("ExportAsPrompt.SaveAs"));
        this.saveas_label.setComponentOrientation(Dictionary.getOrientation());
        this.saveas_combobox = new JComboBox<String>(stringArray);
        this.saveas_combobox.setOpaque(false);
        this.saveas_combobox.setToolTipText(Dictionary.get("ExportAsPrompt.SaveAs_Tooltip"));
        this.saveas_combobox.setComponentOrientation(Dictionary.getOrientation());
        this.convert_xml_button1 = new GLIButton(Dictionary.get("ExportAsPrompt.Browse"), Dictionary.get("ExportAsPrompt.Browse_Tooltip"));
        this.convert_xml_button1.setEnabled(false);
        this.convert_xml_button2 = new GLIButton(Dictionary.get("ExportAsPrompt.Browse"), Dictionary.get("ExportAsPrompt.Browse_Tooltip"));
        this.convert_xml_button2.setEnabled(false);
        this.convert_xml_button3 = new GLIButton(Dictionary.get("ExportAsPrompt.Browse"), Dictionary.get("ExportAsPrompt.Browse_Tooltip"));
        this.convert_xml_button3.setEnabled(false);
        this.convert_xml_checkbox1 = new JCheckBox();
        this.convert_xml_checkbox1.setText(Dictionary.get("ExportAsPrompt.ApplyXSL", "doc.xml"));
        this.convert_xml_checkbox1.setToolTipText(Dictionary.get("ExportAsPrompt.ApplyXSL_Tooltip"));
        this.convert_xml_checkbox1.setComponentOrientation(Dictionary.getOrientation());
        this.convert_xml_checkbox2 = new JCheckBox();
        this.convert_xml_checkbox2.setToolTipText(Dictionary.get("ExportAsPrompt.ApplyXSL_Tooltip"));
        this.convert_xml_checkbox2.setComponentOrientation(Dictionary.getOrientation());
        this.output_single_checkbox = new JCheckBox();
        this.output_single_checkbox.setComponentOrientation(Dictionary.getOrientation());
        this.output_single_checkbox.setText(Dictionary.get("ExportAsPrompt.MARCXMLGroup"));
        this.output_single_checkbox.setToolTipText(Dictionary.get("ExportAsPrompt.MARCXMLGroup_Tooltip"));
        this.mapping_xml_checkbox = new JCheckBox();
        this.mapping_xml_checkbox.setComponentOrientation(Dictionary.getOrientation());
        this.mapping_xml_checkbox.setText(Dictionary.get("ExportAsPrompt.MappingXML"));
        this.mapping_xml_checkbox.setToolTipText(Dictionary.get("ExportAsPrompt.MappingXML_Tooltip"));
        this.convert_xml_field1 = new JTextField();
        this.convert_xml_field1.setComponentOrientation(Dictionary.getOrientation());
        this.convert_xml_field1.setEnabled(false);
        this.convert_xml_field2 = new JTextField();
        this.convert_xml_field2.setComponentOrientation(Dictionary.getOrientation());
        this.convert_xml_field2.setEnabled(false);
        this.mapping_xml_field = new JTextField();
        this.mapping_xml_field.setComponentOrientation(Dictionary.getOrientation());
        this.mapping_xml_field.setEnabled(false);
        this.convert_xml_pane1 = new JPanel(new BorderLayout());
        this.convert_xml_pane1.setComponentOrientation(Dictionary.getOrientation());
        this.convert_xml_pane2 = new JPanel(new BorderLayout());
        this.convert_xml_pane2.setComponentOrientation(Dictionary.getOrientation());
        this.mapping_xml_pane = new JPanel(new BorderLayout());
        this.mapping_xml_pane.setComponentOrientation(Dictionary.getOrientation());
        this.convert_xml_pane = new JPanel(new GridLayout(3, 1));
        this.convert_xml_pane.setComponentOrientation(Dictionary.getOrientation());
        this.all_collections = new ArrayList();
        this.list = new JList(this.getCollectionListModel());
        this.list.setComponentOrientation(Dictionary.getOrientation());
        this.list_label = new JLabel(Dictionary.get("DeleteCollectionPrompt.Collection_List"));
        this.list_label.setComponentOrientation(Dictionary.getOrientation());
        this.ok_button = new GLIButton(Dictionary.get("ExportAsPrompt.Export"), Dictionary.get("ExportAsPrompt.Export_Tooltip"));
        this.title_field = new JTextField();
        this.title_field.setComponentOrientation(Dictionary.getOrientation());
        this.title_field.setToolTipText(Dictionary.get("ExportAsPrompt.Export_Name_Tooltip"));
        this.title_label = new JLabel(Dictionary.get("ExportAsPrompt.Export_Name"));
        this.title_label.setComponentOrientation(Dictionary.getOrientation());
        this.folder_button = new GLIButton(Dictionary.get("ExportAsPrompt.Browse"), Dictionary.get("ExportAsPrompt.Browse_Tooltip"));
        this.folder_button.addActionListener(new FolderButtonListener());
        this.prompt = this;
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("ExportAsPrompt.Title"));
        this.setJMenuBar(new SimpleMenuBar("exporting"));
        this.cancel_button.addActionListener(new CancelButtonListener());
        this.list.addListSelectionListener(new CollectionListListener());
        this.list.clearSelection();
        this.list.getSelectionModel().setSelectionMode(0);
        this.ok_button_listener = new OKButtonListener();
        this.ok_button.addActionListener(this.ok_button_listener);
        this.ok_button.setEnabled(false);
        this.convert_xml_button1.addActionListener(new ConvertXMLButtonListener());
        this.convert_xml_checkbox1.addActionListener(new ConvertXMLCheckboxListener());
        this.mapping_xml_checkbox.addActionListener(new ConvertXMLCheckboxListener());
        this.convert_xml_button3.addActionListener(new ConvertXMLButtonListener());
        this.convert_xml_button2.addActionListener(new ConvertXMLButtonListener());
        this.convert_xml_checkbox2.addActionListener(new ConvertXMLCheckboxListener());
        this.saveas_combobox.addActionListener(new SaveasListener());
    }

    public void destroy() {
        this.saveas_label = null;
        this.saveas_combobox = null;
        this.all_collections.clear();
        this.all_collections = null;
        this.cancel_button = null;
        this.details_textarea = null;
        this.details_label = null;
        this.list = null;
        this.ok_button = null;
        this.prompt = null;
        this.selected_collection = null;
        this.title_field = null;
        this.title_label = null;
    }

    public boolean display() {
        this.instructions_pane = new JPanel(new BorderLayout());
        this.instructions_pane.setComponentOrientation(Dictionary.getOrientation());
        this.instructions_pane.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(this.instructions_textarea);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        this.instructions_pane.add((Component)jScrollPane, "Center");
        this.title_label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 15));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.add((Component)this.title_label, "Before");
        jPanel.add((Component)this.title_field, "Center");
        jPanel.add((Component)this.folder_button, "After");
        this.convert_xml_pane1.removeAll();
        this.convert_xml_pane2.removeAll();
        this.mapping_xml_pane.removeAll();
        this.convert_xml_pane.removeAll();
        this.convert_xml_pane1.add((Component)this.convert_xml_checkbox1, "Before");
        this.convert_xml_pane1.add((Component)this.convert_xml_field1, "Center");
        this.convert_xml_pane1.add((Component)this.convert_xml_button1, "After");
        this.convert_xml_pane2.add((Component)this.convert_xml_checkbox2, "Before");
        this.convert_xml_pane2.add((Component)this.convert_xml_field2, "Center");
        this.convert_xml_pane2.add((Component)this.convert_xml_button2, "After");
        this.mapping_xml_pane.add((Component)this.mapping_xml_checkbox, "Before");
        this.mapping_xml_pane.add((Component)this.mapping_xml_field, "Center");
        this.mapping_xml_pane.add((Component)this.convert_xml_button3, "After");
        this.convert_xml_pane.add(this.convert_xml_pane1);
        String string = (String)this.saveas_combobox.getSelectedItem();
        this.saveas_combobox.setSelectedIndex(0);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        this.saveas_label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 15));
        jPanel2.add((Component)this.saveas_label, "Before");
        jPanel2.add((Component)this.saveas_combobox, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        jPanel3.add((Component)jPanel2, "North");
        jPanel3.add((Component)jPanel, "Center");
        this.instructions_pane.add((Component)jPanel3, "North");
        this.instructions_pane.add((Component)this.convert_xml_pane, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        jPanel4.add((Component)this.list_label, "North");
        jScrollPane = new JScrollPane(this.list);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel4.add((Component)jScrollPane, "Center");
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        jPanel5.add((Component)this.details_label, "North");
        jScrollPane = new JScrollPane(this.details_textarea);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel5.add((Component)jScrollPane, "Center");
        jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel jPanel6 = new JPanel(new GridLayout(2, 1));
        jPanel6.setComponentOrientation(Dictionary.getOrientation());
        jPanel6.add(jPanel4);
        jPanel6.add(jPanel5);
        jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel7 = new JPanel(new GridLayout(1, 2));
        jPanel7.setComponentOrientation(Dictionary.getOrientation());
        jPanel7.add(this.ok_button);
        jPanel7.add(this.cancel_button);
        jPanel7.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.setComponentOrientation(Dictionary.getOrientation());
        jPanel8.add((Component)jPanel7, "South");
        jPanel8.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        JPanel jPanel9 = (JPanel)this.getContentPane();
        jPanel9.setComponentOrientation(Dictionary.getOrientation());
        jPanel9.setLayout(new BorderLayout());
        jPanel9.add((Component)this.instructions_pane, "North");
        jPanel9.add((Component)jPanel6, "Center");
        jPanel9.add((Component)jPanel8, "South");
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - ExportAsPrompt.SIZE.width) / 2, (dimension.height - ExportAsPrompt.SIZE.height) / 2);
        this.setVisible(true);
        return true;
    }

    public void exportAsCollections() {
        Comparable<File> comparable;
        DebugStream.println("ExportAsPrompt.exportAsCollections()");
        if (this.selected_collection == null) {
            return;
        }
        this.cd_title = this.title_field.getText();
        String string = (String)this.saveas_combobox.getSelectedItem();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!Gatherer.isGsdlRemote) {
            arrayList.add(Configuration.perl_path);
            arrayList.add("-S");
        }
        arrayList.add(LocalGreenstone.getBinScriptDirectoryPath() + "export.pl");
        arrayList.add("-gli");
        arrayList.add("-language");
        arrayList.add(Configuration.getLanguage());
        arrayList.add("-removeold");
        arrayList.add("-saveas");
        arrayList.add(string);
        String string2 = Gatherer.getCollectDirectoryPath();
        if (Gatherer.GS3) {
            arrayList.add("-site");
            arrayList.add(Configuration.site_name);
        }
        if (string2 != Gatherer.getDefaultGSCollectDirectoryPath(true)) {
            arrayList.add("-collectdir");
            arrayList.add(string2);
        }
        arrayList.add("-exportdir");
        String string3 = LocalGreenstone.getTmpDirectoryPath();
        if (this.cd_title.equals("")) {
            string3 = string3 + "exported_" + this.selected_collection.getShortName() + "_" + string;
        } else {
            comparable = new File(this.cd_title);
            if (((File)comparable).isAbsolute()) {
                string3 = this.cd_title + File.separator + "exported_" + this.selected_collection.getShortName() + "_" + string;
            } else {
                this.cd_title = this.cd_title.replaceAll("\\s+", "");
                this.cd_title = this.cd_title.replaceAll("\\\\+", "/");
                this.cd_title = this.cd_title.replaceAll("/+", "/");
                string3 = string3 + this.cd_title;
            }
        }
        arrayList.add(string3);
        comparable = new StringBuffer();
        if (string.equals("MARCXML")) {
            if (!this.convert_xml_field1.getText().equals("")) {
                ((StringBuffer)comparable).append("-xslt_file ");
                ((StringBuffer)comparable).append(this.convert_xml_field1.getText() + " ");
            }
            if (!this.mapping_xml_field.getText().equals("")) {
                ((StringBuffer)comparable).append("-mapping_file ");
                ((StringBuffer)comparable).append(this.mapping_xml_field.getText() + " ");
            }
            if (this.output_single_checkbox.isSelected()) {
                ((StringBuffer)comparable).append("-group ");
            }
        } else if (string.endsWith("METS")) {
            if (!this.convert_xml_field1.getText().equals("")) {
                ((StringBuffer)comparable).append("-xslt_txt ");
                ((StringBuffer)comparable).append(this.convert_xml_field1.getText() + " ");
            }
            if (!this.convert_xml_field2.getText().equals("")) {
                ((StringBuffer)comparable).append("-xslt_mets ");
                ((StringBuffer)comparable).append(this.convert_xml_field2.getText() + " ");
            }
        } else if (string.equals("DSpace") && !this.convert_xml_field1.getText().equals("")) {
            ((StringBuffer)comparable).append("-xslt_file ");
            ((StringBuffer)comparable).append(this.convert_xml_field1.getText() + " ");
        }
        if (((StringBuffer)comparable).length() > 0) {
            arrayList.add("-saveas_options");
            arrayList.add(((StringBuffer)comparable).toString());
        }
        arrayList.add(this.selected_collection.getShortName());
        DebugStream.print("export command = ");
        for (int i = 0; i < arrayList.size(); ++i) {
            DebugStream.print(arrayList.get(i) + " ");
        }
        DebugStream.println("");
        String[] stringArray = arrayList.toArray(new String[0]);
        this.progress_monitor = new GDefaultProgressMonitor();
        GShell gShell = new GShell(stringArray, 3, 3, this, this.progress_monitor, GShell.GSHELL_EXPORTAS);
        gShell.start();
        DebugStream.println("ExportAsPrompt.exportAsCollections().return");
    }

    public void cancelExporting() {
        this.progress_monitor.setStop(true);
    }

    public void resultPrompt(boolean bl, String string) {
        String string2;
        String string3;
        Object object;
        Object object2;
        this.args = new String[2];
        this.args[0] = this.selected_collection.getName() + " " + "[" + this.selected_collection.getShortName() + "]";
        String string4 = (String)this.saveas_combobox.getSelectedItem();
        this.args[1] = LocalGreenstone.getTmpDirectoryPath();
        if (this.cd_title.equals("")) {
            this.args[1] = this.args[1] + "exported_" + this.selected_collection.getShortName() + "_" + string4;
        } else {
            object2 = new File(this.cd_title);
            if (((File)object2).isAbsolute()) {
                this.args[1] = this.cd_title + File.separator + "exported_" + this.selected_collection.getShortName() + "_" + string4;
            } else {
                this.cd_title = this.cd_title.replaceAll("\\s+", "");
                this.cd_title = this.cd_title.replaceAll("\\\\+", "/");
                this.cd_title = this.cd_title.replaceAll("/+", "/");
                this.args[1] = this.args[1] + this.cd_title;
            }
        }
        if (bl) {
            object = "ExportAsPrompt.Successful_ExportOne";
            object2 = Dictionary.get("ExportAsPrompt.Successful_Title");
            string3 = Dictionary.get((String)object, this.args);
            string2 = Dictionary.get("ExportAsPrompt.Successful_Details", this.args);
        } else {
            object = "ExportAsPrompt.Failed_ExportOne";
            object2 = Dictionary.get("ExportAsPrompt.Failed_Title");
            string3 = Dictionary.get((String)object, this.args);
            string2 = Dictionary.get("ExportAsPrompt.Failed_Details", this.args);
        }
        object = new SimpleResultDialog((Dialog)this, (String)object2, string3, string2);
        ((ModalDialog)object).setVisible(true);
        ((ModalDialog)object).dispose();
        object = null;
    }

    private ListModel getCollectionListModel() {
        String string;
        DefaultListModel<BasicCollectionConfiguration> defaultListModel = new DefaultListModel<BasicCollectionConfiguration>();
        File file = new File(Gatherer.getCollectDirectoryPath());
        String string2 = string = Gatherer.GS3 ? Utility.CONFIG_GS3_FILE : Utility.CONFIG_FILE;
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            ArrayTools.sort(fileArray);
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                File file2;
                if (!fileArray[i].isDirectory() || fileArray[i].getName().equals("modelcol") || !(file2 = new File(fileArray[i], string)).exists()) continue;
                BasicCollectionConfiguration basicCollectionConfiguration = new BasicCollectionConfiguration(file2);
                defaultListModel.addElement(basicCollectionConfiguration);
                basicCollectionConfiguration = null;
            }
        }
        return defaultListModel;
    }

    @Override
    public synchronized void message(GShellEvent gShellEvent) {
        String string = gShellEvent.getMessage();
        int n = "export.pl> ".length();
        if (string.startsWith("export.pl>")) {
            string = string.substring(n);
            this.error_message.append(string);
            this.error_message.append("\n");
        }
    }

    @Override
    public synchronized void processBegun(GShellEvent gShellEvent) {
    }

    @Override
    public synchronized void processComplete(GShellEvent gShellEvent) {
        this.successful = false;
        if (gShellEvent.getStatus() == 1 && gShellEvent.getType() == 3) {
            this.successful = true;
        }
        this.ok_button_listener.processComplete();
    }

    static /* synthetic */ String[] access$1102(ExportAsPrompt exportAsPrompt, String[] stringArray) {
        exportAsPrompt.args = stringArray;
        return stringArray;
    }

    private class FolderButtonListener
    implements ActionListener {
        private FolderButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(ExportAsPrompt.this.prompt);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                ExportAsPrompt.this.title_field.setText(file.getPath());
            }
        }
    }

    private class ConvertXMLButtonListener
    implements ActionListener {
        private ConvertXMLButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getPath().endsWith(".xsl") || file.isDirectory() || file.getPath().endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return "XSL or XML file";
                }
            };
            jFileChooser.setFileFilter(fileFilter);
            int n = jFileChooser.showOpenDialog(ExportAsPrompt.this.prompt);
            if (n == 0) {
                if (actionEvent.getSource() == ExportAsPrompt.this.convert_xml_button1) {
                    ExportAsPrompt.this.xsl_file1 = jFileChooser.getSelectedFile();
                    ExportAsPrompt.this.convert_xml_field1.setText(ExportAsPrompt.this.xsl_file1.getPath());
                } else if (actionEvent.getSource() == ExportAsPrompt.this.convert_xml_button2) {
                    ExportAsPrompt.this.xsl_file2 = jFileChooser.getSelectedFile();
                    ExportAsPrompt.this.convert_xml_field2.setText(ExportAsPrompt.this.xsl_file2.getPath());
                } else {
                    ExportAsPrompt.this.mapping_file = jFileChooser.getSelectedFile();
                    ExportAsPrompt.this.mapping_xml_field.setText(ExportAsPrompt.this.mapping_file.getPath());
                }
            }
        }
    }

    private class SaveasListener
    implements ActionListener {
        private SaveasListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExportAsPrompt.this.convert_xml_checkbox1.setSelected(false);
            ExportAsPrompt.this.convert_xml_checkbox2.setSelected(false);
            ExportAsPrompt.this.mapping_xml_checkbox.setSelected(false);
            ExportAsPrompt.this.output_single_checkbox.setSelected(false);
            ExportAsPrompt.this.convert_xml_button1.setEnabled(false);
            ExportAsPrompt.this.convert_xml_button2.setEnabled(false);
            ExportAsPrompt.this.convert_xml_button3.setEnabled(false);
            ExportAsPrompt.this.convert_xml_field1.setText("");
            ExportAsPrompt.this.convert_xml_field2.setText("");
            ExportAsPrompt.this.mapping_xml_field.setText("");
            String string = (String)ExportAsPrompt.this.saveas_combobox.getSelectedItem();
            if (ExportAsPrompt.this.convert_xml_pane.getComponentCount() > 1) {
                ExportAsPrompt.this.convert_xml_pane.remove(1);
                if (ExportAsPrompt.this.convert_xml_pane.getComponentCount() > 1) {
                    ExportAsPrompt.this.convert_xml_pane.remove(1);
                }
            }
            if (!string.endsWith("METS")) {
                ExportAsPrompt.this.convert_xml_checkbox1.setText(Dictionary.get("ExportAsPrompt.ApplyXSL", (String)ExportAsPrompt.this.plugoutMap.get(string)));
                if (string.equals("MARCXML")) {
                    ExportAsPrompt.this.convert_xml_pane.add(ExportAsPrompt.this.mapping_xml_pane);
                    ExportAsPrompt.this.convert_xml_pane.add(ExportAsPrompt.this.output_single_checkbox);
                }
            } else {
                String[] stringArray = ((String)ExportAsPrompt.this.plugoutMap.get(string)).split(",");
                ExportAsPrompt.this.convert_xml_checkbox1.setText(Dictionary.get("ExportAsPrompt.ApplyXSL", stringArray[0]));
                ExportAsPrompt.this.convert_xml_checkbox2.setText(Dictionary.get("ExportAsPrompt.ApplyXSL", stringArray[1]));
                ExportAsPrompt.this.convert_xml_pane.add(ExportAsPrompt.this.convert_xml_pane2);
            }
            ExportAsPrompt.this.convert_xml_pane.revalidate();
            ExportAsPrompt.this.convert_xml_pane.repaint();
            ExportAsPrompt.this.instructions_pane.revalidate();
            ExportAsPrompt.this.instructions_pane.repaint();
        }
    }

    private class ConvertXMLCheckboxListener
    implements ActionListener {
        private ConvertXMLCheckboxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExportAsPrompt.this.convert_xml_button1.setEnabled(ExportAsPrompt.this.convert_xml_checkbox1.isSelected());
            ExportAsPrompt.this.convert_xml_field1.setEnabled(ExportAsPrompt.this.convert_xml_checkbox1.isSelected());
            ExportAsPrompt.this.convert_xml_button2.setEnabled(ExportAsPrompt.this.convert_xml_checkbox2.isSelected());
            ExportAsPrompt.this.convert_xml_field2.setEnabled(ExportAsPrompt.this.convert_xml_checkbox2.isSelected());
            ExportAsPrompt.this.convert_xml_button3.setEnabled(ExportAsPrompt.this.mapping_xml_checkbox.isSelected());
            ExportAsPrompt.this.mapping_xml_field.setEnabled(ExportAsPrompt.this.mapping_xml_checkbox.isSelected());
        }
    }

    private class OKButtonListener
    implements ActionListener {
        private Component glass_pane;
        private MouseListener mouse_blocker_listener;
        private ProgressDialog progress_dialog;

        private OKButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExportAsPrompt.this.selected_collection = (BasicCollectionConfiguration)ExportAsPrompt.this.list.getSelectedValue();
            ExportAsPrompt.this.error_message = new StringBuffer();
            this.glass_pane = ExportAsPrompt.this.getGlassPane();
            this.mouse_blocker_listener = new MouseAdapter(){};
            this.glass_pane.addMouseListener(this.mouse_blocker_listener);
            this.glass_pane.setCursor(Cursor.getPredefinedCursor(3));
            this.glass_pane.setVisible(true);
            ExportAsPrompt.this.exportAsCollections();
            this.progress_dialog = new ProgressDialog();
            this.progress_dialog.setVisible(true);
        }

        public void processComplete() {
            Gatherer.invokeInEDT_replacesProceedInCurrThread("ExportAsPrompt.processComplete()", false, new Runnable(){

                @Override
                public void run() {
                    OKButtonListener.this.progress_dialog.setVisible(false);
                    OKButtonListener.this.progress_dialog.dispose();
                    OKButtonListener.this.progress_dialog = null;
                    OKButtonListener.this.glass_pane.setVisible(false);
                    OKButtonListener.this.glass_pane.setCursor(Cursor.getPredefinedCursor(0));
                    OKButtonListener.this.glass_pane.removeMouseListener(OKButtonListener.this.mouse_blocker_listener);
                    OKButtonListener.this.glass_pane = null;
                    OKButtonListener.this.mouse_blocker_listener = null;
                    if (ExportAsPrompt.this.successful) {
                        ExportAsPrompt.this.resultPrompt(true, ExportAsPrompt.this.error_message.toString());
                    } else {
                        ExportAsPrompt.this.resultPrompt(false, ExportAsPrompt.this.error_message.toString());
                    }
                    ExportAsPrompt.this.error_message = null;
                    ExportAsPrompt.this.convert_xml_button1.setEnabled(false);
                    ExportAsPrompt.this.xsl_file1 = null;
                    ExportAsPrompt.this.convert_xml_field1.setText("");
                    ExportAsPrompt.this.convert_xml_checkbox1.setSelected(false);
                    ExportAsPrompt.this.convert_xml_button2.setEnabled(false);
                    ExportAsPrompt.this.xsl_file2 = null;
                    ExportAsPrompt.this.convert_xml_field2.setText("");
                    ExportAsPrompt.this.convert_xml_checkbox2.setSelected(false);
                    ExportAsPrompt.this.mapping_xml_checkbox.setSelected(false);
                    ExportAsPrompt.this.output_single_checkbox.setSelected(false);
                    ExportAsPrompt.this.convert_xml_button3.setEnabled(false);
                    ExportAsPrompt.this.mapping_xml_field.setText("");
                    ExportAsPrompt.this.mapping_file = null;
                }
            });
        }

        private class ProgressDialog
        extends ModalDialog {
            private Dimension size;

            public ProgressDialog() {
                super(Gatherer.g_man, Dictionary.get("ExportAsPrompt.Title"), true);
                this.size = new Dimension(400, 110);
                this.setDefaultCloseOperation(0);
                this.setSize(this.size);
                JPanel jPanel = (JPanel)this.getContentPane();
                JLabel jLabel = new JLabel(Dictionary.get("ExportAsPrompt.Progress_Label"));
                JProgressBar jProgressBar = new JProgressBar();
                jProgressBar.setIndeterminate(true);
                jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                GLIButton gLIButton = new GLIButton(Dictionary.get("ExportAsPrompt.Cancel"), Dictionary.get("ExportAsPrompt.Cancel_Tooltip"));
                gLIButton.setMnemonic(67);
                gLIButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ExportAsPrompt.this.cancelExporting();
                    }
                });
                JPanel jPanel2 = new JPanel(new FlowLayout(1, 0, 0));
                jPanel2.add(gLIButton);
                jPanel.setLayout(new BorderLayout(0, 5));
                jPanel.add((Component)jLabel, "North");
                jPanel.add((Component)jProgressBar, "Center");
                jPanel.add((Component)jPanel2, "South");
                Rectangle rectangle = Gatherer.g_man.getBounds();
                this.setLocation(rectangle.x + (rectangle.width - this.size.width) / 2, rectangle.y + (rectangle.height - this.size.height) / 2);
            }
        }
    }

    private class CollectionListListener
    implements ListSelectionListener {
        private CollectionListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ExportAsPrompt.this.list.isSelectionEmpty()) {
                ExportAsPrompt.this.details_textarea.setText(Dictionary.get("DeleteCollectionPrompt.No_Collection"));
                ExportAsPrompt.this.ok_button.setEnabled(false);
            } else {
                BasicCollectionConfiguration basicCollectionConfiguration = (BasicCollectionConfiguration)ExportAsPrompt.this.list.getSelectedValue();
                ExportAsPrompt.access$1102(ExportAsPrompt.this, new String[3]);
                ((ExportAsPrompt)ExportAsPrompt.this).args[0] = basicCollectionConfiguration.getCreator();
                ((ExportAsPrompt)ExportAsPrompt.this).args[1] = basicCollectionConfiguration.getMaintainer();
                ((ExportAsPrompt)ExportAsPrompt.this).args[2] = basicCollectionConfiguration.getDescription();
                ExportAsPrompt.this.details_textarea.setText(Dictionary.get("DeleteCollectionPrompt.Details", ExportAsPrompt.this.args));
                ExportAsPrompt.this.details_textarea.setCaretPosition(0);
                ExportAsPrompt.this.ok_button.setEnabled(true);
            }
        }
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExportAsPrompt.this.prompt.dispose();
        }
    }
}

