/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.file.FileQueue;
import org.greenstone.gatherer.file.RecycleBin;
import org.greenstone.gatherer.file.WorkspaceTree;
import org.greenstone.gatherer.gui.Filter;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.GProgressBar;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.gui.tree.DragTree;
import org.greenstone.gatherer.util.DragGroup;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.Utility;

public class GatherPane
extends JPanel
implements ActionListener {
    private CardLayout card_layout = null;
    private JPanel card_pane = null;
    private String COLLECTION_LOADED_CARD = "";
    private String NO_COLLECTION_LOADED_CARD = "No collection loaded";
    private DragGroup group = null;
    private DragTree collection_tree = null;
    private FileQueue file_queue = null;
    private Filter collection_filter = null;
    private Filter workspace_filter = null;
    private JButton stop_action = null;
    private JButton new_folder = null;
    private JButton new_file = null;
    private JPanel button_pane = null;
    private JLabel collection_label = null;
    private JLabel filename_label = null;
    private JLabel status_label = null;
    private JLabel workspace_label = null;
    private JPanel collection_pane = null;
    private JPanel control_pane = null;
    private JPanel workspace_pane = null;
    private JScrollPane collection_scroll = null;
    private JScrollPane workspace_scroll = null;
    private JSplitPane tree_pane = null;
    private static Dimension MIN_SIZE = new Dimension(90, 90);
    private static Dimension STATUS_SIZE = new Dimension(450, 120);
    private static Dimension TREE_SIZE = new Dimension(400, 430);
    public WorkspaceTree workspace_tree = null;
    private int pane_mode = Utility.IMPORT_MODE;

    public GatherPane(int n) {
        this.pane_mode = n;
        this.group = new DragGroup();
        this.file_queue = Gatherer.f_man.getQueue();
        this.setComponentOrientation(Dictionary.getOrientation());
        this.stop_action = new GLIButton(Dictionary.get("Collection.Stop"), Dictionary.get("Collection.Stop_Tooltip"));
        this.stop_action.addActionListener(this);
        this.stop_action.setEnabled(false);
        this.file_queue.registerStopButton(this.stop_action);
        this.new_folder = new GLIButton(JarTools.getImage("new-folder.png"), Dictionary.get("Collection.New_Folder_Tooltip"));
        this.new_folder.addActionListener(this);
        this.new_folder.setEnabled(false);
        this.new_folder.setMinimumSize(MIN_SIZE);
        this.new_folder.setPreferredSize(MIN_SIZE);
        this.new_file = new GLIButton(JarTools.getImage("file-upload.png"), Dictionary.get("Collection.New_File_Tooltip"));
        this.new_file.addActionListener(this);
        this.new_file.setEnabled(false);
        this.new_file.setMinimumSize(MIN_SIZE);
        this.new_file.setPreferredSize(MIN_SIZE);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == Gatherer.recycle_bin) {
            DragTree dragTree;
            if (!Gatherer.recycle_bin.ignore() && (dragTree = (DragTree)this.group.getActive()) != null) {
                this.group.setSource(dragTree);
                TreePath[] treePathArray = dragTree.getSelectionPaths();
                if (treePathArray != null) {
                    FileNode[] fileNodeArray = new FileNode[treePathArray.length];
                    for (int i = 0; i < treePathArray.length; ++i) {
                        fileNodeArray[i] = (FileNode)treePathArray[i].getLastPathComponent();
                    }
                    Gatherer.f_man.action(dragTree, fileNodeArray, Gatherer.recycle_bin, null);
                }
            }
        } else if ((actionEvent.getSource() == this.new_folder || actionEvent.getSource() == this.new_file) && this.collection_tree != null) {
            Object object;
            boolean bl = false;
            if (actionEvent.getSource() == this.new_folder) {
                bl = true;
            }
            int n = this.collection_tree.getSelectionCount();
            boolean bl2 = false;
            if (n == 1) {
                object = this.collection_tree.getSelectionPath();
                FileNode fileNode = (FileNode)((TreePath)object).getLastPathComponent();
                if (fileNode.getAllowsChildren()) {
                    if (bl) {
                        Gatherer.f_man.newFolder(this.collection_tree, fileNode);
                    } else {
                        Gatherer.f_man.newCollectionFile(this.collection_tree, fileNode);
                    }
                } else {
                    FileNode fileNode2 = (FileNode)fileNode.getParent();
                    if (fileNode2 != null && fileNode2.getAllowsChildren()) {
                        if (bl) {
                            Gatherer.f_man.newFolder(this.collection_tree, fileNode2);
                        } else {
                            Gatherer.f_man.newCollectionFile(this.collection_tree, fileNode2);
                        }
                    } else {
                        bl2 = true;
                    }
                }
            } else {
                bl2 = true;
            }
            if (bl2) {
                object = (FileNode)this.collection_tree.getModel().getRoot();
                if (bl) {
                    Gatherer.f_man.newFolder(this.collection_tree, (FileNode)object);
                } else {
                    Gatherer.f_man.newCollectionFile(this.collection_tree, (FileNode)object);
                }
            }
        } else if (actionEvent.getSource() == this.stop_action) {
            this.file_queue.cancelAction();
        }
    }

    public void display() {
        JLabel jLabel;
        JPanel jPanel;
        JComponent jComponent;
        JPanel jPanel2;
        this.workspace_pane = new JPanel();
        this.workspace_pane.setMinimumSize(MIN_SIZE);
        this.workspace_pane.setPreferredSize(TREE_SIZE);
        this.workspace_pane.setSize(TREE_SIZE);
        this.workspace_pane.setComponentOrientation(Dictionary.getOrientation());
        this.workspace_label = new JLabel(Dictionary.get("Collection.Workspace"));
        this.workspace_label.setOpaque(true);
        this.workspace_label.setBackground(Configuration.getColor("coloring.workspace_heading_background", false));
        this.workspace_label.setForeground(Configuration.getColor("coloring.workspace_heading_foreground", false));
        this.workspace_label.setComponentOrientation(Dictionary.getOrientation());
        this.workspace_tree = new WorkspaceTree(this.pane_mode);
        this.workspace_tree.setComponentOrientation(Dictionary.getOrientation());
        this.group.add(this.workspace_tree);
        this.workspace_scroll = new JScrollPane(this.workspace_tree);
        this.workspace_scroll.setComponentOrientation(Dictionary.getOrientation());
        this.workspace_filter = this.workspace_tree.getFilter();
        this.workspace_filter.setComponentOrientation(Dictionary.getOrientation());
        this.collection_pane = new JPanel();
        this.collection_pane.setMinimumSize(MIN_SIZE);
        this.collection_pane.setPreferredSize(TREE_SIZE);
        this.collection_pane.setSize(TREE_SIZE);
        this.collection_pane.setComponentOrientation(Dictionary.getOrientation());
        this.collection_label = new JLabel(Dictionary.get("Collection.Collection"));
        this.collection_label.setOpaque(true);
        this.collection_label.setComponentOrientation(Dictionary.getOrientation());
        if (this.pane_mode == Utility.IMPORT_MODE) {
            this.collection_tree = Gatherer.c_man.getCollectionTree();
            this.collection_tree.setEnabled(Gatherer.c_man.getCollectionTreeModel() != null);
        } else {
            this.collection_tree = Gatherer.c_man.getFullCollectionTree();
            this.collection_tree.setEnabled(Gatherer.c_man.getFullCollectionTreeModel() != null);
        }
        this.group.add(this.collection_tree);
        this.collection_filter = this.collection_tree.getFilter();
        this.tree_pane = new JSplitPane(1);
        this.tree_pane.setComponentOrientation(Dictionary.getOrientation());
        if (this.pane_mode == Utility.IMPORT_MODE) {
            this.card_layout = new CardLayout();
            jPanel2 = new JPanel();
            jPanel2.setBackground(Color.lightGray);
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            jComponent = new JLabel(Dictionary.get("Collection.Collection"));
            jComponent.setBackground(Color.lightGray);
            jComponent.setForeground(Color.black);
            jComponent.setOpaque(true);
            jComponent.setComponentOrientation(Dictionary.getOrientation());
            jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            jPanel.setBackground(Color.lightGray);
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            jLabel = new JLabel(Dictionary.get("Collection.No_Collection_Loaded"));
            jLabel.setHorizontalAlignment(0);
            jLabel.setVerticalAlignment(0);
            jLabel.setComponentOrientation(Dictionary.getOrientation());
            this.card_pane = new JPanel();
            this.card_pane.setComponentOrientation(Dictionary.getOrientation());
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jLabel, "Center");
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jComponent, "North");
            jPanel2.add((Component)jPanel, "Center");
            this.card_pane.setLayout(this.card_layout);
            this.card_pane.add((Component)jPanel2, this.NO_COLLECTION_LOADED_CARD);
            this.card_pane.add((Component)this.collection_pane, this.COLLECTION_LOADED_CARD);
        }
        this.control_pane = new JPanel();
        this.control_pane.setComponentOrientation(Dictionary.getOrientation());
        jPanel2 = new JPanel();
        jPanel2.setSize(STATUS_SIZE);
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jComponent = new JPanel();
        jComponent.setComponentOrientation(Dictionary.getOrientation());
        jPanel = new JPanel();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jLabel = this.file_queue.getFileStatus();
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        GProgressBar gProgressBar = this.file_queue.getProgressBar();
        gProgressBar.setComponentOrientation(Dictionary.getOrientation());
        this.button_pane = new JPanel();
        this.button_pane.setComponentOrientation(Dictionary.getOrientation());
        RecycleBin recycleBin = null;
        if (this.pane_mode == Utility.IMPORT_MODE) {
            recycleBin = Gatherer.recycle_bin;
            recycleBin.addActionListener(this);
            recycleBin.setMinimumSize(MIN_SIZE);
            recycleBin.setPreferredSize(MIN_SIZE);
            recycleBin.setToolTipText(Dictionary.get("Collection.Delete_Tooltip"));
            this.group.add(recycleBin);
        }
        this.workspace_pane.setLayout(new BorderLayout());
        this.workspace_pane.add((Component)this.workspace_label, "North");
        this.workspace_pane.add((Component)this.workspace_scroll, "Center");
        this.workspace_pane.add((Component)this.workspace_filter, "South");
        this.collection_pane.setLayout(new BorderLayout());
        this.collection_pane.add((Component)this.collection_label, "North");
        if (Dictionary.getOrientation().isLeftToRight()) {
            this.tree_pane.add((Component)this.workspace_pane, "left");
            if (this.pane_mode == Utility.IMPORT_MODE) {
                this.tree_pane.add((Component)this.card_pane, "right");
            } else {
                this.tree_pane.add((Component)this.collection_pane, "right");
            }
        } else {
            this.tree_pane.add((Component)this.workspace_pane, "right");
            if (this.pane_mode == Utility.IMPORT_MODE) {
                this.tree_pane.add((Component)this.card_pane, "left");
            } else {
                this.tree_pane.add((Component)this.collection_pane, "left");
            }
        }
        this.tree_pane.setDividerLocation(GatherPane.TREE_SIZE.width - 10);
        jComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jComponent.setLayout(new BorderLayout());
        jComponent.add((Component)jLabel, "Center");
        jComponent.add((Component)this.stop_action, "After");
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)gProgressBar, "Center");
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createLoweredBevelBorder()));
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(jComponent);
        jPanel2.add(jPanel);
        this.button_pane.add(this.new_folder);
        this.button_pane.add(this.new_file);
        if (this.pane_mode == Utility.IMPORT_MODE) {
            this.button_pane.add(recycleBin);
        }
        this.control_pane.setLayout(new BorderLayout());
        this.control_pane.add((Component)jPanel2, "Center");
        this.control_pane.add((Component)this.button_pane, "After");
        this.setLayout(new BorderLayout());
        this.add((Component)this.tree_pane, "Center");
        this.add((Component)this.control_pane, "South");
        TestingPreparation.setNamesRecursively(this.collection_filter, "collection_filter");
    }

    public void gainFocus() {
        this.collection_scroll = new JScrollPane(this.collection_tree);
        this.collection_pane.add((Component)this.collection_scroll, "Center");
        this.collection_pane.add((Component)this.collection_filter, "South");
    }

    public void loseFocus() {
        this.collection_pane.remove(this.collection_scroll);
        this.collection_pane.remove(this.collection_filter);
    }

    private FileNode[] getCollectionTreeSelection() {
        TreePath[] treePathArray = this.collection_tree.getSelectionPaths();
        FileNode[] fileNodeArray = null;
        if (treePathArray != null) {
            fileNodeArray = new FileNode[treePathArray.length];
            for (int i = 0; i < fileNodeArray.length; ++i) {
                fileNodeArray[i] = (FileNode)treePathArray[i].getLastPathComponent();
            }
        }
        return fileNodeArray;
    }

    public void modeChanged(int n) {
        this.collection_filter.setEditable(n >= 2);
        this.workspace_filter.setEditable(n >= 2);
    }

    public void refresh(int n, boolean bl) {
        if (bl) {
            if (n == 0) {
                if (this.pane_mode == Utility.IMPORT_MODE) {
                    this.card_layout.show(this.card_pane, this.COLLECTION_LOADED_CARD);
                    this.collection_tree.setModel(Gatherer.c_man.getCollectionTreeModel());
                } else {
                    this.collection_tree.setModel(Gatherer.c_man.getFullCollectionTreeModel());
                }
            }
        } else {
            this.collection_tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("Error")));
            if (this.pane_mode == Utility.IMPORT_MODE) {
                this.card_layout.show(this.card_pane, this.NO_COLLECTION_LOADED_CARD);
            }
        }
        if (n == 3) {
            this.refreshWorkspaceTree(0);
            this.refreshCollectionTree(0);
        }
        this.collection_tree.setEnabled(bl);
        this.collection_filter.setEnabled(bl);
        this.new_folder.setEnabled(bl);
        this.new_file.setEnabled(bl);
    }

    public void refreshCollectionTree(int n) {
        this.collection_tree.refresh(null);
    }

    public void refreshWorkspaceTree(int n) {
        this.workspace_tree.refresh(n);
    }
}

