/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Collections;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.BasicCollectionConfiguration;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.Utility;

public class NewCollectionDetailsPrompt
extends ModalDialog {
    private boolean cancelled = true;
    private boolean collectDirChanged;
    private File base_final;
    private JButton chdir_button;
    private JButton create_button;
    private JComboBox base_collection;
    private JDialog self;
    private JRadioButton personal_collection_button = null;
    private JTextArea description;
    private JTextField title;
    private String collectBasePath;
    private String newCollectPath;
    private String description_final;
    private String title_final = "";
    private static Dimension COMPONENT_SIZE = new Dimension(230, 25);
    private static Dimension SIZE = new Dimension(600, 280);
    private static int FILENAME_SIZE = 8;

    public static boolean titleClashes(String string, String string2, File file) {
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        File file2 = new File(string);
        String string3 = Gatherer.GS3 ? Utility.CONFIG_GS3_FILE : Utility.CONFIG_FILE;
        File[] fileArray = file2.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            File file3 = new File(fileArray[i], string3);
            if (file == null || !file3.equals(file)) {
                BasicCollectionConfiguration basicCollectionConfiguration = new BasicCollectionConfiguration(file3);
                if (basicCollectionConfiguration.getName().equalsIgnoreCase(string2)) {
                    return true;
                }
                basicCollectionConfiguration = null;
            }
            file3 = null;
        }
        return false;
    }

    public NewCollectionDetailsPrompt() {
        super((Frame)Gatherer.g_man, true);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.self = this;
        this.newCollectPath = Gatherer.getCollectDirectoryPath();
        this.collectBasePath = null;
        this.collectDirChanged = false;
        this.setJMenuBar(new SimpleMenuBar("creatingacollection"));
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("NewCollectionPrompt.Title"));
        Vector vector = new Vector();
        this.setupBaseCollections(vector, null);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setOpaque(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel(Dictionary.get("NewCollectionPrompt.Instructions"));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel2 = new JLabel(Dictionary.get("CDM.General.Collection_Name"));
        jLabel2.setComponentOrientation(Dictionary.getOrientation());
        this.title = new JTextField();
        this.title.setComponentOrientation(Dictionary.getOrientation());
        this.title.setPreferredSize(COMPONENT_SIZE);
        this.title.setToolTipText(Dictionary.get("CDM.General.Collection_Name_Tooltip"));
        JLabel jLabel3 = new JLabel(Dictionary.get("NewCollectionPrompt.Collection_Name"));
        jLabel3.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel4 = new JPanel();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel5 = new JPanel();
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel4 = new JLabel(Dictionary.get("NewCollectionPrompt.Collection_Description"));
        jLabel4.setComponentOrientation(Dictionary.getOrientation());
        this.description = new JTextArea();
        this.description.setComponentOrientation(Dictionary.getOrientation());
        this.description.setBackground(Configuration.getColor("coloring.editable_background", false));
        this.description.setForeground(Configuration.getColor("coloring.editable_foreground", false));
        this.description.setRows(5);
        this.description.setToolTipText(Dictionary.get("CDM.General.Collection_Extra_Tooltip"));
        JPanel jPanel6 = new JPanel();
        jPanel6.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel7 = new JPanel();
        jPanel7.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel5 = new JLabel(Dictionary.get("NewCollectionPrompt.Base_Collection"));
        jLabel5.setComponentOrientation(Dictionary.getOrientation());
        this.base_collection = new JComboBox(vector);
        this.base_collection.setComponentOrientation(Dictionary.getOrientation());
        this.base_collection.setOpaque(false);
        this.base_collection.setToolTipText(Dictionary.get("NewCollectionPrompt.Base_Collection_Tooltip"));
        JPanel jPanel8 = new JPanel();
        jPanel8.setComponentOrientation(Dictionary.getOrientation());
        this.personal_collection_button = new JRadioButton(Dictionary.get("NewCollectionPrompt.Collection_Scope_Personal"));
        this.personal_collection_button.setToolTipText(Dictionary.get("NewCollectionPrompt.Collection_Scope_Personal_Tooltip"));
        this.personal_collection_button.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
        this.personal_collection_button.setOpaque(false);
        this.personal_collection_button.setComponentOrientation(Dictionary.getOrientation());
        JRadioButton jRadioButton = new JRadioButton(Dictionary.get("NewCollectionPrompt.Collection_Scope_Shared"));
        jRadioButton.setToolTipText(Dictionary.get("NewCollectionPrompt.Collection_Scope_Shared_Tooltip"));
        jRadioButton.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
        jRadioButton.setOpaque(false);
        jRadioButton.setComponentOrientation(Dictionary.getOrientation());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.personal_collection_button);
        buttonGroup.add(jRadioButton);
        jRadioButton.setSelected(true);
        JPanel jPanel9 = new JPanel();
        jPanel9.setComponentOrientation(Dictionary.getOrientation());
        this.create_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
        this.chdir_button = new GLIButton(Dictionary.get("General.CD"), Dictionary.get("General.CD_Tooltip"));
        GLIButton gLIButton = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
        this.chdir_button.addActionListener(new ChangeDirListener());
        if (Gatherer.isGsdlRemote || Gatherer.isWebswing) {
            this.chdir_button.setEnabled(false);
        } else {
            this.base_collection.addActionListener(new OtherCollectionsListener());
        }
        gLIButton.addActionListener(new CancelListener());
        this.create_button.addActionListener(new CreateListener());
        this.description.addKeyListener(new DescriptionListener());
        jPanel3.setLayout(new BorderLayout(5, 0));
        jPanel3.add((Component)jLabel2, "Before");
        jPanel3.add((Component)this.title, "Center");
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(jLabel);
        jPanel2.add(jPanel3);
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jLabel4, "North");
        JScrollPane jScrollPane = new JScrollPane(this.description);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel5.add((Component)jScrollPane, "Center");
        jPanel7.setLayout(new BorderLayout(5, 0));
        jPanel7.add((Component)jLabel5, "Before");
        jPanel7.add((Component)this.base_collection, "Center");
        jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel8.setLayout(new GridLayout(1, 2));
        jPanel8.add(this.personal_collection_button);
        jPanel8.add(jRadioButton);
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel5, "Center");
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)jPanel7, "North");
        if (Gatherer.isGsdlRemote || Gatherer.isWebswing) {
            jPanel6.add((Component)jPanel8, "Center");
            jPanel6.add((Component)jPanel9, "South");
        } else {
            jPanel6.add((Component)jPanel9, "Center");
        }
        if (Gatherer.isWebswing) {
            if (!Gatherer.webswingAuthenticator.canEditSharedCollections()) {
                jRadioButton.setEnabled(false);
                this.personal_collection_button.setSelected(true);
            }
            if (!Gatherer.webswingAuthenticator.canEditPersonalCollections()) {
                this.personal_collection_button.setEnabled(false);
                jRadioButton.setSelected(true);
            }
        }
        jPanel9.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel9.setLayout(new GridLayout(1, 3));
        jPanel9.add(this.create_button);
        jPanel9.add(this.chdir_button);
        jPanel9.add(gLIButton);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel4, "Center");
        jPanel.add((Component)jPanel6, "South");
        this.getRootPane().setDefaultButton(this.create_button);
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - NewCollectionDetailsPrompt.SIZE.width) / 2, (dimension.height - NewCollectionDetailsPrompt.SIZE.height) / 2);
        TestingPreparation.setNamesRecursively(this);
        this.setVisible(true);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public File getBase() {
        return this.base_final;
    }

    public String getDescription() {
        return this.description_final;
    }

    @Override
    public String getName() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        for (n = 0; n < this.title_final.length() && n2 < 8; ++n) {
            char c = this.title_final.charAt(n);
            if (c >= '\u0080' || !Character.isLetterOrDigit(c)) continue;
            stringBuffer.append(Character.toLowerCase(c));
            ++n2;
        }
        if (stringBuffer.length() == 0) {
            stringBuffer = new StringBuffer("col");
        }
        if (Gatherer.isGsdlRemote && this.personal_collection_button.isSelected()) {
            stringBuffer = new StringBuffer(Gatherer.remoteGreenstoneServer.getUsername() + "@" + stringBuffer.toString());
        } else if (Gatherer.isWebswing && this.personal_collection_button.isSelected()) {
            stringBuffer = new StringBuffer(Gatherer.webswingAuthenticator.getUsername() + "@" + stringBuffer.toString());
        }
        n = 0;
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
        while (this.filenameClashes(stringBuffer2.toString())) {
            String string;
            stringBuffer2 = new StringBuffer(stringBuffer.toString());
            if ((string = String.valueOf(++n)).length() + stringBuffer2.length() > 8) {
                stringBuffer2.replace(stringBuffer2.length() - string.length(), stringBuffer2.length(), string);
                continue;
            }
            stringBuffer2.append(string);
        }
        return stringBuffer2.toString();
    }

    private boolean filenameClashes(String string) {
        File file = new File(Gatherer.getCollectDirectoryPath());
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTitle() {
        return this.title_final;
    }

    private void setupBaseCollections(Vector vector, String string) {
        File file = null;
        if (string != null) {
            file = new File(string);
        }
        if (Gatherer.GS3 && !Gatherer.isGsdlRemote && !Gatherer.isWebswing) {
            File file2 = new File(Gatherer.getSitesDirectoryPath());
            File[] fileArray = file2.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (file == null) {
                    file = new File(file2 + File.separator + fileArray[i].getName() + File.separator + "collect");
                }
                if (file.exists()) {
                    this.addCollectionsToModel(vector, file, fileArray[i].getName());
                }
                file = null;
            }
        } else {
            if (file == null) {
                file = new File(Gatherer.getCollectDirectoryPath());
            }
            this.addCollectionsToModel(vector, file, null);
        }
        Collections.sort(vector);
        vector.add(0, new Item(null, Dictionary.get("NewCollectionPrompt.NewCollection")));
        if (!Gatherer.isGsdlRemote && !Gatherer.isWebswing) {
            vector.add(new Item(null, Dictionary.get("NewCollectionPrompt.OtherCollections")));
        }
    }

    private void addCollectionsToModel(Vector vector, File file, String string) {
        File[] fileArray = file.listFiles();
        String string2 = Gatherer.GS3 ? Utility.CONFIG_GS3_FILE : Utility.CONFIG_FILE;
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            Item item;
            File file2 = new File(fileArray[i], string2);
            if (!file2.exists()) continue;
            BasicCollectionConfiguration basicCollectionConfiguration = new BasicCollectionConfiguration(file2);
            if (basicCollectionConfiguration.getCollectGroup().equals("true")) {
                this.addCollectionsToModel(vector, fileArray[i], string);
                continue;
            }
            File file3 = new File(fileArray[i], "metadata");
            if (!file3.exists()) continue;
            BasicCollectionConfiguration basicCollectionConfiguration2 = new BasicCollectionConfiguration(file2);
            if (Gatherer.GS3 && string != null) {
                basicCollectionConfiguration2.setSite(string);
            }
            if (vector.contains(item = new Item(fileArray[i], basicCollectionConfiguration2))) continue;
            vector.add(item);
        }
    }

    private class CollectionFileView
    extends FileView {
        final String configfile_name;
        final ImageIcon COLLECTION_ICON = JarTools.getImage("gsCollection.gif", true);
        private File previous = null;
        private boolean previousWasCollection = false;

        public CollectionFileView() {
            this.configfile_name = Gatherer.GS3 ? Utility.CONFIG_GS3_FILE : Utility.CONFIG_FILE;
        }

        @Override
        public String getDescription(File file) {
            if (!file.equals(this.previous)) {
                this.previous = file;
                this.previousWasCollection = false;
            }
            return null;
        }

        @Override
        public Icon getIcon(File file) {
            if (file.equals(this.previous) && this.previousWasCollection) {
                return this.COLLECTION_ICON;
            }
            if (this.isCollectionBase(file)) {
                return this.COLLECTION_ICON;
            }
            return null;
        }

        @Override
        public String getName(File file) {
            if (!file.equals(this.previous)) {
                this.previous = file;
                this.previousWasCollection = false;
            }
            return file.getName();
        }

        @Override
        public String getTypeDescription(File file) {
            if (file.equals(this.previous) && this.previousWasCollection) {
                return "collection";
            }
            if (this.isCollectionBase(file)) {
                return "collection";
            }
            return "not a collection";
        }

        @Override
        public Boolean isTraversable(File file) {
            if (file.equals(this.previous) && this.previousWasCollection) {
                return Boolean.FALSE;
            }
            if (this.isCollectionBase(file)) {
                return Boolean.FALSE;
            }
            if (file.isFile()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        private boolean isCollectionBase(File file) {
            BasicCollectionConfiguration basicCollectionConfiguration;
            File file2;
            this.previous = file;
            this.previousWasCollection = false;
            if (!file.isFile() && (file2 = new File(file, this.configfile_name)).exists() && !(basicCollectionConfiguration = new BasicCollectionConfiguration(file2)).getCollectGroup().equals("true")) {
                this.previousWasCollection = true;
            }
            return this.previousWasCollection;
        }
    }

    private class CollectionFileFilter
    extends FileFilter {
        private CollectionFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "greenstone collection view";
        }
    }

    private class Item
    implements Comparable {
        private BasicCollectionConfiguration config;
        private File file;
        private String name;

        public Item(File file, BasicCollectionConfiguration basicCollectionConfiguration) {
            this.config = basicCollectionConfiguration;
            this.file = file;
            this.name = null;
        }

        public Item(File file, String string) {
            this.config = null;
            this.file = file;
            this.name = string;
        }

        public int compareTo(Object object) {
            if (this == null && object == null) {
                return 0;
            }
            if (object == null) {
                return 1;
            }
            if (this == null) {
                return -1;
            }
            return this.toString().toLowerCase().compareTo(object.toString().toLowerCase());
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public File getFile() {
            return this.file;
        }

        public String toString() {
            if (this.name == null && this.config != null) {
                this.name = this.config.toString();
            }
            return this.name;
        }
    }

    private class DescriptionListener
    extends KeyAdapter {
        private DescriptionListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 9) {
                keyEvent.consume();
                NewCollectionDetailsPrompt.this.base_collection.grabFocus();
            }
        }
    }

    private class CreateListener
    implements ActionListener {
        private CreateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            NewCollectionDetailsPrompt.this.title_final = NewCollectionDetailsPrompt.this.title.getText();
            if (NewCollectionDetailsPrompt.this.title_final.length() == 0) {
                JOptionPane jOptionPane = new JOptionPane();
                jOptionPane.setComponentOrientation(Dictionary.getOrientation());
                jOptionPane.setOpaque(!Utility.isMac());
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("NewCollectionPrompt.Title_Error"), Dictionary.get("NewCollectionPrompt.Error"), 0);
                return;
            }
            Object object2 = object = NewCollectionDetailsPrompt.this.collectDirChanged ? NewCollectionDetailsPrompt.this.newCollectPath : Gatherer.getCollectDirectoryPath();
            if (NewCollectionDetailsPrompt.titleClashes((String)object, NewCollectionDetailsPrompt.this.title_final, null)) {
                JOptionPane jOptionPane = new JOptionPane();
                jOptionPane.setComponentOrientation(Dictionary.getOrientation());
                jOptionPane.setOpaque(!Utility.isMac());
                if (JOptionPane.showConfirmDialog(Gatherer.g_man, Dictionary.get("NewCollectionPrompt.Title_Clash"), Dictionary.get("General.Warning"), 0) == 1) {
                    return;
                }
            }
            NewCollectionDetailsPrompt.this.description_final = NewCollectionDetailsPrompt.this.description.getText();
            object = (Item)NewCollectionDetailsPrompt.this.base_collection.getSelectedItem();
            NewCollectionDetailsPrompt.this.base_final = ((Item)object).getFile();
            NewCollectionDetailsPrompt.this.cancelled = false;
            NewCollectionDetailsPrompt.this.self.dispose();
            if (NewCollectionDetailsPrompt.this.collectDirChanged) {
                Gatherer.collectDirectoryHasChanged(Gatherer.getCollectDirectoryPath(), NewCollectionDetailsPrompt.this.newCollectPath, Gatherer.g_man.getContentPane());
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NewCollectionDetailsPrompt.this.cancelled = true;
            NewCollectionDetailsPrompt.this.self.dispose();
        }
    }

    private class ChangeDirListener
    implements ActionListener {
        private ChangeDirListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = NewCollectionDetailsPrompt.this.newCollectPath;
            JFileChooser jFileChooser = new JFileChooser(NewCollectionDetailsPrompt.this.newCollectPath);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle(Dictionary.get("General.ChooseCollectDirectory"));
            int n = jFileChooser.showOpenDialog(NewCollectionDetailsPrompt.this);
            if (n == 0) {
                NewCollectionDetailsPrompt.this.newCollectPath = jFileChooser.getSelectedFile().getAbsolutePath() + File.separator;
                NewCollectionDetailsPrompt.this.collectDirChanged = !NewCollectionDetailsPrompt.this.newCollectPath.equals(string);
            }
        }
    }

    private class OtherCollectionsListener
    implements ActionListener {
        private OtherCollectionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (NewCollectionDetailsPrompt.this.base_collection.getSelectedIndex() == NewCollectionDetailsPrompt.this.base_collection.getItemCount() - 1) {
                if (NewCollectionDetailsPrompt.this.collectBasePath == null) {
                    NewCollectionDetailsPrompt.this.collectBasePath = NewCollectionDetailsPrompt.this.newCollectPath;
                }
                JFileChooser jFileChooser = new JFileChooser(NewCollectionDetailsPrompt.this.collectBasePath);
                jFileChooser.setFileView(new CollectionFileView());
                jFileChooser.setDialogTitle(Dictionary.get("NewCollectionPrompt.ChooseACollection"));
                jFileChooser.setApproveButtonText(Dictionary.get("NewCollectionPrompt.Select"));
                jFileChooser.setFileSelectionMode(2);
                jFileChooser.setFileFilter(new CollectionFileFilter());
                jFileChooser.setAcceptAllFileFilterUsed(false);
                int n = jFileChooser.showOpenDialog(NewCollectionDetailsPrompt.this);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    if (NewCollectionDetailsPrompt.this.collectBasePath.equals(file.getAbsolutePath() + File.separator)) {
                        NewCollectionDetailsPrompt.this.base_collection.setSelectedIndex(0);
                    } else {
                        String string = Gatherer.GS3 ? Utility.CONFIG_GS3_FILE : Utility.CONFIG_FILE;
                        boolean bl = false;
                        while (new File(file, string).exists()) {
                            file = file.getParentFile();
                            bl = true;
                        }
                        NewCollectionDetailsPrompt.this.collectBasePath = file.getAbsolutePath() + File.separator;
                        NewCollectionDetailsPrompt.this.base_collection.removeAllItems();
                        Vector vector = new Vector();
                        NewCollectionDetailsPrompt.this.setupBaseCollections(vector, NewCollectionDetailsPrompt.this.collectBasePath);
                        for (int i = 0; i < vector.size(); ++i) {
                            Item item = (Item)vector.get(i);
                            NewCollectionDetailsPrompt.this.base_collection.addItem(item);
                            if (!bl || !jFileChooser.getSelectedFile().equals(item.getFile())) continue;
                            NewCollectionDetailsPrompt.this.base_collection.setSelectedIndex(i);
                        }
                        if (!bl && NewCollectionDetailsPrompt.this.base_collection.getSelectedIndex() == NewCollectionDetailsPrompt.this.base_collection.getItemCount() - 1) {
                            NewCollectionDetailsPrompt.this.base_collection.setSelectedIndex(0);
                        }
                    }
                } else {
                    NewCollectionDetailsPrompt.this.base_collection.setSelectedIndex(0);
                }
            }
        }
    }
}

