/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.BasicCollectionConfiguration;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.greenstone.LocalGreenstone;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.gui.SimpleResultDialog;
import org.greenstone.gatherer.shell.GShell;
import org.greenstone.gatherer.shell.GShellEvent;
import org.greenstone.gatherer.shell.GShellListener;
import org.greenstone.gatherer.util.ArrayTools;
import org.greenstone.gatherer.util.CheckList;
import org.greenstone.gatherer.util.CheckListEntry;
import org.greenstone.gatherer.util.Utility;

public class WriteCDImagePrompt
extends ModalDialog
implements GShellListener {
    private OKButtonListener ok_button_listener;
    private ArrayList all_collections = null;
    private ArrayList selected_collections = null;
    private CheckList list = null;
    private BasicCollectionConfiguration collection = null;
    private WriteCDImagePrompt prompt = null;
    private JButton cancel_button = null;
    private JButton ok_button = null;
    private JLabel details_label = null;
    private JLabel list_label = null;
    private JTextArea details_textarea = null;
    private JTextArea instructions_textarea;
    private JRadioButton noinstall_button = null;
    private JRadioButton install_button = null;
    private JTextField title_field = null;
    private JTextField estimated_size_field = null;
    private JLabel title_label = null;
    private JLabel estimated_size_label = null;
    private String[] args = null;
    private String cd_title = null;
    private boolean successful = false;
    private boolean exporting = false;
    private StringBuffer error_message = null;
    private long total_exported_size = 14000000L;
    public static final Dimension SIZE = new Dimension(500, 500);

    public WriteCDImagePrompt() {
        super((Frame)Gatherer.g_man, true);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.cancel_button = new GLIButton(Dictionary.get("General.Close"), Dictionary.get("General.Close_Tooltip"));
        this.details_textarea = new JTextArea(Dictionary.get("DeleteCollectionPrompt.No_Collection"));
        this.details_textarea.setComponentOrientation(Dictionary.getOrientation());
        this.details_textarea.setEditable(false);
        this.details_label = new JLabel(Dictionary.get("DeleteCollectionPrompt.Collection_Details"));
        this.details_label.setComponentOrientation(Dictionary.getOrientation());
        this.instructions_textarea = new JTextArea(Dictionary.get("WriteCDImagePrompt.Instructions"));
        this.instructions_textarea.setComponentOrientation(Dictionary.getOrientation());
        this.instructions_textarea.setCaretPosition(0);
        this.instructions_textarea.setEditable(false);
        this.instructions_textarea.setLineWrap(true);
        this.instructions_textarea.setRows(4);
        this.instructions_textarea.setWrapStyleWord(true);
        this.all_collections = new ArrayList();
        this.list = new CheckList(true);
        this.list_label = new JLabel(Dictionary.get("DeleteCollectionPrompt.Collection_List"));
        this.list_label.setComponentOrientation(Dictionary.getOrientation());
        this.ok_button = new GLIButton(Dictionary.get("WriteCDImagePrompt.Export"), Dictionary.get("WriteCDImagePrompt.Export_Tooltip"));
        this.title_field = new JTextField();
        this.title_field.setComponentOrientation(Dictionary.getOrientation());
        this.title_label = new JLabel(Dictionary.get("WriteCDImagePrompt.CD_Name"));
        this.title_label.setComponentOrientation(Dictionary.getOrientation());
        this.estimated_size_field = new JTextField();
        this.estimated_size_field.setComponentOrientation(Dictionary.getOrientation());
        this.estimated_size_field.setEditable(false);
        this.total_exported_size += this.getFileSize(new File(LocalGreenstone.getDirectoryPath() + File.separator + "images"));
        this.estimated_size_field.setText(Utility.formatFileLength(this.total_exported_size));
        this.estimated_size_field.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
        this.estimated_size_label = new JLabel(Dictionary.get("WriteCDImagePrompt.Size_Label"));
        this.estimated_size_label.setComponentOrientation(Dictionary.getOrientation());
        this.scanForCollections();
        this.list.setListData(this.all_collections);
        this.prompt = this;
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("WriteCDImagePrompt.Export"));
        this.setJMenuBar(new SimpleMenuBar("exportingcollections"));
        this.cancel_button.addActionListener(new CancelButtonListener());
        this.list.addListSelectionListener(new CollectionListListener());
        this.list.clearSelection();
        this.list.getSelectionModel().setSelectionMode(0);
        this.ok_button_listener = new OKButtonListener();
        this.ok_button.addActionListener(this.ok_button_listener);
        this.ok_button.setEnabled(false);
        this.noinstall_button = new JRadioButton(Dictionary.get("WriteCDImagePrompt.NoInstall"));
        this.noinstall_button.setToolTipText(Dictionary.get("WriteCDImagePrompt.NoInstall_Tooltip"));
        this.noinstall_button.setComponentOrientation(Dictionary.getOrientation());
        this.install_button = new JRadioButton(Dictionary.get("WriteCDImagePrompt.Install"));
        this.install_button.setToolTipText(Dictionary.get("WriteCDImagePrompt.Install_Tooltip"));
        this.install_button.setComponentOrientation(Dictionary.getOrientation());
    }

    public void destroy() {
        this.all_collections.clear();
        this.all_collections = null;
        this.cancel_button = null;
        this.details_textarea = null;
        this.details_label = null;
        this.list = null;
        this.ok_button = null;
        this.prompt = null;
        if (this.selected_collections != null) {
            this.selected_collections.clear();
            this.selected_collections = null;
        }
        this.title_field = null;
        this.title_label = null;
    }

    public boolean display() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.install_button);
        this.install_button.setSelected(true);
        buttonGroup.add(this.noinstall_button);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        JScrollPane jScrollPane = new JScrollPane(this.instructions_textarea);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel.add((Component)jScrollPane, "Center");
        this.title_label.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 15));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.add((Component)this.title_label, "Before");
        jPanel2.add((Component)this.title_field, "Center");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1));
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        this.install_button.setBackground(Configuration.getColor("coloring.collection_heading_background", true));
        this.noinstall_button.setBackground(Configuration.getColor("coloring.collection_heading_background", true));
        jPanel3.add(this.install_button);
        jPanel3.add(this.noinstall_button);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        jPanel4.add((Component)jPanel2, "North");
        jPanel4.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel4, "South");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        jPanel5.add((Component)this.list_label, "North");
        jScrollPane = new JScrollPane(this.list);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel5.add((Component)jScrollPane, "Center");
        jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.add((Component)this.details_label, "North");
        jScrollPane = new JScrollPane(this.details_textarea);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel6.add((Component)jScrollPane, "Center");
        jPanel6.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel jPanel7 = new JPanel(new GridLayout(2, 1));
        jPanel7.setComponentOrientation(Dictionary.getOrientation());
        jPanel7.add(jPanel5);
        jPanel7.add(jPanel6);
        jPanel7.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.setComponentOrientation(Dictionary.getOrientation());
        jPanel8.add((Component)this.estimated_size_label, "Before");
        jPanel8.add((Component)this.estimated_size_field, "Center");
        jPanel8.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        JPanel jPanel9 = new JPanel(new GridLayout(1, 2));
        jPanel9.setComponentOrientation(Dictionary.getOrientation());
        jPanel9.add(this.ok_button);
        jPanel9.add(this.cancel_button);
        jPanel9.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.setComponentOrientation(Dictionary.getOrientation());
        jPanel10.add((Component)jPanel8, "North");
        jPanel10.add((Component)jPanel9, "South");
        jPanel10.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        JPanel jPanel11 = (JPanel)this.getContentPane();
        jPanel11.setComponentOrientation(Dictionary.getOrientation());
        jPanel11.setLayout(new BorderLayout());
        jPanel11.add((Component)jPanel, "North");
        jPanel11.add((Component)jPanel7, "Center");
        jPanel11.add((Component)jPanel10, "South");
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - WriteCDImagePrompt.SIZE.width) / 2, (dimension.height - WriteCDImagePrompt.SIZE.height) / 2);
        this.setVisible(true);
        return true;
    }

    private long getFileSize(File file) {
        long l = 0L;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                l += this.getFileSize(fileArray[i]);
            }
        } else {
            l = file.length();
        }
        return l;
    }

    public void writeCDImageCollections() {
        int n;
        String string;
        DebugStream.println("WriteCDImagePrompt.writeCDImageCollections()");
        int n2 = this.selected_collections.size();
        if (n2 == 0) {
            return;
        }
        this.cd_title = this.title_field.getText();
        this.cd_title = this.cd_title.trim();
        this.cd_title = this.cd_title.replaceAll("\"", "");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!Gatherer.isGsdlRemote) {
            arrayList.add(Configuration.perl_path);
            arrayList.add("-S");
        }
        arrayList.add(LocalGreenstone.getBinScriptDirectoryPath() + "exportcol.pl");
        arrayList.add("-gli");
        arrayList.add("-language");
        arrayList.add(Configuration.getLanguage());
        if (this.cd_title.equals("")) {
            arrayList.add("-cdname");
            arrayList.add("Greenstone Collections");
            arrayList.add("-cddir");
            arrayList.add("exported_collections");
        } else {
            arrayList.add("-cdname");
            arrayList.add(this.cd_title);
            string = "exported_" + this.cd_title.replaceAll("\\s", "");
            arrayList.add("-cddir");
            arrayList.add(string);
        }
        if (this.noinstall_button.isSelected()) {
            arrayList.add("-noinstall");
        }
        if ((string = Gatherer.getCollectDirectoryPath()) != Gatherer.getDefaultGSCollectDirectoryPath(true)) {
            arrayList.add("-collectdir");
            arrayList.add(string);
        }
        for (n = 0; n < n2; ++n) {
            arrayList.add(((BasicCollectionConfiguration)this.selected_collections.get(n)).getShortName());
        }
        DebugStream.print("export command = ");
        for (n = 0; n < arrayList.size(); ++n) {
            DebugStream.print(arrayList.get(n) + " ");
        }
        DebugStream.println("");
        String[] stringArray = arrayList.toArray(new String[0]);
        GShell gShell = new GShell(stringArray, 4, 3, this, null, GShell.GSHELL_CDIMAGE);
        gShell.start();
        DebugStream.println("WriteCDImagePrompt.writeCDImageCollections().return");
    }

    public void resultPrompt(boolean bl, String string) {
        String string2;
        Object object;
        this.args = new String[2];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.selected_collections.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            object = (BasicCollectionConfiguration)this.selected_collections.get(i);
            stringBuffer.append(((BasicCollectionConfiguration)object).getName() + " " + "[" + ((BasicCollectionConfiguration)object).getShortName() + "]");
            object = null;
        }
        this.args[0] = stringBuffer.toString();
        this.args[1] = LocalGreenstone.getTmpDirectoryPath();
        this.args[1] = this.cd_title.equals("") ? this.args[1] + "exported_collections" : this.args[1] + "exported_" + this.cd_title.replaceAll("\\s", "");
        if (bl) {
            string2 = Dictionary.get("WriteCDImagePrompt.Successful_Title");
            object = Dictionary.get("WriteCDImagePrompt.Successful_Export", this.args);
        } else {
            string2 = Dictionary.get("WriteCDImagePrompt.Failed_Title");
            object = Dictionary.get("WriteCDImagePrompt.Failed_Export", this.args);
        }
        SimpleResultDialog simpleResultDialog = new SimpleResultDialog(string2, (String)object, string);
        simpleResultDialog.setVisible(true);
        simpleResultDialog.dispose();
        simpleResultDialog = null;
    }

    private void scanForCollections() {
        File file = new File(Gatherer.getCollectDirectoryPath());
        if (file.exists()) {
            this.scanForCollectionsInternal(file);
        }
    }

    private void scanForCollectionsInternal(File file) {
        String string = Gatherer.GS3 ? Utility.CONFIG_GS3_FILE : Utility.CONFIG_FILE;
        File[] fileArray = file.listFiles();
        ArrayTools.sort(fileArray);
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            File file2;
            if (!fileArray[i].isDirectory() || fileArray[i].getName().equals("modelcol") || !(file2 = new File(fileArray[i], string)).exists()) continue;
            BasicCollectionConfiguration basicCollectionConfiguration = new BasicCollectionConfiguration(file2);
            if (basicCollectionConfiguration.getCollectGroup().equals("true")) {
                this.scanForCollectionsInternal(fileArray[i]);
                continue;
            }
            this.all_collections.add(basicCollectionConfiguration);
            basicCollectionConfiguration = null;
        }
    }

    @Override
    public synchronized void message(GShellEvent gShellEvent) {
        String string = gShellEvent.getMessage();
        if (string.startsWith("exportcol.pl>")) {
            string = string.substring(13);
            this.error_message.append(string);
            this.error_message.append("\n");
        }
    }

    @Override
    public synchronized void processBegun(GShellEvent gShellEvent) {
    }

    @Override
    public synchronized void processComplete(GShellEvent gShellEvent) {
        this.successful = false;
        if (gShellEvent.getStatus() == 1 && gShellEvent.getType() == 4) {
            this.successful = true;
        }
        this.ok_button_listener.processComplete();
    }

    static /* synthetic */ String[] access$802(WriteCDImagePrompt writeCDImagePrompt, String[] stringArray) {
        writeCDImagePrompt.args = stringArray;
        return stringArray;
    }

    private class OKButtonListener
    implements ActionListener {
        private Component glass_pane;
        private MouseListener mouse_blocker_listener;
        private ProgressDialog progress_dialog;

        private OKButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WriteCDImagePrompt.this.selected_collections = WriteCDImagePrompt.this.list.getTicked();
            WriteCDImagePrompt.this.error_message = new StringBuffer();
            this.glass_pane = WriteCDImagePrompt.this.getGlassPane();
            this.mouse_blocker_listener = new MouseAdapter(){};
            this.glass_pane.addMouseListener(this.mouse_blocker_listener);
            this.glass_pane.setCursor(Cursor.getPredefinedCursor(3));
            this.glass_pane.setVisible(true);
            WriteCDImagePrompt.this.writeCDImageCollections();
            this.progress_dialog = new ProgressDialog();
            this.progress_dialog.setVisible(true);
        }

        public void processComplete() {
            this.progress_dialog.setVisible(false);
            this.progress_dialog.dispose();
            this.progress_dialog = null;
            this.glass_pane.setVisible(false);
            this.glass_pane.setCursor(Cursor.getPredefinedCursor(0));
            this.glass_pane.removeMouseListener(this.mouse_blocker_listener);
            this.glass_pane = null;
            this.mouse_blocker_listener = null;
            if (WriteCDImagePrompt.this.successful) {
                WriteCDImagePrompt.this.resultPrompt(true, WriteCDImagePrompt.this.error_message.toString());
            } else {
                WriteCDImagePrompt.this.resultPrompt(false, WriteCDImagePrompt.this.error_message.toString());
            }
            WriteCDImagePrompt.this.error_message = null;
        }

        private class ProgressDialog
        extends ModalDialog {
            private Dimension size;

            public ProgressDialog() {
                super(Gatherer.g_man, Dictionary.get("WriteCDImagePrompt.Title"), true);
                this.size = new Dimension(400, 65);
                this.setComponentOrientation(Dictionary.getOrientation());
                this.setDefaultCloseOperation(0);
                this.setSize(this.size);
                JPanel jPanel = (JPanel)this.getContentPane();
                jPanel.setComponentOrientation(Dictionary.getOrientation());
                JLabel jLabel = new JLabel(Dictionary.get("WriteCDImagePrompt.Progress_Label"));
                jLabel.setComponentOrientation(Dictionary.getOrientation());
                JProgressBar jProgressBar = new JProgressBar();
                jProgressBar.setComponentOrientation(Dictionary.getOrientation());
                jProgressBar.setIndeterminate(true);
                jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)jLabel, "North");
                jPanel.add((Component)jProgressBar, "Center");
                Rectangle rectangle = Gatherer.g_man.getBounds();
                this.setLocation(rectangle.x + (rectangle.width - this.size.width) / 2, rectangle.y + (rectangle.height - this.size.height) / 2);
            }
        }
    }

    private class CollectionListListener
    implements ListSelectionListener {
        private CollectionListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            WriteCDImagePrompt.this.ok_button.setEnabled(!WriteCDImagePrompt.this.list.isNothingTicked());
            if (WriteCDImagePrompt.this.list.isSelectionEmpty()) {
                WriteCDImagePrompt.this.details_textarea.setText(Dictionary.get("DeleteCollectionPrompt.No_Collection"));
                return;
            }
            WriteCDImagePrompt.this.collection = (BasicCollectionConfiguration)((CheckListEntry)WriteCDImagePrompt.this.list.getSelectedValue()).getObject();
            WriteCDImagePrompt.access$802(WriteCDImagePrompt.this, new String[3]);
            ((WriteCDImagePrompt)WriteCDImagePrompt.this).args[0] = WriteCDImagePrompt.this.collection.getCreator();
            ((WriteCDImagePrompt)WriteCDImagePrompt.this).args[1] = WriteCDImagePrompt.this.collection.getMaintainer();
            ((WriteCDImagePrompt)WriteCDImagePrompt.this).args[2] = WriteCDImagePrompt.this.collection.getDescription();
            WriteCDImagePrompt.this.details_textarea.setText(Dictionary.get("DeleteCollectionPrompt.Details", WriteCDImagePrompt.this.args));
            WriteCDImagePrompt.this.details_textarea.setCaretPosition(0);
            String string = CollectionManager.getCollectionDirectoryPath(WriteCDImagePrompt.this.collection.getShortName());
            File file = new File(string + "etc");
            File file2 = new File(string + "images");
            File file3 = new File(string + "index");
            long l = WriteCDImagePrompt.this.getFileSize(file) + WriteCDImagePrompt.this.getFileSize(file2) + WriteCDImagePrompt.this.getFileSize(file3);
            if (((CheckListEntry)WriteCDImagePrompt.this.list.getSelectedValue()).isSelected()) {
                WriteCDImagePrompt.this.total_exported_size = WriteCDImagePrompt.this.total_exported_size + l;
            } else {
                WriteCDImagePrompt.this.total_exported_size = WriteCDImagePrompt.this.total_exported_size - l;
            }
            WriteCDImagePrompt.this.estimated_size_field.setText(Utility.formatFileLength(WriteCDImagePrompt.this.total_exported_size));
        }
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WriteCDImagePrompt.this.prompt.dispose();
        }
    }
}

