/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui.tree;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.util.Utility;

public class DragTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Color selection_background = this.getBackgroundSelectionColor();
    private Color selection_foreground = this.getTextSelectionColor();

    public void gainFocus() {
        this.setBackgroundSelectionColor(this.selection_background);
        this.setTextSelectionColor(this.selection_foreground);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof FileNode) {
            FileNode fileNode = (FileNode)object;
            String string = fileNode.toString();
            if (Configuration.get("general.show_file_size", true) && fileNode.getFile() != null && !fileNode.getAllowsChildren()) {
                string = string + " " + "[" + Utility.formatFileLength(fileNode.getFile().length()) + "]";
            }
            return (JLabel)super.getTreeCellRendererComponent(jTree, string, bl, bl2, bl3, n, bl4);
        }
        return (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
    }

    public void loseFocus() {
        this.setBackgroundSelectionColor(Color.lightGray);
        this.setTextSelectionColor(Color.black);
    }
}

