/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.FontUIResource;

public class Uninstaller {
    public static int SCREEN_WIDTH = 600;
    public static int SCREEN_HEIGHT = 450;
    public static final ResourceBundle bundle = ResourceBundle.getBundle("resources.LanguagePack");
    public static final File gs2InstallProps = new File("etc/installation.properties");
    public static final File gs3InstallProps = new File("installation.properties");
    boolean keepCollections = true;
    boolean ignoreReadOnlys = false;
    JFrame frame;
    JCheckBox keepCollectionsCheckbox;
    JPanel progressPanel;
    JPanel introPanel;
    JPanel initialToolbar;
    JPanel finishToolbar;
    JScrollPane logPane;
    FollowingJTextArea log;
    JButton uninstallButton;
    JButton finishButton;
    boolean confirmationGiven = false;
    Thread mainThread = null;

    public static void main(String[] stringArray) {
        new Uninstaller().go();
    }

    public void go() {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        String string = null;
        if (System.getProperty("os.name").equals("Linux")) {
            string = "Bitstream Cyberbit";
        } else if (System.getProperty("os.name").startsWith("Windows")) {
            string = "Arial Unicode MS";
        }
        if (string != null) {
            serializable = new FontUIResource(string, 0, 12);
            object3 = UIManager.getDefaults().keys();
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                object = UIManager.get(object2);
                if (!(object instanceof FontUIResource)) continue;
                UIManager.put(object2, serializable);
            }
        }
        this.mainThread = Thread.currentThread();
        this.frame = new JFrame();
        this.frame.setSize(SCREEN_WIDTH, SCREEN_HEIGHT);
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation(((Dimension)serializable).width / 2 - this.frame.getWidth() / 2, ((Dimension)serializable).height / 2 - this.frame.getHeight() / 2);
        this.introPanel = new JPanel(new BorderLayout());
        object3 = new JPanel();
        ((Container)object3).setLayout(new BoxLayout((Container)object3, 1));
        ((JComponent)object3).setBorder(new EmptyBorder(10, 10, 5, 10));
        this.introPanel.add("West", (Component)object3);
        this.progressPanel = new JPanel(new BorderLayout());
        this.log = new FollowingJTextArea();
        this.log.setEditable(false);
        this.logPane = new JScrollPane(this.log);
        this.logPane.setHorizontalScrollBarPolicy(31);
        this.logPane.setVerticalScrollBarPolicy(22);
        this.progressPanel.add("North", new JLabel("Progress"));
        this.progressPanel.add("Center", this.logPane);
        this.initialToolbar = new JPanel();
        this.uninstallButton = new JButton(bundle.getString("uninstaller.uninstall"));
        this.uninstallButton.addActionListener(new StartUninstallListener());
        object2 = new JButton(bundle.getString("uninstaller.cancel"));
        ((AbstractButton)object2).addActionListener(new CancelListener());
        this.initialToolbar.add(this.uninstallButton);
        this.initialToolbar.add((Component)object2);
        this.finishToolbar = new JPanel();
        this.finishButton = new JButton(bundle.getString("uninstaller.finish"));
        this.finishButton.addActionListener(new FinishListener());
        this.finishButton.setEnabled(false);
        this.finishToolbar.add(this.finishButton);
        object = new File(".").getAbsolutePath();
        if (((String)object).endsWith("/.")) {
            object = ((String)object).substring(0, ((String)object).length() - 2);
        }
        JLabel jLabel = new JLabel(bundle.getString("uninstaller.will.uninstall.from"));
        ((Container)object3).add(jLabel);
        ((Container)object3).add(Box.createRigidArea(new Dimension(5, 5)));
        jLabel = new JLabel("  " + (String)object);
        jLabel.setFont(new Font("Monospaced", 1, 14));
        ((Container)object3).add(jLabel);
        ((Container)object3).add(Box.createRigidArea(new Dimension(5, 20)));
        jLabel = new JLabel(bundle.getString("uninstaller.uninstall.options"));
        ((Container)object3).add(jLabel);
        this.keepCollectionsCheckbox = new JCheckBox(bundle.getString("uninstaller.keep.collections"));
        this.keepCollectionsCheckbox.setSelected(true);
        ((Container)object3).add(this.keepCollectionsCheckbox);
        this.frame.setTitle(bundle.getString("uninstaller.greenstone.uninstaller"));
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().add("Center", this.introPanel);
        this.frame.getContentPane().add("South", this.initialToolbar);
        this.frame.setVisible(true);
        boolean bl = this.precheck();
        if (!bl) {
            System.exit(0);
        }
        do {
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!this.confirmationGiven);
        this.doUninstall();
        this.finishButton.setEnabled(true);
    }

    public boolean precheck() {
        if (!gs2InstallProps.exists() && !gs3InstallProps.exists()) {
            this.log(bundle.getString("uninstaller.error.couldnt.find.install.props") + "\n");
            JOptionPane.showMessageDialog(this.frame, bundle.getString("uninstaller.error.couldnt.find.install.props"), bundle.getString("uninstaller.error"), 0);
            return false;
        }
        return true;
    }

    public void log(String string) {
        SwingUtilities.invokeLater(new LogAppender(string));
    }

    public void doUninstall() {
        Object object;
        File file = null;
        if (gs2InstallProps.exists()) {
            object = null;
            try {
                object = this.getPropertyValue("installed.startmenu.path", gs2InstallProps);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
            if (object != null) {
                file = new File((String)object);
            }
        } else if (gs3InstallProps.exists()) {
            object = null;
            try {
                object = this.getPropertyValue("installed.startmenu.path", gs3InstallProps);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
            if (object != null) {
                file = new File((String)object);
            }
        }
        if (file == null) {
            this.log(bundle.getString("uninstaller.info.no.startmenu") + "\n");
        } else {
            this.log("StartMenu Path: " + file.getAbsolutePath() + "\n");
            try {
                this.recursiveDelete(file, null);
            }
            catch (CancelledException cancelledException) {
                this.log(bundle.getString("uninstaller.cancelled") + "\n");
                this.changeToFinishToolbar();
                JOptionPane.showMessageDialog(this.frame, bundle.getString("uninstaller.cancelled"), bundle.getString("uninstaller.complete"), 1);
                return;
            }
        }
        try {
            object = new ArrayList();
            ((ArrayList)object).add(new File("bin/search4j.exe"));
            ((ArrayList)object).add(new File("bin/search4j"));
            ((ArrayList)object).add(new File("bin/windows/search4j.exe"));
            ((ArrayList)object).add(new File("bin/linux/search4j"));
            ((ArrayList)object).add(new File("bin/darwin/search4j"));
            ((ArrayList)object).add(new File("packages/jre"));
            ((ArrayList)object).add(new File("uninstall"));
            if (this.keepCollections) {
                ((ArrayList)object).add(new File("web/sites/localsite/collect"));
                ((ArrayList)object).add(new File("collect"));
            }
            File file2 = null;
            try {
                file2 = new File(new File(".").getCanonicalPath());
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.frame, bundle.getString("uninstaller.failed.to.figure.cd"), bundle.getString("uninstaller.error"), 0);
                System.exit(0);
            }
            File[] fileArray = new File[((ArrayList)object).size()];
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                fileArray[i] = (File)((ArrayList)object).get(i);
            }
            this.selectiveDelete(file2, fileArray);
        }
        catch (CancelledException cancelledException) {
            this.log(bundle.getString("uninstaller.cancelled") + "\n");
            JOptionPane.showMessageDialog(this.frame, bundle.getString("uninstaller.cancelled"), bundle.getString("uninstaller.complete"), 1);
            this.changeToFinishToolbar();
            return;
        }
        try {
            new File("uninst.flag").createNewFile();
        }
        catch (Exception exception) {
            this.log(bundle.getString("uninstaller.couldnt-create-flagfile") + "\n");
        }
        this.changeToFinishToolbar();
        this.log(bundle.getString("uninstaller.finished"));
        JOptionPane.showMessageDialog(this.frame, bundle.getString("uninstaller.finished"), bundle.getString("uninstaller.complete"), 1);
    }

    public String getPropertyValue(String string, File file) throws Exception {
        String string2 = "^" + string.replaceAll("\\.", "\\\\.") + "[:=]\\s*(.*)$";
        Pattern pattern = Pattern.compile(string2);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (Exception exception) {
            throw new Exception("Error - couldn't open the properties file " + file);
        }
        String string3 = null;
        try {
            String string4;
            boolean bl = false;
            while ((string4 = bufferedReader.readLine()) != null && !bl) {
                Matcher matcher = pattern.matcher(string4);
                if (!matcher.matches()) continue;
                string3 = matcher.group(1);
                string3 = string3.replaceAll("#.*", "").trim();
                return string3;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new Exception("Error - couldn't read from the properties file");
        }
        return null;
    }

    public void selectiveDelete(File file, File[] fileArray) throws CancelledException {
        File[] fileArray2 = new File("uninstall").listFiles();
        for (int i = 0; i < fileArray2.length; ++i) {
            if (!fileArray2[i].getAbsolutePath().endsWith(".uninstall")) continue;
            String[] stringArray = this.getPathsFromUninstallFile(fileArray2[i]);
            for (int j = 0; j < stringArray.length; ++j) {
                this.recursiveDelete(new File(stringArray[j]), fileArray);
            }
        }
    }

    public String[] getRelevantPathsFromUninstallFile(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                int n = string.indexOf(File.separator);
                if (n == -1 && string.length() > 0 && !arrayList.contains(string)) {
                    arrayList.add(string);
                    continue;
                }
                if (n <= -1 || string.length() <= 0 || arrayList.contains(string2 = string.substring(0, n))) continue;
                arrayList.add(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getPathsFromUninstallFile(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.length() <= 0 || arrayList.contains(string)) continue;
                arrayList.add(string);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return arrayList.toArray(new String[0]);
    }

    public void recursiveDelete(File file, File[] fileArray) throws CancelledException {
        File[] fileArray2;
        int n;
        if (fileArray != null) {
            for (n = 0; n < fileArray.length; ++n) {
                try {
                    if (!file.equals(fileArray[n]) && !file.getCanonicalPath().equals(fileArray[n].getCanonicalPath())) continue;
                    this.log(Strings.replaceAll(bundle.getString("uninstaller.info.skipping"), "{file}", file.getAbsolutePath()) + "\n");
                    return;
                }
                catch (Exception exception) {
                    System.err.println("ERROR: Failed to resolve a path");
                    return;
                }
            }
        }
        if (file.isDirectory() && (fileArray2 = file.listFiles()) != null && fileArray2.length > 0) {
            for (int i = 0; i < fileArray2.length; ++i) {
                try {
                    this.recursiveDelete(fileArray2[i], fileArray);
                    continue;
                }
                catch (CancelledException cancelledException) {
                    throw new CancelledException();
                }
            }
        }
        n = 1;
        if (file.isDirectory()) {
            File[] fileArray3 = file.listFiles();
            int n2 = n = fileArray3 == null || fileArray3.length == 0 ? 1 : 0;
        }
        if (n != 0) {
            this.log(Strings.replaceAll(bundle.getString("uninstaller.deleting"), "{file}", file.getAbsolutePath()) + "\n");
            if (!file.delete()) {
                this.log("*********\n" + Strings.replaceAll(bundle.getString("uninstaller.warning.couldnt.delete"), "{file}", file.getAbsolutePath()) + "\n*********\n");
                return;
            }
        }
    }

    public void changeToFinishToolbar() {
        this.initialToolbar.setVisible(false);
        this.frame.getContentPane().remove(this.initialToolbar);
        this.frame.getContentPane().add("South", this.finishToolbar);
        this.finishToolbar.setVisible(true);
    }

    class CancelledException
    extends Exception {
        CancelledException() {
        }
    }

    class LogAppender
    implements Runnable {
        String s;

        public LogAppender(String string) {
            this.s = string;
        }

        @Override
        public void run() {
            Uninstaller.this.log.append(this.s);
        }
    }

    class StartUninstallListener
    implements ActionListener {
        StartUninstallListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[]{bundle.getString("uninstaller.uninstall"), bundle.getString("uninstaller.cancel")};
            int n = JOptionPane.showOptionDialog(Uninstaller.this.frame, bundle.getString("uninstaller.are.you.sure"), bundle.getString("uninstaller.confirmation"), 1, 3, null, objectArray, objectArray[0]);
            if (n == 1) {
                return;
            }
            Uninstaller.this.keepCollections = Uninstaller.this.keepCollectionsCheckbox.isSelected();
            if (!Uninstaller.this.keepCollections) {
                objectArray[0] = bundle.getString("uninstaller.continue");
                objectArray[1] = bundle.getString("uninstaller.cancel");
                n = JOptionPane.showOptionDialog(Uninstaller.this.frame, bundle.getString("uninstaller.are.you.sure.collections"), bundle.getString("uninstaller.confirmation"), 1, 2, null, objectArray, objectArray[0]);
                if (n == 1) {
                    return;
                }
            }
            Uninstaller.this.introPanel.setVisible(false);
            Uninstaller.this.frame.getContentPane().remove(Uninstaller.this.introPanel);
            Uninstaller.this.frame.getContentPane().add("Center", Uninstaller.this.progressPanel);
            Uninstaller.this.initialToolbar.setVisible(false);
            Uninstaller.this.frame.getContentPane().remove(Uninstaller.this.initialToolbar);
            Uninstaller.this.frame.getContentPane().add("South", Uninstaller.this.finishToolbar);
            Uninstaller.this.confirmationGiven = true;
            Uninstaller.this.mainThread.interrupt();
        }
    }

    class FinishListener
    implements ActionListener {
        FinishListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.exit(0);
        }
    }
}

