/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer;

import java.awt.ComponentOrientation;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.plaf.FontUIResource;
import org.greenstone.gatherer.DebugStream;

public class Dictionary
extends HashMap {
    private static FontUIResource font = null;
    private static Locale locale = null;
    private static ResourceBundle dictionary = null;
    private static ComponentOrientation orientation = null;
    public static final int JAVA_MAJOR_VERSION;

    public Dictionary(Locale locale, FontUIResource fontUIResource) {
        font = fontUIResource;
        Dictionary.locale = locale == null ? Locale.getDefault() : locale;
        dictionary = ResourceBundle.getBundle("dictionary", Dictionary.locale);
        orientation = Dictionary.get("Component.Orientation").equals("RTL") ? ComponentOrientation.RIGHT_TO_LEFT : ComponentOrientation.LEFT_TO_RIGHT;
    }

    public static String getLanguage() {
        return locale.getLanguage();
    }

    public static ComponentOrientation getOrientation() {
        return orientation;
    }

    public static String get(String string) {
        return Dictionary.get(string, (String[])null);
    }

    public static String get(String string, String string2) {
        String[] stringArray = new String[]{string2};
        return Dictionary.get(string, stringArray);
    }

    public static String get(String string, String[] stringArray) {
        try {
            String string2 = dictionary.getString(string).trim();
            String string3 = "";
            try {
                string3 = JAVA_MAJOR_VERSION >= 11 ? string2 : new String(string2.getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
                return string2;
            }
            if (string3.indexOf("#") != -1) {
                string3 = string3.substring(0, string3.indexOf("#"));
                string3 = string3.trim();
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (string3.length() > 0 && string3.indexOf(123) != -1 && string3.indexOf(125) != -1) {
                int n = string3.indexOf(123);
                int n2 = string3.indexOf(125);
                int n3 = string3.indexOf(45, n);
                if (n3 > n2) {
                    n3 = -1;
                }
                stringBuffer.append(string3.substring(0, n));
                String string4 = null;
                string4 = n3 != -1 ? string3.substring(n + 1, n3) : string3.substring(n + 1, n2);
                string3 = n2 + 1 < string3.length() ? string3.substring(n2 + 1) : "";
                if (string4.equals("FONT")) {
                    stringBuffer.append(font != null ? font.getFontName() : "Arial");
                    continue;
                }
                int n4 = Integer.parseInt(string4);
                if (stringArray == null || 0 > n4 || n4 >= stringArray.length) continue;
                stringBuffer.append(stringArray[n4]);
            }
            stringBuffer.append(string3);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.err.println("Missing value for key: " + string);
            return string;
        }
    }

    static {
        String string = System.getProperty("java.version");
        int n = 1;
        String[] stringArray = string.split("\\.");
        if (!stringArray[0].equals("1")) {
            n = Integer.parseInt(stringArray[0]);
        } else if (stringArray.length == 1) {
            n = 1;
        } else {
            try {
                n = Integer.parseInt(stringArray[1]);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("NumberFormatException while parsing the javaVersion " + string + " after period mark, " + stringArray[1]);
                n = 1;
            }
        }
        JAVA_MAJOR_VERSION = n;
    }
}

