/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.UIManager;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.UnzipTools;
import org.greenstone.gatherer.util.Utility;

public class GathererApplet
extends JApplet
implements ActionListener {
    private Gatherer gatherer = null;

    protected String fullLibraryURL(String string) {
        String string2 = "";
        if (string.startsWith("http:")) {
            string2 = string;
        } else if (string.startsWith("/")) {
            URL uRL = this.getDocumentBase();
            int n = uRL.getPort();
            String string3 = n > 0 ? ":" + n : "";
            string2 = "http://" + uRL.getHost() + string3 + string;
        }
        return string2;
    }

    @Override
    public void init() {
        File file;
        String[] stringArray;
        Object object;
        String string;
        JarTools.initialise(this);
        try {
            System.setProperty("java.util.prefs.syncInterval", "2000000");
        }
        catch (Exception exception) {
            this.getContentPane().add(new JLabel("Greenstone Librarian Interface Applet deactivated", 0));
            return;
        }
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string2 = System.getProperty("user.home") + File.separator;
        string2 = Utility.isWindows() ? ((string = this.getParameter("windowsHome")) != null && !string.equals("") ? string + File.separator + "GLI" + File.separator : string2 + "Application Data" + File.separator + "Greenstone" + File.separator + "GLI" + File.separator) : string2 + ".gli" + File.separator;
        Gatherer.setGLIUserDirectoryPath(string2);
        Gatherer.setGLIDirectoryPath(string2);
        Gatherer.isApplet = true;
        string = this.fullLibraryURL(this.getParameter("gwcgi"));
        String string3 = this.getParameter("gsdl3");
        boolean bl = string3 != null && string3.equals("true");
        String string4 = !bl ? string.substring(0, string.lastIndexOf(47) + 1) + "gliserver.pl" : string + "/cgi-bin/gliserver.pl";
        if (!bl) {
            object = new String[]{"-use_remote_greenstone", "-gliserver_url", string4, "-library_url", string};
            stringArray = object;
        } else {
            object = new String[]{"-use_remote_greenstone", "-gliserver_url", string4, "-library_url", string, "-gsdl3"};
            stringArray = object;
        }
        Gatherer.setCollectDirectoryPath(Gatherer.getGLIUserDirectoryPath() + "collect" + File.separator);
        object = new File(Gatherer.getCollectDirectoryPath());
        if (!((File)object).exists()) {
            if (JarTools.isInJar("collect.zip")) {
                GathererApplet.unzipFromJar("collect.zip", Gatherer.getGLIUserDirectoryPath());
            } else if (!((File)object).mkdir()) {
                System.err.println("Warning: Unable to make directory: " + object);
            }
        }
        if (!(file = new File(Gatherer.getGLIMetadataDirectoryPath())).exists()) {
            GathererApplet.unzipFromJar("metadata.zip", Gatherer.getGLIDirectoryPath());
        }
        this.gatherer = new Gatherer(stringArray);
        JButton jButton = new JButton("Launch Greenstone Librarian Interface ...");
        jButton.addActionListener(this);
        this.getContentPane().add(jButton);
    }

    @Override
    public void start() {
        System.err.println("Start called");
    }

    @Override
    public void stop() {
        System.err.println("Stop called");
    }

    @Override
    public void destroy() {
        System.err.println("Destroy called");
        GathererApplet gathererApplet = this;
        gathererApplet.gatherer.exit();
        this.gatherer = null;
        System.err.println("Done gatherer exit.");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.gatherer.openGUI();
    }

    public static void unzipFromJar(String string, String string2) {
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        JarTools.extractFromJar(string, string2, true);
        UnzipTools.unzipFile(string2 + string, string2);
    }
}

