/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import org.greenstone.gatherer.cdm.Classifier;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.DOMProxyListEntry;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Format4gs3
implements DOMProxyListEntry {
    private Element element = null;
    private String feature_name = null;
    private String feature_format = null;
    private String pure_format = null;
    private static boolean is_classifier = false;
    private String classifier_options = "";

    public Format4gs3() {
    }

    public Format4gs3(Element element) {
        this.element = element;
        is_classifier = element.getParentNode().getNodeName().equals("Classify");
        if (is_classifier && CollectionDesignManager.classifier_manager != null) {
            this.feature_name = "CL" + this.getClassifierPosition(element);
            Classifier classifier = Format4gs3.getClassifier(this.feature_name);
            if (classifier != null) {
                this.classifier_options = classifier.toString();
            }
            this.pure_format = Format4gs3.toOneLineFormat(XMLTools.getNodeText(element));
            this.feature_format = this.classifier_options + " " + this.pure_format;
        } else {
            this.feature_name = element.getAttribute("name");
            this.pure_format = this.feature_format = Format4gs3.toOneLineFormat(XMLTools.getNodeText(element));
        }
    }

    public Format4gs3(String string, String string2) {
        this.feature_name = string;
        this.feature_format = string2;
        this.pure_format = string2;
        is_classifier = string.startsWith("CL");
        this.element = CollectionConfiguration.createElement("format");
        if (is_classifier) {
            Classifier classifier = Format4gs3.getClassifier(string);
            this.classifier_options = classifier.toString();
            string2 = this.classifier_options + " " + string2;
        } else {
            this.element.setAttribute("name", string);
        }
        XMLTools.setNodeText(this.element, Format4gs3.toOneLineFormat(this.pure_format));
    }

    public int getClassifierPosition(Element element) {
        Element element2 = CollectionDesignManager.collect_config.getDocumentElement();
        NodeList nodeList = element2.getElementsByTagName("Classify");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element3 = (Element)nodeList.item(i);
            Element element4 = (Element)XMLTools.getChildByTagName(element3, "format");
            if (element4 != element) continue;
            Classifier classifier = CollectionDesignManager.classifier_manager.getClassifier(i);
            this.classifier_options = classifier.toString();
            return i + 1;
        }
        return -1;
    }

    public static Classifier getClassifier(String string) {
        int n = Integer.parseInt(string.substring("CL".length()));
        Classifier classifier = CollectionDesignManager.classifier_manager.getClassifier(n - 1);
        return classifier;
    }

    public Element getClassifyElement() {
        int n = Integer.parseInt(this.feature_name.substring("CL".length()));
        Element element = CollectionDesignManager.collect_config.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("Classify");
        return (Element)nodeList.item(--n);
    }

    public String toString() {
        return this.feature_name + " " + Format4gs3.toOneLineFormat(this.feature_format);
    }

    public void update() {
        if (is_classifier) {
            this.feature_name = "CL" + this.getClassifierPosition(this.element);
            Classifier classifier = Format4gs3.getClassifier(this.feature_name);
            this.classifier_options = classifier.toString();
            this.pure_format = Format4gs3.toOneLineFormat(XMLTools.getNodeText(this.element));
            this.feature_format = this.classifier_options + " " + this.pure_format;
        }
    }

    public String getFormatedFormat() {
        return Format4gs3.toFormatedFormat(this.feature_format);
    }

    public String getPureFormat() {
        return Format4gs3.toFormatedFormat(this.pure_format);
    }

    public Classifier getClassifier() {
        if (!this.isClassifier()) {
            return null;
        }
        int n = Integer.parseInt(this.feature_name.substring("CL".length()));
        return CollectionDesignManager.classifier_manager.getClassifier(--n);
    }

    public void setFeatureName(String string) {
        this.feature_name = string;
    }

    public void setFeatureFormat(String string) {
        this.feature_format = is_classifier ? this.classifier_options + " " + string : string;
    }

    public void setPureFormat(String string) {
        this.pure_format = string;
        this.setFeatureFormat(string);
        XMLTools.setNodeText(this.element, this.pure_format);
    }

    public static String toOneLineFormat(String string) {
        return string.replaceAll("\n", "").replaceAll("\\s+", " ").replaceAll(" <", "<");
    }

    public static String toFormatedFormat(String string) {
        return string.replaceAll("\\s+", " ").replaceAll("<", "\n<").replaceFirst("\n", "");
    }

    public int compareTo(Object object) {
        if (object == null) {
            return -1;
        }
        return this.getFeatureName().compareToIgnoreCase(((Format4gs3)object).getFeatureName());
    }

    @Override
    public DOMProxyListEntry create(Element element) {
        return new Format4gs3(element);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public boolean isClassifier() {
        return this.feature_name.startsWith("CL");
    }

    public String getFeatureName() {
        return this.feature_name;
    }

    public String getFeatureFormat() {
        return this.feature_format;
    }

    @Override
    public void setElement(Element element) {
        this.element = element;
    }

    @Override
    public boolean isAssigned() {
        return true;
    }

    @Override
    public void setAssigned(boolean bl) {
    }
}

