/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.cdm.ArgumentControl;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.DOMProxyListModel;
import org.greenstone.gatherer.cdm.Language;
import org.greenstone.gatherer.cdm.SearchMeta;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSetManager;
import org.greenstone.gatherer.util.CheckList;
import org.greenstone.gatherer.util.CheckListEntry;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LanguageManager
extends DOMProxyListModel {
    public static Document LANGUAGES_DOCUMENT = XMLTools.parseXMLFile("xml/languages.xml", true);
    private static final Dimension COMPONENT_SIZE = new Dimension(125, 25);
    private Control controls = null;
    private DOMProxyListModel model = null;
    private LinkedHashMap known_languages = null;
    private Language default_language = null;
    private Element language_metadata = null;

    public LanguageManager(Element element) {
        super(element, "Language", new Language());
        DebugStream.println("LanguageManager: " + this.getSize() + " languages parsed.");
        this.model = this;
        NodeList nodeList = CollectionConfiguration.getElementsByTagName("DefaultLanguage");
        if (nodeList.getLength() > 0) {
            this.default_language = new Language((Element)nodeList.item(0));
        }
        this.language_metadata = CollectionDesignManager.collect_config.getLanguageMetadata();
        this.known_languages = new LinkedHashMap();
        NodeList nodeList2 = LANGUAGES_DOCUMENT.getDocumentElement().getElementsByTagName("Language");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Element element2 = (Element)nodeList2.item(i);
            String string = element2.getAttribute("code");
            String string2 = element2.getAttribute("name");
            this.known_languages.put(string.toLowerCase(), string2);
            string2 = null;
            string = null;
            element2 = null;
        }
    }

    private void addLanguage(Language language) {
        if (!this.contains(language)) {
            SearchMeta searchMeta = new SearchMeta(language.getCode(), "language");
            searchMeta.setValue(language.getName());
            CollectionDesignManager.searchmeta_manager.addMetadatum(searchMeta);
            this.add(this.getSize(), language);
        }
    }

    public void destroy() {
        if (this.controls != null) {
            this.controls.destroy();
            this.controls = null;
        }
        this.known_languages.clear();
        this.known_languages = null;
        this.default_language = null;
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new LanguageControl();
        }
        return this.controls;
    }

    public Language getLanguage(String string) {
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            Language language = (Language)this.getElementAt(i);
            if (!language.getCode().equals(string)) continue;
            return language;
        }
        return null;
    }

    public ArrayList getLanguages() {
        return this.children();
    }

    public ArrayList getLanguageCodes() {
        return new ArrayList(this.known_languages.keySet());
    }

    public String getLanguageName(String string) {
        return (String)this.known_languages.get(string);
    }

    public void modeChanged(int n) {
    }

    private int moveLanguage(Language language, boolean bl) {
        int n;
        int n2 = this.indexOf(language);
        if (bl) {
            if (n2 == 0) {
                return n2;
            }
            n = n2 - 1;
            this.addBefore(language, (Language)this.getElementAt(n));
        } else {
            if (n2 == this.getSize() - 1) {
                return n2;
            }
            n = n2 + 1;
            this.addAfter(language, (Language)this.getElementAt(n));
        }
        return n;
    }

    private void removeLanguage(Language language) {
        this.remove(language);
        CollectionDesignManager.searchmeta_manager.removeMetadata(language.getCode(), "language");
        if (this.default_language != null && this.default_language.equals(language)) {
            this.setDefault(null);
        }
    }

    private void replaceLanguage(Language language, Language language2) {
        CollectionDesignManager.searchmeta_manager.removeMetadata(language.getCode(), "language");
        SearchMeta searchMeta = new SearchMeta(language2.getCode(), "language");
        searchMeta.setValue(language2.getName());
        CollectionDesignManager.searchmeta_manager.addMetadatum(searchMeta);
        if (this.default_language != null && this.default_language.equals(language)) {
            this.setDefault(language2);
        }
        int n = this.indexOf(language);
        this.remove(language);
        this.add(n, language2);
    }

    public void setDefault(Language language) {
        if (language != null) {
            if (this.default_language == null) {
                Element element = this.root.getOwnerDocument().createElement("DefaultLanguage");
                this.default_language = new Language(element);
                Node node = CollectionConfiguration.findInsertionPoint(element);
                if (node != null) {
                    this.root.getOwnerDocument().getDocumentElement().insertBefore(element, node);
                } else {
                    this.root.getOwnerDocument().getDocumentElement().appendChild(element);
                }
            }
            this.default_language.setAssigned(true);
            this.default_language.setCode(language.getCode());
        } else if (this.default_language != null) {
            this.default_language.setAssigned(false);
        }
    }

    private class LanguageCheckListCellRenderer
    implements ListCellRenderer {
        private LanguageCheckListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JCheckBox jCheckBox = (JCheckBox)object;
            jCheckBox.setBackground(jList.getBackground());
            jCheckBox.setForeground(jList.getForeground());
            jCheckBox.setBorderPainted(false);
            jCheckBox.setEnabled(jList.isEnabled());
            jCheckBox.setFont(jList.getFont());
            jCheckBox.setFocusPainted(false);
            jCheckBox.setBorder(bl ? UIManager.getBorder("List.focusCellHighlightBorder") : new EmptyBorder(1, 1, 1, 1));
            String string = (String)((CheckListEntry)jList.getModel().getElementAt(n)).getObject();
            jCheckBox.setText((String)LanguageManager.this.known_languages.get(string));
            return jCheckBox;
        }
    }

    private class LanguageControl
    extends JPanel
    implements Control {
        private CheckList language_list = null;
        private JButton add_button = null;
        private JButton replace_button = null;
        private JButton remove_button = null;
        private JButton move_down_button;
        private JButton move_up_button;
        private JButton select_all_button;
        private JButton select_none_button;
        private JButton set_default_button = null;
        private JList selected_languages_list = null;
        private JComboBox language_metadata_combo = null;

        public LanguageControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel = new JLabel(Dictionary.get("CDM.LanguageManager.Assigned_Languages"));
            this.selected_languages_list = new JList(LanguageManager.this.model);
            this.selected_languages_list.setCellRenderer(new MyLanguageListCellRenderer());
            this.selected_languages_list.setSelectionMode(0);
            this.selected_languages_list.setVisibleRowCount(5);
            this.selected_languages_list.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel2 = new JPanel();
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel3 = new JPanel();
            jPanel3.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel2 = new JLabel(Dictionary.get("CDM.LanguageManager.Selector"));
            jLabel2.setComponentOrientation(Dictionary.getOrientation());
            this.select_all_button = new GLIButton(Dictionary.get("CDM.IndexManager.Select_All"), Dictionary.get("CDM.IndexManager.Select_All_Tooltip"));
            this.select_none_button = new GLIButton(Dictionary.get("CDM.IndexManager.Select_None"), Dictionary.get("CDM.IndexManager.Select_None_Tooltip"));
            this.language_metadata_combo = new JComboBox<Object>(MetadataSetManager.getEveryMetadataSetElement().toArray());
            this.language_metadata_combo.setOpaque(false);
            this.language_metadata_combo.setToolTipText(Dictionary.get("CDM.LanguageManager.LanguageMetadata_Tooltip"));
            this.language_metadata_combo.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel3 = new JLabel(Dictionary.get("CDM.LanguageManager.LanguageMetadata"));
            jLabel3.setComponentOrientation(Dictionary.getOrientation());
            String string = "ex.Language";
            if (LanguageManager.this.language_metadata.getAttribute("assigned").equals("true") && !LanguageManager.this.language_metadata.getAttribute("name").equals("")) {
                string = LanguageManager.this.language_metadata.getAttribute("name");
            }
            ArgumentControl.selectValue(this.language_metadata_combo, string);
            this.language_list = new CheckList(false);
            this.language_list.setListData(LanguageManager.this.getLanguageCodes());
            this.language_list.setToolTipText(Dictionary.get("CDM.LanguageManager.Selector_Tooltip"));
            this.language_list.setCellRenderer(new LanguageCheckListCellRenderer());
            this.select_all_button.setEnabled(this.isSelectAllEnabled());
            this.select_none_button.setEnabled(this.isSelectAllEnabled());
            JPanel jPanel4 = new JPanel();
            jPanel4.setComponentOrientation(Dictionary.getOrientation());
            this.move_up_button = new GLIButton(Dictionary.get("CDM.Move.Move_Up"), JarTools.getImage("arrow-up.gif"), Dictionary.get("CDM.Move.Move_Up_Tooltip"));
            this.move_up_button.setEnabled(false);
            this.move_down_button = new GLIButton(Dictionary.get("CDM.Move.Move_Down"), JarTools.getImage("arrow-down.gif"), Dictionary.get("CDM.Move.Move_Down_Tooltip"));
            this.move_down_button.setEnabled(false);
            this.set_default_button = new GLIButton(Dictionary.get("CDM.LanguageManager.Set_Default"), Dictionary.get("CDM.LanguageManager.Set_Default_Tooltip"));
            this.set_default_button.setEnabled(false);
            JPanel jPanel5 = new JPanel();
            jPanel5.setComponentOrientation(Dictionary.getOrientation());
            this.add_button = new GLIButton(Dictionary.get("CDM.SubcollectionIndexManager.Add_Subindex"), Dictionary.get("CDM.LanguageManager.Add_Tooltip"));
            this.add_button.setEnabled(false);
            this.replace_button = new GLIButton(Dictionary.get("CDM.SubcollectionIndexManager.Replace_Subindex"), Dictionary.get("CDM.LanguageManager.Replace_Tooltip"));
            this.replace_button.setEnabled(false);
            this.remove_button = new GLIButton(Dictionary.get("CDM.SubcollectionIndexManager.Remove_Subindex"), Dictionary.get("CDM.LanguageManager.Remove_Tooltip"));
            this.remove_button.setEnabled(false);
            this.add_button.addActionListener(new AddListener());
            this.add_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.move_down_button.addActionListener(new MoveListener(false));
            this.move_down_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.move_up_button.addActionListener(new MoveListener(true));
            this.move_up_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.remove_button.addActionListener(new RemoveListener());
            this.remove_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.replace_button.addActionListener(new ReplaceListener());
            this.replace_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.select_all_button.addActionListener(new SelectAllListener());
            this.select_all_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.select_none_button.addActionListener(new SelectNoneListener());
            this.select_none_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.language_list.addListSelectionListener(new LanguageListListener());
            this.language_metadata_combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = ((MetadataElement)LanguageControl.this.language_metadata_combo.getSelectedItem()).getFullName();
                    LanguageManager.this.language_metadata.setAttribute("assigned", "true");
                    LanguageManager.this.language_metadata.setAttribute("name", string);
                }
            });
            this.set_default_button.addActionListener(new SetDefaultListener());
            this.set_default_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.selected_languages_list.addListSelectionListener(new AssignedListListener());
            jPanel5.setLayout(new GridLayout(1, 3));
            jPanel5.add(this.add_button);
            jPanel5.add(this.replace_button);
            jPanel5.add(this.remove_button);
            JPanel jPanel6 = new JPanel();
            jPanel6.setComponentOrientation(Dictionary.getOrientation());
            jPanel6.setLayout(new BorderLayout());
            JPanel jPanel7 = new JPanel();
            jPanel7.setComponentOrientation(Dictionary.getOrientation());
            jPanel7.setLayout(new BorderLayout(10, 10));
            jPanel7.add((Component)jLabel3, "Before");
            jPanel7.add((Component)this.language_metadata_combo, "Center");
            jPanel6.add((Component)new JPanel(), "Center");
            jPanel6.add((Component)jPanel7, "After");
            jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            jPanel4.setLayout(new GridLayout(3, 1));
            jPanel4.add(this.move_up_button);
            jPanel4.add(this.move_down_button);
            jPanel4.add(this.set_default_button);
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel2.setLayout(new BorderLayout());
            jPanel3.setLayout(new BorderLayout());
            jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel3.setLayout(gridBagLayout);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
            jPanel3.add(jLabel2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.select_all_button, gridBagConstraints);
            jPanel3.add(this.select_all_button);
            gridBagConstraints.gridy = 2;
            gridBagLayout.setConstraints(this.select_none_button, gridBagConstraints);
            jPanel3.add(this.select_none_button);
            jPanel2.add((Component)jPanel3, "Before");
            jPanel2.add((Component)new JScrollPane(this.language_list), "Center");
            jPanel2.add((Component)jPanel5, "South");
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jLabel, "North");
            jPanel.add((Component)new JScrollPane(this.selected_languages_list), "Center");
            jPanel.add((Component)jPanel4, "After");
            JPanel jPanel8 = new JPanel();
            jPanel8.setComponentOrientation(Dictionary.getOrientation());
            jPanel8.setLayout(new BorderLayout());
            jPanel8.add((Component)jPanel6, "North");
            jPanel8.add((Component)jPanel, "South");
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel8, "North");
            this.add((Component)jPanel2, "Center");
        }

        @Override
        public void destroy() {
        }

        @Override
        public void gainFocus() {
        }

        @Override
        public void loseFocus() {
        }

        private void clearControls() {
            this.selected_languages_list.clearSelection();
            this.language_list.clearTicked();
            this.add_button.setEnabled(false);
            this.remove_button.setEnabled(false);
            this.replace_button.setEnabled(false);
            this.set_default_button.setEnabled(false);
            this.move_down_button.setEnabled(false);
            this.move_up_button.setEnabled(false);
            this.select_all_button.setEnabled(this.isSelectAllEnabled());
            this.select_none_button.setEnabled(this.isSelectAllEnabled());
        }

        private void updateControlsWithSelectedLanguage() {
            Language language = (Language)this.selected_languages_list.getSelectedValue();
            if (language == null) {
                this.clearControls();
                return;
            }
            this.language_list.clearTicked();
            if (language.getCode() == null) {
                return;
            }
            this.language_list.setTickedObjects(language.getCode().split(","));
        }

        private void validateButtons() {
            boolean bl = false;
            boolean bl2 = false;
            if (!this.language_list.isNothingTicked()) {
                ArrayList arrayList = this.language_list.getTicked();
                StringBuffer stringBuffer = new StringBuffer();
                boolean bl3 = true;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!bl3) {
                        stringBuffer.append(",");
                    } else {
                        bl3 = false;
                    }
                    stringBuffer.append(arrayList.get(i));
                }
                String string = stringBuffer.toString();
                if (!LanguageManager.this.model.contains(string)) {
                    bl = true;
                    if (!this.selected_languages_list.isSelectionEmpty()) {
                        bl2 = true;
                    }
                }
            }
            this.add_button.setEnabled(bl);
            this.replace_button.setEnabled(bl2);
            this.select_all_button.setEnabled(this.isSelectAllEnabled());
            this.select_none_button.setEnabled(this.isSelectAllEnabled());
        }

        private boolean isSelectAllEnabled() {
            return this.language_list.getModel().getSize() > 0;
        }

        private class MyLanguageListCellRenderer
        extends DefaultListCellRenderer {
            private MyLanguageListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (LanguageManager.this.default_language != null && LanguageManager.this.default_language.equals(object)) {
                    jLabel.setText(jLabel.getText() + " [" + Dictionary.get("CDM.LanguageManager.Default_Language") + "]");
                }
                return jLabel;
            }
        }

        private class AssignedListListener
        implements ListSelectionListener {
            private AssignedListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (LanguageControl.this.selected_languages_list.isSelectionEmpty()) {
                    LanguageControl.this.clearControls();
                    return;
                }
                int n = LanguageControl.this.selected_languages_list.getSelectedIndex();
                int n2 = LanguageControl.this.selected_languages_list.getModel().getSize();
                LanguageControl.this.select_all_button.setEnabled(LanguageControl.this.isSelectAllEnabled());
                LanguageControl.this.select_none_button.setEnabled(LanguageControl.this.isSelectAllEnabled());
                Language language = (Language)LanguageControl.this.selected_languages_list.getSelectedValue();
                LanguageControl.this.remove_button.setEnabled(true);
                LanguageControl.this.replace_button.setEnabled(false);
                LanguageControl.this.add_button.setEnabled(false);
                LanguageControl.this.set_default_button.setEnabled(LanguageManager.this.default_language == null || !LanguageManager.this.default_language.equals(language));
                if (n > 0) {
                    LanguageControl.this.move_up_button.setEnabled(true);
                } else {
                    LanguageControl.this.move_up_button.setEnabled(false);
                }
                if (n < n2 - 1) {
                    LanguageControl.this.move_down_button.setEnabled(true);
                } else {
                    LanguageControl.this.move_down_button.setEnabled(false);
                }
                LanguageControl.this.updateControlsWithSelectedLanguage();
            }
        }

        private class MoveListener
        implements ActionListener {
            private boolean move_up;

            public MoveListener(boolean bl) {
                this.move_up = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Language language = (Language)LanguageControl.this.selected_languages_list.getSelectedValue();
                if (language != null) {
                    int n = LanguageManager.this.moveLanguage(language, this.move_up);
                    LanguageControl.this.selected_languages_list.setSelectedIndex(n);
                }
            }
        }

        private class SetDefaultListener
        implements ActionListener {
            private SetDefaultListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Language language = (Language)LanguageControl.this.selected_languages_list.getSelectedValue();
                if (language != null) {
                    LanguageManager.this.setDefault(language);
                    LanguageControl.this.selected_languages_list.setSelectedValue(language, true);
                }
                LanguageControl.this.set_default_button.setEnabled(false);
            }
        }

        private class SelectNoneListener
        implements ActionListener {
            private SelectNoneListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LanguageControl.this.select_all_button.isEnabled()) {
                    LanguageControl.this.language_list.clearTicked();
                    LanguageControl.this.validateButtons();
                }
            }
        }

        private class SelectAllListener
        implements ActionListener {
            private SelectAllListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LanguageControl.this.select_all_button.isEnabled()) {
                    LanguageControl.this.language_list.setAllTicked();
                    LanguageControl.this.validateButtons();
                }
            }
        }

        private class LanguageListListener
        implements ListSelectionListener {
            private LanguageListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                LanguageControl.this.validateButtons();
            }
        }

        private class ReplaceListener
        implements ActionListener {
            private ReplaceListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LanguageControl.this.selected_languages_list.isSelectionEmpty() || LanguageControl.this.language_list.isNothingTicked()) {
                    LanguageControl.this.replace_button.setEnabled(false);
                    return;
                }
                Language language = (Language)LanguageControl.this.selected_languages_list.getSelectedValue();
                Language language2 = new Language(LanguageControl.this.language_list.getTicked());
                LanguageManager.this.replaceLanguage(language, language2);
            }
        }

        private class RemoveListener
        implements ActionListener {
            private RemoveListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Language language = (Language)LanguageControl.this.selected_languages_list.getSelectedValue();
                if (language != null) {
                    LanguageManager.this.removeLanguage(language);
                }
            }
        }

        private class AddListener
        implements ActionListener {
            private AddListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!LanguageControl.this.language_list.isNothingTicked()) {
                    LanguageManager.this.addLanguage(new Language(LanguageControl.this.language_list.getTicked()));
                    LanguageControl.this.clearControls();
                }
            }
        }
    }
}

