/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.ArgumentConfiguration;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.DOMProxyListModel;
import org.greenstone.gatherer.cdm.Plugin;
import org.greenstone.gatherer.collection.CollectionContentsChangedListener;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.greenstone.Plugins;
import org.greenstone.gatherer.gui.DesignPaneHeader;
import org.greenstone.gatherer.gui.GComboBox;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.gui.WarningDialog;
import org.greenstone.gatherer.util.JarTools;
import org.greenstone.gatherer.util.StaticStrings;
import org.greenstone.gatherer.util.Utility;
import org.w3c.dom.Element;

public class PluginManager
extends DOMProxyListModel
implements CollectionContentsChangedListener {
    private boolean modify_row_count = false;
    private Control controls = null;
    private DOMProxyListModel model;
    private JPanel separator;
    private Plugin separator_plugin;
    private static int NUM_FIXED_PLUGINS = 3;

    public PluginManager() {
        super(CollectionDesignManager.collect_config.getDocumentElement(), "Plugin", new Plugin());
        DebugStream.println("PluginManager: " + super.getSize() + " plugins parsed.");
        this.model = this;
        for (int i = 0; i < this.getSize(); ++i) {
            this.getElementAt(i);
        }
        Gatherer.invokeInEDT_replacesProceedInCurrThread("CollectionDesignManager.loadDesignDetails", true, new Runnable(){

            @Override
            public void run() {
                PluginManager.this.separator = PluginManager.this.getSeparator();
                PluginManager.this.placeSeparator();
            }
        });
        this.ensureMetadataXMLPlugIsLoaded();
        CollectionManager.addCollectionContentsChangedListener(this);
    }

    private void ensureMetadataXMLPlugIsLoaded() {
        Plugin plugin = Plugins.getPlugin("MetadataXMLPlugin", false);
        if (plugin != null && !this.contains(plugin)) {
            Element element = CollectionConfiguration.createElement("Plugin");
            element.setAttribute("type", plugin.getName());
            Plugin plugin2 = new Plugin(element, plugin);
            this.assignPlugin(plugin2);
        }
    }

    private Object[] getAvailablePlugins() {
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        ArrayList arrayList2 = Plugins.getPluginsList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string;
            Plugin plugin = (Plugin)arrayList2.get(i);
            if (plugin.isAbstract() || (string = plugin.getName()).equals("ArchivesInfPlugin") || string.equals("DirectoryPlugin") || string.equals("MetadataXMLPlugin")) continue;
            arrayList.add(plugin);
        }
        Collections.sort(arrayList);
        return arrayList.toArray();
    }

    public ArrayList getExploderPlugins(File file) {
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        ArrayList arrayList2 = Plugins.getPluginsList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            Plugin plugin = (Plugin)arrayList2.get(i);
            if (!plugin.doesExplodeMetadataDatabases() || !plugin.doesProcessFile(file)) continue;
            arrayList.add(plugin);
        }
        return arrayList;
    }

    public boolean isFileExplodable(File file) {
        ArrayList arrayList = Plugins.getPluginsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Plugin plugin = (Plugin)arrayList.get(i);
            if (!plugin.doesExplodeMetadataDatabases() || !plugin.doesProcessFile(file)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getSrcReplacerPlugins(File file) {
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        ArrayList arrayList2 = Plugins.getPluginsList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            Plugin plugin = (Plugin)arrayList2.get(i);
            if (!plugin.doesReplaceSrcDocsWithHtml() || !plugin.doesProcessFile(file)) continue;
            arrayList.add(plugin);
        }
        return arrayList;
    }

    public boolean isFileSrcReplaceable(File file) {
        ArrayList arrayList = Plugins.getPluginsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Plugin plugin = (Plugin)arrayList.get(i);
            if (!plugin.doesReplaceSrcDocsWithHtml() || !plugin.doesProcessFile(file)) continue;
            return true;
        }
        return false;
    }

    private void assignPlugin(Plugin plugin) {
        if (plugin.getName().equals("DirectoryPlugin") || plugin.getName().equals("ArchivesInfPlugin") || plugin.getName().equals("MetadataXMLPlugin")) {
            this.addAfter(plugin, this.separator_plugin);
        } else {
            this.addBefore(plugin, this.separator_plugin);
        }
    }

    public void destroy() {
        CollectionManager.removeCollectionContentsChangedListener(this);
        if (this.controls != null) {
            this.controls.destroy();
            this.controls = null;
        }
    }

    @Override
    public void fileAddedToCollection(File file) {
        Serializable serializable;
        Object[] objectArray;
        for (int i = 0; i < super.getSize(); ++i) {
            objectArray = (Object[])this.getElementAt(i);
            if (objectArray.isSeparator() || !objectArray.doesProcessFile(file) && !objectArray.doesBlockFile(file)) continue;
            DebugStream.println("Processed by assigned plugin: " + objectArray);
            return;
        }
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        objectArray = this.getAvailablePlugins();
        for (int i = 0; i < objectArray.length; ++i) {
            serializable = (Plugin)objectArray[i];
            if (!((Plugin)serializable).doesProcessFile(file)) continue;
            DebugStream.println("Processed by unassigned plugin: " + serializable);
            arrayList.add((Plugin)serializable);
        }
        if (arrayList.size() == 0) {
            String[] stringArray = new String[]{file.getName()};
            serializable = new WarningDialog("warning.NoPluginExpectedToProcessFile", Dictionary.get("NoPluginExpectedToProcessFile.Title"), Dictionary.get("NoPluginExpectedToProcessFile.Message", stringArray), null, false);
            ((WarningDialog)serializable).display();
            ((ModalDialog)serializable).dispose();
            return;
        }
        new PluginSuggestionPrompt(file.getName(), arrayList);
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new PluginControl();
        }
        return this.controls;
    }

    @Override
    public int getSize() {
        int n = super.getSize();
        if (this.modify_row_count) {
            n -= NUM_FIXED_PLUGINS + 1;
        }
        return n;
    }

    public void modeChanged(int n) {
        if (this.controls != null) {
            ((PluginControl)this.controls).modeChanged(n);
        }
    }

    private void movePlugin(Plugin plugin, boolean bl, boolean bl2) {
        if (super.getSize() < NUM_FIXED_PLUGINS + 2) {
            return;
        }
        if (plugin.getName().equals("ArchivesInfPlugin") || plugin.getName().equals("DirectoryPlugin") || plugin.getName().equals("MetadataXMLPlugin")) {
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CDM.Move.Fixed"), Dictionary.get("CDM.Move.Title"), 0);
            return;
        }
        if (bl2) {
            if (bl) {
                this.remove(plugin);
                Plugin plugin2 = (Plugin)this.getElementAt(0);
                this.addBefore(plugin, plugin2);
                plugin2 = null;
            } else {
                this.remove(plugin);
                this.addBefore(plugin, this.separator_plugin);
            }
        } else {
            int n = this.indexOf(plugin);
            if (bl) {
                if (--n < 0) {
                    String[] stringArray = new String[]{Dictionary.get("CDM.PlugInManager.PlugIn_Str"), plugin.getName()};
                    JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CDM.Move.At_Top", stringArray), Dictionary.get("CDM.Move.Title"), 0);
                    return;
                }
                this.remove(plugin);
                this.add(n, plugin);
            } else {
                Plugin plugin3;
                if ((plugin3 = (Plugin)this.getElementAt(++n)).isSeparator()) {
                    String[] stringArray = new String[]{plugin.getName()};
                    JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CDM.Move.Cannot", stringArray), Dictionary.get("CDM.Move.Title"), 0);
                    return;
                }
                this.remove(plugin);
                this.add(n, plugin);
            }
        }
    }

    private void placeSeparator() {
        int n = super.getSize();
        if (n > 0) {
            boolean bl = false;
            int n2 = n - 1;
            while (n2 > 0) {
                Plugin plugin = (Plugin)this.getElementAt(n2);
                String string = plugin.getName();
                if (string.equals("DirectoryPlugin") || string.equals("ArchivesInfPlugin") || string.equals("MetadataXMLPlugin")) {
                    bl = true;
                    --n2;
                } else if (bl) {
                    n = n2 + 1;
                    n2 = -1;
                } else {
                    --n2;
                }
                string = null;
                plugin = null;
            }
        }
        Element element = CollectionConfiguration.createElement("Plugin");
        element.setAttribute("type", "separator");
        element.setAttribute("separator", "true");
        this.separator_plugin = new Plugin(element, null);
        this.add(n, this.separator_plugin);
    }

    private void removePlugin(Plugin plugin) {
        this.remove(plugin);
    }

    private void setHideLines(boolean bl) {
        this.modify_row_count = bl;
        int n = super.getSize();
        if (bl) {
            this.fireIntervalRemoved(this, n - (NUM_FIXED_PLUGINS + 2), n - 1);
        } else {
            this.fireIntervalAdded(this, n - (NUM_FIXED_PLUGINS + 2), n - 1);
        }
    }

    private int findSeparatorIndex() {
        int n;
        for (n = super.getSize() - 1; n >= 0; --n) {
            Plugin plugin = (Plugin)this.getElementAt(n);
            if (!plugin.isSeparator()) continue;
            return n;
        }
        return n;
    }

    private JPanel getSeparator() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 3, 1, 3));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        jPanel.add(new BasicSeparator());
        jPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        return jPanel;
    }

    private static class BasicSeparator
    extends JSeparator {
        private ComponentUI basic_ui = new BasicSeparatorUI();

        @Override
        public void paintComponent(Graphics graphics) {
            if (this.basic_ui != null) {
                this.basic_ui.update(graphics, this);
            }
        }
    }

    private class PluginSuggestionPrompt
    extends ModalDialog
    implements ActionListener {
        private Dimension size;
        private GComboBox suitable_plugins_combobox;
        private GLIButton add_button;
        private GLIButton ignore_button;

        public PluginSuggestionPrompt(String string, ArrayList arrayList) {
            super((Frame)Gatherer.g_man, true);
            this.size = new Dimension(480, 240);
            this.suitable_plugins_combobox = null;
            this.add_button = null;
            this.ignore_button = null;
            this.setModal(true);
            this.setSize(this.size);
            this.setTitle(Dictionary.get("CDM.PluginManager.SuggestedPluginListTitle"));
            this.setComponentOrientation(Dictionary.getOrientation());
            String[] stringArray = new String[]{string};
            JTextArea jTextArea = new JTextArea(Dictionary.get("CDM.PluginManager.Plugin_Suggestion_Prompt", stringArray));
            jTextArea.setCaretPosition(0);
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setRows(5);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel = new JLabel(Dictionary.get("CDM.PlugInManager.PlugIn"));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            jLabel.setComponentOrientation(Dictionary.getOrientation());
            this.suitable_plugins_combobox = new GComboBox(arrayList);
            this.suitable_plugins_combobox.setBackgroundNonSelectionColor(Configuration.getColor("coloring.editable_background", false));
            this.suitable_plugins_combobox.setBackgroundSelectionColor(Configuration.getColor("coloring.collection_selection_background", false));
            this.suitable_plugins_combobox.setTextNonSelectionColor(Configuration.getColor("coloring.workspace_tree_foreground", false));
            this.suitable_plugins_combobox.setTextSelectionColor(Configuration.getColor("coloring.collection_selection_foreground", false));
            this.suitable_plugins_combobox.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            jPanel.setLayout(new BorderLayout(5, 0));
            jPanel.add((Component)jLabel, "Before");
            jPanel.add((Component)this.suitable_plugins_combobox, "Center");
            this.add_button = new GLIButton(Dictionary.get("CDM.PlugInManager.QuickAdd"), Dictionary.get("CDM.PlugInManager.Add_Tooltip"));
            this.ignore_button = new GLIButton(Dictionary.get("CDM.PlugInManager.Ignore"), Dictionary.get("CDM.PlugInManager.Ignore_Tooltip"));
            this.add_button.addActionListener(this);
            this.ignore_button.addActionListener(this);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayout(1, 2, 5, 0));
            jPanel2.add(this.add_button);
            jPanel2.add(this.ignore_button);
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel3.setLayout(new GridLayout(2, 1, 0, 5));
            jPanel3.add(jPanel);
            jPanel3.add(jPanel2);
            jPanel3.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel4 = (JPanel)this.getContentPane();
            jPanel4.setComponentOrientation(Dictionary.getOrientation());
            jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)jTextArea, "Center");
            jPanel4.add((Component)jPanel3, "South");
            Dimension dimension = Configuration.screen_size;
            this.setLocation((dimension.width - this.size.width) / 2, (dimension.height - this.size.height) / 2);
            TestingPreparation.setNamesRecursively(this);
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setVisible(false);
            if (actionEvent.getSource() == this.add_button) {
                AddPluginWithoutConfigurationTask addPluginWithoutConfigurationTask = new AddPluginWithoutConfigurationTask(this.suitable_plugins_combobox.getSelectedItem().toString());
                addPluginWithoutConfigurationTask.start();
                try {
                    addPluginWithoutConfigurationTask.join();
                }
                catch (Exception exception) {
                    DebugStream.printStackTrace(exception);
                }
            }
        }

        private class AddPluginWithoutConfigurationTask
        extends Thread {
            private String plugin_name;

            public AddPluginWithoutConfigurationTask(String string) {
                this.plugin_name = string;
            }

            @Override
            public void run() {
                Plugin plugin = Plugins.getPlugin(this.plugin_name, true);
                if (plugin == null) {
                    System.err.println("Error: getPlugin() returned null.");
                    return;
                }
                Element element = CollectionConfiguration.createElement("Plugin");
                element.setAttribute("type", plugin.getName());
                Plugin plugin2 = new Plugin(element, plugin);
                PluginManager.this.assignPlugin(plugin2);
                Gatherer.c_man.getCollection().cdm.save();
            }
        }
    }

    private class PluginControl
    extends JPanel
    implements Control {
        private JButton add = new GLIButton(Dictionary.get("CDM.PlugInManager.Add"), Dictionary.get("CDM.PlugInManager.Add_Tooltip"));
        private JButton configure = null;
        private JButton move_down_button = null;
        private JButton move_up_button = null;
        private JButton remove = null;
        private JComboBox plugin_combobox = null;
        private JLabel plugin_label = null;
        private JLabel plugin_list_label = null;
        private JList plugin_list = null;
        private JPanel button_pane = new JPanel();
        private JPanel central_pane = new JPanel();
        private JPanel movement_pane = null;
        private JPanel plugin_pane = null;
        private JPanel plugin_list_pane = null;

        public PluginControl() {
            this.button_pane.setComponentOrientation(Dictionary.getOrientation());
            this.central_pane.setComponentOrientation(Dictionary.getOrientation());
            this.configure = new GLIButton(Dictionary.get("CDM.PlugInManager.Configure"), Dictionary.get("CDM.PlugInManager.Configure_Tooltip"));
            this.configure.setEnabled(false);
            DesignPaneHeader designPaneHeader = new DesignPaneHeader("CDM.GUI.Plugins", "plugins");
            this.move_up_button = new GLIButton(Dictionary.get("CDM.Move.Move_Up"), JarTools.getImage("arrow-up.gif"), Dictionary.get("CDM.Move.Move_Up_Tooltip"));
            this.move_up_button.setEnabled(false);
            this.move_down_button = new GLIButton(Dictionary.get("CDM.Move.Move_Down"), JarTools.getImage("arrow-down.gif"), Dictionary.get("CDM.Move.Move_Down_Tooltip"));
            this.move_down_button.setEnabled(false);
            this.movement_pane = new JPanel();
            this.movement_pane.setComponentOrientation(Dictionary.getOrientation());
            PluginComboboxListener pluginComboboxListener = new PluginComboboxListener();
            this.plugin_combobox = new JComboBox<Object>(PluginManager.this.getAvailablePlugins());
            this.plugin_combobox.setOpaque(!Utility.isMac());
            this.plugin_combobox.setEditable(false);
            this.plugin_combobox.setComponentOrientation(Dictionary.getOrientation());
            pluginComboboxListener.itemStateChanged(new ItemEvent(this.plugin_combobox, 0, null, 1));
            this.plugin_label = new JLabel(Dictionary.get("CDM.PlugInManager.PlugIn"));
            this.plugin_label.setComponentOrientation(Dictionary.getOrientation());
            this.plugin_list = new JList(PluginManager.this.model);
            this.plugin_list.setOpaque(true);
            this.plugin_list.setCellRenderer(new ListRenderer());
            this.plugin_list.setSelectionMode(0);
            this.plugin_list.setComponentOrientation(Dictionary.getOrientation());
            this.plugin_list_label = new JLabel(Dictionary.get("CDM.PlugInManager.Assigned"));
            this.plugin_list_label.setOpaque(true);
            this.plugin_list_label.setComponentOrientation(Dictionary.getOrientation());
            this.plugin_list_pane = new JPanel();
            this.plugin_list_pane.setComponentOrientation(Dictionary.getOrientation());
            this.plugin_pane = new JPanel();
            this.plugin_pane.setOpaque(true);
            this.plugin_pane.setComponentOrientation(Dictionary.getOrientation());
            this.remove = new GLIButton(Dictionary.get("CDM.PlugInManager.Remove"), Dictionary.get("CDM.PlugInManager.Remove_Tooltip"));
            this.remove.setEnabled(false);
            this.add.addActionListener(new AddListener());
            this.configure.addActionListener(new ConfigureListener());
            MoveListener moveListener = new MoveListener();
            this.move_down_button.addActionListener(moveListener);
            this.move_down_button.addActionListener(CollectionDesignManager.all_change_listener);
            this.move_up_button.addActionListener(moveListener);
            this.move_up_button.addActionListener(CollectionDesignManager.all_change_listener);
            this.plugin_combobox.addItemListener(pluginComboboxListener);
            this.remove.addActionListener(new RemoveListener());
            this.remove.addActionListener(CollectionDesignManager.all_change_listener);
            this.plugin_list.addMouseListener(new ClickListener());
            this.plugin_list.addListSelectionListener(new ListListener());
            pluginComboboxListener = null;
            this.movement_pane.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            this.movement_pane.setLayout(new GridLayout(4, 1));
            this.movement_pane.add(this.move_up_button);
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            this.movement_pane.add(jPanel);
            jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            this.movement_pane.add(jPanel);
            this.movement_pane.add(this.move_down_button);
            this.plugin_list_pane.setLayout(new BorderLayout());
            this.plugin_list_pane.add((Component)this.plugin_list_label, "North");
            this.plugin_list_pane.add((Component)new JScrollPane(this.plugin_list), "Center");
            this.plugin_list_pane.add((Component)this.movement_pane, "After");
            this.modeChanged(Configuration.getMode());
            this.plugin_label.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            this.plugin_pane.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.plugin_pane.setLayout(new BorderLayout(5, 0));
            this.plugin_pane.add((Component)this.plugin_label, "Before");
            this.plugin_pane.add((Component)this.plugin_combobox, "Center");
            this.button_pane.setLayout(new GridLayout(1, 3));
            this.button_pane.add(this.add);
            this.button_pane.add(this.configure);
            this.button_pane.add(this.remove);
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel2.add((Component)this.plugin_pane, "North");
            jPanel2.add((Component)this.button_pane, "South");
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            this.central_pane.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            this.central_pane.setLayout(new BorderLayout());
            this.central_pane.add((Component)this.plugin_list_pane, "Center");
            this.central_pane.add((Component)jPanel2, "South");
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)designPaneHeader, "North");
            this.add((Component)this.central_pane, "Center");
            TestingPreparation.setNamesRecursively(this);
        }

        @Override
        public void destroy() {
        }

        @Override
        public void gainFocus() {
            super.updateUI();
        }

        @Override
        public void loseFocus() {
        }

        public void modeChanged(int n) {
            this.plugin_list.clearSelection();
            this.plugin_combobox.setModel(new DefaultComboBoxModel<Object>(PluginManager.this.getAvailablePlugins()));
            PluginManager.this.setHideLines(n < 3);
            this.plugin_list_pane.updateUI();
        }

        private class RemoveListener
        implements ActionListener {
            private RemoveListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = PluginControl.this.plugin_list.getSelectedIndex();
                if (n != -1) {
                    Plugin plugin = (Plugin)PluginControl.this.plugin_list.getSelectedValue();
                    PluginManager.this.removePlugin(plugin);
                    plugin = null;
                    PluginControl.this.plugin_combobox.setModel(new DefaultComboBoxModel<Object>(PluginManager.this.getAvailablePlugins()));
                    if (n < PluginControl.this.plugin_list.getModel().getSize()) {
                        if (n < PluginManager.this.findSeparatorIndex()) {
                            PluginControl.this.plugin_list.setSelectedIndex(n);
                            int n2 = Configuration.getMode();
                            for (int i = 0; i < StaticStrings.KEEP_PLUG.length; ++i) {
                                String string = ((Plugin)PluginControl.this.plugin_list.getSelectedValue()).getName();
                                if (string.equals("MetadataXMLPlugin")) {
                                    PluginControl.this.remove.setEnabled(false);
                                    continue;
                                }
                                if (string.equals(StaticStrings.KEEP_PLUG[i]) && n2 < 3) {
                                    PluginControl.this.remove.setEnabled(false);
                                    break;
                                }
                                PluginControl.this.remove.setEnabled(true);
                            }
                        } else {
                            PluginControl.this.plugin_list.setSelectedIndex(n + 1);
                            PluginControl.this.remove.setEnabled(false);
                        }
                    } else {
                        PluginControl.this.remove.setEnabled(false);
                    }
                } else {
                    PluginControl.this.remove.setEnabled(false);
                }
            }
        }

        private class PluginComboboxListener
        implements ItemListener {
            private PluginComboboxListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Object object = PluginControl.this.plugin_combobox.getSelectedItem();
                    if (object == null || object instanceof String) {
                        PluginControl.this.plugin_combobox.setToolTipText(Dictionary.get("CDM.PlugInManager.PlugIn_Tooltip"));
                    } else {
                        Plugin plugin = (Plugin)object;
                        PluginControl.this.plugin_combobox.setToolTipText(Utility.formatHTMLWidth(plugin.getDescription(), 40));
                        plugin = null;
                    }
                    object = null;
                }
            }
        }

        private class MoveListener
        implements ActionListener {
            private MoveListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object e;
                if (!PluginControl.this.plugin_list.isSelectionEmpty() && (e = PluginControl.this.plugin_list.getSelectedValue()) instanceof Plugin) {
                    Plugin plugin = (Plugin)e;
                    if (actionEvent.getSource() == PluginControl.this.move_up_button) {
                        PluginManager.this.movePlugin(plugin, true, false);
                    } else if (actionEvent.getSource() == PluginControl.this.move_down_button) {
                        PluginManager.this.movePlugin(plugin, false, false);
                    }
                    int n = PluginManager.this.indexOf(plugin);
                    if (n >= 0 && n < PluginControl.this.plugin_list.getModel().getSize()) {
                        PluginControl.this.plugin_list.setSelectedIndex(n);
                        PluginControl.this.plugin_list.ensureIndexIsVisible(n);
                    }
                }
            }
        }

        private class ListRenderer
        extends DefaultListCellRenderer {
            private ListRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Plugin plugin = (Plugin)object;
                if (plugin.isSeparator()) {
                    return PluginManager.this.separator;
                }
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
        }

        private class ListListener
        implements ListSelectionListener {
            private ListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (PluginControl.this.plugin_list.isSelectionEmpty()) {
                        PluginControl.this.move_up_button.setEnabled(false);
                        PluginControl.this.move_down_button.setEnabled(false);
                        PluginControl.this.configure.setEnabled(false);
                        PluginControl.this.remove.setEnabled(false);
                    } else {
                        Plugin plugin = (Plugin)PluginControl.this.plugin_list.getSelectedValue();
                        if (plugin.isSeparator()) {
                            PluginControl.this.move_up_button.setEnabled(false);
                            PluginControl.this.move_down_button.setEnabled(false);
                            PluginControl.this.configure.setEnabled(false);
                            PluginControl.this.remove.setEnabled(false);
                        } else {
                            PluginControl.this.configure.setEnabled(true);
                            String string = plugin.getName();
                            if (string.equals("ArchivesInfPlugin") || string.equals("DirectoryPlugin") || string.equals("MetadataXMLPlugin")) {
                                PluginControl.this.move_up_button.setEnabled(false);
                                PluginControl.this.move_down_button.setEnabled(false);
                                PluginControl.this.remove.setEnabled(false);
                            } else {
                                Plugin plugin2;
                                int n = Configuration.getMode();
                                for (int i = 0; i < StaticStrings.KEEP_PLUG.length; ++i) {
                                    if (string.equals(StaticStrings.KEEP_PLUG[i]) && n < 3) {
                                        PluginControl.this.remove.setEnabled(false);
                                        break;
                                    }
                                    PluginControl.this.remove.setEnabled(true);
                                }
                                if (!(plugin2 = (Plugin)PluginManager.this.getElementAt(0)).equals(plugin)) {
                                    PluginControl.this.move_up_button.setEnabled(true);
                                } else {
                                    PluginControl.this.move_up_button.setEnabled(false);
                                }
                                int n2 = PluginManager.this.findSeparatorIndex();
                                int n3 = PluginControl.this.plugin_list.getSelectedIndex();
                                if (n3 < n2 - 1) {
                                    PluginControl.this.move_down_button.setEnabled(true);
                                } else {
                                    PluginControl.this.move_down_button.setEnabled(false);
                                }
                            }
                            plugin = null;
                            string = null;
                        }
                    }
                }
            }
        }

        private class ConfigureListener
        implements ActionListener {
            private ConfigureListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Plugin plugin;
                if (!PluginControl.this.plugin_list.isSelectionEmpty() && !(plugin = (Plugin)PluginControl.this.plugin_list.getSelectedValue()).isSeparator()) {
                    ArgumentConfiguration argumentConfiguration = new ArgumentConfiguration(plugin);
                    argumentConfiguration.addOKButtonActionListener(CollectionDesignManager.all_change_listener);
                    if (argumentConfiguration.display()) {
                        PluginManager.this.refresh(plugin);
                    }
                    argumentConfiguration.destroy();
                    argumentConfiguration = null;
                }
            }
        }

        private class ClickListener
        extends MouseAdapter {
            private ClickListener() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Plugin plugin;
                if (mouseEvent.getClickCount() == 2 && !PluginControl.this.plugin_list.isSelectionEmpty() && !(plugin = (Plugin)PluginControl.this.plugin_list.getSelectedValue()).isSeparator()) {
                    ArgumentConfiguration argumentConfiguration = new ArgumentConfiguration(plugin);
                    argumentConfiguration.addOKButtonActionListener(CollectionDesignManager.all_change_listener);
                    if (argumentConfiguration.display()) {
                        PluginManager.this.refresh(plugin);
                    }
                    argumentConfiguration.destroy();
                    argumentConfiguration = null;
                }
            }
        }

        private class AddPluginTask
        extends Thread {
            private String plugin_name;

            public AddPluginTask(String string) {
                this.plugin_name = string;
            }

            @Override
            public void run() {
                Plugin plugin = Plugins.getPlugin(this.plugin_name, true);
                if (plugin == null) {
                    System.err.println("Error: getPlugin() returned null.");
                    return;
                }
                Element element = CollectionConfiguration.createElement("Plugin");
                element.setAttribute("type", plugin.getName());
                final Plugin plugin2 = new Plugin(element, plugin);
                Gatherer.invokeInEDT_replacesProceedInCurrThread("PluginManager::AddPluginTask.run()", true, new Runnable(){

                    @Override
                    public void run() {
                        ArgumentConfiguration argumentConfiguration = new ArgumentConfiguration(plugin2);
                        argumentConfiguration.addOKButtonActionListener(CollectionDesignManager.all_change_listener);
                        if (argumentConfiguration.display()) {
                            PluginManager.this.assignPlugin(plugin2);
                            PluginControl.this.plugin_list.setSelectedValue(plugin2, true);
                        }
                    }
                });
            }
        }

        private class AddListener
        implements ActionListener {
            private AddListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PluginControl.this.plugin_combobox.getSelectedItem() != null) {
                    new AddPluginTask(PluginControl.this.plugin_combobox.getSelectedItem().toString()).start();
                }
            }
        }
    }
}

