/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.feedback;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.greenstone.gatherer.feedback.ActionRecorderDialog;
import org.greenstone.gatherer.feedback.Base64;
import org.greenstone.gatherer.feedback.History;
import org.greenstone.gatherer.feedback.ReportDetails;
import org.greenstone.gatherer.feedback.SaveToXML;
import org.greenstone.gatherer.feedback.ScreenShot;
import org.greenstone.gatherer.feedback.SelectPicture;
import org.greenstone.gatherer.feedback.SendHTTP;
import org.greenstone.gatherer.feedback.ZipFile;

public class FeedbackInterface
extends JDialog
implements ActionListener {
    private JButton view_button;
    public JButton send_button;
    private JButton notsend_button;
    private JTextArea problem_details;
    private JComboBox problem_type;
    private JComboBox problem_urgency;
    private JComboBox problem_screenshot;
    private JTextField smtp_address;
    private JTextField email_address;
    private String frameName;
    private static String code;
    private Date curr_date;
    private static ActionRecorderDialog dialog;
    private static ResourceBundle messages;
    private ScreenShot screen;
    private Thread save;
    private HashMap picAndPane;
    private JPanel picture_scroll;
    private int row;
    private ArrayList paneArray;
    private JButton remove;
    private FeedbackInterface frame;
    private Thread sendThread;
    private static boolean finish;
    private Timer timer;
    private JProgressBar progressBar;
    private JLabel wait_lbl;
    private Color bckcolor;
    private JPanel tempPane;
    private Thread prevThread;
    private boolean selected = false;
    private MouseListener mouse_blocker_listener = new MouseAdapter(){};

    public FeedbackInterface(ScreenShot screenShot, String string, ResourceBundle resourceBundle, ActionRecorderDialog actionRecorderDialog) {
        this.frame = this;
        this.bckcolor = new Color(176, 209, 217);
        this.picAndPane = new HashMap();
        messages = resourceBundle;
        this.frameName = string;
        dialog = actionRecorderDialog;
        FeedbackInterface.setDefaultLookAndFeelDecorated(true);
        this.setDefaultCloseOperation(0);
        this.setTitle(messages.getString("SendFeedbackForm"));
        this.screen = screenShot;
        Container container = this.getContentPane();
        this.createUI(container);
        this.curr_date = new Date();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.height;
        int n2 = dimension.width;
        Dimension dimension2 = this.getSize();
        this.setLocation(n2 - dimension2.width - 500, n - dimension2.height - 700);
        this.setBackground(this.bckcolor);
        this.pack();
        this.setModal(false);
        this.setVisible(true);
    }

    public void createUI(Container container) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.bckcolor);
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        String string = messages.getString("FeedbackOpeningText");
        JTextArea jTextArea = new JTextArea(string);
        jTextArea.setMinimumSize(new Dimension(100, 100));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(new EmptyBorder(10, 10, 0, 10));
        jTextArea.setBackground(this.bckcolor);
        jPanel.add(jTextArea);
        this.tempPane = new JPanel();
        this.tempPane.setLayout(new BorderLayout());
        this.tempPane.setBackground(new Color(176, 208, 176));
        this.paneArray = new ArrayList();
        this.picture_scroll = new JPanel();
        this.row = 1;
        this.picture_scroll.setLayout(new GridLayout(0, 1));
        this.picture_scroll.setBackground(new Color(176, 208, 176));
        this.tempPane.add((Component)this.picture_scroll, "First");
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(new Color(176, 208, 176));
        this.remove = new JButton("Remove");
        this.remove.setActionCommand("Remove");
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FeedbackInterface.this.paneArray.size() == 0) {
                    System.out.println("There is no panel here!");
                } else {
                    JPanel jPanel = (JPanel)FeedbackInterface.this.paneArray.get(FeedbackInterface.this.row - 2);
                    Object v = FeedbackInterface.this.picAndPane.get(jPanel);
                    v = null;
                    FeedbackInterface.this.picAndPane.remove(jPanel);
                    FeedbackInterface.this.paneArray.remove(FeedbackInterface.this.row - 2);
                    if (FeedbackInterface.this.paneArray.size() == 0) {
                        FeedbackInterface.this.remove.setVisible(false);
                    }
                    FeedbackInterface.this.picture_scroll.remove(jPanel);
                    FeedbackInterface.this.row--;
                    FeedbackInterface.this.picture_scroll.setSize(FeedbackInterface.this.picture_scroll.getPreferredSize());
                    FeedbackInterface.this.picture_scroll.revalidate();
                    FeedbackInterface.this.picture_scroll.repaint();
                    FeedbackInterface.this.tempPane.setSize(FeedbackInterface.this.tempPane.getPreferredSize());
                    FeedbackInterface.this.tempPane.revalidate();
                    FeedbackInterface.this.tempPane.repaint();
                }
            }
        });
        this.remove.setToolTipText("Remove last thumbnail");
        this.remove.setBackground(new Color(176, 208, 176));
        this.remove.setVisible(false);
        jPanel2.add(this.remove);
        this.tempPane.add((Component)jPanel2, "Last");
        JScrollPane jScrollPane = new JScrollPane(this.tempPane);
        jScrollPane.setBackground(this.bckcolor);
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        jScrollPane.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel.add(jScrollPane);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBackground(this.bckcolor);
        jPanel3.setLayout(new GridLayout(0, 2));
        jPanel3.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel jLabel = new JLabel(messages.getString("Whatkindofproblemisit") + "?    ");
        jLabel.setBackground(this.bckcolor);
        jPanel3.add(jLabel);
        String[] stringArray = new String[]{" ", messages.getString("ContentError"), messages.getString("ImageNotShow"), messages.getString("StrangeBehaviour"), messages.getString("SomethingUnexpectedHappen"), messages.getString("HardToUse"), messages.getString("Other")};
        this.problem_type = new JComboBox<String>(stringArray);
        this.problem_type.setOpaque(false);
        this.problem_type.addActionListener(this);
        this.problem_type.setBackground(this.bckcolor);
        jPanel3.add(this.problem_type);
        JLabel jLabel2 = new JLabel(messages.getString("Howbadistheproblem") + "?  ");
        jLabel2.setBackground(this.bckcolor);
        jPanel3.add(jLabel2);
        String[] stringArray2 = new String[]{" ", messages.getString("Critical"), messages.getString("Serious"), messages.getString("Medium"), messages.getString("Minor"), messages.getString("Trivial")};
        this.problem_urgency = new JComboBox<String>(stringArray2);
        this.problem_urgency.setOpaque(false);
        this.problem_urgency.addActionListener(this);
        this.problem_urgency.setBackground(this.bckcolor);
        jPanel3.add(this.problem_urgency);
        JLabel jLabel3 = new JLabel("   ");
        jLabel3.setBackground(this.bckcolor);
        jPanel3.add(jLabel3);
        JLabel jLabel4 = new JLabel("   ");
        jLabel4.setBackground(this.bckcolor);
        jPanel3.add(jLabel4);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 3));
        jPanel4.setBackground(this.bckcolor);
        jPanel4.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.view_button = new JButton("Details . . .");
        this.view_button.setActionCommand(messages.getString("Preview"));
        this.view_button.addActionListener(this);
        this.view_button.setToolTipText(messages.getString("ConformationPreview"));
        this.view_button.setBackground(this.bckcolor);
        jPanel4.add(this.view_button);
        this.send_button = new JButton(messages.getString("Send"));
        this.send_button.setActionCommand(messages.getString("Send"));
        this.send_button.addActionListener(this);
        this.send_button.setDefaultCapable(true);
        this.send_button.setToolTipText(messages.getString("FeedbackSendButton"));
        this.send_button.setBackground(this.bckcolor);
        jPanel4.add(this.send_button);
        this.notsend_button = new JButton("Cancel");
        this.notsend_button.setActionCommand(messages.getString("NotSend"));
        this.notsend_button.addActionListener(this);
        this.notsend_button.setToolTipText(messages.getString("FeedbackNotSendButton"));
        this.notsend_button.setBackground(this.bckcolor);
        jPanel4.add(this.notsend_button);
        jPanel.add(jPanel4);
        jTextArea.setAlignmentX(0.0f);
        jScrollPane.setAlignmentX(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel4.setAlignmentX(0.0f);
        String string2 = messages.getString("FeedbackAboutText");
        JTextArea jTextArea2 = new JTextArea(string2);
        jTextArea2.setEditable(false);
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setBackground(this.bckcolor);
        jTextArea2.setBorder(new EmptyBorder(10, 10, 10, 10));
        String string3 = messages.getString("FeedbackPrivacyText");
        JTextArea jTextArea3 = new JTextArea(string3);
        jTextArea3.setEditable(false);
        jTextArea3.setLineWrap(true);
        jTextArea3.setWrapStyleWord(true);
        jTextArea3.setBackground(this.bckcolor);
        jTextArea3.setBorder(new EmptyBorder(10, 10, 10, 10));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBackground(this.bckcolor);
        jTabbedPane.addTab(messages.getString("Form"), jPanel);
        jTabbedPane.addTab(messages.getString("About"), jTextArea2);
        jTabbedPane.addTab(messages.getString("Privacy"), jTextArea3);
        jTabbedPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 3));
        jPanel5.setBackground(this.bckcolor);
        jPanel5.setBorder(new EmptyBorder(new Insets(10, 10, 10, 10)));
        this.wait_lbl = new JLabel(messages.getString("Pleasewait"));
        this.wait_lbl.setBackground(this.bckcolor);
        this.wait_lbl.setVisible(false);
        jPanel5.add(this.wait_lbl);
        this.progressBar = new JProgressBar();
        this.progressBar.setBackground(this.bckcolor);
        this.progressBar.setVisible(false);
        jPanel5.add(this.progressBar);
        JLabel jLabel5 = new JLabel("   ");
        jLabel5.setBackground(this.bckcolor);
        jPanel5.add(jLabel5);
        this.wait_lbl.setAlignmentX(0.5f);
        this.progressBar.setAlignmentX(0.5f);
        jLabel5.setAlignmentX(0.5f);
        final String string4 = "Tab";
        final String string5 = "ProgressBar";
        final JPanel jPanel6 = new JPanel(new CardLayout());
        jPanel6.setBackground(this.bckcolor);
        jPanel6.add((Component)jTabbedPane, string4);
        jPanel6.add((Component)jPanel5, string5);
        container.add(jPanel6);
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (finish) {
                    if (FeedbackInterface.this.sendThread != null) {
                        FeedbackInterface.this.sendThread.interrupt();
                        FeedbackInterface.this.sendThread = null;
                    }
                    if (FeedbackInterface.this.prevThread != null) {
                        FeedbackInterface.this.prevThread.interrupt();
                        FeedbackInterface.this.prevThread = null;
                    }
                    Component component = FeedbackInterface.this.frame.getGlassPane();
                    component.setVisible(false);
                    component.setCursor(Cursor.getPredefinedCursor(0));
                    component.removeMouseListener(FeedbackInterface.this.mouse_blocker_listener);
                    FeedbackInterface.this.wait_lbl.setVisible(false);
                    FeedbackInterface.this.progressBar.setIndeterminate(false);
                    FeedbackInterface.this.progressBar.setVisible(false);
                    FeedbackInterface.this.frame.setTitle(messages.getString("SendFeedbackForm"));
                    CardLayout cardLayout = (CardLayout)jPanel6.getLayout();
                    cardLayout.show(jPanel6, string4);
                    if (FeedbackInterface.this.selected) {
                        FeedbackInterface.this.frame.dispose();
                    }
                    FeedbackInterface.this.timer.stop();
                } else {
                    Component component = FeedbackInterface.this.frame.getGlassPane();
                    component.addMouseListener(FeedbackInterface.this.mouse_blocker_listener);
                    component.setCursor(Cursor.getPredefinedCursor(3));
                    component.setVisible(true);
                    FeedbackInterface.this.frame.setTitle("Please wait...");
                    CardLayout cardLayout = (CardLayout)jPanel6.getLayout();
                    cardLayout.show(jPanel6, string5);
                    FeedbackInterface.this.wait_lbl.setVisible(true);
                    FeedbackInterface.this.progressBar.setIndeterminate(true);
                    FeedbackInterface.this.progressBar.setVisible(true);
                }
            }
        });
    }

    public static void setFinish(boolean bl) {
        finish = bl;
    }

    public void setComment(boolean bl) {
        if (this.paneArray.size() == 0) {
            System.out.println("There is no panel here!");
        } else {
            JPanel jPanel = (JPanel)this.paneArray.get(this.row - 2);
            ThumbnailPic thumbnailPic = (ThumbnailPic)this.picAndPane.get(jPanel);
            String string = bl ? "Please close '" + thumbnailPic.getTitles() + "' window \nbefore you can enter comments here." : " ";
            thumbnailPic.setComments(string);
        }
    }

    public void addScreenPanel(String string, BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBackground(new Color(176, 208, 176));
        Border border = BorderFactory.createEtchedBorder(1);
        if (string.length() > 41) {
            String string2 = string.substring(0, 40) + "  . . . ";
        } else {
            String string3 = string;
        }
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, string);
        titledBorder.setTitleJustification(1);
        jPanel.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(5, 5, 5, 5), titledBorder));
        ThumbnailPic thumbnailPic = new ThumbnailPic(bufferedImage, string, n, n2, n3, n4);
        this.picAndPane.put(jPanel, thumbnailPic);
        jPanel.add((Component)thumbnailPic.getPanel(), "Before");
        this.remove.setVisible(true);
        this.picture_scroll.add(jPanel);
        this.paneArray.add(jPanel);
        ++this.row;
        this.picture_scroll.setSize(this.picture_scroll.getPreferredSize());
        this.picture_scroll.revalidate();
        this.picture_scroll.repaint();
        this.tempPane.setSize(this.tempPane.getPreferredSize());
        this.tempPane.revalidate();
        this.tempPane.repaint();
    }

    public String getPrevData() {
        try {
            UID uID = new UID();
            code = "" + InetAddress.getLocalHost().hashCode() + uID.hashCode();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return code;
    }

    public static String getCode() {
        return code;
    }

    public String convert(BufferedImage bufferedImage) {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            string = Base64.encodeBytes(byArray);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    private void ensureEventThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        throw new RuntimeException(messages.getString("file"));
    }

    private void sendState(SaveToXML saveToXML, Vector vector, String[] stringArray, String[] stringArray2) {
        Serializable serializable;
        String string = "xmlfeedback/";
        File file = new File("xmlfeedback");
        if (!file.isDirectory()) {
            file.mkdir();
        }
        saveToXML.saveFeedback(stringArray, stringArray2);
        saveToXML.open(string + "feedbackcontent" + FeedbackInterface.getCode() + ".xml", "HISTORY");
        SaveToXML saveToXML2 = new SaveToXML(messages);
        saveToXML2.open(string + "feedbackcommand" + FeedbackInterface.getCode() + ".xml", "COMMANDS");
        for (int i = 0; i < vector.size(); ++i) {
            History history = (History)vector.get(i);
            history.sendXML(saveToXML);
            history.sendXMLComm(saveToXML2);
        }
        Vector vector2 = this.getPrev_log();
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                serializable = (History)vector2.get(i);
                ((History)serializable).sendXML(saveToXML);
                ((History)serializable).sendXMLComm(saveToXML2);
            }
            vector2.removeAllElements();
            System.gc();
            vector2 = null;
        }
        saveToXML2.close("COMMANDS");
        saveToXML.close("HISTORY");
        this.getHistPrev_log(saveToXML, saveToXML2);
        ZipFile zipFile = new ZipFile();
        zipFile.sendZipXMLFile();
        serializable = new File(string + "feedback" + FeedbackInterface.getCode() + ".xml");
        ((File)serializable).delete();
        serializable = new File(string + "feedbackcontent" + FeedbackInterface.getCode() + ".xml");
        ((File)serializable).delete();
        serializable = new File(string + "feedbackcommand" + FeedbackInterface.getCode() + ".xml");
        ((File)serializable).delete();
        serializable = new File(string + "command" + FeedbackInterface.getCode() + ".xml");
        ((File)serializable).delete();
        String[] stringArray3 = new String[5];
        stringArray3[0] = "vl6@cs.waikato.ac.nz";
        stringArray3[1] = string + "Jar" + FeedbackInterface.getCode() + "File.jar";
        stringArray3[4] = "lib/parser.jar";
        stringArray3[2] = stringArray[19];
        stringArray3[3] = stringArray[20];
        SendHTTP sendHTTP = new SendHTTP();
        sendHTTP.sendMail(stringArray3, messages, FeedbackInterface.getCode());
    }

    private void getHistPrev_log(SaveToXML saveToXML, SaveToXML saveToXML2) {
        Vector vector = null;
        try {
            File file = new File("history.log");
            if (file.exists()) {
                History history;
                int n;
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                vector = (Vector)objectInputStream.readObject();
                String string = "xmlfeedback/";
                saveToXML2.open(string + "command" + FeedbackInterface.getCode() + ".xml", "COMMANDS");
                if (vector != null) {
                    for (n = 0; n < vector.size(); ++n) {
                        history = (History)vector.get(n);
                        history.sendXMLComm(saveToXML2);
                    }
                    vector.removeAllElements();
                    System.gc();
                    vector = null;
                }
                if ((vector = (Vector)objectInputStream.readObject()) != null) {
                    for (n = 0; n < vector.size(); ++n) {
                        history = (History)vector.get(n);
                        history.sendXMLComm(saveToXML2);
                    }
                    vector.removeAllElements();
                    System.gc();
                    vector = null;
                }
                saveToXML2.close("COMMANDS");
                objectInputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("class exp");
        }
    }

    public Vector getPrev_log() {
        Vector vector = null;
        try {
            File file = new File("temp_feedbackhist.log");
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                vector = (Vector)objectInputStream.readObject();
                objectInputStream.close();
                return vector;
            }
            vector = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("class exp");
        }
        return vector;
    }

    public void sendMethod(final Vector vector, final String[] stringArray, final String[] stringArray2) {
        this.ensureEventThread();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                finish = false;
                FeedbackInterface.this.selected = true;
                SaveToXML saveToXML = new SaveToXML(messages);
                FeedbackInterface.this.sendState(saveToXML, vector, stringArray, stringArray2);
                finish = true;
            }
        };
        this.sendThread = new Thread(runnable);
        this.sendThread.start();
    }

    public void viewMethod(final Vector vector, final String[] stringArray, final String[] stringArray2) {
        this.ensureEventThread();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                finish = false;
                FeedbackInterface.this.selected = false;
                ReportDetails reportDetails = new ReportDetails(vector, stringArray, stringArray2, messages, true);
                finish = true;
            }
        };
        this.prevThread = new Thread(runnable);
        this.prevThread.start();
    }

    public void saveGraph(final BufferedImage bufferedImage, final String string) {
        this.ensureEventThread();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    File file = new File(string);
                    ImageIO.write((RenderedImage)bufferedImage, "jpg", file);
                    FeedbackInterface.this.save = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        this.save = new Thread(runnable);
        this.save.start();
    }

    public String[] getimgFile() {
        String[] stringArray = null;
        if (this.paneArray.size() > 0) {
            stringArray = new String[this.paneArray.size() * 10];
            for (int i = 0; i < this.paneArray.size() * 10; i += 10) {
                String string;
                JPanel jPanel = (JPanel)this.paneArray.get(i / 10);
                ThumbnailPic thumbnailPic = (ThumbnailPic)this.picAndPane.get(jPanel);
                stringArray[i + 0] = string = thumbnailPic.getTitles();
                stringArray[i + 1] = thumbnailPic.getScreenImage();
                string = "Window" + jPanel.hashCode() + "File";
                stringArray[i + 2] = messages.getString("screen") + string + i + ".jpg";
                stringArray[i + 3] = thumbnailPic.getScreenAndLineImage();
                stringArray[i + 4] = messages.getString("ErrorLineAnd") + stringArray[i + 2];
                stringArray[i + 5] = thumbnailPic.getLineForScreenImage();
                stringArray[i + 6] = messages.getString("ErrorLineFor") + stringArray[i + 2];
                stringArray[i + 7] = thumbnailPic.getWidth();
                stringArray[i + 8] = thumbnailPic.getHeight();
                stringArray[i + 9] = thumbnailPic.getProblemDetails();
            }
        }
        return stringArray;
    }

    public String[] geterr_array() {
        String[] stringArray = null;
        String string = System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch");
        Date date = new Date();
        String string2 = date.toString();
        String string3 = System.getProperty("java.vendor") + " " + System.getProperty("java.class.version");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        String string4 = "" + dimension.width + "x" + dimension.height;
        try {
            stringArray = new String[24];
            stringArray[0] = code;
            stringArray[1] = this.frameName;
            stringArray[2] = "";
            stringArray[3] = (String)this.problem_type.getSelectedItem();
            stringArray[4] = (String)this.problem_urgency.getSelectedItem();
            stringArray[5] = System.getProperty("user.name");
            stringArray[6] = System.getProperty("user.home");
            stringArray[7] = System.getProperty("user.dir");
            stringArray[8] = this.curr_date.toString();
            stringArray[9] = string2;
            stringArray[10] = string;
            stringArray[11] = string3;
            stringArray[12] = "" + Locale.getDefault();
            stringArray[13] = "Greenstone Librarian Interface 2.88";
            stringArray[14] = InetAddress.getLocalHost().getHostName();
            stringArray[15] = InetAddress.getLocalHost().getHostAddress();
            stringArray[16] = string4;
            stringArray[17] = "";
            stringArray[19] = "mail.waikato.ac.nz";
            stringArray[20] = "vl6@cs.waikato.ac.nz";
            Runtime runtime = Runtime.getRuntime();
            stringArray[21] = this.formatFileSize(runtime.totalMemory());
            stringArray[22] = this.formatFileSize(runtime.maxMemory());
            stringArray[23] = this.formatFileSize(runtime.freeMemory());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return stringArray;
    }

    public String formatFileSize(long l) {
        int n;
        String string = " B";
        long l2 = 1024000000L;
        String string2 = " GB";
        long l3 = 1024L;
        String string3 = " KB";
        long l4 = 1024000L;
        String string4 = " MB";
        StringBuffer stringBuffer = new StringBuffer("");
        float f = 0.0f;
        String string5 = null;
        if (l >= l2) {
            f = (float)l / (float)l2;
            string5 = string2;
        } else if (l >= l4) {
            f = (float)l / (float)l4;
            string5 = string4;
        } else if (l >= l3) {
            f = (float)l / (float)l3;
            string5 = string3;
        } else {
            return l + string;
        }
        String string6 = Float.toString(f);
        char[] cArray = string6.toCharArray();
        for (n = 0; cArray != null && n < cArray.length && cArray[n] != '.'; ++n) {
            stringBuffer.append(cArray[n]);
        }
        if (n < cArray.length) {
            stringBuffer.append(cArray[n]);
            ++n;
            for (int i = 0; i < 2 && n < cArray.length; ++i, ++n) {
                stringBuffer.append(cArray[n]);
            }
            while (n < cArray.length && cArray[n] != 'E') {
                ++n;
            }
            while (n < cArray.length) {
                stringBuffer.append(cArray[n]);
                ++n;
            }
        }
        stringBuffer.append(string5);
        return stringBuffer.toString();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String[] stringArray;
        String[] stringArray2;
        this.getPrevData();
        if (messages.getString("Send").equals(actionEvent.getActionCommand())) {
            stringArray2 = this.getimgFile();
            stringArray = this.geterr_array();
            this.timer.start();
            this.sendMethod(dialog.getVector(), stringArray, stringArray2);
        }
        if (messages.getString("Preview").equals(actionEvent.getActionCommand())) {
            stringArray2 = this.getimgFile();
            stringArray = this.geterr_array();
            this.timer.start();
            this.viewMethod(dialog.getVector(), stringArray, stringArray2);
        }
        if (messages.getString("NotSend").equals(actionEvent.getActionCommand())) {
            this.dispose();
        }
    }

    private class ThumbnailPic
    implements Serializable {
        private JPanel picpane;
        private BufferedImage[] screenimages;
        private BufferedImage[] windowimages;
        private JTextArea problem_details;
        private boolean iswindow;
        private String titles;
        private String iw;
        private String ih;
        private int xcoord;
        private int ycoord;
        private int width;
        private int height;

        public ThumbnailPic(BufferedImage bufferedImage, String string, int n, int n2, int n3, int n4) {
            this.xcoord = n;
            this.ycoord = n2;
            this.width = n3;
            this.height = n4;
            this.iswindow = false;
            this.titles = string;
            this.screenimages = new BufferedImage[3];
            this.windowimages = new BufferedImage[3];
            this.screenimages[0] = bufferedImage;
            this.screenimages[1] = null;
            this.screenimages[2] = null;
            this.windowimages[0] = null;
            this.windowimages[1] = null;
            this.windowimages[2] = null;
            this.addPanel(bufferedImage);
        }

        public void addPanel(BufferedImage bufferedImage) {
            this.picpane = new JPanel();
            this.picpane.setLayout(new BorderLayout());
            final JButton jButton = new JButton();
            int n = 75;
            int n2 = 75;
            this.iw = "" + bufferedImage.getWidth();
            this.ih = "" + bufferedImage.getHeight();
            ImageIcon imageIcon = new ImageIcon(bufferedImage.getScaledInstance(n, n2, 4));
            jButton.setIcon(imageIcon);
            jButton.setText("Draw . . .");
            jButton.setActionCommand("Scribble");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FeedbackInterface.this.frame.addMouseListener(FeedbackInterface.this.mouse_blocker_listener);
                    FeedbackInterface.this.frame.setCursor(Cursor.getPredefinedCursor(3));
                    SelectPicture selectPicture = new SelectPicture(ThumbnailPic.this.screenimages, ThumbnailPic.this.windowimages, ThumbnailPic.this.iswindow, ThumbnailPic.this.problem_details.getText(), messages);
                    FeedbackInterface.this.frame.setCursor(Cursor.getPredefinedCursor(0));
                    FeedbackInterface.this.frame.removeMouseListener(FeedbackInterface.this.mouse_blocker_listener);
                    selectPicture.setWindowBounds(ThumbnailPic.this.xcoord, ThumbnailPic.this.ycoord, ThumbnailPic.this.width, ThumbnailPic.this.height);
                    ThumbnailPic.this.iswindow = selectPicture.getIsWindow();
                    ((ThumbnailPic)ThumbnailPic.this).screenimages[0] = selectPicture.getImage3();
                    ((ThumbnailPic)ThumbnailPic.this).screenimages[1] = selectPicture.getImage();
                    ((ThumbnailPic)ThumbnailPic.this).screenimages[2] = selectPicture.getImage2();
                    if (ThumbnailPic.this.iswindow) {
                        ((ThumbnailPic)ThumbnailPic.this).windowimages[0] = selectPicture.getWindowImage3();
                        ((ThumbnailPic)ThumbnailPic.this).windowimages[1] = selectPicture.getWindowImage();
                        ((ThumbnailPic)ThumbnailPic.this).windowimages[2] = selectPicture.getWindowImage2();
                    } else {
                        ((ThumbnailPic)ThumbnailPic.this).windowimages[0] = null;
                        ((ThumbnailPic)ThumbnailPic.this).windowimages[1] = null;
                        ((ThumbnailPic)ThumbnailPic.this).windowimages[2] = null;
                    }
                    ThumbnailPic.this.problem_details.setText(selectPicture.getDetails());
                    int n = 75;
                    int n2 = 75;
                    ImageIcon imageIcon = !ThumbnailPic.this.iswindow ? new ImageIcon(ThumbnailPic.this.screenimages[1].getScaledInstance(n, n2, 4)) : new ImageIcon(ThumbnailPic.this.windowimages[1].getScaledInstance(n, n2, 4));
                    jButton.setIcon(imageIcon);
                    if (selectPicture.getSendNow()) {
                        ActionEvent actionEvent2 = new ActionEvent(FeedbackInterface.this.send_button, 1001, messages.getString("Send"));
                        FeedbackInterface.this.frame.actionPerformed(actionEvent2);
                    }
                }
            });
            jButton.setToolTipText("Click if you want to draw on it");
            jButton.setMargin(new Insets(5, 5, 5, 5));
            jButton.setVerticalTextPosition(3);
            jButton.setHorizontalTextPosition(0);
            jButton.setBackground(new Color(176, 208, 176));
            this.picpane.add((Component)jButton, "Before");
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBackground(new Color(176, 208, 176));
            jPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JLabel jLabel = new JLabel("Comments :");
            jLabel.setBackground(new Color(176, 208, 176));
            jPanel.add((Component)jLabel, "First");
            this.problem_details = new JTextArea();
            this.problem_details.setWrapStyleWord(true);
            this.problem_details.setEditable(true);
            this.problem_details.setBackground(new Color(224, 240, 224));
            JScrollPane jScrollPane = new JScrollPane(this.problem_details);
            jScrollPane.setBackground(new Color(176, 208, 176));
            jScrollPane.setPreferredSize(new Dimension(300, 150));
            jPanel.add((Component)jScrollPane, "Before");
            this.picpane.setSize(new Dimension(150, 150));
            this.picpane.add((Component)jPanel, "Center");
        }

        public String getWidth() {
            if (!this.iswindow) {
                return "" + this.screenimages[0].getWidth();
            }
            return "" + this.windowimages[0].getWidth();
        }

        public String getHeight() {
            if (!this.iswindow) {
                return "" + this.screenimages[0].getHeight();
            }
            return "" + this.windowimages[0].getHeight();
        }

        public String getTitles() {
            return this.titles;
        }

        public String getProblemDetails() {
            String string = this.problem_details.getText();
            if (string == null) {
                return " ";
            }
            return string;
        }

        public void setComments(String string) {
            this.problem_details.setText(string);
        }

        public BufferedImage[] getImages() {
            if (!this.iswindow) {
                return this.screenimages;
            }
            return this.windowimages;
        }

        public String getScreenImage() {
            if (!this.iswindow) {
                return FeedbackInterface.this.convert(this.screenimages[0]);
            }
            return FeedbackInterface.this.convert(this.windowimages[1]);
        }

        public String getScreenAndLineImage() {
            if (!this.iswindow) {
                if (this.screenimages[1] != null) {
                    return FeedbackInterface.this.convert(this.screenimages[1]);
                }
                return FeedbackInterface.this.convert(this.screenimages[0]);
            }
            if (this.windowimages[1] != null) {
                return FeedbackInterface.this.convert(this.windowimages[1]);
            }
            return FeedbackInterface.this.convert(this.windowimages[0]);
        }

        public String getLineForScreenImage() {
            if (!this.iswindow) {
                if (this.screenimages[2] != null) {
                    return FeedbackInterface.this.convert(this.screenimages[2]);
                }
                return "";
            }
            if (this.windowimages[2] != null) {
                return FeedbackInterface.this.convert(this.windowimages[2]);
            }
            return "";
        }

        public JPanel getPanel() {
            return this.picpane;
        }
    }
}

