/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.feedback;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;

public class Graphs {
    private BufferedImage I = null;
    private BufferedImage I2;
    private Graphics2D G;
    private Graphics2D G2;
    private BufferedImage[] screen;
    private Graphics2D G3;
    private double imwidth;
    private double imheight;

    public Graphs(BufferedImage[] bufferedImageArray) {
        this.screen = bufferedImageArray;
        if (this.screen[0] != null) {
            this.imwidth = this.screen[0].getWidth();
            this.imheight = this.screen[0].getHeight();
            if (this.screen[1] == null && this.screen[2] == null) {
                this.I = new BufferedImage(this.screen[0].getWidth(), this.screen[0].getHeight(), 1);
                this.I2 = new BufferedImage(this.I.getWidth(), this.I.getHeight(), 2);
            } else {
                this.I = this.screen[1];
                this.I2 = this.screen[2];
            }
            this.start();
        } else {
            System.out.println("weird");
        }
    }

    public void flush() {
        this.G.dispose();
        this.G = null;
        this.G3.dispose();
        this.G3 = null;
        this.G2.dispose();
        this.G2 = null;
        for (int i = 0; i < 3; ++i) {
            if (this.screen[i] == null) continue;
            this.screen[i].flush();
            this.screen[i] = null;
        }
        this.I.flush();
        this.I = null;
        this.I2.flush();
        this.I2 = null;
        System.gc();
    }

    public void reset() {
        this.I.flush();
        this.I = null;
        System.gc();
        this.I2.flush();
        this.I2 = null;
        this.G.dispose();
        System.gc();
        this.G2.dispose();
        this.G = null;
        this.G2 = null;
        System.gc();
        this.I = new BufferedImage(this.screen[0].getWidth(), this.screen[0].getHeight(), 1);
        this.I2 = new BufferedImage(this.I.getWidth(), this.I.getHeight(), 2);
        this.screen[1] = null;
        this.screen[2] = null;
        this.start();
    }

    public void start() {
        this.G3 = this.screen[0].createGraphics();
        this.G3.drawImage((Image)this.screen[0], 0, 0, new JLabel());
        this.G = this.I.createGraphics();
        if (this.screen[1] == null) {
            this.G.drawImage((Image)this.screen[0], 0, 0, new JLabel());
        } else {
            this.G.drawImage((Image)this.screen[1], 0, 0, new JLabel());
        }
        this.G2 = this.I2.createGraphics();
    }

    public void drawLines(int n, int n2, int n3, int n4) {
        this.G2.setColor(Color.red);
        this.G.setColor(Color.red);
        this.G.setStroke(new BasicStroke(2.5f));
        this.G2.setStroke(new BasicStroke(2.5f));
        this.G2.drawLine(n, n2, n3, n4);
        this.G.drawLine(n, n2, n3, n4);
    }

    public void eraseLines(int n, int n2, int n3, int n4) {
        this.G3.setColor(Color.white);
        this.G2.setColor(Color.white);
        this.G.setColor(Color.white);
        this.G.setStroke(new BasicStroke(25.5f));
        this.G2.setStroke(new BasicStroke(25.5f));
        this.G3.setStroke(new BasicStroke(25.5f));
        this.G3.drawLine(n, n2, n3, n4);
        this.G2.drawLine(n, n2, n3, n4);
        this.G.drawLine(n, n2, n3, n4);
    }

    public BufferedImage getImage() {
        return this.I;
    }

    public BufferedImage getImage2() {
        return this.I2;
    }

    public BufferedImage getScreenImage() {
        return this.screen[0];
    }

    public BufferedImage[] getWindowVersion(int n, int n2, int n3, int n4) {
        BufferedImage[] bufferedImageArray = new BufferedImage[3];
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if ((double)n >= this.imwidth) {
            n = (int)(this.imwidth - 1.0);
        }
        if ((double)n2 >= this.imheight) {
            n2 = (int)(this.imheight - 1.0);
        }
        if ((double)(n + n3) > this.imwidth) {
            n3 = (int)(this.imwidth - (double)n);
        }
        if ((double)(n2 + n4) > this.imheight) {
            n4 = (int)(this.imheight - (double)n2);
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        bufferedImageArray[0] = this.getClipVersion(this.screen[0], n, n2, n3, n4);
        bufferedImageArray[1] = this.getClipVersion(this.I, n, n2, n3, n4);
        bufferedImageArray[2] = this.getClipVersion(this.I2, n, n2, n3, n4);
        return bufferedImageArray;
    }

    public BufferedImage getClipVersion(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(n, n2, n3, n4);
        return bufferedImage2;
    }

    public void setScreenVersion(BufferedImage[] bufferedImageArray, int n, int n2, int n3, int n4) {
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if ((double)n >= this.imwidth) {
            n = (int)(this.imwidth - 1.0);
        }
        if ((double)n2 >= this.imheight) {
            n2 = (int)(this.imheight - 1.0);
        }
        if ((double)(n + n3) > this.imwidth) {
            n3 = (int)(this.imwidth - (double)n);
        }
        if ((double)(n2 + n4) > this.imheight) {
            n4 = (int)(this.imheight - (double)n2);
        }
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        this.G3.drawImage((Image)bufferedImageArray[0], n, n2, new JLabel());
        this.G.drawImage((Image)bufferedImageArray[1], n, n2, new JLabel());
        this.G2.drawImage((Image)bufferedImageArray[2], n, n2, new JLabel());
    }
}

