/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gems;

import java.util.ArrayList;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.greenstone.gatherer.gems.Attribute;
import org.greenstone.gatherer.gems.AttributeContainer;
import org.greenstone.gatherer.gems.GEMSConstants;
import org.greenstone.gatherer.gems.MetadataSetEvent;
import org.greenstone.gatherer.gems.MetadataSetListener;
import org.greenstone.gatherer.gems.MetadataSetModel;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetadataSetInfo
extends AttributeContainer {
    private String file_path = "";
    private static ArrayList listeners = new ArrayList();
    private static MetadataSetModel metadata_model;
    private String current_language = GEMSConstants.DEFAULT_LANGUAGE;
    private boolean isNew = false;

    public MetadataSetInfo() {
        super(GEMSConstants.SET_REQUIRED_ATTRIBUTES, GEMSConstants.SET_LANG_DEPEND_ATTR_NAMES);
    }

    public boolean isNamespaceAlreadyUsed(String string) {
        if (metadata_model != null) {
            return metadata_model.getMetadataSetManager().isNamespaceAlreadyUsed(string);
        }
        return false;
    }

    public void setNew(boolean bl) {
        this.isNew = bl;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public Document getMetadataSetDocument() {
        return metadata_model.getMetadataSetDocument();
    }

    public MetadataSetModel getMetadataSetModel() {
        return metadata_model;
    }

    public void setMetadataSetModel(MetadataSetModel metadataSetModel) {
        metadata_model = metadataSetModel;
    }

    public String getMetadataSetName() {
        return this.getMetadataSetName(this.getCurrentLanguage());
    }

    public String getMetadataSetName(String string) {
        Attribute attribute = this.getAttributeByNameAndLanguage(GEMSConstants.NAME_ATTRIBUTE, string);
        if (attribute != null) {
            return attribute.getValue();
        }
        return GEMSConstants.UNKNOWN_NAME;
    }

    public void setMetadataSetName(String string) {
        this.setMetadataSetName(string, this.getCurrentLanguage());
    }

    public void setMetadataSetName(String string, String string2) {
        Attribute attribute = this.getAttributeByNameAndLanguage(GEMSConstants.NAME_ATTRIBUTE, string2);
        if (attribute != null) {
            attribute.setValue(string);
        } else {
            attribute = new Attribute(GEMSConstants.NAME_ATTRIBUTE, string, string2, true);
            this.language_dependent_attributes.add(attribute);
        }
    }

    public String getMetadataSetDescription() {
        return this.getMetadataSetDescription(this.getCurrentLanguage());
    }

    public String getMetadataSetDescription(String string) {
        Attribute attribute = this.getAttributeByNameAndLanguage(GEMSConstants.DESCRIPTION_ATTRIBUTE, string);
        if (attribute != null) {
            return attribute.getValue();
        }
        return "";
    }

    public void setMetadataSetDescription(String string) {
        this.setMetadataSetDescription(string, this.getCurrentLanguage());
    }

    public void setMetadataSetDescription(String string, String string2) {
        Attribute attribute = this.getAttributeByNameAndLanguage(GEMSConstants.DESCRIPTION_ATTRIBUTE, string2);
        if (attribute != null) {
            attribute.setValue(string);
        } else {
            attribute = new Attribute(GEMSConstants.DESCRIPTION_ATTRIBUTE, string, string2, true);
            this.language_dependent_attributes.add(attribute);
        }
    }

    public String getCurrentLanguage() {
        return this.current_language;
    }

    public void setCurrentLanguage(String string) {
        this.current_language = string;
    }

    public String getNamespace() {
        Attribute attribute = this.getAttributeByName(GEMSConstants.NAMESPACE_ATTRIBUTE);
        if (attribute != null) {
            return attribute.getValue();
        }
        return "";
    }

    public void setNamespace(String string) {
        Attribute attribute = this.getAttributeByName(GEMSConstants.NAMESPACE_ATTRIBUTE);
        if (attribute != null) {
            attribute.setValue(string);
        } else {
            attribute = new Attribute(GEMSConstants.NAMESPACE_ATTRIBUTE, string, true);
            this.attributes.add(attribute);
        }
    }

    public String getFilePath() {
        return this.file_path;
    }

    public void infoChanged() {
        metadata_model.valueChanged();
    }

    public void setFilePath(String string) {
        this.file_path = string;
    }

    public void addMetadataSetListener(MetadataSetListener metadataSetListener) {
        if (!listeners.contains(metadataSetListener)) {
            listeners.add(metadataSetListener);
        }
    }

    public void removeMetadataSetListener(MetadataSetListener metadataSetListener) {
        listeners.remove(metadataSetListener);
    }

    public void removeAllMetadataSetListeners() {
        listeners.clear();
    }

    public void deleteMetadataSet() {
        metadata_model.getMetadataSetManager().deleteMetadataSet(this);
        if (metadata_model.getMetadataSetInfo() != null && metadata_model.getMetadataSetInfo().getFilePath().equals(this.getFilePath())) {
            metadata_model.metadataSetDeleted();
            MetadataSetEvent metadataSetEvent = new MetadataSetEvent(null);
            for (int i = 0; i < listeners.size(); ++i) {
                MetadataSetListener metadataSetListener = (MetadataSetListener)listeners.get(i);
                metadataSetListener.metadataSetChanged(metadataSetEvent);
            }
        }
    }

    public void notifyListeners() {
        MetadataSetEvent metadataSetEvent = new MetadataSetEvent(this);
        for (int i = 0; i < listeners.size(); ++i) {
            MetadataSetListener metadataSetListener = (MetadataSetListener)listeners.get(i);
            metadataSetListener.metadataSetChanged(metadataSetEvent);
        }
    }

    public void save() {
        Element element;
        Object object;
        int n;
        Node node;
        Document document = metadata_model.getMetadataSetDocument();
        if (document == null) {
            document = new DocumentImpl();
            node = new DocumentTypeImpl((DocumentImpl)document, GEMSConstants.MATADATASET_NAME, null, GEMSConstants.SYSTEM_ID);
            document.appendChild(document.createElement(GEMSConstants.METADATASET_ELEMENT));
            document.appendChild(node);
            metadata_model.setMetadataSetDocument(document);
        }
        node = document.getDocumentElement();
        NamedNodeMap namedNodeMap = document.getDocumentElement().getAttributes();
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            object = (Attr)namedNodeMap.item(n);
            node.removeAttribute(object.getName());
        }
        for (n = 0; n < this.attributes.size(); ++n) {
            object = (Attribute)this.attributes.get(n);
            if (((Attribute)object).getName() == null || ((Attribute)object).getName().trim().equals("")) continue;
            node.setAttribute(((Attribute)object).getName(), ((Attribute)object).getValue());
        }
        NodeList nodeList = node.getElementsByTagName(GEMSConstants.SET_LANGUAGE_ELEMENT);
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Node node2 = nodeList.item(i);
            node.removeChild(node2);
        }
        ArrayList arrayList = XMLTools.getChildElementsByTagName((Element)node, GEMSConstants.NAME_ELEMENT);
        for (int i = 0; i < arrayList.size(); ++i) {
            Element element2 = (Element)arrayList.get(i);
            node.removeChild(element2);
        }
        ArrayList arrayList2 = XMLTools.getChildElementsByTagName((Element)node, GEMSConstants.DESCRIPTION_ELEMENT);
        for (int i = 0; i < arrayList2.size(); ++i) {
            element = (Element)arrayList2.get(i);
            node.removeChild(element);
        }
        Node node3 = node.getFirstChild();
        element = null;
        ArrayList arrayList3 = this.getAllLanguages();
        for (int i = 0; i < arrayList3.size(); ++i) {
            String string = (String)arrayList3.get(i);
            Attribute attribute = this.getAttributeByNameAndLanguage(GEMSConstants.NAME_ATTRIBUTE, string);
            if (attribute == null) continue;
            Element element3 = document.createElement(GEMSConstants.SET_LANGUAGE_ELEMENT);
            element3.setAttribute(GEMSConstants.CODE_ATTRIBUTE, string);
            Element element4 = document.createElement(GEMSConstants.NAME_ELEMENT);
            element4.appendChild(document.createTextNode(attribute.getValue()));
            element3.appendChild(element4);
            Attribute attribute2 = this.getAttributeByNameAndLanguage(GEMSConstants.DESCRIPTION_ATTRIBUTE, string);
            if (attribute2 != null) {
                Element element5 = document.createElement(GEMSConstants.DESCRIPTION_ELEMENT);
                element5.appendChild(document.createTextNode(attribute2.getValue()));
                element3.appendChild(element5);
            }
            if (node3 == null) {
                if (element != null && element.getNextSibling() != null) {
                    node.insertBefore(element3, element.getNextSibling());
                    continue;
                }
                node.appendChild(element3);
                continue;
            }
            node.insertBefore(element3, node3);
            node3 = null;
            element = element3;
        }
    }
}

