/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.GAuthenticator;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.cdm.ArgumentContainer;
import org.greenstone.gatherer.cdm.ArgumentControl;
import org.greenstone.gatherer.download.Download;
import org.greenstone.gatherer.download.DownloadScrollPane;
import org.greenstone.gatherer.download.ServerInfoDialog;
import org.greenstone.gatherer.download.URLConnectionManager;
import org.greenstone.gatherer.greenstone.LocalGreenstone;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.Preferences;
import org.greenstone.gatherer.util.SafeProcess;
import org.greenstone.gatherer.util.Utility;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DownloadPane
extends JPanel {
    private static final Dimension LABEL_SIZE = new Dimension(225, 25);
    private static final Dimension TREE_SIZE = new Dimension(150, 500);
    private String[] CONTENTS = null;
    private boolean download_button_enabled = false;
    private boolean ready = false;
    private JPanel options_pane;
    private DesignTree tree;
    private HashMap download_map;
    private ServerInfoDialog server_info;
    private JScrollPane list_scroll;
    private DownloadScrollPane getter;
    private String mode = null;
    private TreePath previous_path;
    private Properties proxy_urls = new Properties();
    private Proxy proxyObject = null;

    public DownloadPane() {
        Object object;
        this.setComponentOrientation(Dictionary.getOrientation());
        this.getter = new DownloadScrollPane();
        this.getter.start();
        this.list_scroll = this.getter.getDownloadJobList();
        this.list_scroll.setComponentOrientation(Dictionary.getOrientation());
        String string = Configuration.getLanguage();
        this.download_map = new HashMap();
        ArrayList<String> arrayList = this.loadDownloadersInfo(string);
        int n = arrayList.size();
        this.CONTENTS = new String[n];
        for (int i = 0; i < n; ++i) {
            object = arrayList.get(i);
            this.CONTENTS[i] = "DOWNLOAD.MODE." + ((String)object).replace("3950", "");
        }
        this.tree = new DesignTree();
        this.tree.setComponentOrientation(Dictionary.getOrientation());
        this.options_pane = new JPanel();
        this.options_pane.setComponentOrientation(Dictionary.getOrientation());
        GLIButton gLIButton = new GLIButton(Dictionary.get("Mirroring.ClearCache"), Dictionary.get("Mirroring.ClearCache_Tooltip"));
        gLIButton.setEnabled(true);
        gLIButton.setMnemonic(67);
        object = new GLIButton(Dictionary.get("Mirroring.Download"), Dictionary.get("Mirroring.Download_Tooltip"));
        ((AbstractButton)object).setEnabled(true);
        ((AbstractButton)object).setMnemonic(68);
        GLIButton gLIButton2 = new GLIButton(Dictionary.get("Download.ServerInformation"), Dictionary.get("Download.ServerInformation_Tooltip"));
        gLIButton2.setEnabled(true);
        gLIButton2.setMnemonic(83);
        GLIButton gLIButton3 = new GLIButton(Dictionary.get("Mirroring.Preferences"), Dictionary.get("Mirroring.Preferences_Tooltip"));
        gLIButton3.setEnabled(true);
        gLIButton3.setMnemonic(80);
        gLIButton.addActionListener(new ClearCacheListener());
        ((AbstractButton)object).addActionListener(new DownloadButtonListener());
        gLIButton3.addActionListener(new PreferencesButtonActionListener());
        gLIButton2.addActionListener(new InformationButtonActionListener());
        this.tree.addTreeSelectionListener(new TreeListener());
        JPanel jPanel = new JPanel();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setLayout(new GridLayout(1, 4));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add(gLIButton);
        jPanel.add((Component)object);
        jPanel.add(gLIButton2);
        jPanel.add(gLIButton3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setPreferredSize(TREE_SIZE);
        Color color = Configuration.getColor("coloring.collection_tree_background", false);
        this.options_pane.setBackground(color);
        this.options_pane.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane jScrollPane2 = new JScrollPane(this.options_pane);
        jScrollPane2.setComponentOrientation(Dictionary.getOrientation());
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setComponentOrientation(Dictionary.getOrientation());
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        if (Dictionary.getOrientation().isLeftToRight()) {
            jSplitPane.add((Component)jPanel2, "left");
            jSplitPane.add((Component)jScrollPane2, "right");
            jSplitPane.setDividerLocation(DownloadPane.TREE_SIZE.width);
        } else {
            jSplitPane.add((Component)jPanel2, "right");
            jSplitPane.add((Component)jScrollPane2, "left");
            jSplitPane.setDividerLocation(1 - DownloadPane.TREE_SIZE.width);
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Download Setting"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jSplitPane, "Center");
        jPanel3.add((Component)jPanel, "Last");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new GridLayout(2, 1));
        this.add(jPanel3);
        this.add(this.list_scroll);
        this.mode = this.convertCONTENTStoMode(this.CONTENTS[0]);
        this.generateOptions(this.options_pane, (Download)this.download_map.get(this.mode));
        this.previous_path = this.tree.getSelectionPath();
    }

    public void modeChanged(int n) {
    }

    private void addHeader(String string, Color color, JPanel jPanel) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.setBackground(color);
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createRaisedBevelBorder()));
        jPanel3.setBackground(color);
        JLabel jLabel = new JLabel("<html><strong>" + string + "</strong></html>");
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        jLabel.setBackground(Configuration.getColor("coloring.collection_heading_background", false));
        jLabel.setHorizontalAlignment(0);
        jLabel.setOpaque(true);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jLabel, "Center");
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel3, "Center");
        jPanel.add(jPanel2);
    }

    private ArrayList<String> loadDownloadersInfo(String string) {
        Document document = null;
        try {
            if (Gatherer.isGsdlRemote) {
                String string2 = Gatherer.remoteGreenstoneServer.getScriptOptions("downloadinfo.pl", "&describeall");
                StringReader stringReader = new StringReader(string2);
                document = XMLTools.parseXML(stringReader);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                String[] stringArray = null;
                if (Configuration.perl_path != null) {
                    arrayList.add(Configuration.perl_path);
                } else if (Utility.isWindows()) {
                    arrayList.add("Perl.exe");
                } else {
                    arrayList.add("perl");
                }
                arrayList.add("-S");
                arrayList.add(LocalGreenstone.getBinScriptDirectoryPath() + "downloadinfo.pl");
                arrayList.add("-describeall");
                arrayList.add("-xml");
                arrayList.add("-language");
                arrayList.add(string);
                stringArray = arrayList.toArray(new String[0]);
                SafeProcess safeProcess = new SafeProcess(stringArray);
                DebugStream.println("Getting Download Info: " + arrayList);
                int n = safeProcess.runProcess();
                if (n != 0) {
                    throw new Exception("*** Error running Download Info process, process exited with: " + n);
                }
                String string3 = safeProcess.getStdError();
                StringReader stringReader = new StringReader(string3);
                document = XMLTools.parseXML(stringReader);
                stringReader.close();
            }
        }
        catch (Exception exception) {
            System.err.println("Failed when trying to parse downloadinfo.pl -describeall");
            exception.printStackTrace();
        }
        if (document != null) {
            return this.parseXML(document.getDocumentElement());
        }
        return null;
    }

    private ArrayList<String> parseXML(Node node) {
        ArrayList<String> arrayList = null;
        Element element = (Element)node;
        int n = -1;
        if (element.hasAttribute("length")) {
            n = Integer.parseInt(element.getAttribute("length"));
            arrayList = new ArrayList<String>(n);
            for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                String string = null;
                for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    String string2;
                    String string3 = node3.getNodeName();
                    if (string3.equalsIgnoreCase("Name")) {
                        string = XMLTools.getValue(node3);
                        continue;
                    }
                    if (!string3.equalsIgnoreCase("Abstract") || !(string2 = XMLTools.getValue(node3)).equalsIgnoreCase("no") || string == null) continue;
                    arrayList.add(string);
                    Download download = this.parseDownloadInfoXML(node2);
                    String string4 = string.replace("Download", "");
                    this.download_map.put(string4, download);
                }
            }
        }
        return arrayList;
    }

    private Download parseDownloadInfoXML(Node node) {
        Download download = new Download();
        String string = null;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Object object;
            string = node2.getNodeName();
            if (string.equalsIgnoreCase("Name")) {
                object = XMLTools.getValue(node2);
                download.setName((String)object);
                continue;
            }
            if (string.equalsIgnoreCase("Desc")) {
                download.setDescription(XMLTools.getValue(node2));
                continue;
            }
            if (string.equalsIgnoreCase("Abstract")) {
                download.setIsAbstract(XMLTools.getValue(node2).equalsIgnoreCase("yes"));
                continue;
            }
            if (string.equalsIgnoreCase("Arguments")) {
                for (object = node2.getFirstChild(); object != null; object = object.getNextSibling()) {
                    string = object.getNodeName();
                    if (!string.equalsIgnoreCase("Option")) continue;
                    Argument argument = new Argument((Element)object);
                    argument.parseXML((Element)object);
                    argument.setValue(argument.getDefaultValue());
                    download.addArgument(argument);
                }
                continue;
            }
            if (!string.equalsIgnoreCase("DownloadInfo")) continue;
            object = this.parseDownloadInfoXML(node2);
            download.setSuper((Download)object);
        }
        if (download.getName() != null) {
            return download;
        }
        return null;
    }

    private boolean updateArguments(boolean bl) {
        boolean bl2 = true;
        for (int i = 0; i < this.options_pane.getComponentCount(); ++i) {
            Component component = this.options_pane.getComponent(i);
            if (!(component instanceof ArgumentControl)) continue;
            bl2 = bl2 && ((ArgumentControl)component).updateArgument(bl);
        }
        return bl2;
    }

    private void generateOptions(JPanel jPanel, ArgumentContainer argumentContainer) {
        int n;
        jPanel.removeAll();
        ArrayList arrayList = argumentContainer.getArguments(true, false);
        int n2 = Configuration.getMode();
        ArrayList<ArgumentControl> arrayList2 = new ArrayList<ArgumentControl>();
        for (n = 0; n < arrayList.size(); ++n) {
            Argument argument = (Argument)arrayList.get(n);
            if (argument.isHiddenGLI()) continue;
            ArgumentControl argumentControl = new ArgumentControl(argument, false, null);
            arrayList2.add(argumentControl);
        }
        jPanel.setLayout(new GridLayout(arrayList2.size(), 1));
        for (n = 0; n < arrayList2.size(); ++n) {
            jPanel.add((ArgumentControl)arrayList2.get(n));
        }
    }

    public void afterDisplay() {
        this.ready = true;
    }

    public void gainFocus() {
        if (!this.ready) {
            return;
        }
        this.download_button_enabled = true;
    }

    public void refresh(int n, boolean bl) {
    }

    private String convertCONTENTStoMode(String string) {
        return string.replace("DOWNLOAD.MODE.", "").replace("ZDownload", "Z3950").replace("Download", "");
    }

    private String getRedirectURL(String string) {
        boolean bl = false;
        boolean bl2 = false;
        HttpURLConnection httpURLConnection = null;
        if (string.startsWith("http:") || string.startsWith("https:")) {
            try {
                boolean bl3 = true;
                httpURLConnection = (HttpURLConnection)URLConnectionManager.getConnection(string, this.proxyObject, bl3);
                httpURLConnection.setInstanceFollowRedirects(false);
                httpURLConnection.setConnectTimeout(2000);
                httpURLConnection.setReadTimeout(2000);
                int n = httpURLConnection.getResponseCode();
                if (n >= 300 && n < 400) {
                    String string2 = httpURLConnection.getHeaderField("Location");
                    string = string2.trim();
                } else {
                    bl = true;
                }
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                bl2 = true;
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                System.err.println("Checking redirection. Tried to connect to " + string + ",\nbut got exception: " + exception);
            }
        }
        if (bl || bl2) {
            return string;
        }
        return this.getRedirectURL(string);
    }

    private void updateArgument(Argument argument, String string) {
        for (int i = 0; i < this.options_pane.getComponentCount(); ++i) {
            ArgumentControl argumentControl;
            Component component = this.options_pane.getComponent(i);
            if (!(component instanceof ArgumentControl) || (argumentControl = (ArgumentControl)component).getArgument() != argument) continue;
            argumentControl.setValue(string);
            argumentControl.repaint();
        }
    }

    private boolean checkURL(boolean bl) {
        if (!this.updateArguments(bl)) {
            return false;
        }
        Download download = (Download)this.download_map.get(this.mode);
        Argument argument = download.getArgument("url");
        if (argument == null) {
            return true;
        }
        String string = argument.getValue();
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("Mirroring.Invalid_URL"), Dictionary.get("Mirroring.Invalid_URL_Title"), 0);
            return false;
        }
        return true;
    }

    private boolean checkProxy() {
        this.proxy_urls.clear();
        Download download = (Download)this.download_map.get(this.mode);
        Argument argument = download.getArgument("proxy_on");
        if (argument == null) {
            return true;
        }
        if (Configuration.get("general.use_proxy", true)) {
            boolean bl = this.setProxyURLFor("HTTP");
            boolean bl2 = this.setProxyURLFor("HTTPS");
            boolean bl3 = this.setProxyURLFor("FTP");
            if (this.proxy_urls.size() == 0 || !bl && !bl2 && !bl3) {
                argument = download.getArgument("proxy_on");
                argument.setValue("false");
                argument.setAssigned(false);
                this.proxy_urls.clear();
                return false;
            }
            return true;
        }
        argument = download.getArgument("proxy_on");
        argument.setValue("false");
        argument.setAssigned(false);
        this.proxy_urls.clear();
        return true;
    }

    private boolean setProxyURLFor(String string) {
        int n;
        String string2 = Configuration.getString("general." + string + "_proxy_host", true);
        if (string2.equals("")) {
            return true;
        }
        String string3 = Configuration.getString("general." + string + "_proxy_port", true);
        String string4 = "";
        int n2 = string2.indexOf("://");
        if (n2 != -1) {
            string4 = string2.substring(0, n2 += "://".length());
            string2 = string2.substring(n2);
        } else {
            string4 = string.toLowerCase() + "://";
        }
        String string5 = "";
        String string6 = string2 + ":" + string3;
        GAuthenticator.setMode(1);
        for (n = 0; n < 3 && (string5 = (String)GAuthenticator.authentications.get(string6)) == null; ++n) {
            Authenticator.requestPasswordAuthentication(string2, null, Integer.parseInt(string3), "http://", Dictionary.get("WGet.Prompt"), "HTTP");
        }
        if (n >= 3) {
            return false;
        }
        Download download = (Download)this.download_map.get(this.mode);
        Argument argument = download.getArgument("proxy_on");
        if (string5.indexOf("@") != -1) {
            argument.setValue("true");
            argument.setAssigned(true);
            argument = download.getArgument(string.toLowerCase() + "_proxy_host");
            argument.setValue(string2);
            argument.setAssigned(true);
            argument = download.getArgument(string.toLowerCase() + "_proxy_port");
            argument.setValue(string3);
            argument.setAssigned(true);
            String string7 = string5.substring(0, string5.indexOf("@"));
            String string8 = string5.substring(string5.indexOf("@") + 1);
            String string9 = string4 + string7 + ":" + string8 + "@" + string2 + ":" + string3 + "/";
            this.proxy_urls.setProperty(string, string9);
            return true;
        }
        return false;
    }

    private boolean old_checkProxy() {
        String string = null;
        Download download = (Download)this.download_map.get(this.mode);
        Argument argument = download.getArgument("proxy_on");
        if (argument == null) {
            return true;
        }
        if (Configuration.get("general.use_proxy", true)) {
            int n;
            String string2 = Configuration.getString("general.proxy_host", true);
            String string3 = Configuration.getString("general.proxy_port", true);
            String string4 = "";
            String string5 = string2 + ":" + string3;
            GAuthenticator.setMode(1);
            for (n = 0; n < 3 && (string4 = (String)GAuthenticator.authentications.get(string5)) == null; ++n) {
                Authenticator.requestPasswordAuthentication(string2, null, Integer.parseInt(string3), "http://", Dictionary.get("WGet.Prompt"), "HTTP");
            }
            if (n >= 3) {
                return false;
            }
            this.proxyObject = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string2, Integer.parseInt(string3)));
            if (string4.indexOf("@") != -1) {
                argument.setValue("true");
                argument.setAssigned(true);
                argument = download.getArgument("proxy_host");
                argument.setValue(string2);
                argument.setAssigned(true);
                argument = download.getArgument("proxy_port");
                argument.setValue(string3);
                argument.setAssigned(true);
                String string6 = string4.substring(0, string4.indexOf("@"));
                String string7 = string4.substring(string4.indexOf("@") + 1);
                string = string6 + ":" + string7 + "@" + string2 + ":" + string3 + "/";
                return true;
            }
            argument = download.getArgument("proxy_on");
            argument.setValue("false");
            argument.setAssigned(false);
            return false;
        }
        argument = download.getArgument("proxy_on");
        argument.setValue("false");
        argument.setAssigned(false);
        return true;
    }

    private class PreferencesButtonActionListener
    implements ActionListener {
        private PreferencesButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new Preferences("connection");
        }
    }

    private class InformationButtonActionListener
    implements ActionListener {
        private InformationButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Download download = (Download)DownloadPane.this.download_map.get(DownloadPane.this.mode);
            if (!DownloadPane.this.checkProxy() || !DownloadPane.this.checkURL(false)) {
                return;
            }
            if (DownloadPane.this.server_info != null) {
                DownloadPane.this.server_info.dispose();
            }
            Argument argument = download.getArgument("url");
            String string = "";
            if (argument != null && argument.isAssigned()) {
                string = argument.getValue();
            }
            boolean bl = Configuration.get("general.no_check_certificate", true);
            Argument argument2 = download.getArgument("no_check_certificate");
            if (argument2 != null) {
                if (bl) {
                    argument2.setValue("true");
                    argument2.setAssigned(true);
                } else {
                    argument2.setValue("false");
                    argument2.setAssigned(false);
                }
            }
            DownloadPane.this.server_info = new ServerInfoDialog(string, DownloadPane.this.proxy_urls, DownloadPane.this.mode, (Download)DownloadPane.this.download_map.get(DownloadPane.this.mode));
        }
    }

    private class DownloadButtonListener
    implements ActionListener {
        private DownloadButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DownloadPane.this.checkURL(true) && DownloadPane.this.checkProxy()) {
                Argument argument;
                Download download = (Download)DownloadPane.this.download_map.get(DownloadPane.this.mode);
                boolean bl = Configuration.get("general.no_check_certificate", true);
                Argument argument2 = download.getArgument("no_check_certificate");
                if (argument2 != null) {
                    if (bl) {
                        argument2.setValue("true");
                        argument2.setAssigned(true);
                    } else {
                        argument2.setValue("false");
                        argument2.setAssigned(false);
                    }
                }
                if ((argument = download.getArgument("url")) != null) {
                    String string = argument.getValue();
                }
                DownloadPane.this.getter.newDownloadJob((Download)DownloadPane.this.download_map.get(DownloadPane.this.mode), DownloadPane.this.mode, DownloadPane.this.proxy_urls);
            }
        }
    }

    private class ClearCacheListener
    implements ActionListener {
        private ClearCacheListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Utility.delete(Utility.getCacheDir());
            Gatherer.g_man.refreshWorkspaceTree(11);
        }
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (!DownloadPane.this.tree.isSelectionEmpty()) {
                TreePath treePath = DownloadPane.this.tree.getSelectionPath();
                DesignNode designNode = (DesignNode)treePath.getLastPathComponent();
                String string = (String)designNode.getUserObject();
                Gatherer.g_man.wait(true);
                DownloadPane.this.mode = DownloadPane.this.convertCONTENTStoMode(string);
                DownloadPane.this.generateOptions(DownloadPane.this.options_pane, (Download)DownloadPane.this.download_map.get(DownloadPane.this.mode));
                DownloadPane.this.tree.setSelectionPath(treePath);
                DownloadPane.this.previous_path = treePath;
                DownloadPane.this.repaint();
                Gatherer.g_man.wait(false);
            }
        }
    }

    private class DesignNode
    extends DefaultMutableTreeNode {
        public DesignNode(String string) {
            super(string);
        }

        @Override
        public String toString() {
            return Dictionary.get((String)this.getUserObject());
        }
    }

    private class DesignTree
    extends JTree {
        private DesignNode root = null;

        public DesignTree() {
            this.setComponentOrientation(Dictionary.getOrientation());
            this.resetModel(Configuration.getMode());
            this.expandRow(0);
            this.setRootVisible(false);
            this.setSelectionRow(0);
        }

        public void resetModel(int n) {
            this.root = new DesignNode("DOWNLOAD.MODE.Root");
            for (int i = 0; i < DownloadPane.this.CONTENTS.length; ++i) {
                this.root.add(new DesignNode(DownloadPane.this.CONTENTS[i]));
            }
            this.setModel(new DefaultTreeModel(this.root));
            this.updateUI();
        }

        public void setSelectedView(String string) {
            string = Dictionary.get(string);
            for (int i = 0; i < this.root.getChildCount(); ++i) {
                DesignNode designNode = (DesignNode)this.root.getChildAt(i);
                if (!designNode.toString().equals(string)) continue;
                TreePath treePath = new TreePath(designNode.getPath());
                this.setSelectionPath(treePath);
            }
        }
    }
}

