/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.BasicCollectionConfiguration;
import org.greenstone.gatherer.gui.FormatConversionDialog;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.shell.GShell;
import org.greenstone.gatherer.util.Utility;

public class OpenCollectionDialog
extends ModalDialog {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    private static final Dimension SIZE = new Dimension(640, 480);
    private static final String BLANK = "b";
    private static final String DESCRIPTION = "d";
    private CardLayout card_layout;
    private int result;
    private JButton cancel_button;
    private JButton chdir_button;
    private JButton open_button;
    private JList collection_list;
    private JTextArea description_textarea;
    private JPanel description_pane;
    private String filename;
    private String newCollectPath;

    public OpenCollectionDialog() {
        super(Gatherer.g_man, "", true);
        this.setJMenuBar(new SimpleMenuBar("openingacollection"));
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("OpenCollectionDialog.Title"));
        this.newCollectPath = Gatherer.getCollectDirectoryPath();
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel(Dictionary.get("OpenCollectionDialog.Available_Collections"));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        this.collection_list = new JList(new CollectionListModel());
        this.collection_list.setComponentOrientation(Dictionary.getOrientation());
        this.description_pane = new JPanel();
        this.description_pane.setComponentOrientation(Dictionary.getOrientation());
        this.card_layout = new CardLayout();
        JPanel jPanel4 = new JPanel();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel5 = new JPanel();
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel2 = new JLabel(Dictionary.get("OpenCollectionDialog.Description"));
        jLabel2.setComponentOrientation(Dictionary.getOrientation());
        this.description_textarea = new JTextArea();
        this.description_textarea.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel6 = new JPanel();
        jPanel6.setComponentOrientation(Dictionary.getOrientation());
        this.open_button = new GLIButton(Dictionary.get("OpenCollectionDialog.Open"), Dictionary.get("OpenCollectionDialog.Open_Tooltip"));
        this.open_button.setEnabled(false);
        this.chdir_button = new GLIButton(Dictionary.get("General.CD"), Dictionary.get("General.CD_Tooltip"));
        this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Pure_Cancel_Tooltip"));
        this.chdir_button.addActionListener(new ChangeDirListener());
        if (Gatherer.isGsdlRemote || Gatherer.isWebswing) {
            this.chdir_button.setEnabled(false);
        }
        this.cancel_button.addActionListener(new CancelListener());
        this.open_button.addActionListener(new OpenListener());
        CollectionListSelectionListener collectionListSelectionListener = new CollectionListSelectionListener();
        this.collection_list.addListSelectionListener(collectionListSelectionListener);
        this.collection_list.addMouseListener(collectionListSelectionListener);
        collectionListSelectionListener = null;
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jLabel, "North");
        JScrollPane jScrollPane = new JScrollPane(this.collection_list);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel3.add((Component)jScrollPane, "Center");
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jLabel2, "North");
        jScrollPane = new JScrollPane(this.description_textarea);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel5.add((Component)jScrollPane, "Center");
        this.description_pane.setLayout(this.card_layout);
        this.description_pane.add((Component)jPanel5, DESCRIPTION);
        this.description_pane.add((Component)jPanel4, BLANK);
        jPanel2.setLayout(new GridLayout(2, 1, 0, 5));
        jPanel2.add(jPanel3);
        jPanel2.add(this.description_pane);
        jPanel6.setLayout(new GridLayout(1, 3));
        jPanel6.add(this.open_button);
        jPanel6.add(this.chdir_button);
        jPanel6.add(this.cancel_button);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel6, "South");
        this.getRootPane().setDefaultButton(this.open_button);
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - OpenCollectionDialog.SIZE.width) / 2, (dimension.height - OpenCollectionDialog.SIZE.height) / 2);
        dimension = null;
    }

    public void destroy() {
    }

    public int display() {
        this.setVisible(true);
        return this.result;
    }

    public String getFileName() {
        return this.filename;
    }

    private class OpenListener
    implements ActionListener {
        private OpenListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OpenCollectionDialog.this.result = 0;
            Object e = OpenCollectionDialog.this.collection_list.getSelectedValue();
            if (e instanceof BasicCollectionConfiguration) {
                BasicCollectionConfiguration basicCollectionConfiguration = (BasicCollectionConfiguration)e;
                File file = basicCollectionConfiguration.getFile();
                OpenCollectionDialog.this.result = FormatConversionDialog.checkForGS2FormatStatements(file);
                if (OpenCollectionDialog.this.result == 0) {
                    File file2 = file.getParentFile();
                    File file3 = file2.getParentFile();
                    OpenCollectionDialog.this.filename = file3.getAbsolutePath() + File.separator + "gli.col";
                    file3 = null;
                    file2 = null;
                    file = null;
                    basicCollectionConfiguration = null;
                }
                OpenCollectionDialog.this.dispose();
            }
            Gatherer.collectDirectoryHasChanged(Gatherer.getCollectDirectoryPath(), OpenCollectionDialog.this.newCollectPath, Gatherer.g_man.getContentPane());
        }
    }

    private class CollectionListModel
    extends AbstractListModel {
        private TreeSet data = new TreeSet();
        public static final int COLLECT = 3;

        public CollectionListModel() {
            this.reload(Gatherer.getCollectDirectoryPath());
        }

        public void reload(String string) {
            this.data.clear();
            File file = new File(string);
            if (!file.exists()) {
                file = null;
                return;
            }
            this.load_collection_configs(this.data, file);
            this.fireContentsChanged(this, 0, this.data.size());
        }

        protected void load_collection_configs(TreeSet treeSet, File file) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                String string = file2.getName();
                if (file2.isDirectory() && !string.equals("modelcol")) {
                    String string2;
                    if (Gatherer.GS3) {
                        this.convertToGS3Collection(file2);
                        string2 = Utility.CONFIG_GS3_FILE;
                    } else {
                        string2 = Utility.CONFIG_FILE;
                    }
                    File file3 = new File(file2, string2);
                    if (file3.exists()) {
                        BasicCollectionConfiguration basicCollectionConfiguration = new BasicCollectionConfiguration(file3);
                        if (basicCollectionConfiguration.getCollectGroup().equals("true")) {
                            this.load_collection_configs(treeSet, file2);
                        } else if (Gatherer.isWebswing) {
                            if (Gatherer.webswingAuthenticator.canEditCollection(string)) {
                                treeSet.add(basicCollectionConfiguration);
                            }
                        } else {
                            treeSet.add(basicCollectionConfiguration);
                        }
                    }
                    file3 = null;
                }
                string = null;
                file2 = null;
            }
            fileArray = null;
            file = null;
        }

        @Override
        public Object getElementAt(int n) {
            Iterator iterator = this.data.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (n2 == n) {
                    iterator = null;
                    return e;
                }
                e = null;
                ++n2;
            }
            iterator = null;
            return null;
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        public void convertToGS3Collection(File file) {
            File file2 = new File(file.getAbsolutePath() + File.separator + "etc" + File.separator + "collect.cfg");
            File file3 = new File(file.getAbsolutePath() + File.separator + "index" + File.separator + "build.cfg");
            if (file2.exists() && file3.exists()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (!Gatherer.isGsdlRemote) {
                    arrayList.add(Configuration.perl_path);
                    arrayList.add("-S");
                }
                arrayList.add(Configuration.getGS3ScriptPath() + "convert_coll_from_gs2.pl");
                arrayList.add("-collectdir");
                arrayList.add(file.getParent());
                arrayList.add(file.getName());
                String[] stringArray = arrayList.toArray(new String[0]);
                GShell gShell = new GShell(stringArray, 5, 3, null, null, GShell.GSHELL_CONVERT);
                gShell.run();
                File file4 = new File(file.getAbsolutePath() + File.separator + "etc" + File.separator + "collect.cfg.bak");
                File file5 = new File(file.getAbsolutePath() + File.separator + "index" + File.separator + "build.cfg.bak");
                if (!file2.renameTo(file4)) {
                    System.err.println("Unable to move collect.cfg to " + file4);
                }
                if (!file3.renameTo(file5)) {
                    System.err.println("Unable to move build.cfg to " + file5);
                }
            }
        }
    }

    private class CollectionListSelectionListener
    extends MouseAdapter
    implements ListSelectionListener {
        private CollectionListSelectionListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() >= 2) {
                Point point = mouseEvent.getPoint();
                int n = OpenCollectionDialog.this.collection_list.locationToIndex(point);
                OpenCollectionDialog.this.collection_list.setSelectedIndex(n);
                point = null;
                OpenCollectionDialog.this.open_button.doClick();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (OpenCollectionDialog.this.collection_list.isSelectionEmpty()) {
                OpenCollectionDialog.this.card_layout.show(OpenCollectionDialog.this.description_pane, OpenCollectionDialog.BLANK);
                OpenCollectionDialog.this.open_button.setEnabled(false);
            } else {
                BasicCollectionConfiguration basicCollectionConfiguration = (BasicCollectionConfiguration)OpenCollectionDialog.this.collection_list.getSelectedValue();
                OpenCollectionDialog.this.description_textarea.setText(basicCollectionConfiguration.getDescription());
                OpenCollectionDialog.this.description_textarea.setCaretPosition(0);
                OpenCollectionDialog.this.card_layout.show(OpenCollectionDialog.this.description_pane, OpenCollectionDialog.DESCRIPTION);
                OpenCollectionDialog.this.open_button.setEnabled(true);
            }
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OpenCollectionDialog.this.result = 1;
            OpenCollectionDialog.this.dispose();
        }
    }

    private class ChangeDirListener
    implements ActionListener {
        private ChangeDirListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(OpenCollectionDialog.this.newCollectPath);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle(Dictionary.get("General.ChooseCollectDirectory"));
            int n = jFileChooser.showOpenDialog(OpenCollectionDialog.this);
            if (n == 0) {
                String string = OpenCollectionDialog.this.newCollectPath;
                OpenCollectionDialog.this.newCollectPath = jFileChooser.getSelectedFile().getAbsolutePath() + File.separator;
                if (!OpenCollectionDialog.this.newCollectPath.equals(string)) {
                    CollectionListModel collectionListModel = (CollectionListModel)OpenCollectionDialog.this.collection_list.getModel();
                    collectionListModel.reload(OpenCollectionDialog.this.newCollectPath);
                    OpenCollectionDialog.this.collection_list.repaint();
                }
            }
        }
    }
}

