/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.URLField;
import org.greenstone.gatherer.util.JarTools;

public class WarningDialog
extends ModalDialog
implements ActionListener,
KeyListener {
    private static final Dimension NORMAL_SIZE = new Dimension(450, 160);
    private static final Dimension SETTING_SIZE = new Dimension(450, 200);
    private int result = 2;
    private JButton cancel_button;
    private JButton ok_button;
    private JCheckBox show_check;
    private JComponent value_field;
    private JPanel value_panel;
    private String affected_property;
    private String full_property;
    private final boolean showcheckbox;

    public WarningDialog(String string, String string2, String string3, String string4, boolean bl) {
        this(string, string2, string3, string4, bl, true);
    }

    public WarningDialog(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        super(Gatherer.g_man, "Warning", true);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.showcheckbox = bl2;
        this.affected_property = string4;
        this.full_property = string;
        if (string4 != null) {
            this.setSize(SETTING_SIZE);
        } else {
            this.setSize(NORMAL_SIZE);
        }
        this.setTitle(string2);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        String string5 = "gatherer_medium.png";
        if (Configuration.fedora_info != null && Configuration.fedora_info.isActive()) {
            string5 = "fli-" + string5;
        }
        JLabel jLabel = new JLabel(JarTools.getImage(string5));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setComponentOrientation(Dictionary.getOrientation());
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setText(string3);
        jTextArea.setCaretPosition(0);
        jTextArea.setWrapStyleWord(true);
        this.value_panel = new JPanel();
        this.value_panel.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel2 = new JLabel(Dictionary.get("WarningDialog.Value"));
        jLabel2.setComponentOrientation(Dictionary.getOrientation());
        this.value_field = new JTextField();
        this.value_field.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel4 = new JPanel();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        this.ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
        this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Pure_Cancel_Tooltip"));
        this.ok_button.addActionListener(this);
        this.cancel_button.addActionListener(this);
        this.ok_button.addKeyListener(this);
        this.cancel_button.addKeyListener(this);
        this.getRootPane().setDefaultButton(this.ok_button);
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        jLabel2.setBorder(BorderFactory.createEmptyBorder(0, jLabel.getPreferredSize().width, 0, 0));
        this.value_panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.value_panel.setLayout(new BorderLayout(5, 0));
        this.value_panel.add((Component)jLabel2, "Before");
        this.value_panel.add((Component)this.value_field, "Center");
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel, "Before");
        jPanel2.add((Component)new JScrollPane(jTextArea), "Center");
        if (string4 != null) {
            jPanel2.add((Component)this.value_panel, "South");
        }
        if (bl) {
            jPanel4.setLayout(new GridLayout(1, 2, 5, 0));
            jPanel4.add(this.ok_button);
            jPanel4.add(this.cancel_button);
        } else {
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)this.ok_button, "After");
        }
        jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel4, "After");
        if (bl2) {
            this.show_check = new JCheckBox(Dictionary.get("WarningDialog.Dont_Show_Again"));
            this.show_check.setComponentOrientation(Dictionary.getOrientation());
            jPanel3.add((Component)this.show_check, "Center");
        }
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        Dimension dimension = this.getSize();
        if (Gatherer.g_man != null) {
            Rectangle rectangle = Gatherer.g_man.getBounds();
            this.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
        } else {
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        if (actionEvent.getSource() == this.ok_button) {
            if (this.affected_property != null && Configuration.self != null && (bl = URLField.validateURL(this.value_field))) {
                URLField.store(this.value_field, this.affected_property);
            }
            if (bl) {
                this.result = 0;
            }
        }
        if (bl) {
            if (Configuration.self != null && this.showcheckbox) {
                Configuration.set(this.full_property, true, !this.show_check.isSelected());
            }
            this.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("WarningDialog.Invalid_Value"), Dictionary.get("General.Error"), 0);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Object object;
        if (keyEvent.getKeyCode() == 10 && (object = keyEvent.getSource()) instanceof AbstractButton) {
            ((AbstractButton)object).doClick();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public int display() {
        if (Configuration.self == null || Configuration.get(this.full_property, false)) {
            this.setVisible(true);
        } else {
            this.result = 0;
        }
        if (Gatherer.g_man != null) {
            Gatherer.g_man.repaint();
        }
        return this.result;
    }

    public void setMessageOnly(boolean bl) {
        if (!this.showcheckbox) {
            return;
        }
        if (bl) {
            this.show_check.setText(Dictionary.get("WarningDialog.Dont_Show_Again_Message"));
        } else {
            this.show_check.setText(Dictionary.get("WarningDialog.Dont_Show_Again"));
        }
    }

    public void setValueField(JComponent jComponent) {
        this.value_panel.remove(this.value_field);
        this.value_field = jComponent;
        this.value_panel.add((Component)this.value_field, "Center");
    }

    @Override
    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 205) {
            if (this.affected_property != null) {
                this.value_field.requestFocus();
            } else {
                this.ok_button.requestFocus();
            }
        } else {
            super.processWindowEvent(windowEvent);
        }
    }

    public void setValueField(String string) {
        URLField.setText(this.value_field, string);
    }
}

