/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui.metaaudit;

import java.util.ArrayList;

public class Autofilter {
    private static final int LESS_THAN = -1;
    private static final int EQUAL = 0;
    private static final int GREATER_THAN = 1;
    private static final int ERROR = 42;
    public boolean active;
    public boolean casesense_one;
    public boolean casesense_two;
    public boolean operation = false;
    public boolean sort = true;
    public int method_one;
    public int method_two;
    public String value_one;
    public String value_two;
    public static final boolean ASCENDING = true;
    public static final boolean AND = true;
    public static final boolean DESCENDING = false;
    public static final boolean OR = false;
    public static final String[] METHOD_LIST = new String[]{"Autofilter.eqeq", "Autofilter.!eq", "Autofilter.<", "Autofilter.<eq", "Autofilter.>", "Autofilter.>eq", "Autofilter.^", "Autofilter.!^", "Autofilter.$", "Autofilter.!$", "Autofilter.?", "Autofilter.!?"};

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.err.println("Usage: java Autofilter <string> <pattern>");
        } else {
            switch (Autofilter.compareToPattern(stringArray[0], stringArray[1])) {
                case -1: {
                    System.err.print(stringArray[0] + " is less than");
                    break;
                }
                case 1: {
                    System.err.print(stringArray[0] + " is greater than");
                    break;
                }
                case 0: {
                    System.err.print(stringArray[0] + " is equal to");
                    break;
                }
                default: {
                    System.err.print(stringArray[0] + " is something to");
                }
            }
            System.err.println(" " + stringArray[1]);
        }
    }

    private static int compareToPattern(String string, String string2) {
        if (string2.indexOf(42) == -1) {
            return Autofilter.compareToPattern(string, string2, 0, 0, false);
        }
        return Autofilter.compareToPattern(string, string2, 0, 0, true);
    }

    private static int compareToPattern(String string, String string2, int n, int n2, boolean bl) {
        if (n >= string.length() && n2 >= string2.length()) {
            return 0;
        }
        if (n >= string.length()) {
            if (bl) {
                return 42;
            }
            while (n2 < string2.length()) {
                if (string2.charAt(n2) == '*') {
                    ++n2;
                    continue;
                }
                return -1;
            }
            return 0;
        }
        if (n2 >= string2.length()) {
            if (bl) {
                return 42;
            }
            return 1;
        }
        char c = string.charAt(n);
        char c2 = string2.charAt(n2);
        if (c2 == '*') {
            int n3;
            if (n2 + 1 < string2.length() && (n3 = Autofilter.compareToPattern(string, string2, n, n2 + 1, bl)) != 42) {
                return n3;
            }
            n3 = Autofilter.compareToPattern(string, string2, n + 1, n2 + 1, bl);
            if (n3 != 42) {
                return n3;
            }
            n3 = Autofilter.compareToPattern(string, string2, n + 1, n2, bl);
            if (n3 != 42) {
                return n3;
            }
        }
        if (c == c2) {
            return Autofilter.compareToPattern(string, string2, n + 1, n2 + 1, bl);
        }
        if (c < c2) {
            if (bl) {
                if (Autofilter.compareToPattern(string, string2, n + 1, n2 + 1, bl) != 42) {
                    return -1;
                }
                return 42;
            }
            return -1;
        }
        if (c > c2) {
            if (bl) {
                if (Autofilter.compareToPattern(string, string2, n + 1, n2 + 1, bl) != 42) {
                    return 1;
                }
                return 42;
            }
            return 1;
        }
        return -1;
    }

    public boolean active() {
        return this.active;
    }

    public boolean filter(ArrayList arrayList) {
        boolean bl = false;
        if (this.value_one != null) {
            bl = this.filter(arrayList, this.method_one, this.value_one, this.casesense_one);
            if (bl) {
                if (this.operation && this.value_two != null) {
                    bl = this.filter(arrayList, this.method_two, this.value_two, this.casesense_two);
                }
            } else if (!this.operation && this.value_two != null) {
                bl = this.filter(arrayList, this.method_two, this.value_two, this.casesense_two);
            }
        }
        return bl;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public void setFilter(int n, int n2, String string, boolean bl) {
        if (!bl && string != null) {
            string = string.toLowerCase();
        }
        if (n == 1) {
            this.casesense_one = bl;
            this.method_one = n2;
            this.value_one = string;
        } else {
            this.casesense_two = bl;
            this.method_two = n2;
            this.value_two = string;
        }
    }

    public void setOperation(boolean bl) {
        this.operation = bl;
    }

    public void setSort(boolean bl) {
        this.sort = bl;
    }

    public boolean filter(ArrayList arrayList, int n, String string, boolean bl) {
        boolean bl2 = false;
        if (string == null || string.length() == 0 || string.equals("*")) {
            bl2 = true;
        } else {
            for (int i = 0; i < arrayList.size(); ++i) {
                boolean bl3;
                String string2 = bl ? arrayList.get(i).toString() : arrayList.get(i).toString().toLowerCase();
                switch (n) {
                    case 1: {
                        bl3 = Autofilter.compareToPattern(string2, string) != 0;
                        break;
                    }
                    case 2: {
                        bl3 = Autofilter.compareToPattern(string2, string) < 0;
                        break;
                    }
                    case 3: {
                        bl3 = Autofilter.compareToPattern(string2, string) <= 0;
                        break;
                    }
                    case 4: {
                        bl3 = Autofilter.compareToPattern(string2, string) > 0;
                        break;
                    }
                    case 5: {
                        bl3 = Autofilter.compareToPattern(string2, string) >= 0;
                        break;
                    }
                    case 6: {
                        bl3 = string2.startsWith(string);
                        break;
                    }
                    case 7: {
                        bl3 = !string2.startsWith(string);
                        break;
                    }
                    case 8: {
                        bl3 = string2.endsWith(string);
                        break;
                    }
                    case 9: {
                        bl3 = !string2.endsWith(string);
                        break;
                    }
                    case 10: {
                        bl3 = string2.indexOf(string) != -1;
                        break;
                    }
                    case 11: {
                        bl3 = string2.indexOf(string) == -1;
                        break;
                    }
                    default: {
                        bl3 = Autofilter.compareToPattern(string2, string) == 0;
                    }
                }
                bl2 = bl2 || bl3;
            }
        }
        return bl2;
    }

    public String toString() {
        String string = "One: " + this.method_one + " - " + this.value_one + " - " + this.casesense_one;
        if (this.value_two != null) {
            string = string + "\nOperation: " + (this.operation ? "AND" : "OR") + "\n";
            string = string + "Two: " + this.method_two + " - " + this.value_two + " - " + this.casesense_two;
        }
        return string;
    }
}

